/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa2.font;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Subset;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.CIDSystemInfo;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.CMapObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDSet;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDSystemInfo;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCosFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFType0FontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFWritingMode;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.CMapResourceBuilder;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.CMapsUtil;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.services.fontresources.FontResources;
import com.adobe.internal.pdftoolkit.services.pdfa.common.FontProcessorUtils;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.PDFA2ErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2AbstractFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorCIDGreaterThan65535;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorCMapNotEmbedded;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorEmbeddingFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorFontDataCorrupt;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorFontNotEmbedded;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorIncompleteCIDSet;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorMismatchedCMapWModes;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorMismatchedSystemInfoOrdering;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorMismatchedSystemInfoRegistry;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorMismatchedSystemInfoSupplement;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorMismatchedWidthsInfo;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorMissingOrIncompleteWidthsArray;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorNameNotUTF8;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorNonPermittedCmapReferencedFromCmap;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorPDFGeneralFailure;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorSymbolicTrueTypeEncodingNotAllowed;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTextNotMappedToUnicode;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTrueTypeEmbeddedFontCouldNotMapGlyph;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorType2CIDFontInvalidCIDToGIDMap;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorType2CIDFontMissingCIDToGIDMap;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTypeAbsentInCIDFont;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTypeAbsentInFont;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTypeAbsentInFontDescriptor;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTypeIncorrectInCIDFont;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTypeIncorrectInFont;
import com.adobe.internal.pdftoolkit.services.pdfa2.error.codes.PDFA2FontErrorTypeIncorrectInFontDescriptor;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.FontContext;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa2.font.UnembeddedFontInfo;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeMap;

class Type0FontProcessor {
    Type0FontProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PDFA2ErrorSet<PDFA2AbstractFontErrorCode> processType0FontErrors(PDFFont font, PDFA2ConversionHandler conversionHandler, Map<ASName, CosStream> cMapsEmbedded, HashSet<Integer> referencedCharCodes, PDFA2ConformanceLevel conformanceLevel) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, FontEngineException {
        PDFFontType0 type0Font;
        PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errorCodes;
        block57: {
            PDFFontDescriptor fDesc;
            errorCodes = new PDFA2ErrorSet<PDFA2AbstractFontErrorCode>();
            if (font == null) {
                return errorCodes;
            }
            if (!(font instanceof PDFFontType0)) {
                return errorCodes;
            }
            int objectNumber = font.getCosObject().getObjNum();
            int genNumber = font.getCosObject().getObjGen();
            CosObject fontTypeCosObj = font.getCosDictionary().get(ASName.k_Type);
            String fontType = fontTypeCosObj instanceof CosName ? fontTypeCosObj.nameValue().asString() : null;
            FontProcessor.setTypeErrorCodes(font.getCosDictionary(), ASName.k_Font, conversionHandler, errorCodes, new PDFA2FontErrorTypeIncorrectInFont(fontType, objectNumber, genNumber), new PDFA2FontErrorTypeAbsentInFont(objectNumber, genNumber));
            type0Font = (PDFFontType0)font;
            PDFType0FontEncoding cMap = type0Font.getEncoding();
            PDFCIDFont cidFont = type0Font.getDescendantFont();
            if (cidFont == null) {
                throw new PDFInvalidDocumentException("Invalid Type0 font - it does not have descendant font");
            }
            int cidFontObjectNumber = cidFont.getCosObject().getObjNum();
            int cidFontGenNumber = cidFont.getCosObject().getObjGen();
            ASName fontName = cidFont.getBaseFont();
            if (fontName != null && !PDFText.isValidUTF8(fontName.getBytes())) {
                errorCodes.addErrorCode(new PDFA2FontErrorNameNotUTF8(fontName.asString(), cidFontObjectNumber, cidFontGenNumber));
            }
            fontType = (fontTypeCosObj = cidFont.getCosDictionary().get(ASName.k_Type)) instanceof CosName ? fontTypeCosObj.nameValue().asString() : null;
            FontProcessor.setTypeErrorCodes(cidFont.getCosDictionary(), ASName.k_Font, conversionHandler, errorCodes, new PDFA2FontErrorTypeIncorrectInCIDFont(fontType, cidFontObjectNumber, cidFontGenNumber), new PDFA2FontErrorTypeAbsentInCIDFont(cidFontObjectNumber, cidFontGenNumber));
            if (cMap != null) {
                errorCodes.mergeErrorSet(Type0FontProcessor.processCMapErrors(cMap, cidFont, conversionHandler));
            }
            if (cidFont.getSubType() == ASName.k_CIDFontType2) {
                if (!cidFont.hasCIDToGIDMap()) {
                    errorCodes.addErrorCode(new PDFA2FontErrorType2CIDFontMissingCIDToGIDMap(cidFontObjectNumber, cidFontGenNumber));
                } else if (cidFont.isCIDToGIDMapAName()) {
                    if (cidFont.getCIDToGIDMapName() != ASName.k_Identity) {
                        errorCodes.addErrorCode(new PDFA2FontErrorType2CIDFontInvalidCIDToGIDMap(cidFontObjectNumber, cidFontGenNumber));
                    }
                } else if (!cidFont.isCIDToGIDMapAStream()) {
                    errorCodes.addErrorCode(new PDFA2FontErrorType2CIDFontInvalidCIDToGIDMap(cidFontObjectNumber, cidFontGenNumber));
                }
            }
            if (PDFFontUtils.isSubsetFont(font) && (fDesc = cidFont.getFontDescriptor()) != null) {
                PDFCIDSet cidSet;
                PDFCosFontDescriptor desc = fDesc.getPDFCosDescriptor();
                if (desc != null) {
                    fontTypeCosObj = desc.getCosDictionary().get(ASName.k_Type);
                    fontType = fontTypeCosObj instanceof CosName ? fontTypeCosObj.nameValue().asString() : null;
                    FontProcessor.setTypeErrorCodes(desc.getCosDictionary(), ASName.k_FontDescriptor, conversionHandler, errorCodes, new PDFA2FontErrorTypeIncorrectInFontDescriptor(fontType, desc.getCosDictionary().getObjNum(), desc.getCosDictionary().getObjGen()), new PDFA2FontErrorTypeAbsentInFontDescriptor(desc.getCosDictionary().getObjNum(), desc.getCosDictionary().getObjGen()));
                }
                if ((cidSet = fDesc.getCIDSet()) != null) {
                    InputByteStream cidStream = cidSet.getCosStream().getStreamDecoded();
                    boolean isCMapIdentity = PDFFontUtils.isCMapIdentity(cMap);
                    try {
                        if (!isCMapIdentity && type0Font.getDescendantFont().getSubType() != ASName.k_CIDFontType0 && type0Font.getDescendantFont().getSubType() != ASName.k_CIDFontType2) break block57;
                        long cidSetLength = cidStream.length();
                        Font afeFont = type0Font.getAFEFont();
                        if (afeFont == null) {
                            PDFA2ErrorSet<PDFA2AbstractFontErrorCode> pDFA2ErrorSet = errorCodes;
                            return pDFA2ErrorSet;
                        }
                        PDFFontDescription fontDesc = afeFont.getPDFFontDescription();
                        if (fontDesc == null) {
                            PDFA2ErrorSet<PDFA2AbstractFontErrorCode> e = errorCodes;
                            return e;
                        }
                        HashSet<Long> cidHashSet = new HashSet<Long>();
                        int numGlyphs = fontDesc.getNumGlyphs();
                        if (cidFont.hasCIDToGIDMap() && cidFont.isCIDToGIDMapAStream()) {
                            InputByteStream cidToGIDStream = cidFont.getCIDToGIDMapStream().getCosStream().getStreamDecoded();
                            int cidToGIDLength = (int)cidToGIDStream.length();
                            for (int i = 0; i < cidToGIDLength / 2; ++i) {
                                if (i > 65535) {
                                    errorCodes.addErrorCode(new PDFA2FontErrorCIDGreaterThan65535(i, cidFontObjectNumber, cidFontGenNumber));
                                }
                                cidHashSet.add(Long.valueOf(i));
                            }
                        } else {
                            for (int i = 0; i < numGlyphs; ++i) {
                                long cid;
                                long l = cid = fontDesc.getROS() == null ? (long)i : (long)fontDesc.getGlyphCid(i);
                                if (cid > 65535L) {
                                    errorCodes.addErrorCode(new PDFA2FontErrorCIDGreaterThan65535(cid, cidFontObjectNumber, cidFontGenNumber));
                                }
                                cidHashSet.add(cid);
                            }
                        }
                        for (Long cid : cidHashSet) {
                            long cidByte = cid / 8L;
                            if (cidByte >= cidSetLength) {
                                errorCodes.addErrorCode(new PDFA2FontErrorIncompleteCIDSet(type0Font.getCosObject().getObjNum(), type0Font.getCosObject().getObjGen()));
                            } else {
                                byte cidBit = (byte)(1 << (int)(7L - cid % 8L));
                                cidStream.seek(cidByte);
                                if ((cidStream.read() & cidBit) != 0 || cid == 0L) continue;
                                errorCodes.addErrorCode(new PDFA2FontErrorIncompleteCIDSet(type0Font.getCosObject().getObjNum(), type0Font.getCosObject().getObjGen()));
                            }
                            break;
                        }
                    }
                    catch (IOException e) {
                        errorCodes.addErrorCode(new PDFA2FontErrorPDFGeneralFailure(0, 0));
                    }
                    catch (FontEngineException e3) {
                        errorCodes.addErrorCode(new PDFA2FontErrorFontDataCorrupt(type0Font.getCosObject().getObjNum(), type0Font.getCosObject().getObjGen()));
                    }
                    finally {
                        try {
                            cidStream.close();
                        }
                        catch (IOException e) {
                            errorCodes.addErrorCode(new PDFA2FontErrorPDFGeneralFailure(0, 0));
                        }
                    }
                }
            }
        }
        if (conversionHandler != null) {
            if (errorCodes.errorCodeSet(PDFA2FontErrorCMapNotEmbedded.class) && Type0FontProcessor.embedCMap(type0Font, cMapsEmbedded)) {
                if (!conversionHandler.cMapEmbeddedInType0Font(font)) {
                    return null;
                }
                errorCodes.unSetErrorCode(PDFA2FontErrorCMapNotEmbedded.class);
            }
            if (errorCodes.errorCodeSet(PDFA2FontErrorMismatchedCMapWModes.class) && PDFFontUtils.setWModeInEmbeddedCMap(type0Font)) {
                if (!conversionHandler.wModeUpdatedInType0Font(font)) {
                    return null;
                }
                errorCodes.unSetErrorCode(PDFA2FontErrorMismatchedCMapWModes.class);
            }
            if (errorCodes.errorCodeSet(PDFA2FontErrorIncompleteCIDSet.class)) {
                boolean embeddingSuccess = false;
                try {
                    embeddingSuccess = FontProcessorUtils.embedCIDSet(type0Font, null, null, null);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!embeddingSuccess) {
                    type0Font.getFontDescriptor().setCIDSet(null);
                }
                if (!conversionHandler.CIDSetUpdatedInType0Font(font)) {
                    return null;
                }
                errorCodes.unSetErrorCode(PDFA2FontErrorIncompleteCIDSet.class);
            }
        }
        FontProcessorUtils.processToUnicodeRequirement(conversionHandler, referencedCharCodes, errorCodes, type0Font, conformanceLevel);
        return errorCodes;
    }

    static PDFA2ErrorSet<PDFA2AbstractFontErrorCode> embedType0Font(PDFFontType0 font, UnembeddedFontInfo ufInfo, PDFA2ConversionHandler conversionHandler, Map<ASName, CosStream> cMapsEmbedded, FontContext fontContext, PDFA2ConformanceLevel conformanceLevel) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, FontEngineException, PDFInvalidParameterException {
        if (ufInfo == null) {
            return new PDFA2ErrorSet<PDFA2AbstractFontErrorCode>();
        }
        PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errorCodes = ufInfo.getError();
        if (font == null) {
            return errorCodes;
        }
        boolean isEmbedded = false;
        boolean[] isEmbeddedResult = new boolean[1];
        Subset[] fontSubsetResult = new Subset[1];
        int[] cidArray = null;
        int[] gidArray = null;
        Subset fontSubset = null;
        try {
            Map<Integer, int[]> charcodeCidGidMap = ufInfo.getLastFontInfo() == null ? ufInfo.getCharcodeCidGidMap() : ufInfo.getLastFontInfo().getCharcodeCidGidMap();
            cidArray = new int[charcodeCidGidMap.size()];
            gidArray = new int[charcodeCidGidMap.size()];
            if (!FontProcessorUtils.embedType0Font(ufInfo, font, fontContext, charcodeCidGidMap, cidArray, gidArray, isEmbeddedResult, fontSubsetResult)) {
                return errorCodes;
            }
            isEmbedded = isEmbeddedResult[0];
            fontSubset = fontSubsetResult[0];
            if (errorCodes.errorCodeSet(PDFA2FontErrorMismatchedWidthsInfo.class) || errorCodes.errorCodeSet(PDFA2FontErrorMissingOrIncompleteWidthsArray.class)) {
                errorCodes.unSetErrorCode(PDFA2FontErrorMismatchedWidthsInfo.class);
                errorCodes.unSetErrorCode(PDFA2FontErrorMissingOrIncompleteWidthsArray.class);
                if (!conversionHandler.widthsMetricsUpdated(font)) {
                    return null;
                }
            }
        }
        catch (IOException e) {
            throw new PDFInvalidDocumentException(e);
        }
        if (conversionHandler != null) {
            if (errorCodes.errorCodeSet(PDFA2FontErrorCMapNotEmbedded.class) && Type0FontProcessor.embedCMap(font, cMapsEmbedded)) {
                errorCodes.unSetErrorCode(PDFA2FontErrorCMapNotEmbedded.class);
                if (!conversionHandler.cMapEmbeddedInType0Font(font)) {
                    return null;
                }
            }
            if (errorCodes.errorCodeSet(PDFA2FontErrorMismatchedCMapWModes.class) && PDFFontUtils.setWModeInEmbeddedCMap(font)) {
                errorCodes.unSetErrorCode(PDFA2FontErrorMismatchedCMapWModes.class);
                if (!conversionHandler.wModeUpdatedInType0Font(font)) {
                    return null;
                }
            }
            if (errorCodes.errorCodeSet(PDFA2FontErrorTextNotMappedToUnicode.class)) {
                errorCodes.unSetErrorCode(PDFA2FontErrorTextNotMappedToUnicode.class);
                FontProcessorUtils.processToUnicodeRequirement(conversionHandler, ufInfo.getCharCodes(), errorCodes, font, conformanceLevel);
            }
            if (isEmbedded) {
                if (errorCodes.errorCodeSet(PDFA2FontErrorFontNotEmbedded.class)) {
                    errorCodes.unSetErrorCode(PDFA2FontErrorFontNotEmbedded.class);
                    if (!conversionHandler.fontEmbedded(font)) {
                        return null;
                    }
                }
                boolean success = false;
                try {
                    success = FontProcessorUtils.embedCIDSet(font, ufInfo, fontSubset, null);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (errorCodes.errorCodeSet(PDFA2FontErrorIncompleteCIDSet.class)) {
                    if (!success) {
                        font.getFontDescriptor().setCIDSet(null);
                    }
                    errorCodes.unSetErrorCode(PDFA2FontErrorIncompleteCIDSet.class);
                    if (!conversionHandler.CIDSetUpdatedInType0Font(font)) {
                        return null;
                    }
                }
                if ((success = FontProcessorUtils.embedCIDToGIDMap(font, cidArray, gidArray, ufInfo)) && (errorCodes.errorCodeSet(PDFA2FontErrorType2CIDFontInvalidCIDToGIDMap.class) || errorCodes.errorCodeSet(PDFA2FontErrorType2CIDFontMissingCIDToGIDMap.class))) {
                    errorCodes.unSetErrorCode(PDFA2FontErrorType2CIDFontInvalidCIDToGIDMap.class);
                    errorCodes.unSetErrorCode(PDFA2FontErrorType2CIDFontMissingCIDToGIDMap.class);
                    if (!conversionHandler.CIDToGIDMapUpdatedInType0Font(font)) {
                        return null;
                    }
                }
            }
        }
        return errorCodes;
    }

    static PDFA2ErrorSet<PDFA2AbstractFontErrorCode> embedTrueTypeAsType0Font(PDFFontSimple simpleFont, UnembeddedFontInfo ufInfo, PDFA2ConversionHandler conversionHandler, Set<Integer> charCodes, FontContext fontContext, PDFA2ConformanceLevel conformanceLevel) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, FontEngineException, PDFInvalidParameterException {
        if (ufInfo == null) {
            return new PDFA2ErrorSet<PDFA2AbstractFontErrorCode>();
        }
        PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errorCodes = ufInfo.getError();
        if (simpleFont == null) {
            return errorCodes;
        }
        int objectNumber = simpleFont.getCosObject().getObjNum();
        int genNumber = simpleFont.getCosObject().getObjGen();
        Font afeFont = simpleFont.getAFEFont();
        if (afeFont == null) {
            return errorCodes;
        }
        PDFFontDescription afeFontDesc = afeFont.getPDFFontDescription();
        if (afeFontDesc == null) {
            return errorCodes;
        }
        HashMap<Integer, Integer> charCodeGidMap = new HashMap<Integer, Integer>();
        TreeMap<Integer, byte[]> charCodeToUnicodeMap = new TreeMap<Integer, byte[]>();
        for (Integer charcode : charCodes) {
            try {
                charCodeGidMap.put(charcode, simpleFont.charCode2gid(charcode));
                byte[] bytes = new String(simpleFont.getUnicode(charcode.intValue())).getBytes("UTF-16BE");
                charCodeToUnicodeMap.put(charcode, bytes);
            }
            catch (PDFFontException e) {
                return ufInfo.getError();
            }
            catch (UnsupportedEncodingException e) {
                return ufInfo.getError();
            }
        }
        if (charCodeGidMap.size() <= 0) {
            return errorCodes;
        }
        int[] cidArray = new int[charCodeGidMap.size()];
        int[] gidArray = new int[charCodeGidMap.size()];
        boolean isEmbedded = false;
        boolean[] isEmbeddedResult = new boolean[1];
        Subset[] fontSubsetResult = new Subset[1];
        if (!FontProcessorUtils.embedSimpleFontsAsType0Font(ufInfo, simpleFont, fontContext, isEmbeddedResult, fontSubsetResult, charCodes, cidArray, gidArray, charCodeGidMap)) {
            return errorCodes;
        }
        isEmbedded = isEmbeddedResult[0];
        if (conversionHandler != null && isEmbedded) {
            boolean success;
            PDFFontType0 font = (PDFFontType0)PDFFontFactory.getInstance(simpleFont.getCosObject());
            if (errorCodes.errorCodeSet(PDFA2FontErrorFontNotEmbedded.class)) {
                errorCodes.unSetErrorCode(PDFA2FontErrorFontNotEmbedded.class);
                if (!conversionHandler.fontEmbedded(font)) {
                    return null;
                }
            }
            if (errorCodes.errorCodeSet(PDFA2FontErrorTrueTypeEmbeddedFontCouldNotMapGlyph.class)) {
                errorCodes.unSetErrorCode(PDFA2FontErrorTrueTypeEmbeddedFontCouldNotMapGlyph.class);
            }
            if (errorCodes.errorCodeSet(PDFA2FontErrorSymbolicTrueTypeEncodingNotAllowed.class)) {
                errorCodes.unSetErrorCode(PDFA2FontErrorSymbolicTrueTypeEncodingNotAllowed.class);
            }
            if (!(success = FontProcessorUtils.embedCIDToGIDMap(font, cidArray, gidArray, ufInfo))) {
                errorCodes.addErrorCode(new PDFA2FontErrorEmbeddingFailure(objectNumber, genNumber));
            }
            FontResources.createToUnicodeCMap(font, charCodeToUnicodeMap);
            FontProcessorUtils.processToUnicodeRequirement(conversionHandler, ufInfo.getCharCodes(), errorCodes, font, conformanceLevel);
        }
        return errorCodes;
    }

    private static PDFA2ErrorSet<PDFA2AbstractFontErrorCode> processCMapErrors(PDFType0FontEncoding cMap, PDFCIDFont cidFont, PDFA2ConversionHandler conversionHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFA2ErrorSet<PDFA2AbstractFontErrorCode> errorCodes = new PDFA2ErrorSet<PDFA2AbstractFontErrorCode>();
        if (cMap == null) {
            return errorCodes;
        }
        ASString cmapRegistry = null;
        ASString cmapOrdering = null;
        boolean cMapEmbedded = false;
        if (cMap.isPredefinedCMap()) {
            if (!CMapsUtil.isPredefinedCmapPermitted(cMap.getCMapName())) {
                errorCodes.addErrorCode(new PDFA2FontErrorCMapNotEmbedded(cMap.getCosObject().getObjNum(), cMap.getCosObject().getObjGen()));
            }
        } else {
            if (cMap.getCosObject() != null && cMap.getCosObject().getType() == 7) {
                cMapEmbedded = true;
            } else {
                errorCodes.addErrorCode(new PDFA2FontErrorCMapNotEmbedded(cMap.getCosObject().getObjNum(), cMap.getCosObject().getObjGen()));
            }
            PDFType0FontEncoding useCMap = cMap.getUseCMap();
            if (useCMap != null) {
                errorCodes.mergeErrorSet(Type0FontProcessor.processCMapErrors(useCMap, cidFont, conversionHandler));
            }
        }
        if (!PDFFontUtils.isCMapIdentity(cMap) && !errorCodes.errorCodeSet(PDFA2FontErrorCMapNotEmbedded.class) && cMapEmbedded) {
            CIDSystemInfo cmapInfo = cMap.getCIDSystemInfo();
            if (cmapInfo == null) {
                throw new PDFInvalidDocumentException("CIDSystemInfo is a required entry in Cmap dictionary.");
            }
            cmapRegistry = cmapInfo.getRegistry();
            cmapOrdering = cmapInfo.getOrdering();
            int cmapSupplement = cmapInfo.getSupplement();
            PDFCIDSystemInfo cidInfo = cidFont.getCIDSystemInfo();
            if (cidInfo != null) {
                ASString cidRegistry = cidInfo.getRegistry();
                ASString cidOrdering = cidInfo.getOrdering();
                int cidSupplement = cidInfo.getSupplement();
                if (!cidRegistry.equals(cmapRegistry)) {
                    errorCodes.addErrorCode(new PDFA2FontErrorMismatchedSystemInfoRegistry(cidFont.getCosObject().getObjNum(), cidFont.getCosObject().getObjGen()));
                }
                if (!cidOrdering.equals(cmapOrdering)) {
                    errorCodes.addErrorCode(new PDFA2FontErrorMismatchedSystemInfoOrdering(cidFont.getCosObject().getObjNum(), cidFont.getCosObject().getObjGen()));
                }
                if (cidSupplement < cmapSupplement) {
                    errorCodes.addErrorCode(new PDFA2FontErrorMismatchedSystemInfoSupplement(cidFont.getCosObject().getObjNum(), cidFont.getCosObject().getObjGen()));
                }
            } else {
                throw new PDFInvalidDocumentException("CIDSystemInfo is a required entry in CIDFont.");
            }
        }
        if (cMapEmbedded) {
            ArrayList<String> referencedCmaps;
            PDFWritingMode cMapStreamWMode;
            PDFWritingMode cMapDictWMode = cMap.getWModeFromCMapDict();
            if (cMapDictWMode != (cMapStreamWMode = CMapResourceBuilder.getWMode(cMap.getCosStream()))) {
                errorCodes.addErrorCode(new PDFA2FontErrorMismatchedCMapWModes(cMap.getCosObject().getObjNum(), cMap.getCosObject().getObjGen()));
            }
            if ((referencedCmaps = CMapResourceBuilder.getReferencedCmaps(cMap.getCosStream())) != null) {
                for (int i = 0; i < referencedCmaps.size(); ++i) {
                    String cmap = referencedCmaps.get(i);
                    if (CMapsUtil.isPredefinedCmapPermitted(cmap)) continue;
                    errorCodes.addErrorCode(new PDFA2FontErrorNonPermittedCmapReferencedFromCmap(cMap.getCosObject().getObjNum(), cMap.getCosObject().getObjGen()));
                    break;
                }
            }
        }
        return errorCodes;
    }

    private static CosStream embedCMap(CosDocument cosDoc, ASName cmapName, Map<ASName, CosStream> cMapsEmbedded) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, MissingResourceException {
        if (cMapsEmbedded.containsKey(cmapName)) {
            return cMapsEmbedded.get(cmapName);
        }
        CMapObject preDef = PDFCMap.getCMapObjectForName(cmapName.asString());
        CosStream cmapObj = preDef.getCMapStream(cosDoc, false);
        cMapsEmbedded.put(cmapName, cmapObj);
        return cmapObj;
    }

    private static boolean embedCMap(PDFFontType0 type0Font, Map<ASName, CosStream> cMapsEmbedded) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFType0FontEncoding cMap = type0Font.getEncoding();
        CosDocument cosDoc = type0Font.getCosObject().getDocument();
        if (cMap == null) {
            return true;
        }
        if (!cMap.isPredefinedCMap() && cMap.getCosObject().getType() == 7) {
            PDFType0FontEncoding useCMap = cMap.getUseCMap();
            return CMapsUtil.isPredefinedCmapPermitted(useCMap.getCMapName());
        }
        ASName cmapName = cMap.getCMapName();
        if (CMapsUtil.isPredefinedCmapPermitted(cmapName)) {
            return true;
        }
        CosStream cmapStream = null;
        try {
            cmapStream = Type0FontProcessor.embedCMap(cosDoc, cmapName, cMapsEmbedded);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (cmapStream != null) {
            type0Font.getCosDictionary().put(ASName.k_Encoding, cmapStream);
            return PDFFontUtils.setWModeInEmbeddedCMap(type0Font);
        }
        return false;
    }
}

