/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.XObjectsCycleDetector;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceCMYK;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceGray;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceRGB;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFRenderingIntent;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFGroupAttributes;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectPostScript;
import com.adobe.internal.pdftoolkit.pdf.utils.ContentUtil;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetXObject;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.common.PDFXobjectImageColorSpaceAdapter;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAXObjectErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.ColorSpaceProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.ContentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.DocumentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.GStateRegionInfo;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.MetadataProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.SharedConstraints;
import java.util.Set;

class XObjectProcessor {
    XObjectProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean process(PDFXObjectMap xObjectMap, Set referencedXObjectNames, DocumentProcessor docProcessor, PDFResources parentResources, PDFAConformanceLevel conformance, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler validationHandler) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (xObjectMap == null || xObjectMap.isEmpty()) {
            return true;
        }
        XObjectsCycleDetector cycleDetector = XObjectsCycleDetector.getInstance(xObjectMap.getPDFDocument());
        if (validationOptions.validateUnusedResourcesEnabled()) {
            for (ASName name : xObjectMap.keySet()) {
                PDFXObject xObject = xObjectMap.get(name);
                if (xObject instanceof PDFXObjectForm || xObject instanceof PDFXObjectImage) continue;
                if (cycleDetector.cycleDetected(xObject)) {
                    throw new PDFInvalidDocumentException("Cyclic dependency found while processing xobjects.");
                }
                cycleDetector.push(xObject);
                try {
                    if (XObjectProcessor.process(name, xObject, docProcessor, parentResources, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    cycleDetector.pop();
                }
            }
        } else {
            if (referencedXObjectNames == null || referencedXObjectNames.isEmpty()) {
                return true;
            }
            for (ASName name : referencedXObjectNames) {
                PDFXObject xObject = xObjectMap.get(name);
                if (xObject instanceof PDFXObjectForm || xObject instanceof PDFXObjectImage) continue;
                if (cycleDetector.cycleDetected(xObject)) {
                    throw new PDFInvalidDocumentException("Cyclic dependency found while processing xobjects.");
                }
                cycleDetector.push(xObject);
                try {
                    if (XObjectProcessor.process(name, xObject, docProcessor, parentResources, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler)) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    cycleDetector.pop();
                }
            }
        }
        return true;
    }

    static boolean process(ASName name, PDFXObject xObject, DocumentProcessor docProcessor, PDFResources parentResources, PDFAConformanceLevel conformance, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler validationHandler) throws PDFIOException, PDFSecurityException {
        return XObjectProcessor.process(name, xObject, docProcessor, parentResources, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, null);
    }

    public static boolean process(ASName name, PDFXObject xObject, DocumentProcessor docProcessor, PDFResources parentResources, PDFAConformanceLevel conformance, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler validationHandler, GStateRegionInfo parentGStateInfo) throws PDFIOException, PDFSecurityException {
        if (xObject == null) {
            return true;
        }
        if (!validationHandler.beginXObjectScan(name, xObject)) {
            return false;
        }
        PDFAErrorSetXObject errorCodes = new PDFAErrorSetXObject();
        try {
            if (xObject.getPDFDocument().requireCatalog().getOCProperties() != null && PDFOCObject.hasOC(xObject)) {
                if (conversionHandler != null && conversionOptions.getRemoveOptionalContent()) {
                    PDFOCObject oc = PDFOCObject.getOC(xObject);
                    if (docProcessor.canRemovePDFOCObject(oc)) {
                        PDFOCObject.removeOC(xObject);
                        if (!conversionHandler.xObjectOnOCEntryRemoved(xObject, oc)) {
                            return false;
                        }
                    } else {
                        errorCodes.addErrorCode(PDFAXObjectErrorCode.xObjectIsOptionalContent);
                        docProcessor.markOCsOCGsUnremovable(oc);
                    }
                } else {
                    errorCodes.addErrorCode(PDFAXObjectErrorCode.xObjectIsOptionalContent);
                }
            }
            if (xObject instanceof PDFXObjectForm) {
                PDFXObjectForm form;
                if (!MetadataProcessor.processDictionaryXMP(xObject, conversionHandler)) {
                    errorCodes.addErrorCode(PDFAXObjectErrorCode.objectXMPMetadataInvalid);
                }
                if ((form = (PDFXObjectForm)xObject).isReferenceXObject()) {
                    errorCodes.addErrorCode(PDFAXObjectErrorCode.referenceXObjectNotAllowed);
                } else {
                    Content content;
                    ASName subType2;
                    PDFGroupAttributes group;
                    if (form.isGroupXObject() && (group = form.getGroup()).getSubType() == ASName.k_Transparency) {
                        errorCodes.addErrorCode(PDFAXObjectErrorCode.transparencyGroupNotAllowed);
                    }
                    if (form.dictionaryContains(ASName.k_OPI)) {
                        if (conversionHandler != null && conversionOptions.getRemoveXObjectOPI()) {
                            form.removeValue(ASName.k_OPI);
                            if (!conversionHandler.opiRemovedFromXObject(form)) {
                                return false;
                            }
                        } else {
                            errorCodes.addErrorCode(PDFAXObjectErrorCode.opiNotAllowed);
                        }
                    }
                    if (form.getCosDictionary().containsKey(ASName.k_Subtype2) && (subType2 = form.getDictionaryNameValue(ASName.k_Subtype2)).equals(ASName.k_PS)) {
                        if (conversionHandler != null && conversionOptions.getRemoveFormXObjectPSData()) {
                            form.removeValue(ASName.k_Subtype2);
                            if (!conversionHandler.psRemovedFromXObject(form, ASName.k_Subtype2)) {
                                return false;
                            }
                        } else {
                            errorCodes.addErrorCode(PDFAXObjectErrorCode.subtype2ValueNotAllowed);
                        }
                    }
                    if (form.getCosDictionary().containsKey(ASName.k_PS)) {
                        if (conversionHandler != null && conversionOptions.getRemoveFormXObjectPSData()) {
                            form.removeValue(ASName.k_PS);
                            if (!conversionHandler.psRemovedFromXObject(form, ASName.k_PS)) {
                                return false;
                            }
                        } else {
                            errorCodes.addErrorCode(PDFAXObjectErrorCode.psNotAllowed);
                        }
                    }
                    if ((content = ContentUtil.getContent(conversionHandler != null, form, parentResources)) != null) {
                        PDFResources resources;
                        if (!ContentProcessor.process(content, form, null, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, parentGStateInfo)) {
                            return false;
                        }
                        if (conversionHandler != null && content.resourcesDetached() && !(resources = content.getResources()).isEmpty()) {
                            form.setResources(content.getResources());
                        }
                    }
                }
            } else if (xObject instanceof PDFXObjectImage) {
                PDFColorSpace cs;
                int bpc;
                PDFXObjectImage image;
                if (!MetadataProcessor.processDictionaryXMP(xObject, conversionHandler)) {
                    errorCodes.addErrorCode(PDFAXObjectErrorCode.objectXMPMetadataInvalid);
                }
                if ((image = (PDFXObjectImage)xObject).dictionaryContains(ASName.k_Alternates)) {
                    if (conversionHandler != null && conversionOptions.getRemoveImageAlternates()) {
                        image.removeValue(ASName.k_Alternates);
                        if (!conversionHandler.alternatesRemovedFromImage(image)) {
                            return false;
                        }
                    } else {
                        errorCodes.addErrorCode(PDFAXObjectErrorCode.alternateImagesNotAllowed);
                    }
                }
                if (image.dictionaryContains(ASName.k_OPI)) {
                    if (conversionHandler != null && conversionOptions.getRemoveXObjectOPI()) {
                        image.removeValue(ASName.k_OPI);
                        if (!conversionHandler.opiRemovedFromXObject(image)) {
                            return false;
                        }
                    } else {
                        errorCodes.addErrorCode(PDFAXObjectErrorCode.opiNotAllowed);
                    }
                }
                if (image.dictionaryContains(ASName.k_Interpolate) && image.getDictionaryBooleanValue(ASName.k_Interpolate)) {
                    if (conversionHandler != null && conversionOptions.getRemoveIllegalInterpolation()) {
                        image.removeValue(ASName.k_Interpolate);
                        if (!conversionHandler.illegalInterpolationRemoved()) {
                            return false;
                        }
                    } else {
                        errorCodes.addErrorCode(PDFAXObjectErrorCode.interpolationNotAllowed);
                    }
                }
                if (image.dictionaryContains(ASName.k_Intent) && !SharedConstraints.allowedRenderingIntents.contains(image.getIntent())) {
                    if (conversionHandler != null && conversionOptions.getOverrideRenderingIntent() != null) {
                        ASName oldIntent = image.getIntent();
                        PDFRenderingIntent newIntent = conversionOptions.getOverrideRenderingIntent();
                        image.setIntent(newIntent.getValue());
                        if (!conversionHandler.renderingIntentOverridden(oldIntent, newIntent.getValue())) {
                            return false;
                        }
                    } else {
                        errorCodes.addErrorCode(PDFAXObjectErrorCode.renderingIntentValueNotAllowed);
                    }
                }
                if (image.dictionaryContains(ASName.k_SMask)) {
                    errorCodes.addErrorCode(PDFAXObjectErrorCode.softMaskNotAllowed);
                }
                if (image.dictionaryContains(ASName.k_BitsPerComponent) && (bpc = image.getBitsPerComponent()) > 8) {
                    errorCodes.addErrorCode(PDFAXObjectErrorCode.imageWithMoreThan8BPCNotAllowed);
                }
                if ((cs = image.getColorSpace()) != null) {
                    if (!(cs instanceof PDFColorSpaceDeviceRGB || cs instanceof PDFColorSpaceDeviceCMYK || cs instanceof PDFColorSpaceDeviceGray)) {
                        CosObject csObj = image.getDictionaryValue(ASName.k_ColorSpace);
                        if (csObj != null && csObj.getType() == 5) {
                            PDFXobjectImageColorSpaceAdapter adapter;
                            CosArray csArray = (CosArray)csObj;
                            ASName csName = csArray.getName(0);
                            PDFColorSpaceMap colorSpaceMap = parentResources.getColorSpaceMap();
                            boolean defaultRGBSet = false;
                            boolean defaultCMYKSet = false;
                            if (colorSpaceMap != null) {
                                defaultRGBSet = colorSpaceMap.get(ASName.k_DefaultRGB) != null;
                                boolean bl = defaultCMYKSet = colorSpaceMap.get(ASName.k_DefaultCMYK) != null;
                            }
                            if (!ColorSpaceProcessor.process(adapter = new PDFXobjectImageColorSpaceAdapter(image), csName, cs, docProcessor, defaultRGBSet, defaultCMYKSet, conformance, validationHandler, conversionHandler)) {
                                return false;
                            }
                        }
                    } else {
                        boolean defaultRGBSet = false;
                        boolean defaultCMYKSet = false;
                        boolean defaultGraySet = false;
                        PDFColorSpaceMap colorSpaceMap = null;
                        if (parentResources != null && (colorSpaceMap = parentResources.getColorSpaceMap()) != null) {
                            defaultRGBSet = colorSpaceMap.get(ASName.k_DefaultRGB) != null;
                            defaultCMYKSet = colorSpaceMap.get(ASName.k_DefaultCMYK) != null;
                            boolean bl = defaultGraySet = colorSpaceMap.get(ASName.k_DefaultGray) != null;
                        }
                        if (cs instanceof PDFColorSpaceDeviceRGB) {
                            PDFColorSpace defaultRGB;
                            if (conversionHandler != null && !defaultRGBSet && !docProcessor.hasRGBOutputIntent && (defaultRGB = conversionOptions.getDefaultRGBColorSpace()) != null) {
                                if (colorSpaceMap == null) {
                                    colorSpaceMap = PDFColorSpaceMap.newInstance(docProcessor.document);
                                    parentResources.setColorSpaceMap(colorSpaceMap);
                                }
                                colorSpaceMap.set(ASName.k_DefaultRGB, defaultRGB);
                                defaultRGBSet = true;
                                if (!conversionHandler.defaultColorSpaceSet(ASName.k_DefaultRGB, defaultRGB)) {
                                    return false;
                                }
                            }
                            if (!defaultRGBSet && !docProcessor.hasRGBOutputIntent) {
                                errorCodes.addErrorCode(PDFAXObjectErrorCode.deviceDependentColorUsed);
                            }
                        } else if (cs instanceof PDFColorSpaceDeviceCMYK) {
                            PDFColorSpace defaultCMYK;
                            if (conversionHandler != null && !defaultCMYKSet && !docProcessor.hasCMYKOutputIntent && (defaultCMYK = conversionOptions.getDefaultCMYKColorSpace()) != null) {
                                if (colorSpaceMap == null) {
                                    colorSpaceMap = PDFColorSpaceMap.newInstance(docProcessor.document);
                                    parentResources.setColorSpaceMap(colorSpaceMap);
                                }
                                colorSpaceMap.set(ASName.k_DefaultCMYK, defaultCMYK);
                                defaultCMYKSet = true;
                                if (!conversionHandler.defaultColorSpaceSet(ASName.k_DefaultCMYK, defaultCMYK)) {
                                    return false;
                                }
                            }
                            if (!defaultCMYKSet && !docProcessor.hasCMYKOutputIntent) {
                                errorCodes.addErrorCode(PDFAXObjectErrorCode.deviceDependentColorUsed);
                            }
                        } else if (cs instanceof PDFColorSpaceDeviceGray) {
                            PDFColorSpace defaultGray;
                            if (conversionHandler != null && !defaultGraySet && !docProcessor.hasGRAYOutputIntent && (defaultGray = conversionOptions.getDefaultGrayColorSpace()) != null) {
                                if (colorSpaceMap == null) {
                                    colorSpaceMap = PDFColorSpaceMap.newInstance(docProcessor.document);
                                    parentResources.setColorSpaceMap(colorSpaceMap);
                                }
                                colorSpaceMap.set(ASName.k_DefaultGray, defaultGray);
                                defaultGraySet = true;
                                if (!conversionHandler.defaultColorSpaceSet(ASName.k_DefaultGray, defaultGray)) {
                                    return false;
                                }
                            }
                            if (!defaultGraySet && !docProcessor.hasGRAYOutputIntent) {
                                errorCodes.addErrorCode(PDFAXObjectErrorCode.deviceDependentColorUsed);
                            }
                        }
                    }
                }
            } else if (xObject instanceof PDFXObjectPostScript) {
                errorCodes.addErrorCode(PDFAXObjectErrorCode.postScriptXObjectNotAllowed);
            }
        }
        catch (PDFInvalidDocumentException e) {
            errorCodes.addErrorCode(PDFAXObjectErrorCode.pdfGeneralFailure);
        }
        if (errorCodes.hasErrors() && !validationHandler.xObjectError(errorCodes)) {
            return false;
        }
        return validationHandler.endXObjectScan();
    }

    static boolean hasTransparency(PDFXObjectMap xObjectMap) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        for (ASName name : xObjectMap.keySet()) {
            PDFXObject xObject = xObjectMap.get(name);
            if (xObject == null || !XObjectProcessor.hasTransparency(xObject)) continue;
            return true;
        }
        return false;
    }

    static boolean hasTransparency(PDFXObject xObject) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        PDFXObjectImage image;
        if (xObject instanceof PDFXObjectForm) {
            PDFXObjectForm form = (PDFXObjectForm)xObject;
            if (form.isGroupXObject()) {
                PDFGroupAttributes group = form.getGroup();
                if (group != null && group.getSubType() == ASName.k_Transparency) {
                    return true;
                }
                Content content = ContentUtil.getContent(false, form, null);
                if (content != null) {
                    return ContentProcessor.hasTransparency(content);
                }
            }
        } else if (xObject instanceof PDFXObjectImage && (image = (PDFXObjectImage)xObject).dictionaryContains(ASName.k_SMask)) {
            return true;
        }
        return false;
    }
}

