/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGStateMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPatternMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShadingMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCPropertyMap;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.DocumentProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.GStateRegionInfo;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.ReferencedResources;
import com.adobe.internal.pdftoolkit.services.pdfa.processor.ResourceProcessor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ContentProcessor {
    static final double MAX_REAL = 32767.0;
    static final double MIN_REAL = -32767.0;
    private static final HashSet<ASName> markingOperators = new HashSet(14);
    private static final HashSet<ASName> strokingOperators;
    private static final HashSet<ASName> fillingOperators;
    private static final HashSet<ASName> textShowingOperators;

    public static boolean process(Content content, PDFCosDictionary parent, ASName charProcName, DocumentProcessor docProcessor, PDFAConformanceLevel conformance, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler validationHandler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return ContentProcessor.process(content, parent, charProcName, docProcessor, conformance, conversionOptions, conversionHandler, validationOptions, validationHandler, null);
    }

    /*
     * Exception decompiling
     */
    public static boolean process(Content content, PDFCosDictionary parent, ASName charProcName, DocumentProcessor docProcessor, PDFAConformanceLevel conformance, PDFAConversionOptions conversionOptions, PDFAConversionHandler conversionHandler, PDFAValidationOptions validationOptions, PDFAValidationHandler validationHandler, GStateRegionInfo inheritedGStateInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 447[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void removeUnusedResources(PDFResources resources, ReferencedResources referencedResources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectMap xObjectMap;
        PDFPatternMap patternMap;
        PDFShadingMap shadingMap;
        PDFMCPropertyMap propertyMap;
        PDFFontMap fontMap;
        PDFExtGStateMap extGStateMap;
        if (resources == null) {
            return;
        }
        PDFColorSpaceMap csMap = resources.getColorSpaceMap();
        if (csMap != null) {
            Set explicitlyReferencedNames = referencedResources.getColorSpaceNames();
            HashSet<ASName> includingImplicitNames = new HashSet<ASName>();
            if (explicitlyReferencedNames != null) {
                includingImplicitNames.addAll(explicitlyReferencedNames);
            }
            includingImplicitNames.add(ASName.k_DefaultRGB);
            includingImplicitNames.add(ASName.k_DefaultCMYK);
            includingImplicitNames.add(ASName.k_DefaultGray);
            ContentProcessor.scrubUnreferencedResources(csMap.keySet(), includingImplicitNames);
            if (csMap.size() == 0) {
                resources.removeColorSpaceMap();
            }
        }
        if ((extGStateMap = resources.getExtGStateMap()) != null) {
            ContentProcessor.scrubUnreferencedResources(extGStateMap.keySet(), referencedResources.getExtGStateNames());
            if (extGStateMap.size() == 0) {
                resources.removeExtGStateMap();
            }
        }
        if ((fontMap = resources.getFontMap()) != null) {
            ContentProcessor.scrubUnreferencedResources(fontMap.keySet(), referencedResources.getFontNames());
            if (fontMap.size() == 0) {
                resources.removeFontMap();
            }
        }
        if ((propertyMap = resources.getMCPropertyMap()) != null) {
            ContentProcessor.scrubUnreferencedResources(propertyMap.keySet(), referencedResources.getPropertyNames());
            if (propertyMap.size() == 0) {
                resources.removeMCPropertyMap();
            }
        }
        if ((shadingMap = resources.getShadingMap()) != null) {
            ContentProcessor.scrubUnreferencedResources(shadingMap.keySet(), referencedResources.getShadingNames());
            if (shadingMap.size() == 0) {
                resources.removeShadingMap();
            }
        }
        if ((patternMap = resources.getPatternMap()) != null) {
            ContentProcessor.scrubUnreferencedResources(patternMap.keySet(), referencedResources.getTilingPatternNames());
            if (patternMap.size() == 0) {
                resources.removePatternMap();
            }
        }
        if ((xObjectMap = resources.getXObjectMap()) != null) {
            ContentProcessor.scrubUnreferencedResources(xObjectMap.keySet(), referencedResources.getXObjectNames());
            if (xObjectMap.size() == 0) {
                resources.removeXObjectMap();
            }
        }
    }

    private static void scrubUnreferencedResources(Set<ASName> namesInResourceSubDict, Set<ASName> namesReferenced) {
        block4: {
            if (namesInResourceSubDict == null) break block4;
            Iterator<ASName> iter = namesInResourceSubDict.iterator();
            if (namesReferenced == null || namesReferenced.isEmpty()) {
                while (iter.hasNext()) {
                    iter.next();
                    iter.remove();
                }
            } else {
                while (iter.hasNext()) {
                    ASName aResourceName = iter.next();
                    if (namesReferenced.contains(aResourceName)) continue;
                    iter.remove();
                }
            }
        }
    }

    static boolean hasTransparency(Content content) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFResources resources = content.getResources();
        return ResourceProcessor.hasTransparency(resources);
    }

    static {
        markingOperators.add(ASName.k_S);
        markingOperators.add(ASName.k_s);
        markingOperators.add(ASName.k_F);
        markingOperators.add(ASName.k_f);
        markingOperators.add(ASName.k_fStar);
        markingOperators.add(ASName.k_B);
        markingOperators.add(ASName.k_b);
        markingOperators.add(ASName.k_BStar);
        markingOperators.add(ASName.k_bStar);
        markingOperators.add(ASName.k_TJ);
        markingOperators.add(ASName.k_Tj);
        markingOperators.add(ASName.k_SingleQuote);
        markingOperators.add(ASName.k_DoubleQuote);
        markingOperators.add(ASName.k_sh);
        strokingOperators = new HashSet(6);
        strokingOperators.add(ASName.k_S);
        strokingOperators.add(ASName.k_s);
        strokingOperators.add(ASName.k_B);
        strokingOperators.add(ASName.k_b);
        strokingOperators.add(ASName.k_BStar);
        strokingOperators.add(ASName.k_bStar);
        fillingOperators = new HashSet(8);
        fillingOperators.add(ASName.k_F);
        fillingOperators.add(ASName.k_f);
        fillingOperators.add(ASName.k_fStar);
        fillingOperators.add(ASName.k_B);
        fillingOperators.add(ASName.k_b);
        fillingOperators.add(ASName.k_BStar);
        fillingOperators.add(ASName.k_bStar);
        fillingOperators.add(ASName.k_sh);
        textShowingOperators = new HashSet(4);
        textShowingOperators.add(ASName.k_TJ);
        textShowingOperators.add(ASName.k_Tj);
        textShowingOperators.add(ASName.k_SingleQuote);
        textShowingOperators.add(ASName.k_DoubleQuote);
    }
}

