/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa.font;

import com.adobe.fontengine.FontEngineException;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFontWidths;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSetFont;
import com.adobe.internal.pdftoolkit.services.pdfa.common.FontProcessorUtils;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAFontErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.font.FontContext;
import com.adobe.internal.pdftoolkit.services.pdfa.font.FontProcessor;
import com.adobe.internal.pdftoolkit.services.pdfa.font.ReferencedFontInfoProcessor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class WidthsProcessor {
    WidthsProcessor() {
    }

    private static PDFAErrorSetFont fixSimpleFontWidths(PDFFontSimple simpleFont, PDFAConversionHandler conversionHandler, PDFAErrorSetFont errorCodes, FontContext fontContext) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, FontEngineException, PDFInvalidParameterException {
        int firstChar = 0;
        int lastChar = 255;
        int[] Widths = null;
        try {
            firstChar = simpleFont.getFirstChar();
            lastChar = simpleFont.getLastChar();
            Widths = simpleFont.getWidths();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (Widths == null) {
            errorCodes.addErrorCode(PDFAFontErrorCode.missingOrIncompleteWidthsArray);
        } else {
            int numChars = lastChar - firstChar + 1;
            if (Widths.length != numChars) {
                errorCodes.addErrorCode(PDFAFontErrorCode.missingOrIncompleteWidthsArray);
            }
        }
        if (conversionHandler != null && (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.mismatchedWidthsInfo) || FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.missingOrIncompleteWidthsArray)) && FontProcessorUtils.embedWidthsArray(simpleFont, null, fontContext)) {
            FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.mismatchedWidthsInfo);
            FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.missingOrIncompleteWidthsArray);
            if (!conversionHandler.widthsMetricsUpdated(simpleFont)) {
                return null;
            }
        }
        return errorCodes;
    }

    private static PDFAErrorSetFont fixType0FontsWidth(PDFFont font, List showStringList, PDFAConversionHandler conversionHandler, PDFAErrorSetFont errorCodes) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFontType0 type0Font = (PDFFontType0)font;
        PDFCIDFont cidFont = type0Font.getDescendantFont();
        HashSet<Integer> charCodes = ReferencedFontInfoProcessor.getReferencedCharCodes(font, showStringList);
        if (charCodes == null) {
            return errorCodes;
        }
        int dw = cidFont.getDW();
        Font afeFont = null;
        try {
            afeFont = font.getAFEFont();
        }
        catch (FontEngineException e3) {
            errorCodes.addErrorCode(PDFAFontErrorCode.fontDataCorrupt);
        }
        PDFCIDFontWidths pdfCIDFontWidths = PDFCIDFontWidths.newInstance(font.getPDFDocument());
        Iterator<Integer> iter = charCodes.iterator();
        try {
            WidthsProcessor.compareCIDFontWidths(pdfCIDFontWidths, iter, type0Font, afeFont, dw);
        }
        catch (FontEngineException e) {
            errorCodes.addErrorCode(PDFAFontErrorCode.fontDataCorrupt);
        }
        catch (PDFFontException e) {
            errorCodes.addErrorCode(PDFAFontErrorCode.pdfGeneralFailure);
        }
        cidFont.setDW(dw);
        cidFont.setW(pdfCIDFontWidths);
        FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.mismatchedWidthsInfo);
        FontProcessor.unSetErrorFlag(errorCodes, PDFAFontErrorCode.missingOrIncompleteWidthsArray);
        if (!conversionHandler.widthsMetricsUpdated(font)) {
            return null;
        }
        return errorCodes;
    }

    private static boolean compareCIDFontWidths(PDFCIDFontWidths pdfCIDFontWidths, Iterator<Integer> charCodesIter, PDFFontType0 font, Font afeFont, int dw) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, InvalidFontException, UnsupportedFontException, FontLoadingException {
        boolean widthsChanged = false;
        double[] dWidths = new double[1];
        while (charCodesIter.hasNext()) {
            Integer charCodeInt = charCodesIter.next();
            int charCode = charCodeInt;
            int gid = font.charCode2gid(charCode);
            int cid = font.getEncoding().getCID(charCode);
            if (gid <= 0) continue;
            dWidths[0] = afeFont.getPDFFontDescription().getAdvance(gid);
            if (!(Math.abs(dWidths[0] - (double)dw) > 1.0)) continue;
            pdfCIDFontWidths.addWidths(dWidths, cid, cid);
            widthsChanged = true;
        }
        return widthsChanged;
    }

    static PDFAErrorSetFont fixWidths(PDFFont font, List showStringList, PDFAConversionHandler conversionHandler, PDFAErrorSetFont errorCodes, FontContext fontContext) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, FontEngineException, PDFInvalidParameterException {
        if (conversionHandler != null && (FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.mismatchedWidthsInfo) || FontProcessor.isSetErrorFlag(errorCodes, PDFAFontErrorCode.missingOrIncompleteWidthsArray))) {
            if (font instanceof PDFFontSimple) {
                WidthsProcessor.fixSimpleFontWidths((PDFFontSimple)font, conversionHandler, errorCodes, fontContext);
            } else if (font instanceof PDFFontType0) {
                WidthsProcessor.fixType0FontsWidth(font, showStringList, conversionHandler, errorCodes);
            }
        }
        return errorCodes;
    }
}

