/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa;

import com.adobe.internal.pdftoolkit.services.pdfa.PDFAErrorSet;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAErrorCode;
import com.adobe.internal.pdftoolkit.services.pdfa.error.PDFAXObjectErrorCode;
import java.util.ArrayList;

public class PDFAErrorSetXObject
extends PDFAErrorSet {
    public PDFAErrorSetXObject() {
        super(PDFAXObjectErrorCode.class);
    }

    public PDFAErrorSetXObject(PDFAErrorCode errorCode) {
        this();
        this.addErrorCode(errorCode);
    }

    public boolean opiNotAllowed() {
        return this.errorCodeSet(PDFAXObjectErrorCode.opiNotAllowed);
    }

    public boolean subtype2ValueNotAllowed() {
        return this.errorCodeSet(PDFAXObjectErrorCode.subtype2ValueNotAllowed);
    }

    public boolean psNotAllowed() {
        return this.errorCodeSet(PDFAXObjectErrorCode.psNotAllowed);
    }

    public boolean referenceXObjectNotAllowed() {
        return this.errorCodeSet(PDFAXObjectErrorCode.referenceXObjectNotAllowed);
    }

    public boolean postScriptXObjectNotAllowed() {
        return this.errorCodeSet(PDFAXObjectErrorCode.postScriptXObjectNotAllowed);
    }

    public boolean alternateImagesNotAllowed() {
        return this.errorCodeSet(PDFAXObjectErrorCode.alternateImagesNotAllowed);
    }

    public boolean interpolationNotAllowed() {
        return this.errorCodeSet(PDFAXObjectErrorCode.interpolationNotAllowed);
    }

    public boolean renderingIntentValueNotAllowed() {
        return this.errorCodeSet(PDFAXObjectErrorCode.renderingIntentValueNotAllowed);
    }

    public boolean softMaskNotAllowed() {
        return this.errorCodeSet(PDFAXObjectErrorCode.softMaskNotAllowed);
    }

    public boolean transparencyGroupNotAllowed() {
        return this.errorCodeSet(PDFAXObjectErrorCode.transparencyGroupNotAllowed);
    }

    public boolean imageWithMoreThan8BPCNotAllowed() {
        return this.errorCodeSet(PDFAXObjectErrorCode.imageWithMoreThan8BPCNotAllowed);
    }

    public boolean xObjectIsOptionalContent() {
        return this.errorCodeSet(PDFAXObjectErrorCode.xObjectIsOptionalContent);
    }

    public boolean deviceDependentColorUsed() {
        return this.errorCodeSet(PDFAXObjectErrorCode.deviceDependentColorUsed);
    }

    public boolean objectXMPMetadataInvalid() {
        return this.errorCodeSet(PDFAXObjectErrorCode.objectXMPMetadataInvalid);
    }

    @Override
    public boolean pdfGeneralFailure() {
        return this.errorCodeSet(PDFAXObjectErrorCode.pdfGeneralFailure);
    }

    @Override
    public String toString() {
        ArrayList<String> violations = new ArrayList<String>(5);
        if (this.pdfGeneralFailure()) {
            violations.add("pdf general failure");
        }
        if (this.opiNotAllowed()) {
            violations.add("OPI entry not permitted");
        }
        if (this.subtype2ValueNotAllowed()) {
            violations.add("Subtype 2 value not permitted");
        }
        if (this.psNotAllowed()) {
            violations.add("PS entry not permitted");
        }
        if (this.referenceXObjectNotAllowed()) {
            violations.add("reference xobject not allowed");
        }
        if (this.postScriptXObjectNotAllowed()) {
            violations.add("postscript xobject not allowed");
        }
        if (this.alternateImagesNotAllowed()) {
            violations.add("alternate images not allowed in image xobjects");
        }
        if (this.interpolationNotAllowed()) {
            violations.add("interpolation now allowed for images");
        }
        if (this.renderingIntentValueNotAllowed()) {
            violations.add("ri value not permitted");
        }
        if (this.softMaskNotAllowed()) {
            violations.add("SMask not permitted for images");
        }
        if (this.transparencyGroupNotAllowed()) {
            violations.add("transparency group not allowed");
        }
        if (this.imageWithMoreThan8BPCNotAllowed()) {
            violations.add("16-bit (and greater) images not allowed");
        }
        if (this.xObjectIsOptionalContent()) {
            violations.add("xObject has an OC (optional content) entry");
        }
        if (this.deviceDependentColorUsed()) {
            violations.add("xObject uses device-dependent color space not backed by PDF/A output intent");
        }
        if (this.objectXMPMetadataInvalid()) {
            violations.add("Object XMP metadata is not valid");
        }
        return super.toString() + " " + violations;
    }
}

