/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfa;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;

public final class PDFAConformanceLevel {
    static int Level1a = 1;
    static int Level1b = 2;
    static String Level_1a_STR = "PDF/A-1a";
    static String Level_1b_STR = "PDF/A-1b";
    private int conformanceLevel;
    public static final PDFAConformanceLevel Level_1a = new PDFAConformanceLevel(Level1a);
    public static final PDFAConformanceLevel Level_1b = new PDFAConformanceLevel(Level1b);

    PDFAConformanceLevel(int conformanceLevel) {
        this.conformanceLevel = conformanceLevel;
    }

    public String toString() {
        if (this.conformanceLevel == Level1a) {
            return Level_1a_STR;
        }
        if (this.conformanceLevel == Level1b) {
            return Level_1b_STR;
        }
        return null;
    }

    static final PDFAConformanceLevel getInstance(int level) throws PDFInvalidParameterException {
        PDFAConformanceLevel pdfaConformance = null;
        switch (level) {
            case 1: {
                pdfaConformance = Level_1a;
                break;
            }
            case 2: {
                pdfaConformance = Level_1b;
                break;
            }
            default: {
                throw new PDFInvalidParameterException("Unsupported conformance level");
            }
        }
        return pdfaConformance;
    }
}

