/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.optimizer.fontimpl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDSystemInfo;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.EmbeddedFontDetails;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.EmbeddedFontGroup;
import com.adobe.internal.pdftoolkit.services.optimizer.fontimpl.GroupingKey;
import java.util.Collection;
import java.util.HashMap;

public class EmbeddedFontGrouper {
    private Collection<EmbeddedFontDetails> embeddedFontDetails;
    private HashMap<GroupingKey, EmbeddedFontGroup> groupingMap;

    public EmbeddedFontGrouper(Collection<EmbeddedFontDetails> embeddedFontDetails) {
        this.embeddedFontDetails = embeddedFontDetails;
        this.groupingMap = new HashMap();
    }

    public Collection<EmbeddedFontGroup> getEmbeddedFontGroups() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        for (EmbeddedFontDetails embeddedFontDetail : this.embeddedFontDetails) {
            GroupingKey key = this.createGroupingKey(embeddedFontDetail);
            EmbeddedFontGroup group = this.groupingMap.get(key);
            if (group == null) {
                group = new EmbeddedFontGroup();
                this.groupingMap.put(key, group);
            }
            group.addToGroup(embeddedFontDetail);
        }
        return this.groupingMap.values();
    }

    GroupingKey createGroupingKey(EmbeddedFontDetails embeddedFontDetails) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFont pdfFont = embeddedFontDetails.getPdfFont();
        String reducedbaseFontName = PDFFontUtils.getActualBaseFontName(pdfFont);
        ASString fontFamily = null;
        ASName subtype = pdfFont.getSubtype();
        GroupingKey key = new GroupingKey(reducedbaseFontName, fontFamily, subtype);
        if (pdfFont instanceof PDFFontType0) {
            PDFCIDSystemInfo cidSystemInfo = ((PDFFontType0)pdfFont).getDescendantFont().getCIDSystemInfo();
            key.setCidSystemInfoString(cidSystemInfo.getRegistry() + ":" + cidSystemInfo.getOrdering() + ":" + cidSystemInfo.getSupplement());
        }
        return key;
    }
}

