/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript.security;

import com.adobe.internal.pdftoolkit.services.javascript.security.JSClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.WrappedException;

public class JSSecurityController
extends SecurityController {
    private ProtectionDomain m_permissions;

    public JSSecurityController(ProtectionDomain permissions) {
        this.m_permissions = permissions;
    }

    public GeneratedClassLoader createClassLoader(ClassLoader parent, Object security) {
        if (security instanceof JSClassLoader) {
            return (JSClassLoader)security;
        }
        return new JSClassLoader(parent, this.m_permissions);
    }

    public Object getDynamicSecurityDomain(Object loader) {
        if (loader != null && loader instanceof JSClassLoader) {
            return loader;
        }
        return AccessController.getContext();
    }

    public Object callWithDomain(Object securityDomain, final Context cx, final Callable callable, final Scriptable scope, final Scriptable thisObj, final Object[] args) {
        AccessControlContext acc;
        if (securityDomain instanceof AccessControlContext) {
            acc = (AccessControlContext)securityDomain;
        } else {
            JSClassLoader loader = (JSClassLoader)securityDomain;
            acc = loader.rhinoAccessControlContext;
        }
        PrivilegedExceptionAction execAction = new PrivilegedExceptionAction(){

            public Object run() {
                return callable.call(cx, scope, thisObj, args);
            }
        };
        try {
            return AccessController.doPrivileged(execAction, acc);
        }
        catch (Exception e) {
            throw new WrappedException((Throwable)e);
        }
    }
}

