/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript.model;

import com.adobe.internal.pdftoolkit.services.javascript.Doc;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptHandler;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptSecurityException;
import com.adobe.internal.pdftoolkit.services.javascript.UnsupportedJavaScriptFeatureException;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.JSMeshValidator;
import com.adobe.internal.pdftoolkit.services.javascript.model.Param;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContinuationPending;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public abstract class ESObject
extends ScriptableObject {
    private static final long serialVersionUID = -8562261418805403801L;
    private static final Method mInvokeMethod;

    public ESObject() {
    }

    public ESObject(Scriptable scope, Scriptable prototype) {
        super(scope, prototype);
    }

    public String getClassName() {
        return "ESObject";
    }

    protected abstract ScriptTable getScriptTable();

    public Object get(String name, Scriptable start) {
        ScriptTable table = this.getScriptTable();
        Property prop = table.getProperty(name, start);
        if (prop != null) {
            if (prop.isSecurityRestricted() && !JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isTrustedMode()) {
                throw Context.throwAsScriptRuntimeEx((Throwable)new JavaScriptSecurityException());
            }
            return prop.invokeGetProp((Object)this);
        }
        Function func = table.getFunction(name);
        if (func != null) {
            if (func.getIsUnsupported()) {
                throw new UnsupportedJavaScriptFeatureException(" Unsupported javascript evaluation feature");
            }
            if (func.isSecurityRestricted()) {
                if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isTrustedMode()) {
                    throw Context.throwAsScriptRuntimeEx((Throwable)new JavaScriptSecurityException());
                }
                return new FunctionObject(name, (Member)mInvokeMethod, (Scriptable)this);
            }
            if (func.getIsGUIError()) {
                throw Context.throwAsScriptRuntimeEx((Throwable)new RuntimeException("GUI based JS API " + name + " is unsupported."));
            }
            return new FunctionObject(name, (Member)mInvokeMethod, (Scriptable)this);
        }
        return super.get(name, start);
    }

    public void put(String name, Scriptable start, Object value) {
        ScriptTable table = this.getScriptTable();
        Property prop = table.getProperty(name, start);
        if (prop != null && prop.hasSetter()) {
            if (prop.isSecurityRestricted() && !JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isTrustedMode()) {
                throw Context.throwAsScriptRuntimeEx((Throwable)new JavaScriptSecurityException());
            }
            prop.invokeSetProp((Object)this, value, start);
        } else {
            super.put(name, start, value);
        }
    }

    public static Object invoke(Context cx, Scriptable obj, Object[] args, org.mozilla.javascript.Function func) {
        if (obj instanceof ESObject) {
            ESObject esObj = (ESObject)obj;
            String fName = ((FunctionObject)func).getFunctionName();
            ScriptTable table = esObj.getScriptTable();
            Function function = table.getFunction(fName);
            Object[] finalArgs = null;
            Param[] params = function.getParams();
            if (params != null) {
                finalArgs = new Object[params.length];
                JSMeshValidator.validateFunctionParameters(params, function.getName(), args, finalArgs, cx, obj);
            }
            try {
                return function.getMMethod().invoke((Object)obj, finalArgs);
            }
            catch (IllegalArgumentException e) {
                throw Context.throwAsScriptRuntimeEx((Throwable)new RuntimeException("Exception occured while calling method " + fName, e));
            }
            catch (IllegalAccessException e) {
                throw Context.throwAsScriptRuntimeEx((Throwable)new RuntimeException("Exception occured while calling method " + fName, e));
            }
            catch (InvocationTargetException e2) {
                Throwable e = e2;
                while ((e = e.getTargetException()) instanceof InvocationTargetException) {
                }
                if (e instanceof ContinuationPending) {
                    throw (ContinuationPending)e;
                }
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
        return Undefined.instance;
    }

    public static <T extends Scriptable> T create(Scriptable scope, boolean sealed, String className, boolean putAsProp, String propName) {
        Scriptable obj = Context.getCurrentContext().newObject(scope, className);
        if (putAsProp) {
            scope.put(propName, scope, (Object)obj);
        }
        obj.setParentScope(scope);
        return (T)obj;
    }

    static {
        Method m = null;
        try {
            m = ESObject.class.getMethod("invoke", Context.class, Scriptable.class, Object[].class, org.mozilla.javascript.Function.class);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Could not find method invoke", ex);
        }
        mInvokeMethod = m;
    }
}

