/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFCertificateSeedValue;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureFieldSeedValue;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSubjectDN;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSubjectDNList;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTimeStampSeed;
import com.adobe.internal.pdftoolkit.services.javascript.CertificateSpecifier;
import com.adobe.internal.pdftoolkit.services.javascript.JSStateListener;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptException;
import com.adobe.internal.pdftoolkit.services.javascript.TimeStamp;
import com.adobe.internal.pdftoolkit.services.javascript.Util;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import com.adobe.internal.pdftoolkit.services.javascript.model.manual.SeedValueParams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Delegator;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class SeedValue
extends ESObject {
    protected static final ScriptTable scriptTable = new ScriptTable("SeedValue.class", new HashMap<String, Function>(0){
        private static final long serialVersionUID = 1L;
    }, new HashMap<String, Property>(11){
        private static final long serialVersionUID = 1L;
        {
            this.put("mdp", new Property(SeedValue.class, "mdp", "getMdp", "setMdp", SeedValueParams.mdp, false, false));
            this.put("legalAttestations", new Property(SeedValue.class, "legalAttestations", "getLegalAttestations", "setLegalAttestations", SeedValueParams.legalAttestations, false, false));
            this.put("timeStampspec", new Property(SeedValue.class, "timeStampspec", "getTimeStampspec", "setTimeStampSpec", SeedValueParams.timeStampspec, false, false));
            this.put("version", new Property(SeedValue.class, "version", "getVersion", "setVersion", SeedValueParams.version, false, false));
            this.put("flags", new Property(SeedValue.class, "flags", "getFlags", "setFlags", SeedValueParams.flags, false, false));
            this.put("filter", new Property(SeedValue.class, "filter", "getFilter", "setFilter", SeedValueParams.filter, false, false));
            this.put("shouldAddRevInfo", new Property(SeedValue.class, "shouldAddRevInfo", "getShouldAddRevInfo", "setShouldAddRevInfo", SeedValueParams.shouldAddRevInfo, false, false));
            this.put("digestMethod", new Property(SeedValue.class, "digestMethod", "getDigestMethod", "setDigestMethod", SeedValueParams.digestMethod, false, false));
            this.put("certspec", new Property(SeedValue.class, "certspec", "getCertspec", "setCertspec", SeedValueParams.certspec, false, false));
            this.put("reasons", new Property(SeedValue.class, "reasons", "getReasons", "setReasons", SeedValueParams.reasons, false, false));
            this.put("subFilter", new Property(SeedValue.class, "subFilter", "getSubFilter", "setSubFilter", SeedValueParams.subFilter, false, false));
        }
    });
    private static final long serialVersionUID = 4367224129620141022L;
    private JSStateListener.SeedValueCache seedValue = null;
    static final String className = "SeedValue";
    private Integer seedvalueId = null;

    @Override
    public Object get(String name, Scriptable start) {
        return super.get(name, start);
    }

    @Override
    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    @Override
    public String getClassName() {
        return className;
    }

    void setCurrentSigSeedValue(PDFSignatureFieldSeedValue signatureSeedValue) {
        this.seedvalueId = signatureSeedValue.getCosObject().getObjNum();
        this.seedValue = this.procureSeedValueListener(signatureSeedValue);
        this.initSeedValueCache(signatureSeedValue);
    }

    private void initSeedValueCache(PDFSignatureFieldSeedValue signatureSeedValue) {
        try {
            PDFCertificateSeedValue certificateSeedValue = signatureSeedValue.getPDFCertificateSeedValue();
            if (certificateSeedValue != null) {
                this.seedValue.certificateSeedValue = this.initCertificateSeedCache(certificateSeedValue);
            }
            this.seedValue.isNamesEntryPresent = signatureSeedValue.getCosDictionary().containsKey(ASName.k_JavaScript);
            this.seedValue.digestMethod = signatureSeedValue.getDigestMethod();
            this.seedValue.filter = signatureSeedValue.getFilter();
            this.seedValue.flags = signatureSeedValue.getFlags();
            this.seedValue.legalAttestations = signatureSeedValue.getLegalAttestations();
            this.seedValue.mdp = signatureSeedValue.getMDP();
            this.seedValue.reasons = signatureSeedValue.getReasons();
            this.seedValue.shouldAddRevInfo = signatureSeedValue.getAddRevInfo();
            this.seedValue.subFilter = signatureSeedValue.getSubFilters();
            this.seedValue.version = signatureSeedValue.getVersion();
            this.seedValue.timeStampSpec = signatureSeedValue.getPDFTimeStamp();
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getCertspec() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptException {
        JSStateListener.SeedValueCache.CertificateSpecifierCache certSeed = this.seedValue.certificateSeedValue;
        if (certSeed != null) {
            CertificateSpecifier seed = (CertificateSpecifier)((Object)ESObject.create(this.getParentScope(), true, "CertificateSpecifier", false, null));
            seed.setCurrentCertificateSeedValue(certSeed);
            return seed;
        }
        return Undefined.instance;
    }

    public void setCertspec(CertificateSpecifier certspec) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.seedValue.certificateSeedValue = certspec.getCertificateSpecifier();
    }

    public Object getDigestMethod() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String[] digestMethod = this.seedValue.digestMethod;
        if (digestMethod != null) {
            ArrayList<String> valList = new ArrayList<String>();
            Scriptable scope = this.getParentScope();
            valList.addAll(Arrays.asList(digestMethod));
            Scriptable array = Context.getCurrentContext().newArray(scope, valList.toArray());
            return new Delegator(array){

                public void put(int index, Scriptable start, Object value) {
                    ((SeedValue)SeedValue.this).seedValue.digestMethod = Util.processDelegator(((SeedValue)SeedValue.this).seedValue.digestMethod, index, value);
                }
            };
        }
        return Undefined.instance;
    }

    public void setDigestMethod(Object digestMethod) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.seedValue.digestMethod = Util.inputValidation(digestMethod);
    }

    public Object getFilter() throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName filter = this.seedValue.filter;
        if (filter != null) {
            return filter.asString();
        }
        return Undefined.instance;
    }

    public void setFilter(Object filter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.seedValue.filter = ASName.create(String.valueOf(filter));
    }

    public Object getFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Integer flags = this.seedValue.flags;
        if (flags != null) {
            return flags;
        }
        return Undefined.instance;
    }

    public void setFlags(Integer flags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.seedValue.flags = flags;
    }

    public Object getLegalAttestations() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String[] legalAttestations = this.seedValue.legalAttestations;
        if (legalAttestations != null) {
            ArrayList<String> valList = new ArrayList<String>();
            Scriptable scope = this.getParentScope();
            valList.addAll(Arrays.asList(legalAttestations));
            Scriptable array = Context.getCurrentContext().newArray(scope, valList.toArray());
            return new Delegator(array){

                public void put(int index, Scriptable start, Object value) {
                    ((SeedValue)SeedValue.this).seedValue.legalAttestations = Util.processDelegator(((SeedValue)SeedValue.this).seedValue.legalAttestations, index, value);
                }
            };
        }
        return Undefined.instance;
    }

    public void setLegalAttestations(Object legalAttestations) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.seedValue.legalAttestations = Util.inputValidation(legalAttestations);
    }

    public Object getMdp() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Integer mdp = this.seedValue.mdp;
        if (mdp != null) {
            return mdp;
        }
        return Undefined.instance;
    }

    public void setMdp(Integer mdp) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.seedValue.mdp = mdp;
    }

    public Object getReasons() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String[] reasons = this.seedValue.reasons;
        if (reasons != null) {
            ArrayList<String> valList = new ArrayList<String>();
            Scriptable scope = this.getParentScope();
            valList.addAll(Arrays.asList(reasons));
            Scriptable array = Context.getCurrentContext().newArray(scope, valList.toArray());
            return new Delegator(array){

                public void put(int index, Scriptable start, Object value) {
                    ((SeedValue)SeedValue.this).seedValue.reasons = Util.processDelegator(((SeedValue)SeedValue.this).seedValue.reasons, index, value);
                }
            };
        }
        return Undefined.instance;
    }

    public void setReasons(Object reasons) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.seedValue.reasons = Util.inputValidation(reasons);
    }

    public Object getShouldAddRevInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Boolean shouldAddRevInfo = this.seedValue.shouldAddRevInfo;
        if (shouldAddRevInfo != null) {
            return shouldAddRevInfo;
        }
        return false;
    }

    public void setShouldAddRevInfo(Boolean shouldAddRevInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.seedValue.shouldAddRevInfo = shouldAddRevInfo;
    }

    public Object getSubFilter() throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName[] sFilters = this.seedValue.subFilter;
        if (sFilters != null && sFilters.length > 0) {
            String[] subFilter = new String[sFilters.length];
            for (int i = 0; i < sFilters.length; ++i) {
                subFilter[i] = sFilters[i].asString();
            }
            ArrayList<String> valList = new ArrayList<String>();
            if (subFilter != null && subFilter.length > 0) {
                valList.addAll(Arrays.asList(subFilter));
            }
            Scriptable scope = this.getParentScope();
            Scriptable array = Context.getCurrentContext().newArray(scope, valList.toArray());
            return new Delegator(array){

                public void put(int index, Scriptable start, Object value) {
                    ASName[] sFilters = ((SeedValue)SeedValue.this).seedValue.subFilter;
                    if (sFilters != null && sFilters.length > 0) {
                        String[] subFilter = new String[sFilters.length];
                        for (int i = 0; i < sFilters.length; ++i) {
                            subFilter[i] = sFilters[i].asString();
                        }
                        String[] inputSubFilter = Util.processDelegator(subFilter, index, value);
                        if (inputSubFilter != null && inputSubFilter.length > 0) {
                            ASName[] valName = new ASName[inputSubFilter.length];
                            for (int i = 0; i < inputSubFilter.length; ++i) {
                                valName[i] = ASName.create(inputSubFilter[i]);
                            }
                            ((SeedValue)SeedValue.this).seedValue.subFilter = valName;
                        }
                    }
                }
            };
        }
        return Undefined.instance;
    }

    public void setSubFilter(Object subFilter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String[] inSubFilter = Util.inputValidation(subFilter);
        if (inSubFilter != null) {
            ASName[] sFilters = new ASName[inSubFilter.length];
            for (int i = 0; i < inSubFilter.length; ++i) {
                sFilters[i] = ASName.create(inSubFilter[i]);
            }
            this.seedValue.subFilter = sFilters;
        }
    }

    public Object getTimeStampspec() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFTimeStampSeed tsSeed = this.seedValue.timeStampSpec;
        if (tsSeed != null) {
            TimeStamp ts = (TimeStamp)((Object)ESObject.create(this.getParentScope(), true, "TimeStamp", false, null));
            ts.setTimeStamp(tsSeed);
            return ts;
        }
        return Undefined.instance;
    }

    public void setTimeStampSpec(TimeStamp timeStampSpec) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.seedValue.timeStampSpec = timeStampSpec.getTimeStamp();
    }

    public Object getVersion() throws NumberFormatException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Double version = this.seedValue.version;
        if (version != null) {
            return version.intValue();
        }
        return Undefined.instance;
    }

    public void setVersion(Object version) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.seedValue.version = version == null ? null : Double.valueOf(((Number)version).doubleValue());
    }

    private JSStateListener.SeedValueCache getSeedValueListener(PDFSignatureFieldSeedValue signatureSeedValue) {
        JSStateListener listener = (JSStateListener)signatureSeedValue.getPDFDocument().getListenerRegistry().getListener(JSStateListener.class);
        JSStateListener.SeedValueCache seedValueCache = null;
        if (listener != null) {
            seedValueCache = listener.seedValueMap.get(this.seedvalueId);
        }
        return seedValueCache;
    }

    private JSStateListener.SeedValueCache procureSeedValueListener(PDFSignatureFieldSeedValue signatureSeedValue) {
        JSStateListener.SeedValueCache seedValueCache = this.getSeedValueListener(signatureSeedValue);
        if (seedValueCache == null) {
            JSStateListener listener = (JSStateListener)signatureSeedValue.getPDFDocument().getListenerRegistry().getListener(JSStateListener.class);
            if (listener == null) {
                listener = new JSStateListener();
                signatureSeedValue.getPDFDocument().getListenerRegistry().registerListener(JSStateListener.class, listener);
            }
            seedValueCache = new JSStateListener.SeedValueCache();
            listener.seedValueMap.put(this.seedvalueId, seedValueCache);
        }
        return seedValueCache;
    }

    private JSStateListener.SeedValueCache.CertificateSpecifierCache initCertificateSeedCache(PDFCertificateSeedValue certSeed) {
        JSStateListener.SeedValueCache.CertificateSpecifierCache certificateSpecifier = this.seedValue.new JSStateListener.SeedValueCache.CertificateSpecifierCache();
        try {
            certificateSpecifier.flags = certSeed.getFlags();
            certificateSpecifier.keyUsage = certSeed.getKeyUsage();
            certificateSpecifier.oid = certSeed.getOIDs();
            certificateSpecifier.urlType = certSeed.getURLType();
            certificateSpecifier.url = certSeed.getURL();
            certificateSpecifier.issuer = certSeed.getIssuers();
            certificateSpecifier.subject = certSeed.getSubjects();
            PDFSubjectDNList pdfSubjectDNList = certSeed.getSubjectDN();
            if (pdfSubjectDNList != null) {
                certificateSpecifier.subjectDN = new ArrayList<Map<String, String>>();
                PDFSubjectDNList.SubjectDNArrayListIterator subjectDNIter = pdfSubjectDNList.getIterator();
                while (subjectDNIter.hasNext()) {
                    PDFSubjectDN pdfSubjectDN = subjectDNIter.next();
                    if (pdfSubjectDN == null) continue;
                    try {
                        certificateSpecifier.subjectDN.add(pdfSubjectDN.getAttributes());
                    }
                    catch (PDFInvalidParameterException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return certificateSpecifier;
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

