/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.ObjectOperations;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerRegistry;
import com.adobe.internal.pdftoolkit.pdf.impl.FieldAndAnnotationImpl;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionJavaScript;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFJavaScriptEvent;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedJavaScripts;
import com.adobe.internal.pdftoolkit.services.javascript.Doc;
import com.adobe.internal.pdftoolkit.services.javascript.EventObject;
import com.adobe.internal.pdftoolkit.services.javascript.Field;
import com.adobe.internal.pdftoolkit.services.javascript.GibsonContextFactory;
import com.adobe.internal.pdftoolkit.services.javascript.GibsonMemoryTracking;
import com.adobe.internal.pdftoolkit.services.javascript.GibsonTopLevelScope;
import com.adobe.internal.pdftoolkit.services.javascript.JSExecuteOptions;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptException;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptListener;
import com.adobe.internal.pdftoolkit.services.javascript.ScriptChangeListener;
import com.adobe.internal.pdftoolkit.services.javascript.ValueChangeListener;
import com.adobe.internal.pdftoolkit.services.javascript.extension.JSExtensionOptions;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.JSUtils;
import com.adobe.internal.pdftoolkit.services.javascript.security.JSSecurityController;
import com.adobe.internal.pdftoolkit.services.permissions.PermissionsManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class JavaScriptHandler
implements GibsonMemoryTracking.Listener {
    private final PDFDocument jsDocument;
    private InputStream externalJS;
    private ProtectionDomain securityPermissions;
    private static GibsonTopLevelScope topLevel;
    private Doc docLevelScope;
    private PermissionsManager permManager;
    private HashMap<String, Object> formattedFieldValueMap;
    private boolean isTrustedMode;
    private boolean useConsole;
    private ValueChangeListener valueChangeListener;
    private ScriptChangeListener scriptChangeListener;
    private JSExtensionOptions extensionOptions;
    private JSExecuteOptions executionOptions;
    private double memoryThreshhold = 0.9;
    private GibsonMemoryTracking mws = null;
    private GibsonContextFactory factory = null;

    public static JavaScriptHandler getInstance(PDFDocument document, InputStream external_JS_file, ProtectionDomain securityPermissions, PermissionsManager perManager, boolean isTrustedMode) throws PDFInvalidParameterException, PDFUnableToCompleteOperationException, JavaScriptException {
        JSExtensionOptions extensionOptions = null;
        return JavaScriptHandler.getInstance(document, external_JS_file, securityPermissions, perManager, isTrustedMode, extensionOptions);
    }

    public static JavaScriptHandler getInstance(PDFDocument document, InputStream external_JS_file, ProtectionDomain securityPermissions, PermissionsManager perManager, boolean isTrustedMode, JSExtensionOptions extensionOptions) throws PDFInvalidParameterException, PDFUnableToCompleteOperationException, JavaScriptException {
        JavaScriptHandler jsHandler = JavaScriptHandler.getRegisteredInstance(document);
        if (jsHandler != null) {
            throw new PDFInvalidParameterException("Attempt to redefine existing JavaScriptHandler");
        }
        jsHandler = new JavaScriptHandler(document, external_JS_file, securityPermissions, perManager, isTrustedMode, true, extensionOptions, null);
        return jsHandler;
    }

    public static JavaScriptHandler getInstance(PDFDocument document, InputStream external_JS_file, ProtectionDomain securityPermissions, PermissionsManager perManager, boolean isTrustedMode, boolean useConsole) throws PDFInvalidParameterException, PDFUnableToCompleteOperationException, JavaScriptException {
        JSExtensionOptions extensionOptions = null;
        JSExecuteOptions executeOptions = null;
        return JavaScriptHandler.getInstance(document, external_JS_file, securityPermissions, perManager, isTrustedMode, useConsole, extensionOptions, executeOptions);
    }

    public static JavaScriptHandler getInstance(PDFDocument document, InputStream external_JS_file, ProtectionDomain securityPermissions, PermissionsManager perManager, boolean isTrustedMode, boolean useConsole, JSExtensionOptions extensionOptions, JSExecuteOptions executeOptions) throws PDFInvalidParameterException, PDFUnableToCompleteOperationException, JavaScriptException {
        JavaScriptHandler jsHandler = JavaScriptHandler.getRegisteredInstance(document);
        if (jsHandler != null) {
            throw new PDFInvalidParameterException("Attempt to redefine existing JavaScriptHandler");
        }
        jsHandler = new JavaScriptHandler(document, external_JS_file, securityPermissions, perManager, isTrustedMode, useConsole, extensionOptions, executeOptions);
        return jsHandler;
    }

    public static JavaScriptHandler getRegisteredInstance(PDFDocument document) {
        DocumentListenerRegistry registry = document.getListenerRegistry();
        JavaScriptListener jsListener = (JavaScriptListener)registry.getListener(JavaScriptHandler.class);
        return jsListener != null ? jsListener.getHandler() : null;
    }

    private JavaScriptHandler(PDFDocument pdfDoc, InputStream javaScriptFile, ProtectionDomain options, PermissionsManager permanager, boolean isTrustedMode, boolean useConsole, JSExtensionOptions extensionOptions, JSExecuteOptions executeOpt) throws PDFUnableToCompleteOperationException, JavaScriptException {
        this.jsDocument = pdfDoc;
        this.externalJS = javaScriptFile;
        this.securityPermissions = options;
        this.permManager = permanager;
        this.isTrustedMode = isTrustedMode;
        this.useConsole = useConsole;
        this.extensionOptions = extensionOptions;
        this.executionOptions = executeOpt;
        DocumentListenerRegistry registry = pdfDoc.getListenerRegistry();
        JavaScriptListener jsListener = new JavaScriptListener(this);
        registry.registerListener(JavaScriptHandler.class, jsListener);
        this.initJSEngine();
    }

    public InputStream getExternalJavaScriptFile() {
        return this.externalJS;
    }

    public ProtectionDomain getSecurityPermissions() {
        return this.securityPermissions;
    }

    public void setSecurityPermissions(ProtectionDomain securityPermissions) {
        this.securityPermissions = securityPermissions;
    }

    private void initJSEngine() throws PDFUnableToCompleteOperationException, JavaScriptException {
        this.memoryThreshhold = this.executionOptions == null ? 0.9 : this.executionOptions.getMemoryThreshhold();
        this.mws = new GibsonMemoryTracking();
        GibsonMemoryTracking.setPercentageUsageThreshold(this.memoryThreshhold);
        this.factory = new GibsonContextFactory();
        JSSecurityController controller = new JSSecurityController(this.getSecurityPermissions());
        this.factory.setSecurityController(controller);
        this.factory.setExecuteOptions(this.executionOptions);
        Context ctx = this.factory.enterContext();
        try {
            if (topLevel == null) {
                topLevel = new GibsonTopLevelScope(ctx);
            }
            this.docLevelScope = new Doc();
            this.docLevelScope.put("doc", (Scriptable)this.docLevelScope, (Object)this.docLevelScope);
            this.docLevelScope.setPrototype((Scriptable)topLevel);
            this.docLevelScope.init();
            this.docLevelScope.setActiveDocument(this.getJavaScriptHandlerDocument());
            InputStreamReader externalJS = null;
            if (this.getExternalJavaScriptFile() != null) {
                externalJS = new InputStreamReader(this.getExternalJavaScriptFile());
            }
            if (externalJS != null) {
                ctx.evaluateReader((Scriptable)this.docLevelScope, (Reader)externalJS, "externalJS", 1, null);
            }
            topLevel.put("systemOut", (Scriptable)topLevel, System.out);
            this.addXFAPropertiesTodocLevelScope();
        }
        catch (IOException e) {
            throw new PDFUnableToCompleteOperationException(e);
        }
        finally {
            Context.exit();
        }
    }

    private void addXFAPropertiesTodocLevelScope() {
        if (!ScriptableObject.hasProperty((Scriptable)this.docLevelScope, (String)"xfa_installed")) {
            ScriptableObject.defineProperty((Scriptable)this.docLevelScope, (String)"xfa_installed", (Object)Boolean.TRUE, (int)15);
        }
        if (!ScriptableObject.hasProperty((Scriptable)this.docLevelScope, (String)"xfa_version")) {
            ScriptableObject.defineProperty((Scriptable)this.docLevelScope, (String)"xfa_version", (Object)3.3, (int)15);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(PDFActionJavaScript javaScriptAction) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException, Exception {
        try {
            String js = javaScriptAction.getJavaScriptString();
            this.mws.addListener(this);
            GibsonMemoryTracking.setPercentageUsageThreshold(this.memoryThreshhold);
            this.eval(js);
        }
        finally {
            this.mws.removeListener(this);
        }
    }

    public void executeDocumentScript() throws Exception, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFNameDictionary names;
        PDFNamedJavaScripts scripts;
        JSUtils.setEventTargetToDoc(this);
        if (this.jsDocument.requireCatalog().dictionaryContains(ASName.k_Names) && (scripts = (names = this.jsDocument.requireCatalog().getNameDictionary()).getNamedJavaScripts()) != null) {
            int origNumScripts = 0;
            Iterator<PDFTree.Entry> srcIterator = scripts.iterator();
            ArrayList<PDFActionJavaScript> scriptList = new ArrayList<PDFActionJavaScript>();
            while (srcIterator.hasNext()) {
                PDFTree.Entry srcEntry = srcIterator.next();
                PDFActionJavaScript jsAction = (PDFActionJavaScript)srcEntry.getValue();
                scriptList.add(jsAction);
                ++origNumScripts;
            }
            for (int i = 0; i < scriptList.size(); ++i) {
                this.execute((PDFActionJavaScript)scriptList.get(i));
            }
            srcIterator = scripts.iterator();
            int newNumScripts = 0;
            ArrayList<PDFActionJavaScript> newscriptList = new ArrayList<PDFActionJavaScript>();
            while (srcIterator.hasNext()) {
                PDFTree.Entry srcEntry = srcIterator.next();
                PDFActionJavaScript jsAction = (PDFActionJavaScript)srcEntry.getValue();
                newscriptList.add(jsAction);
                ++newNumScripts;
            }
            if (newNumScripts > origNumScripts) {
                newscriptList.removeAll(scriptList);
                for (int i = 0; i < newscriptList.size(); ++i) {
                    this.execute((PDFActionJavaScript)newscriptList.get(i));
                }
            }
        }
    }

    public void execute(PDFJavaScriptEvent jsEvent) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException, Exception {
        this.execute(jsEvent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(PDFJavaScriptEvent jsEvent, Object eventSource) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException, Exception {
        this.factory.enterContext();
        try {
            String js = jsEvent.getPdfJSAction().getJavaScriptString();
            EventObject event = (EventObject)((Object)ESObject.create((Scriptable)this.docLevelScope, true, "EventObject", true, "event"));
            Field theField = new Field(jsEvent.getParent());
            theField.setParentScope((Scriptable)this.docLevelScope);
            event.setTarget((Object)theField);
            event.setSource(eventSource);
            event.setType(jsEvent.getEventType());
            event.setName(jsEvent.getEventName());
            this.mws.addListener(this);
            GibsonMemoryTracking.setPercentageUsageThreshold(this.memoryThreshhold);
            this.eval(js);
        }
        finally {
            this.mws.removeListener(this);
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String js) throws Exception {
        if (js == null) {
            return null;
        }
        Object ret = null;
        Context cx = this.factory.enterContext();
        try {
            Script s = cx.compileReader((Reader)new StringReader(js), "externalScript", 1, null);
            ret = s.exec(cx, (Scriptable)this.docLevelScope);
            Object object = this.unwrapReturnValue(ret);
            return object;
        }
        finally {
            Context.exit();
        }
    }

    private Object unwrapReturnValue(Object result) {
        if (result instanceof Wrapper) {
            result = ((Wrapper)result).unwrap();
        }
        return result instanceof Undefined ? null : result;
    }

    public PDFDocument getJavaScriptHandlerDocument() {
        return this.jsDocument;
    }

    public FieldAndAnnotationImpl getField(String fieldName) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return this.getFieldNode(fieldName);
    }

    private FieldAndAnnotationImpl getFieldNode(String fieldNodeName) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        String[] partialNames = fieldNodeName.split("\\.");
        PDFInteractiveForm iform = this.getJavaScriptHandlerDocument().getInteractiveForm();
        boolean useAcrobatIsTerminalFieldCheck = true;
        return PDFFieldUtils.findChildFieldNode(partialNames, iform, iform, useAcrobatIsTerminalFieldCheck, 0);
    }

    public PermissionsManager getPermissionsManager() {
        return this.permManager;
    }

    public void setPermissionsManager(PermissionsManager permManager) {
        this.permManager = permManager;
    }

    public boolean isFormFillinOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.FORM_FILLIN);
    }

    public boolean isFormModifyOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.FORM_MODIFY);
    }

    public boolean isDocModifyOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.DOC_MODIFY);
    }

    public boolean isDocSecureOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.DOC_SECURE);
    }

    public boolean isDocCopyOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.DOC_COPY);
    }

    public boolean isDocSelectOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.DOC_SELECT);
    }

    public boolean isFormCreateOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.FORM_CREATE);
    }

    public boolean isFormDeleteOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.FORM_DELETE);
    }

    public boolean isPageInsertOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.PAGE_INSERT);
    }

    public boolean isPageDeleteOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.PAGE_DELETE);
    }

    public boolean isPageCropOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.PAGE_COPY);
    }

    public boolean isPageReorderOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.PAGE_REORDER);
    }

    public boolean isPageCopyOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.PAGE_COPY);
    }

    public boolean isPageModifyOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.PAGE_MODIFY);
    }

    public boolean isPageRotateOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.PAGE_ROTATE);
    }

    public boolean isAnnotCreateOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.ANNOT_CREATE);
    }

    public boolean isAnnotDeleteOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.ANNOT_DELETE);
    }

    public boolean isLinkCreateOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.LINK_CREATE);
    }

    public boolean isLinkDeleteOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.LINK_DELETE);
    }

    public boolean isThumbnailDeleteOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.THUMBNAIL_DELETE);
    }

    public boolean isThumbnailCreateOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.THUMBNAIL_CREATE);
    }

    public boolean isEFCreateOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.EF_CREATE);
    }

    public boolean isEFDeleteOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.EF_DELETE);
    }

    public boolean isEFModifyOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.EF_MODIFY);
    }

    public boolean isSignatureDeleteOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.SIGNATURE_DELETE);
    }

    public boolean isSignatureFillinOk() throws PDFUnableToCompleteOperationException {
        return this.getPermissionsManager().isPermitted(ObjectOperations.SIGNATURE_FILLIN);
    }

    public JSExtensionOptions getExtensionOptions() {
        return this.extensionOptions;
    }

    public JSExecuteOptions getExecutionOptions() {
        return this.executionOptions;
    }

    public boolean isTrustedMode() {
        return this.isTrustedMode;
    }

    public void setTrustedMode(boolean isTrustedMode) {
        this.isTrustedMode = isTrustedMode;
    }

    public HashMap<String, Object> getFormattedFieldValueMap() {
        if (this.formattedFieldValueMap == null) {
            this.formattedFieldValueMap = new HashMap();
        }
        return this.formattedFieldValueMap;
    }

    public HashMap<String, Object> addFormattedFieldValueToMap(String fieldName, Object fieldValue) {
        this.getFormattedFieldValueMap().put(fieldName, fieldValue);
        return this.formattedFieldValueMap;
    }

    public boolean isUseConsole() {
        return this.useConsole;
    }

    public void setUseConsole(boolean useConsole) {
        this.useConsole = useConsole;
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        this.setValueChangeListener(listener);
    }

    public ValueChangeListener getValueChangeListener() {
        return this.valueChangeListener;
    }

    private void setValueChangeListener(ValueChangeListener valueChangeListener) {
        this.valueChangeListener = valueChangeListener;
    }

    public void addScriptChangeListener(ScriptChangeListener listener) {
        this.setScriptChangeListener(listener);
    }

    public ScriptChangeListener getScriptChangeListener() {
        return this.scriptChangeListener;
    }

    private void setScriptChangeListener(ScriptChangeListener scriptChangeListener) {
        this.scriptChangeListener = scriptChangeListener;
    }

    @Override
    public void trackMemoryUsage(long usedMemory, long maxMemory) throws Exception {
        double percentageUsed = (double)usedMemory / (double)maxMemory;
        GibsonMemoryTracking.setPercentageUsageThreshold(0.8);
        if (percentageUsed > 0.8) {
            this.factory.interruptScript();
        }
    }

    public static GibsonTopLevelScope getTopLevelScope() {
        return topLevel;
    }

    public Doc getDocLevelScope() {
        return this.docLevelScope;
    }

    public GibsonContextFactory getContextFactory() {
        return this.factory;
    }
}

