/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFFieldLock;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureFieldSeedValue;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionJavaScript;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsField;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLink;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearanceCharacteristics;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderStyle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFIconFit;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldChoice;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldText;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFVariableText;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.impl.PDFDefaultAppearanceWrapper;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldPDF;
import com.adobe.internal.pdftoolkit.services.javascript.Color;
import com.adobe.internal.pdftoolkit.services.javascript.Doc;
import com.adobe.internal.pdftoolkit.services.javascript.EventObject;
import com.adobe.internal.pdftoolkit.services.javascript.Icon;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptException;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptHandler;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptSecurityException;
import com.adobe.internal.pdftoolkit.services.javascript.Lock;
import com.adobe.internal.pdftoolkit.services.javascript.SeedValue;
import com.adobe.internal.pdftoolkit.services.javascript.SignatureInfo;
import com.adobe.internal.pdftoolkit.services.javascript.Span;
import com.adobe.internal.pdftoolkit.services.javascript.UnsupportedJavaScriptFeatureException;
import com.adobe.internal.pdftoolkit.services.javascript.Util;
import com.adobe.internal.pdftoolkit.services.javascript.extension.JSExtensionOptions;
import com.adobe.internal.pdftoolkit.services.javascript.extension.JSSigInfo;
import com.adobe.internal.pdftoolkit.services.javascript.extension.JSSigValidateProvider;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.JSUtils;
import com.adobe.internal.pdftoolkit.services.javascript.model.Param;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import com.adobe.internal.pdftoolkit.services.javascript.params.FieldParams;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextHandler;
import com.adobe.internal.pdftoolkit.services.xfa.form.DocumentContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Delegator;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class Field
extends ESObject {
    protected static final ScriptTable scriptTable = new ScriptTable("Field.class", new HashMap<String, Function>(27){
        private static final long serialVersionUID = 1L;
        {
            this.put("getArray", new Function(Field.class, "getArray", Param.Type.Object, FieldParams.getArray, 0, false, false));
            this.put("browseForFileToSubmit", new Function(Field.class, "browseForFileToSubmit", Param.Type.Object, FieldParams.browseForFileToSubmit, 0, true, false));
            this.put("buttonGetCaption", new Function(Field.class, "buttonGetCaption", Param.Type.String, FieldParams.buttonGetCaption, 1, false, false));
            this.put("buttonGetIcon", new Function(Field.class, "buttonGetIcon", Param.Type.Icon, FieldParams.buttonGetIcon, 1, false, false));
            this.put("buttonImportIcon", new Function(Field.class, "buttonImportIcon", Param.Type.Object, FieldParams.buttonImportIcon, 2, true, false, true));
            this.put("buttonSetCaption", new Function(Field.class, "buttonSetCaption", Param.Type.Object, FieldParams.buttonSetCaption, 2, false, false));
            this.put("buttonSetIcon", new Function(Field.class, "buttonSetIcon", Param.Type.Object, FieldParams.buttonSetIcon, 2, false, false));
            this.put("checkThisBox", new Function(Field.class, "checkThisBox", Param.Type.Object, FieldParams.checkThisBox, 2, false, false));
            this.put("clear", new Function(Field.class, "clear", Param.Type.Object, FieldParams.clear, 0, false, false));
            this.put("clearItems", new Function(Field.class, "clearItems", Param.Type.Object, FieldParams.clearItems, 0, false, false));
            this.put("defaultIsChecked", new Function(Field.class, "defaultIsChecked", Param.Type.Boolean, FieldParams.defaultIsChecked, 2, false, false));
            this.put("deleteItemAt", new Function(Field.class, "deleteItemAt", Param.Type.Object, FieldParams.deleteItemAt, 1, false, false));
            this.put("getItemAt", new Function(Field.class, "getItemAt", Param.Type.String, FieldParams.getItemAt, 2, false, false));
            this.put("getLock", new Function(Field.class, "getLock", Param.Type.Object, FieldParams.getLock, 0, false, false));
            this.put("insertItemAt", new Function(Field.class, "insertItemAt", Param.Type.Object, FieldParams.insertItemAt, 3, false, false));
            this.put("isBoxChecked", new Function(Field.class, "isBoxChecked", Param.Type.Boolean, FieldParams.isBoxChecked, 1, false, false));
            this.put("isDefaultChecked", new Function(Field.class, "isDefaultChecked", Param.Type.Boolean, FieldParams.isDefaultChecked, 1, false, false));
            this.put("setAction", new Function(Field.class, "setAction", Param.Type.Object, FieldParams.setAction, 2, false, false));
            this.put("setFocus", new Function(Field.class, "setFocus", Param.Type.Object, FieldParams.setFocus, 0, true, false));
            this.put("setItems", new Function(Field.class, "setItems", Param.Type.Object, FieldParams.setItems, 1, false, false));
            this.put("setLock", new Function(Field.class, "setLock", Param.Type.Object, FieldParams.setLock, 1, false, false, true));
            this.put("signatureGetModifications", new Function(Field.class, "signatureGetModifications", Param.Type.Object, FieldParams.signatureGetModifications, 0, true, false));
            this.put("signatureGetSeedValue", new Function(Field.class, "signatureGetSeedValue", Param.Type.Object, FieldParams.signatureGetSeedValue, 0, false, false));
            this.put("signatureInfo", new Function(Field.class, "signatureInfo", Param.Type.Object, FieldParams.signatureInfo, 1, false, false));
            this.put("signatureSetSeedValue", new Function(Field.class, "signatureSetSeedValue", Param.Type.Object, FieldParams.signatureSetSeedValue, 1, true, false, true));
            this.put("signatureSign", new Function(Field.class, "signatureSign", Param.Type.Object, FieldParams.signatureSign, 5, true, false, true));
            this.put("signatureValidate", new Function(Field.class, "signatureValidate", Param.Type.Integer, FieldParams.signatureValidate, 2, false, false));
        }
    }, new HashMap<String, Property>(48){
        private static final long serialVersionUID = 1L;
        {
            this.put("rotation", new Property(Field.class, "rotation", "getRotation", "setRotation", FieldParams.rotation, false, false));
            this.put("alignment", new Property(Field.class, "alignment", "getAlignment", "setAlignment", FieldParams.alignment, false, false));
            this.put("numItems", new Property(Field.class, "numItems", "getNumItems", null, null, false, false));
            this.put("strokeColor", new Property(Field.class, "strokeColor", "getStrokeColor", "setStrokeColor", FieldParams.strokeColor, false, false));
            this.put("multiline", new Property(Field.class, "multiline", "getMultiline", "setMultiline", FieldParams.multiline, false, false));
            this.put("comb", new Property(Field.class, "comb", "getComb", "setComb", FieldParams.comb, false, false));
            this.put("lineWidth", new Property(Field.class, "lineWidth", "getLineWidth", "setLineWidth", FieldParams.lineWidth, false, false));
            this.put("multipleSelection", new Property(Field.class, "multipleSelection", "getMultipleSelection", "setMultipleSelection", FieldParams.multipleSelection, false, false));
            this.put("password", new Property(Field.class, "password", "getPassword", "setPassword", FieldParams.password, false, false));
            this.put("defaultValue", new Property(Field.class, "defaultValue", "getDefaultValue", "setDefaultValue", FieldParams.defaultValue, false, false));
            this.put("valueAsString", new Property(Field.class, "valueAsString", "getValueAsString", null, null, false, false));
            this.put("commitOnSelChange", new Property(Field.class, "commitOnSelChange", "getCommitOnSelChange", "setCommitOnSelChange", FieldParams.commitOnSelChange, false, false));
            this.put("fgColor", new Property(Field.class, "fgColor", "getFgColor", "setFgColor", FieldParams.fgColor, false, false));
            this.put("highlight", new Property(Field.class, "highlight", "getHighlight", "setHighlight", FieldParams.highlight, false, false));
            this.put("textSize", new Property(Field.class, "textSize", "getTextSize", "setTextSize", FieldParams.textSize, false, false));
            this.put("textFont", new Property(Field.class, "textFont", "getTextFont", "setTextFont", FieldParams.textFont, false, false));
            this.put("doc", new Property(Field.class, "doc", "getDoc", null, null, false, false));
            this.put("editable", new Property(Field.class, "editable", "getEditable", "setEditable", FieldParams.editable, false, false));
            this.put("borderStyle", new Property(Field.class, "borderStyle", "getBorderStyle", "setBorderStyle", FieldParams.borderStyle, false, false));
            this.put("print", new Property(Field.class, "print", "getPrint", "setPrint", FieldParams.print, false, false));
            this.put("value", new Property(Field.class, "value", "getValue", "setValue", FieldParams.value, false, false));
            this.put("type", new Property(Field.class, "type", "getType", null, null, false, false));
            this.put("charLimit", new Property(Field.class, "charLimit", "getCharLimit", "setCharLimit", FieldParams.charLimit, false, false));
            this.put("textColor", new Property(Field.class, "textColor", "getTextColor", "setTextColor", FieldParams.textColor, false, false));
            this.put("readonly", new Property(Field.class, "readonly", "getReadonly", "setReadonly", FieldParams.readonly, false, false));
            this.put("bgColor", new Property(Field.class, "bgColor", "getBgColor", "setBgColor", FieldParams.bgColor, false, false));
            this.put("display", new Property(Field.class, "display", "getDisplay", "setDisplay", FieldParams.display, false, false));
            this.put("currentValueIndices", new Property(Field.class, "currentValueIndices", "getCurrentValueIndices", "setCurrentValueIndices", FieldParams.currentValueIndices, false, false));
            this.put("userName", new Property(Field.class, "userName", "getUserName", "setUserName", FieldParams.userName, false, false));
            this.put("hidden", new Property(Field.class, "hidden", "getHidden", "setHidden", FieldParams.hidden, false, false));
            this.put("richText", new Property(Field.class, "richText", "getRichText", "setRichText", FieldParams.richText, false, false));
            this.put("required", new Property(Field.class, "required", "getRequired", "setRequired", FieldParams.required, false, false));
            this.put("style", new Property(Field.class, "style", "getStyle", "setStyle", FieldParams.style, false, false));
            this.put("borderWidth", new Property(Field.class, "borderWidth", "getBorderWidth", "setBorderWidth", FieldParams.borderWidth, false, false));
            this.put("doNotScroll", new Property(Field.class, "doNotScroll", "getDoNotScroll", "setDoNotScroll", FieldParams.doNotScroll, false, false));
            this.put("name", new Property(Field.class, "name", "getName", null, null, false, false));
            this.put("borderColor", new Property(Field.class, "borderColor", "getBorderColor", "setBorderColor", FieldParams.borderColor, false, false));
            this.put("fileSelect", new Property(Field.class, "fileSelect", "getFileSelect", "setFileSelect", FieldParams.fileSelect, false, false, true));
            this.put("fillColor", new Property(Field.class, "fillColor", "getFillColor", "setFillColor", FieldParams.fillColor, false, false));
            this.put("richValue", new Property(Field.class, "richValue", "getRichValue", "setRichValue", FieldParams.richValue, false, false));
            this.put("rect", new Property(Field.class, "rect", "getRect", "setRect", FieldParams.rect, false, false));
            this.put("defaultStyle", new Property(Field.class, "defaultStyle", "getDefaultStyle", "setDefaultStyle", FieldParams.defaultStyle, false, false));
            this.put("exportValues", new Property(Field.class, "exportValues", "getExportValues", "setExportValues", FieldParams.exportValues, false, false));
            this.put("buttonScaleWhen", new Property(Field.class, "buttonScaleWhen", "getButtonScaleWhen", "setButtonScaleWhen", FieldParams.buttonScaleWhen, false, false));
            this.put("radiosInUnison", new Property(Field.class, "radiosInUnison", "getRadiosInUnison", "setRadiosInUnison", FieldParams.radiosInUnison, false, false));
            this.put("page", new Property(Field.class, "page", "getPage", null, FieldParams.page, false, false));
            this.put("buttonPosition", new Property(Field.class, "buttonPosition", "getButtonPosition", "setButtonPosition", FieldParams.buttonPosition, false, false));
        }
    });
    private static final long serialVersionUID = -4081776246066132575L;
    static final String className = "Field";
    private PDFFieldNode currentField;
    private PDFAnnotationWidget currentAnnot;
    private JSSigInfo jsSigInfo = null;
    private static HashMap<JSUtils.ESTriggerType, String> valid = new HashMap();
    int alignment;
    Color bgColor;
    Color borderColor;
    double borderWidth;
    String borderStyle = null;
    double buttonAlignX = 0.0;
    double buttonAlignY = 0.0;
    boolean buttonFitBounds;
    int buttonPosition;
    int buttonScaleHow;
    int buttonScaleWhen = 0;
    int calcOrderIndex;
    int charLimit;
    boolean comb;
    boolean commitOnSelChange;
    int currentValueIndices;
    String defaultStyle;
    String defaultValue;
    boolean doNotScroll;
    boolean doNotSpellCheck;
    boolean delay;
    int display;
    Object doc;
    boolean editable;
    Object[] exportValues;
    Object fgColor;
    boolean fileSelect;
    Color fillColor;
    boolean hidden;
    String highlight;
    double lineWidth;
    boolean multiline;
    boolean multipleSelection;
    String name;
    int numItems;
    Object[] page;
    boolean isPassword;
    boolean print;
    boolean radiosInUnison;
    boolean readonly;
    double[] rect;
    boolean required;
    Object richValue;
    private static HashMap<String, HashMap<String, String>> bodyStyleSet;
    private static HashMap<String, String> bodyStyle;
    private StringBuilder listValue = null;
    int rotation;
    Color strokeColor;
    String style;
    Object submitName;
    Color textColor;
    String textFont;
    double textSize = 0.0;
    String type;
    String userName;
    Object value;
    Object valueAsString;

    @Override
    public Object get(String name, Scriptable start) {
        return super.get(name, start);
    }

    @Override
    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    public Field() {
    }

    public Field(Object field) {
        if (field instanceof PDFFieldNode) {
            this.setCurrentField((PDFFieldNode)field);
        }
    }

    PDFFieldNode getCurrentField() {
        return this.currentField;
    }

    public void setCurrentField(PDFFieldNode field) {
        this.currentField = field;
    }

    public PDFAnnotation getCurrentAnnot() {
        return this.currentAnnot;
    }

    public void setCurrentAnnot(PDFAnnotationWidget currentAnnot) {
        this.currentAnnot = currentAnnot;
    }

    @Override
    public String getClassName() {
        return className;
    }

    public String getAlignment() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int quadding = this.currentField.getVariableText().getQuadding();
        switch (quadding) {
            case 0: {
                return "left";
            }
            case 1: {
                return "center";
            }
            case 2: {
                return "right";
            }
        }
        return "left";
    }

    public void setAlignment(String value) throws JavaScriptSecurityException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        int quadding = 0;
        if ("left".equals(value)) {
            quadding = 0;
        } else if ("center".equals(value)) {
            quadding = 1;
        } else if ("right".equals(value)) {
            quadding = 2;
        }
        if (this.currentField.getVariableText() != null) {
            this.currentField.getVariableText().setQuadding(quadding);
            this.alignment = quadding;
        }
    }

    public Object getBgColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, IllegalAccessException, NoSuchFieldException {
        double[] colorValue = null;
        PDFAnnotationWidget annot = this.currentAnnot;
        if (annot != null) {
            colorValue = annot.getAppearanceCharacteristics().getBackgroundColor();
        }
        this.bgColor = new Color();
        boolean isStrokeOp = false;
        try {
            this.bgColor.setValue(this.bgColor.getPDFColorSpace(colorValue, isStrokeOp), colorValue);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("Cannot get background color.", e);
        }
        return this.bgColor.getColorValue();
    }

    public void setBgColor(Object value) throws JavaScriptSecurityException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IllegalAccessException, NoSuchFieldException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        boolean isStrokeOp = false;
        this.bgColor = new Color();
        if (value instanceof NativeArray) {
            NativeArray arr = (NativeArray)value;
            Object[] fromJS = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, Context.getCurrentContext());
            this.bgColor.setValue(fromJS, isStrokeOp);
            PDFAnnotationIterator iter = null;
            if (!(this.currentField instanceof PDFField)) {
                PDFField field = PDFField.getInstance(this.currentField.getCosObject());
                iter = field.getAnnotationsIterator();
            } else {
                iter = ((PDFField)this.currentField).getAnnotationsIterator();
            }
            while (iter != null && iter.hasNext()) {
                PDFAnnotation annot = iter.next();
                if (!(annot instanceof PDFAnnotationWidget)) continue;
                ((PDFAnnotationWidget)annot).procureAppearanceCharacteristics().setBackgroundColor(this.bgColor.getColorValue());
            }
        }
    }

    public Object getBorderColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, IllegalAccessException, NoSuchFieldException {
        double[] colorValue = null;
        PDFAnnotationWidget annot = this.currentAnnot;
        if (annot != null) {
            colorValue = annot.getAppearanceCharacteristics().getBorderColor();
        }
        this.borderColor = new Color();
        boolean isStrokeOp = true;
        try {
            this.borderColor.setValue(this.borderColor.getPDFColorSpace(colorValue, isStrokeOp), colorValue);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("Cannot get background color.", e);
        }
        return Arrays.toString(((List)this.borderColor.getValue()).toArray());
    }

    public void setBorderColor(Object value) throws JavaScriptSecurityException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IllegalAccessException, NoSuchFieldException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        boolean isStrokeOp = true;
        this.borderColor = new Color();
        if (value instanceof NativeArray) {
            NativeArray arr = (NativeArray)value;
            Object[] fromJS = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, Context.getCurrentContext());
            this.borderColor.setValue(fromJS, isStrokeOp);
            PDFAnnotationIterator iter = null;
            if (!(this.currentField instanceof PDFField)) {
                PDFField field = PDFField.getInstance(this.currentField.getCosObject());
                iter = field.getAnnotationsIterator();
            } else {
                iter = ((PDFField)this.currentField).getAnnotationsIterator();
            }
            while (iter != null && iter.hasNext()) {
                PDFAnnotation annot = iter.next();
                if (!(annot instanceof PDFAnnotationWidget)) continue;
                ((PDFAnnotationWidget)annot).procureAppearanceCharacteristics().setBorderColor(this.borderColor.getColorValue());
            }
        }
    }

    public double getBorderWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationWidget annot = this.currentAnnot;
        this.borderWidth = annot.hasBorder() ? annot.getBorder().getWidth() : 0.0;
        return this.borderWidth;
    }

    public void setBorderWidth(Double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        PDFAnnotationIterator iter = null;
        if (!(this.currentField instanceof PDFField)) {
            PDFField field = PDFField.getInstance(this.currentField.getCosObject());
            iter = field.getAnnotationsIterator();
        } else {
            iter = ((PDFField)this.currentField).getAnnotationsIterator();
        }
        while (iter != null && iter.hasNext()) {
            PDFAnnotation annot = iter.next();
            if (!annot.hasBorder()) continue;
            annot.getBorder().setWidth(value);
        }
    }

    public String getBorderStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationWidget annot = this.currentAnnot;
        PDFBorderStyle bstyle = annot.getBorderStyle();
        this.borderStyle = "solid";
        if (bstyle != null && bstyle.hasStyle()) {
            if (bstyle.getStyle() == PDFBorderStyle.Style.Beveled) {
                this.borderStyle = "beveled";
                return this.borderStyle;
            }
            if (bstyle.getStyle() == PDFBorderStyle.Style.Dashed) {
                this.borderStyle = "dashed";
                return this.borderStyle;
            }
            if (bstyle.getStyle() == PDFBorderStyle.Style.Solid) {
                this.borderStyle = "solid";
                return this.borderStyle;
            }
            if (bstyle.getStyle() == PDFBorderStyle.Style.Underline) {
                this.borderStyle = "underline";
                return this.borderStyle;
            }
            if (bstyle.getStyle() == PDFBorderStyle.Style.Inset) {
                this.borderStyle = "inset";
                return this.borderStyle;
            }
        }
        return this.borderStyle;
    }

    public void setBorderStyle(String value) throws JavaScriptSecurityException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        PDFAnnotationIterator iter = null;
        if (!(this.currentField instanceof PDFField)) {
            PDFField field = PDFField.getInstance(this.currentField.getCosObject());
            iter = field.getAnnotationsIterator();
        } else {
            iter = ((PDFField)this.currentField).getAnnotationsIterator();
        }
        while (iter != null && iter.hasNext()) {
            PDFAnnotation annot = iter.next();
            if (value.equalsIgnoreCase("beveled")) {
                PDFBorderStyle style = annot.procureBorderStyle();
                annot.setBorderStyle(style);
                style.setStyle(PDFBorderStyle.Style.Beveled);
                break;
            }
            if (value.equalsIgnoreCase("solid")) {
                PDFBorderStyle style = annot.procureBorderStyle();
                annot.setBorderStyle(style);
                style.setStyle(PDFBorderStyle.Style.Solid);
                break;
            }
            if (value.equalsIgnoreCase("inset")) {
                PDFBorderStyle style = annot.procureBorderStyle();
                annot.setBorderStyle(style);
                style.setStyle(PDFBorderStyle.Style.Inset);
                break;
            }
            if (value.equalsIgnoreCase("underline")) {
                PDFBorderStyle style = annot.procureBorderStyle();
                annot.setBorderStyle(style);
                style.setStyle(PDFBorderStyle.Style.Underline);
                break;
            }
            if (!value.equalsIgnoreCase("dashed")) continue;
            PDFBorderStyle style = annot.procureBorderStyle();
            annot.setBorderStyle(style);
            style.setStyle(PDFBorderStyle.Style.Dashed);
            break;
        }
    }

    public double getButtonAlignX() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationWidget annot = this.currentAnnot;
        if (annot != null && annot.getAppearanceCharacteristics().hasIconFit()) {
            PDFIconFit fif = annot.getAppearanceCharacteristics().getIconFit();
            this.buttonAlignX = fif.getScalePositionX();
        }
        return this.buttonAlignX;
    }

    public void setButtonAlignX(Double value) throws JavaScriptSecurityException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        PDFAnnotationIterator iter = null;
        if (!(this.currentField instanceof PDFField)) {
            PDFField field = PDFField.getInstance(this.currentField.getCosObject());
            iter = field.getAnnotationsIterator();
        } else {
            iter = ((PDFField)this.currentField).getAnnotationsIterator();
        }
        while (iter != null && iter.hasNext()) {
            PDFAnnotation annot = iter.next();
            if (!(annot instanceof PDFAnnotationWidget) || !((PDFAnnotationWidget)annot).getAppearanceCharacteristics().hasIconFit()) continue;
            PDFIconFit fif = ((PDFAnnotationWidget)annot).getAppearanceCharacteristics().getIconFit();
            fif.setScalePositionX(value);
        }
        this.buttonAlignX = value;
    }

    public double getButtonAlignY() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFIconFit fif = null;
        PDFAnnotationWidget annot = this.currentAnnot;
        if (annot != null && annot.getAppearanceCharacteristics().hasIconFit()) {
            fif = annot.getAppearanceCharacteristics().getIconFit();
            this.buttonAlignY = fif.getScalePositionY();
        }
        return this.buttonAlignY;
    }

    public void setButtonAlignY(Double value) throws JavaScriptSecurityException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        PDFIconFit fif = null;
        PDFAnnotationIterator iter = null;
        if (!(this.currentField instanceof PDFField)) {
            PDFField field = PDFField.getInstance(this.currentField.getCosObject());
            iter = field.getAnnotationsIterator();
        } else {
            iter = ((PDFField)this.currentField).getAnnotationsIterator();
        }
        while (iter != null && iter.hasNext()) {
            PDFAnnotation annot = iter.next();
            if (!(annot instanceof PDFAnnotationWidget) || !((PDFAnnotationWidget)annot).getAppearanceCharacteristics().hasIconFit()) continue;
            fif = ((PDFAnnotationWidget)annot).getAppearanceCharacteristics().getIconFit();
            fif.setScalePositionY(value);
        }
        this.buttonAlignY = value;
    }

    public boolean getButtonFitBounds() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationWidget annot = this.currentAnnot;
        if (annot != null && annot.getAppearanceCharacteristics().hasIconFit()) {
            PDFIconFit fif = annot.getAppearanceCharacteristics().getIconFit();
            this.buttonFitBounds = fif.getScaleFit();
        }
        return this.buttonFitBounds;
    }

    public void setButtonFitBounds(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        PDFAnnotationIterator iter = null;
        if (!(this.currentField instanceof PDFField)) {
            PDFField field = PDFField.getInstance(this.currentField.getCosObject());
            iter = field.getAnnotationsIterator();
        } else {
            iter = ((PDFField)this.currentField).getAnnotationsIterator();
        }
        while (iter != null && iter.hasNext()) {
            PDFAnnotation annot = iter.next();
            if (!(annot instanceof PDFAnnotationWidget) || !((PDFAnnotationWidget)annot).getAppearanceCharacteristics().hasIconFit()) continue;
            PDFIconFit fif = ((PDFAnnotationWidget)annot).getAppearanceCharacteristics().getIconFit();
            fif.setScaleFit(value);
        }
    }

    public int getButtonPosition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationWidget annot = this.currentAnnot;
        if (annot != null && annot.getAppearanceCharacteristics().hasRotation()) {
            this.buttonPosition = annot.getAppearanceCharacteristics().getCaptionPosition().getValue();
        }
        return this.buttonPosition;
    }

    public void setButtonPosition(Integer value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        PDFAnnotationIterator iter = null;
        if (!(this.currentField instanceof PDFField)) {
            PDFField field = PDFField.getInstance(this.currentField.getCosObject());
            iter = field.getAnnotationsIterator();
        } else {
            iter = ((PDFField)this.currentField).getAnnotationsIterator();
        }
        while (iter != null && iter.hasNext()) {
            PDFAnnotation annot = iter.next();
            if (!(annot instanceof PDFAnnotationWidget) || !((PDFAnnotationWidget)annot).getAppearanceCharacteristics().hasCaptionPosition()) continue;
            ((PDFAnnotationWidget)annot).getAppearanceCharacteristics().setCaptionPosition(value);
        }
    }

    public int getButtonScaleHow() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        PDFAnnotationWidget annot = this.currentAnnot;
        if (annot != null && annot.getAppearanceCharacteristics().hasIconFit()) {
            PDFIconFit fif = annot.getAppearanceCharacteristics().getIconFit();
            if (fif.getIconScaleType() == PDFIconFit.IconScaleType.PROPORTIONAL) {
                return 0;
            }
            if (fif.getIconScaleType() == PDFIconFit.IconScaleType.ANAMORPHIC) {
                return 1;
            }
        }
        return this.buttonScaleHow;
    }

    public void setButtonScaleHow(Integer value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        PDFAnnotationIterator iter = null;
        if (!(this.currentField instanceof PDFField)) {
            PDFField field = PDFField.getInstance(this.currentField.getCosObject());
            iter = field.getAnnotationsIterator();
        } else {
            iter = ((PDFField)this.currentField).getAnnotationsIterator();
        }
        while (iter != null && iter.hasNext()) {
            PDFAnnotation annot = iter.next();
            if (!(annot instanceof PDFAnnotationWidget)) continue;
            PDFIconFit fif = ((PDFAnnotationWidget)annot).getAppearanceCharacteristics().getIconFit();
            switch (value) {
                case 0: {
                    fif.setIconScaleType(PDFIconFit.IconScaleType.PROPORTIONAL);
                    break;
                }
                case 1: {
                    fif.setIconScaleType(PDFIconFit.IconScaleType.ANAMORPHIC);
                }
            }
        }
    }

    public int getButtonScaleWhen() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        PDFAnnotationWidget annot = this.currentAnnot;
        if (annot != null && annot.getAppearanceCharacteristics().hasIconFit()) {
            PDFIconFit fif = annot.getAppearanceCharacteristics().getIconFit();
            if (fif.getIconScaleCondition() == PDFIconFit.IconScaleCondition.ALWAYS) {
                return 0;
            }
            if (fif.getIconScaleCondition() == PDFIconFit.IconScaleCondition.NEVER_SCALE) {
                return 1;
            }
            if (fif.getIconScaleCondition() == PDFIconFit.IconScaleCondition.SCALE_WHEN_BIG) {
                return 2;
            }
            if (fif.getIconScaleCondition() == PDFIconFit.IconScaleCondition.SCALE_WHEN_SMALL) {
                return 3;
            }
        }
        return this.buttonScaleWhen;
    }

    public void setButtonScaleWhen(Integer value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        PDFAnnotationIterator iter = null;
        if (!(this.currentField instanceof PDFField)) {
            PDFField field = PDFField.getInstance(this.currentField.getCosObject());
            iter = field.getAnnotationsIterator();
        } else {
            iter = ((PDFField)this.currentField).getAnnotationsIterator();
        }
        while (iter != null && iter.hasNext()) {
            PDFAnnotation annot = iter.next();
            if (!(annot instanceof PDFAnnotationWidget)) continue;
            PDFIconFit fif = ((PDFAnnotationWidget)annot).getAppearanceCharacteristics().getIconFit();
            if (fif == null) {
                fif = PDFIconFit.newInstance(this.currentField.getPDFDocument());
                ((PDFAnnotationWidget)annot).getAppearanceCharacteristics().setIconFit(fif);
            }
            switch (value) {
                case 0: {
                    fif.setIconScaleCondition(PDFIconFit.IconScaleCondition.ALWAYS);
                    break;
                }
                case 1: {
                    fif.setIconScaleCondition(PDFIconFit.IconScaleCondition.NEVER_SCALE);
                    break;
                }
                case 2: {
                    fif.setIconScaleCondition(PDFIconFit.IconScaleCondition.SCALE_WHEN_BIG);
                    break;
                }
                case 3: {
                    fif.setIconScaleCondition(PDFIconFit.IconScaleCondition.SCALE_WHEN_SMALL);
                }
            }
        }
    }

    public int getCalcOrderIndex() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.calcOrderIndex = this.currentField.getPDFDocument().getInteractiveForm().getCalculationOrder().indexOf(this.currentField);
        return this.calcOrderIndex;
    }

    public void setCalcOrderIndex(Integer value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        PDFFieldNode origField;
        int calcInd;
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        PDFInteractiveForm form = this.currentField.getPDFDocument().getInteractiveForm();
        PDFFieldList calcOrder = form.getCalculationOrder();
        if (calcOrder == null) {
            return;
        }
        int currentFieldCalcIndex = this.getCalcOrderIndex();
        PDFFieldList newOrder = PDFFieldList.newInstance(form.getPDFDocument());
        int newInd = 0;
        for (calcInd = currentFieldCalcIndex + 1; calcInd < value; ++calcInd) {
            origField = (PDFFieldNode)calcOrder.get(calcInd);
            if (origField == null || form.getChildren().getFieldFullyNamed(origField.getQualifiedName()) == null) continue;
            newOrder.add(newInd++, origField);
        }
        newOrder.add(newInd++, this.currentField);
        for (calcInd = value.intValue(); calcInd < calcOrder.size(); ++calcInd) {
            origField = (PDFFieldNode)calcOrder.get(calcInd);
            if (origField == null || form.getChildren().getFieldFullyNamed(origField.getQualifiedName()) == null) continue;
            newOrder.add(newInd++, origField);
        }
        if (newOrder.isEmpty()) {
            newOrder = null;
        }
        form.setCalculationOrder(newOrder);
    }

    public int getCharLimit() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if ((PDFField)this.currentField instanceof PDFFieldText) {
            this.charLimit = ((PDFFieldText)this.currentField).getMaxLen();
            return this.charLimit;
        }
        if ("text".equalsIgnoreCase(this.getType().toString())) {
            PDFFieldText txt = PDFFieldText.getInstance(this.currentField.getCosObject());
            this.charLimit = txt.getMaxLen();
            return this.charLimit;
        }
        return 0;
    }

    public void setCharLimit(Integer value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException, IllegalAccessException, NoSuchFieldException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        if ((PDFField)this.currentField instanceof PDFFieldText) {
            ((PDFFieldText)this.currentField).setMaxLen(value);
            if (this.currentField.getValueList() != null && this.currentField.getValueList().size() > 0) {
                this.setValue(this.currentField.getValueList().get(0).toString().substring(0, value));
            }
        } else if (this.getType().toString().equalsIgnoreCase("text")) {
            PDFFieldText txt = PDFFieldText.getInstance(this.currentField.getCosObject());
            txt.setMaxLen(value);
            if (this.currentField.getValueList() != null && this.currentField.getValueList().size() > 0) {
                this.setValue(this.currentField.getValueList().get(0).toString().substring(0, value));
            }
        }
    }

    public boolean getComb() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentField instanceof PDFFieldText) {
            this.comb = ((PDFFieldText)this.currentField).isComb();
        } else if (this.getType().toString().equalsIgnoreCase("text")) {
            PDFFieldText txt = PDFFieldText.getInstance(this.currentField.getCosObject());
            this.comb = txt.isComb();
        }
        return this.comb;
    }

    public void setComb(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        if (this.currentField instanceof PDFFieldText) {
            ((PDFFieldText)this.currentField).setComb(value);
        } else if (this.getType().toString().equalsIgnoreCase("text")) {
            PDFFieldText txt = PDFFieldText.getInstance(this.currentField.getCosObject());
            txt.setComb(value);
        }
    }

    public boolean getCommitOnSelChange() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentField instanceof PDFFieldChoice) {
            this.commitOnSelChange = ((PDFFieldChoice)this.currentField).commitOnSelectionChange();
        }
        return this.commitOnSelChange;
    }

    public void setCommitOnSelChange(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        if (this.currentField instanceof PDFFieldChoice) {
            ((PDFFieldChoice)this.currentField).setcommitOnSelChange(value);
        }
    }

    public Object getCurrentValueIndices() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentField instanceof PDFFieldChoice) {
            int[] arr = ((PDFFieldChoice)this.currentField).getIndexArray();
            Integer[] bigArr = new Integer[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                bigArr[i] = arr[i];
            }
            if (bigArr.length == 1) {
                return Context.javaToJS((Object)bigArr[0], (Scriptable)this.getParentScope());
            }
            return Context.javaToJS((Object)bigArr, (Scriptable)this.getParentScope());
        }
        return null;
    }

    public void setCurrentValueIndices(Object value) throws IllegalAccessException, NoSuchFieldException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (value instanceof NativeArray) {
            NativeArray arr = (NativeArray)value;
            Object[] arr1 = new Object[Integer.valueOf((int)arr.getLength()).intValue()];
            arr1 = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, Context.getCurrentContext());
            int[] vals = new int[arr1.length];
            for (int i = 0; i < arr1.length; ++i) {
                vals[i] = (int)Double.parseDouble(arr1[i].toString());
            }
            if (this.currentField instanceof PDFFieldChoice) {
                ((PDFFieldChoice)this.currentField).setIndexArray(vals);
            }
        } else if (value instanceof Integer) {
            if (this.currentField instanceof PDFFieldChoice) {
                ((PDFFieldChoice)this.currentField).setIndexArray(new int[]{(Integer)value});
            }
        } else if (value instanceof Double) {
            if (this.currentField instanceof PDFFieldChoice) {
                ((PDFFieldChoice)this.currentField).setIndexArray(new int[]{((Double)value).intValue()});
            }
        } else if (value != null) {
            throw new PDFInvalidParameterException("Cannot use type " + value.getClass().getName() + " for property 'currentValueIndices'!");
        }
    }

    public String getDefaultStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.defaultStyle = ((PDFField)this.currentField).getVariableText().getDefaultStyle();
        return this.defaultStyle;
    }

    public void setDefaultStyle(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        if (((PDFField)this.currentField).getVariableText() != null) {
            ((PDFField)this.currentField).getVariableText().setDefaultStyle(value);
        }
        this.defaultStyle = value;
    }

    public String getDefaultValue() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentField.getDefaultValueList() != null) {
            if (this.currentField.getDefaultValueList().size() > 1) {
                return Context.javaToJS((Object)this.currentField.getDefaultValueList(), (Scriptable)this).toString();
            }
            return Context.javaToJS(this.currentField.getDefaultValueList().get(0), (Scriptable)this).toString();
        }
        return null;
    }

    public void setDefaultValue(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        if (!(this.currentField instanceof PDFFieldButton) || !(this.currentField instanceof PDFFieldSignature)) {
            this.currentField.setDefaultStringValue(value);
        }
    }

    public boolean getDoNotScroll() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.doNotScroll = (PDFField)this.currentField instanceof PDFFieldText ? ((PDFFieldText)this.currentField).getDoNotScroll() : false;
        return this.doNotScroll;
    }

    public void setDoNotScroll(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        if ((PDFField)this.currentField instanceof PDFFieldText) {
            ((PDFFieldText)this.currentField).setdoNotScroll(value);
        }
    }

    public boolean getDoNotSpellCheck() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.doNotSpellCheck = (PDFField)this.currentField instanceof PDFFieldText ? ((PDFFieldText)this.currentField).getDoNotSpellCheck() : ((PDFField)this.currentField instanceof PDFFieldChoice && ((PDFFieldChoice)this.currentField).hasEditableTextBox() ? ((PDFFieldChoice)this.currentField).shouldNotSpellCheck() : false);
        return this.doNotSpellCheck;
    }

    public void setDoNotSpellCheck(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        if ((PDFField)this.currentField instanceof PDFFieldText) {
            ((PDFFieldText)this.currentField).setdoNotSpellCheck(value);
        }
        if ((PDFField)this.currentField instanceof PDFFieldChoice && ((PDFFieldChoice)this.currentField).hasEditableTextBox()) {
            ((PDFFieldChoice)this.currentField).setdoNotSpellCheck(value);
        }
    }

    public boolean getDelay() {
        return true;
    }

    public void setDelay(Object value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
    }

    public int getDisplay() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationWidget annot = this.currentAnnot;
        this.display = this.getDisplay(annot);
        return this.display;
    }

    private int getDisplay(PDFAnnotation annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean printable = annot.isPrintable();
        boolean hidden = annot.isHidden();
        boolean noView = annot.isViewable();
        int nDisplay = 0;
        if (!printable && noView) {
            hidden = true;
        }
        if (hidden) {
            nDisplay = 1;
        } else if (!printable) {
            nDisplay = 2;
        } else if (noView) {
            nDisplay = 3;
        }
        return nDisplay;
    }

    public void setDisplay(Integer value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, JavaScriptException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        PDFAnnotationIterator iter = null;
        PDFField field = null;
        if (this.currentField instanceof PDFField) {
            iter = ((PDFField)this.currentField).getAnnotationsIterator();
            this.setDisplay(iter, value);
        } else if (PDFField.getInstance(this.currentField.getCosObject()) != null) {
            field = PDFField.getInstance(this.currentField.getCosObject());
            iter = field.getAnnotationsIterator();
            this.setDisplay(iter, value);
        } else {
            Object[] obj = (Object[])this.getArray();
            for (int i = 0; i < obj.length; ++i) {
                Field f = (Field)((Object)obj[i]);
                field = PDFField.getInstance(f.getCurrentField().getCosObject());
                iter = field.getAnnotationsIterator();
                this.setDisplay(iter, value);
            }
        }
    }

    private void setDisplay(PDFAnnotationIterator iter, int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        while (iter != null && iter.hasNext()) {
            PDFAnnotation annot = iter.next();
            switch (value) {
                case 0: {
                    annot.setPrintable(true);
                    annot.setViewable(true);
                    annot.setHidden(false);
                    break;
                }
                case 1: {
                    annot.setHidden(true);
                    annot.setPrintable(false);
                    annot.setViewable(false);
                    break;
                }
                case 2: {
                    annot.setPrintable(false);
                    break;
                }
                case 3: {
                    annot.setInvisible(true);
                    annot.setViewable(false);
                }
            }
        }
    }

    public Doc getDoc() {
        return (Doc)this.getParentScope();
    }

    public boolean getEditable() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentField instanceof PDFFieldChoice && ((PDFFieldChoice)this.currentField).isComboBox()) {
            this.editable = ((PDFFieldChoice)this.currentField).hasEditableTextBox();
        }
        return this.editable;
    }

    public void setEditable(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        if (this.currentField instanceof PDFFieldChoice && ((PDFFieldChoice)this.currentField).isComboBox()) {
            ((PDFFieldChoice)this.currentField).setEditable(value);
        }
    }

    public Object getExportValues() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentField instanceof PDFFieldButton && (((PDFFieldButton)this.currentField).isRadioButton() || ((PDFFieldButton)this.currentField).isCheckBox())) {
            List vals = ((PDFFieldButton)this.currentField).getOptionList();
            this.exportValues = vals.toArray();
        }
        return Arrays.toString(this.exportValues);
    }

    public void setExportValues(Object value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, IllegalAccessException, NoSuchFieldException, PDFInvalidParameterException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        if (this.currentField instanceof PDFFieldButton && (((PDFFieldButton)this.currentField).isRadioButton() || ((PDFFieldButton)this.currentField).isCheckBox()) && value instanceof NativeArray) {
            NativeArray arr = (NativeArray)value;
            Object[] arr1 = new Object[Integer.valueOf((int)arr.getLength()).intValue()];
            arr1 = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, Context.getCurrentContext());
            List<Object> vals = Arrays.asList(arr1);
            ((PDFFieldButton)this.currentField).setOptionList(vals instanceof ArrayList ? (ArrayList<Object>)vals : new ArrayList<Object>(vals));
        }
    }

    public Object getFgColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, IllegalAccessException, NoSuchFieldException {
        return this.getTextColor();
    }

    public void setFgColor(Object value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException, IllegalAccessException, NoSuchFieldException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        this.setTextColor(value);
    }

    public boolean getFileSelect() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.fileSelect = ((PDFFieldText)this.currentField).getFileSelect();
        return this.fileSelect;
    }

    public void setFileSelect(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        ((PDFFieldText)this.currentField).setFileSelect(value);
    }

    public Object getFillColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, IllegalAccessException, NoSuchFieldException {
        return this.getBgColor();
    }

    public void setFillColor(Object value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, IllegalAccessException, NoSuchFieldException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        this.setBgColor(value);
    }

    public boolean getHidden() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationWidget annot = this.currentAnnot;
        this.hidden = annot.isHidden();
        return this.hidden;
    }

    public void setHidden(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        PDFAnnotationIterator iter = ((PDFField)this.currentField).getAnnotationsIterator();
        while (iter.hasNext()) {
            PDFAnnotation annot = iter.next();
            annot.setHidden(value);
        }
    }

    public String getHighlight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationWidget annot = this.currentAnnot;
        if (annot instanceof PDFAnnotationLink && ((PDFAnnotationLink)((Object)annot)).hasHighlight()) {
            this.highlight = ((PDFAnnotationLink)((Object)annot)).getHighlight();
        }
        return this.highlight;
    }

    public void setHighlight(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        PDFAnnotationIterator iter = ((PDFField)this.currentField).getAnnotationsIterator();
        while (iter.hasNext()) {
            PDFAnnotation annot = iter.next();
            if (annot instanceof PDFAnnotationLink) {
                ((PDFAnnotationLink)annot).setHighlight(value);
            }
            if (!(annot instanceof PDFAnnotationWidget)) continue;
            ((PDFAnnotationWidget)annot).setHighlight(value);
        }
    }

    public double getLineWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getBorderWidth();
    }

    public void setLineWidth(Double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        this.setBorderWidth(value);
    }

    public boolean getMultiline() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.multiline = ((PDFFieldText)this.currentField).getMultiline();
        return this.multiline;
    }

    public void setMultiline(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        if (this.currentField instanceof PDFFieldText) {
            ((PDFFieldText)this.currentField).setMultiline(value);
        }
    }

    public boolean getMultipleSelection() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentField instanceof PDFFieldChoice) {
            this.multipleSelection = ((PDFFieldChoice)this.currentField).isMultipleSelectionAllowed();
        }
        return this.multipleSelection;
    }

    public void setMultipleSelection(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        if (this.currentField instanceof PDFFieldChoice) {
            ((PDFFieldChoice)this.currentField).setMultipleSelectionAllowed(value);
        }
    }

    public String getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.name = this.currentField.getQualifiedName();
        return this.name;
    }

    public int getNumItems() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentField instanceof PDFFieldChoice) {
            return ((PDFFieldChoice)this.currentField).getOptionValueSize();
        }
        return 0;
    }

    public Object getPage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<Integer> pageNumList = new ArrayList<Integer>();
        PDFAnnotationWidget annot = this.currentAnnot;
        pageNumList.add(annot.getPage().getPageNumber());
        this.page = pageNumList.toArray();
        return Arrays.toString(this.page);
    }

    public boolean getPassword() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.isPassword = ((PDFFieldText)this.currentField).isPassword();
        return this.isPassword;
    }

    public void setPassword(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        if (this.currentField instanceof PDFFieldText) {
            ((PDFFieldText)this.currentField).setPassword(value);
        }
    }

    public boolean getPrint() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationWidget annot = this.currentAnnot;
        this.print = annot.isPrintable();
        return this.print;
    }

    public void setPrint(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        PDFAnnotationIterator iter = null;
        if (!(this.currentField instanceof PDFField)) {
            PDFField field = PDFField.getInstance(this.currentField.getCosObject());
            iter = field.getAnnotationsIterator();
        } else {
            iter = ((PDFField)this.currentField).getAnnotationsIterator();
        }
        while (iter != null && iter.hasNext()) {
            PDFAnnotation annot = iter.next();
            annot.setPrintable(value);
        }
    }

    public boolean getRadiosInUnison() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if ("radiobutton".equalsIgnoreCase(this.getType().toString()) || "checkbox".equalsIgnoreCase(this.getType().toString())) {
            PDFFieldButton b = PDFFieldButton.getInstance(this.currentField.getCosObject());
            this.radiosInUnison = b.isRadiosInUnison();
            return this.radiosInUnison;
        }
        return false;
    }

    public void setRadiosInUnison(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        if (this.getType().toString().equalsIgnoreCase("radiobutton")) {
            PDFFieldButton b = PDFFieldButton.getInstance(this.currentField.getCosObject());
            b.setRadiosInUnison(value);
        }
    }

    public boolean getReadonly() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.readonly = this.currentField.isReadOnly();
        return this.readonly;
    }

    private boolean formModifyOkay() throws PDFUnableToCompleteOperationException {
        if (this.currentField == null) {
            return false;
        }
        JavaScriptHandler jsHandler = JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument());
        if (!jsHandler.isFormModifyOk()) {
            Doc topLevel = (Doc)this.getParentScope();
            EventObject event = null;
            if (topLevel == null || (event = (EventObject)((Object)topLevel.get("event", (Scriptable)topLevel))) == null) {
                return false;
            }
            DocumentContext docContext = DocumentContext.find(this.currentField.getPDFDocument(), true, null);
            return JSUtils.esIsOperationAllowed(docContext, event, valid, true);
        }
        return true;
    }

    public void setReadonly(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!this.formModifyOkay()) {
            throw new JavaScriptSecurityException();
        }
        this.currentField.setReadOnly(value);
    }

    public double[] getRect() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationIterator iter = null;
        if (!(this.currentField instanceof PDFField)) {
            if (this.currentAnnot == null) {
                throw new PDFInvalidDocumentException("Cannot find annot.");
            }
            return this.currentAnnot.getRect().getValues();
        }
        iter = ((PDFField)this.currentField).getAnnotationsIterator();
        while (iter != null && iter.hasNext()) {
            PDFAnnotation annot = iter.next();
            this.rect = annot.getRect().getValues();
        }
        return this.rect;
    }

    public void setRect(Object value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        if (value instanceof double[]) {
            double[] rect = (double[])value;
            PDFAnnotationIterator iter = null;
            if (!(this.currentField instanceof PDFField)) {
                PDFField field = PDFField.getInstance(this.currentField.getCosObject());
                iter = field.getAnnotationsIterator();
            } else {
                iter = ((PDFField)this.currentField).getAnnotationsIterator();
            }
            while (iter != null && iter.hasNext()) {
                PDFAnnotation annot = iter.next();
                annot.setRect(rect[0], rect[1], rect[2], rect[3]);
            }
        }
    }

    public boolean getRequired() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.required = this.currentField.isRequired();
        return this.required;
    }

    public void setRequired(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        this.currentField.setRequired(value);
    }

    public boolean getRichText() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentField instanceof PDFFieldText || this.getType().toString().equalsIgnoreCase("text")) {
            PDFFieldText t = PDFFieldText.getInstance(this.currentField.getCosObject());
            return t.isRichText();
        }
        return false;
    }

    public void setRichText(Boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        if (this.currentField instanceof PDFFieldText) {
            ((PDFFieldText)this.currentField).setRichText(value);
        }
    }

    private void setBodyStyle() {
        try {
            String key = this.currentField.getQualifiedName();
            bodyStyle = bodyStyleSet.get(key);
            if (bodyStyle == null) {
                PDFField field = PDFField.getInstance(this.currentField.getCosObject());
                PDFVariableText varText = PDFVariableText.getInstance(field.getCosObject());
                RichTextHandler.SpanStyleHandler spanStyleHandler = new RichTextHandler.SpanStyleHandler(new RichTextHandler());
                String richText = varText.getRichText();
                spanStyleHandler.getStyleSet(richText);
                bodyStyle = spanStyleHandler.getStyle();
                bodyStyleSet.put(key, bodyStyle);
            }
        }
        catch (PDFCosParseException e) {
            throw new RuntimeException(e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new RuntimeException(e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getRichValue() {
        try {
            PDFField field = PDFField.getInstance(this.currentField.getCosObject());
            PDFVariableText varText = PDFVariableText.getInstance(field.getCosObject());
            ArrayList<Span> spans = new ArrayList<Span>();
            HashMap<Integer, HashMap<String, String>> spanSet = new RichTextHandler.SpanStyleHandler(new RichTextHandler()).getStyleSet(varText.getRichText());
            Scriptable scope = this.getParentScope();
            this.setBodyStyle();
            if (spanSet != null && !spanSet.isEmpty()) {
                HashMap<String, String> currentSpan = null;
                for (int key = 0; key < spanSet.size(); ++key) {
                    currentSpan = spanSet.get(key);
                    if (currentSpan == null || currentSpan.isEmpty()) continue;
                    Span span = (Span)((Object)ESObject.create(this.getParentScope(), true, "Span", false, null));
                    span.setSpan(currentSpan);
                    spans.add(span);
                }
                Scriptable array = Context.getCurrentContext().newArray(scope, spans.toArray());
                return new Delegator(array){};
            }
        }
        catch (PDFCosParseException e) {
            throw new RuntimeException(e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new RuntimeException(e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
        return Undefined.instance;
    }

    public void setRichValue(Object richValue) {
        this.setBodyStyle();
        JavaScriptHandler javaScriptHandler = JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument());
        if (richValue instanceof Delegator) {
            Delegator delegator = (Delegator)richValue;
            this.setRichValue(delegator.getDelegee(), this.currentField, this.listValue, javaScriptHandler, bodyStyle);
        } else if (richValue instanceof NativeArray) {
            this.setRichValue((Scriptable)richValue, this.currentField, this.listValue, javaScriptHandler, bodyStyle);
        }
    }

    private void setRichValue(Scriptable richValue, PDFFieldNode currentField, StringBuilder listValue, JavaScriptHandler javaScriptHandler, HashMap<String, String> bodyStyle) {
        if (richValue instanceof NativeArray) {
            try {
                RichTextHandler richTextHandler = new RichTextHandler();
                PDFField field = PDFField.getInstance(currentField.getCosObject());
                PDFVariableText varText = PDFVariableText.getInstance(field.getCosObject());
                String richText = varText.getRichText();
                ArrayList<String> lValue = new ArrayList<String>();
                listValue = new StringBuilder("");
                Object[] fromJS = Context.getCurrentContext().getElements(richValue);
                Span[] jsSpans = new Span[fromJS.length];
                HashMap<Integer, HashMap<String, String>> richValueMap = new HashMap<Integer, HashMap<String, String>>();
                for (int i = 0; i < fromJS.length; ++i) {
                    HashMap<String, String> spanMapParams = null;
                    if (fromJS[i] instanceof Span) {
                        jsSpans[i] = (Span)((Object)fromJS[i]);
                        spanMapParams = jsSpans[i].getSpan();
                    } else if (fromJS[i] instanceof NativeObject && fromJS[i] != null) {
                        Object[] propertyIds;
                        for (Object propId : propertyIds = ScriptableObject.getPropertyIds((Scriptable)((Scriptable)fromJS[i]))) {
                            String key = propId.toString();
                            Object value = ScriptableObject.getProperty((Scriptable)((Scriptable)fromJS[i]), (String)key);
                            if (value instanceof NativeArray) {
                                value = Util.getJavaScriptArray(value, javaScriptHandler);
                            }
                            if (spanMapParams == null) {
                                spanMapParams = new HashMap();
                            }
                            spanMapParams.put(key, value.toString());
                        }
                        spanMapParams = richTextHandler.convertIntoSpanMap(spanMapParams);
                    }
                    richValueMap.put(i, spanMapParams);
                }
                String richTextValue = richTextHandler.createRichValue(richValueMap, bodyStyle, listValue, richText);
                if (richTextValue != null) {
                    varText.setRichText(richTextValue);
                    lValue.add(listValue.toString());
                    PDFField valueField = PDFField.getInstance(currentField.getCosObject());
                    valueField.setListValue(lValue);
                }
            }
            catch (PDFCosParseException e) {
                throw new RuntimeException(e);
            }
            catch (PDFInvalidDocumentException e) {
                throw new RuntimeException(e);
            }
            catch (PDFIOException e) {
                throw new RuntimeException(e);
            }
            catch (PDFSecurityException e) {
                throw new RuntimeException(e);
            }
            catch (PDFInvalidParameterException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int getRotation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationWidget annot = this.currentAnnot;
        if (annot != null && annot.procureAppearanceCharacteristics().hasRotation()) {
            this.rotation = annot.procureAppearanceCharacteristics().getRotation().getValue();
        }
        return this.rotation;
    }

    public void setRotation(Integer value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        PDFAnnotationIterator iter = null;
        if (!(this.currentField instanceof PDFField)) {
            PDFField field = PDFField.getInstance(this.currentField.getCosObject());
            iter = field.getAnnotationsIterator();
        } else {
            iter = ((PDFField)this.currentField).getAnnotationsIterator();
        }
        while (iter != null && iter.hasNext()) {
            PDFAnnotation annot = iter.next();
            if (!(annot instanceof PDFAnnotationWidget)) continue;
            ((PDFAnnotationWidget)annot).procureAppearanceCharacteristics().setRotation(PDFRotation.getInstance(value));
        }
    }

    public Object getStrokeColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, IllegalAccessException, NoSuchFieldException {
        return this.getBorderColor();
    }

    public void setStrokeColor(Object value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, IllegalAccessException, NoSuchFieldException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        this.setBorderColor(value);
    }

    public String getStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        PDFAppearanceCharacteristics.NormalCaptionForCheckAndRadio caValue;
        PDFAnnotationWidget annot = this.currentAnnot;
        if (annot != null) {
            this.style = annot.procureAppearanceCharacteristics().getNormalCaption();
        }
        String styleValue = null;
        if (this.style != null && (caValue = PDFAppearanceCharacteristics.NormalCaptionForCheckAndRadio.getInstance(this.style)) != null) {
            styleValue = caValue.equals(PDFAppearanceCharacteristics.NormalCaptionForCheckAndRadio.StyleCheck) ? "check" : (caValue.equals(PDFAppearanceCharacteristics.NormalCaptionForCheckAndRadio.StyleCross) ? "cross" : (caValue.equals(PDFAppearanceCharacteristics.NormalCaptionForCheckAndRadio.StyleDiamond) ? "diamond" : (caValue.equals(PDFAppearanceCharacteristics.NormalCaptionForCheckAndRadio.StyleCircle) ? "circle" : (caValue.equals(PDFAppearanceCharacteristics.NormalCaptionForCheckAndRadio.StyleStar) ? "star" : (caValue.equals(PDFAppearanceCharacteristics.NormalCaptionForCheckAndRadio.StyleSquare) ? "square" : null)))));
        }
        return styleValue;
    }

    public void setStyle(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, JavaScriptException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        PDFAppearanceCharacteristics.NormalCaptionForCheckAndRadio caValue = null;
        if ("check".equals(value)) {
            caValue = PDFAppearanceCharacteristics.NormalCaptionForCheckAndRadio.StyleCheck;
        }
        if ("cross".equals(value)) {
            caValue = PDFAppearanceCharacteristics.NormalCaptionForCheckAndRadio.StyleCross;
        }
        if ("diamond".equals(value)) {
            caValue = PDFAppearanceCharacteristics.NormalCaptionForCheckAndRadio.StyleDiamond;
        }
        if ("circle".equals(value)) {
            caValue = PDFAppearanceCharacteristics.NormalCaptionForCheckAndRadio.StyleCircle;
        }
        if ("star".equals(value)) {
            caValue = PDFAppearanceCharacteristics.NormalCaptionForCheckAndRadio.StyleStar;
        }
        if ("square".equals(value)) {
            caValue = PDFAppearanceCharacteristics.NormalCaptionForCheckAndRadio.StyleSquare;
        }
        if (caValue == null) {
            throw new JavaScriptException("Check box style " + value + " is unknown.");
        }
        PDFAnnotationIterator iter = ((PDFField)this.currentField).getAnnotationsIterator();
        while (iter.hasNext()) {
            PDFAnnotation annot = iter.next();
            if (!(annot instanceof PDFAnnotationWidget)) continue;
            ((PDFAnnotationWidget)annot).procureAppearanceCharacteristics().setNormalCaption(caValue.getValue());
        }
    }

    public Object getSubmitName() {
        throw new UnsupportedJavaScriptFeatureException(" Unsupported Javascript evaluation feature # submitName ");
    }

    public void setSubmitName(Object value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        throw new UnsupportedJavaScriptFeatureException(" Unsupported Javascript evaluation feature # submitName ");
    }

    public Object getTextColor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException, IllegalAccessException, NoSuchFieldException {
        PDFField field = PDFField.getInstance(this.currentAnnot.getCosObject());
        if (field == null) {
            field = PDFField.getInstance(this.currentField.getCosObject());
        }
        PDFDefaultAppearanceWrapper defAp = this.getDefaultAppearance(field);
        try {
            if (this.textColor == null) {
                this.textColor = new Color();
                this.textColor.setValue(defAp.getColorSpace(), defAp.getFontColor());
            }
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("Cannot get text color.", e);
        }
        return Arrays.toString(((List)this.textColor.getValue()).toArray());
    }

    public void setTextColor(Object value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException, IllegalAccessException, NoSuchFieldException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        boolean isStrokeOp = false;
        this.textColor = new Color();
        if (value instanceof NativeArray) {
            NativeArray arr = (NativeArray)value;
            Object[] fromJS = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, Context.getCurrentContext());
            this.textColor.setValue(fromJS, isStrokeOp);
            PDFDefaultAppearanceWrapper defAp = this.getDefaultAppearance(this.currentField);
            PDFDefaultAppearance newDefAp = defAp.setFontColor(this.textColor.getColorSpace(), this.textColor.getColorValue());
            PDFField field = null;
            if (this.currentAnnot != null) {
                field = PDFField.getInstance(this.currentAnnot.getCosObject());
            }
            if (field == null) {
                field = PDFField.getInstance(this.currentField.getCosObject());
            }
            ((PDFField)this.currentField).getVariableText().setDefaultAppearance(newDefAp);
        }
    }

    public String getTextFont() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        PDFField field = null;
        if (this.currentAnnot != null) {
            field = PDFField.getInstance(this.currentAnnot.getCosObject());
        }
        if (field == null) {
            field = PDFField.getInstance(this.currentField.getCosObject());
        }
        PDFDefaultAppearanceWrapper defAp = this.getDefaultAppearance(field);
        this.textFont = defAp.getBaseFontName();
        return this.textFont;
    }

    public void setTextFont(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        PDFDefaultAppearanceWrapper defAp = this.getDefaultAppearance(this.currentField);
        PDFDefaultAppearance newDefAp = defAp.setBaseFontName(value);
        PDFField field = null;
        if (this.currentAnnot != null) {
            field = PDFField.getInstance(this.currentAnnot.getCosObject());
        }
        if (field == null) {
            field = PDFField.getInstance(this.currentField.getCosObject());
        }
        ((PDFField)this.currentField).getVariableText().setDefaultAppearance(newDefAp);
        this.textFont = value;
    }

    public double getTextSize() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        PDFField field = PDFField.getInstance(this.currentAnnot.getCosObject());
        if (field == null) {
            field = PDFField.getInstance(this.currentField.getCosObject());
        }
        PDFDefaultAppearanceWrapper defAp = this.getDefaultAppearance(field);
        this.textSize = defAp.getFontSize();
        return this.textSize;
    }

    public void setTextSize(Double value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        PDFDefaultAppearanceWrapper defAp = this.getDefaultAppearance(this.currentField);
        PDFDefaultAppearance newDefAp = defAp.setFontSize(value);
        PDFField field = null;
        if (this.currentAnnot != null) {
            field = PDFField.getInstance(this.currentAnnot.getCosObject());
        }
        if (field == null) {
            field = PDFField.getInstance(this.currentField.getCosObject());
        }
        ((PDFField)this.currentField).getVariableText().setDefaultAppearance(newDefAp);
        this.textSize = value;
    }

    public Object getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String type = this.currentField.getFieldType().toString();
        if (type.equalsIgnoreCase("Btn") && PDFFieldButton.getInstance(this.currentField.getCosObject()).isCheckBox()) {
            return "checkbox";
        }
        if (type.equalsIgnoreCase("Ch") && PDFFieldChoice.getInstance(this.currentField.getCosObject()).isComboBox()) {
            return "combobox";
        }
        if (type.equalsIgnoreCase("Ch") && !PDFFieldChoice.getInstance(this.currentField.getCosObject()).isComboBox()) {
            return "listbox";
        }
        if (type.equalsIgnoreCase("Btn") && PDFFieldButton.getInstance(this.currentField.getCosObject()).isRadioButton()) {
            return "radiobutton";
        }
        if (type.equalsIgnoreCase("Btn")) {
            return "button";
        }
        if (type.equalsIgnoreCase("Sig")) {
            return "signature";
        }
        if (type.equalsIgnoreCase("Tx")) {
            return "text";
        }
        return "text";
    }

    public String getUserName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!(this.currentField instanceof PDFField)) {
            PDFField field = PDFField.getInstance(this.currentField.getCosObject());
            this.userName = field.getAlternateName();
        } else {
            this.userName = ((PDFField)this.currentField).getAlternateName();
        }
        return this.userName;
    }

    public void setUserName(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        if (!(this.currentField instanceof PDFField)) {
            PDFField field = PDFField.getInstance(this.currentField.getCosObject());
            field.setAlternateName(value);
        } else {
            ((PDFField)this.currentField).setAlternateName(value);
        }
    }

    public Object getValue() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (this.currentField.getValueList() != null) {
            if (this.currentField.getValueList().size() > 1) {
                return Context.javaToJS((Object)this.currentField.getValueList(), (Scriptable)this);
            }
            String val = this.currentField.getValueList().get(0).toString();
            if (this.getType().toString().equalsIgnoreCase("radiobutton")) {
                if (!val.equalsIgnoreCase("Off")) {
                    val = "Yes";
                }
                return Context.javaToJS((Object)val, (Scriptable)this);
            }
            try {
                Double d = new Double(val);
                return Context.javaToJS((Object)d, (Scriptable)this);
            }
            catch (NumberFormatException e) {
                if (this.currentField instanceof PDFFieldSignature) {
                    return Context.javaToJS((Object)this.currentField.getValueList().get(0).toString(), (Scriptable)this);
                }
                return Context.javaToJS(this.currentField.getValueList().get(0), (Scriptable)this);
            }
        }
        if (this.currentField instanceof PDFFieldText) {
            return Context.javaToJS((Object)"", (Scriptable)this);
        }
        return null;
    }

    public void setValue(Object value1) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException, PDFInvalidParameterException, IllegalAccessException, NoSuchFieldException {
        Scriptable s;
        String className;
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormFillinOk()) {
            throw new JavaScriptSecurityException();
        }
        String oldVal = null;
        String newVal = null;
        PDFField field = null;
        if (JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).getValueChangeListener() != null) {
            if (this.getValue() != null) {
                oldVal = this.getValue().toString();
            }
            field = PDFField.getInstance(this.getCurrentField().getCosObject());
        }
        if (value1 instanceof ScriptableObject && "Date".equals(className = (s = (Scriptable)value1).getClassName())) {
            Date date = (Date)Context.jsToJava((Object)value1, Date.class);
            value1 = date;
        }
        StringBuilder builder = new StringBuilder(" ");
        if (value1 instanceof Object[]) {
            for (int i = 0; i < ((Object[])value1).length; ++i) {
                builder.append(((Object[])value1)[i].toString());
                builder.append("\n ");
            }
            newVal = builder.toString();
            if (JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).getValueChangeListener() != null) {
                JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).getValueChangeListener().beforeChange(field, oldVal, newVal);
            }
            this.currentField.setStringValue(builder.toString());
        } else if (value1 == null) {
            if (JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).getValueChangeListener() != null) {
                JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).getValueChangeListener().beforeChange(field, oldVal, newVal);
            }
            this.currentField.removeValue();
        } else {
            newVal = value1.toString();
            if (JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).getValueChangeListener() != null) {
                JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).getValueChangeListener().beforeChange(field, oldVal, newVal);
            }
            this.currentField.setStringValue(value1.toString());
        }
        if (JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).getValueChangeListener() != null) {
            JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).getValueChangeListener().afterChange(field, oldVal, newVal);
        }
    }

    public Object getValueAsString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (this.getValue() != null) {
            return this.getValue().toString();
        }
        return "";
    }

    public void browseForFileToSubmit() {
        throw new UnsupportedJavaScriptFeatureException("Unsupported JavaScript evaluation feature  # browseForFileToSubmit");
    }

    public String buttonGetCaption(Integer nFace) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationWidget annot = this.currentAnnot;
        if (annot != null) {
            if (nFace == 0) {
                return annot.procureAppearanceCharacteristics().getNormalCaption();
            }
            if (nFace == 2) {
                return annot.procureAppearanceCharacteristics().getRolloverCaption();
            }
            if (nFace == 1) {
                return annot.procureAppearanceCharacteristics().getAlternateCaption();
            }
        }
        return null;
    }

    public Icon buttonGetIcon(Integer nFace) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormFillinOk()) {
            throw new JavaScriptSecurityException();
        }
        Scriptable scope = this.getParentScope();
        PDFAnnotationWidget annot = this.currentAnnot;
        if (annot != null) {
            if (nFace == 0) {
                Icon icon = new Icon(annot.procureAppearanceCharacteristics().getNormalIcon());
                icon.setParentScope(scope);
                return icon;
            }
            if (nFace == 2) {
                Icon icon = new Icon(annot.procureAppearanceCharacteristics().getRolloverIcon());
                icon.setParentScope(scope);
                return icon;
            }
            if (nFace == 1) {
                Icon icon = new Icon(annot.procureAppearanceCharacteristics().getAlternateIcon());
                icon.setParentScope(scope);
                return icon;
            }
        }
        return null;
    }

    public void buttonImportIcon(Object arg2, Object arg1) {
        throw new UnsupportedJavaScriptFeatureException("Unsupported JavaScript evaluation feature  # buttonImportIcon");
    }

    public void buttonSetCaption(String caption, Integer nFace) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormFillinOk()) {
            throw new JavaScriptSecurityException();
        }
        PDFAnnotationIterator iter = ((PDFField)this.currentField).getAnnotationsIterator();
        while (iter.hasNext()) {
            PDFAnnotation annot = iter.next();
            if (!(annot instanceof PDFAnnotationWidget)) continue;
            if (nFace == 0) {
                ((PDFAnnotationWidget)annot).procureAppearanceCharacteristics().setNormalCaption(caption);
            }
            if (nFace == 2) {
                ((PDFAnnotationWidget)annot).procureAppearanceCharacteristics().setRolloverCaption(caption);
            }
            if (nFace != 1) continue;
            ((PDFAnnotationWidget)annot).procureAppearanceCharacteristics().setAlternateCaption(caption);
        }
    }

    public void buttonSetIcon(Icon icon, Integer nFace) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormFillinOk()) {
            throw new JavaScriptSecurityException();
        }
        if (icon != null) {
            PDFAnnotationIterator iter = ((PDFField)this.currentField).getAnnotationsIterator();
            while (iter.hasNext()) {
                PDFAnnotation annot = iter.next();
                annot.setHidden(false);
                annot.setPrintable(true);
                if (!(annot instanceof PDFAnnotationWidget)) continue;
                if (nFace == 0) {
                    ((PDFAnnotationWidget)annot).procureAppearanceCharacteristics().setNormalIcon(icon.getIconObject());
                }
                if (nFace == 2) {
                    ((PDFAnnotationWidget)annot).procureAppearanceCharacteristics().setRolloverIcon(icon.getIconObject());
                }
                if (nFace != 1) continue;
                ((PDFAnnotationWidget)annot).procureAppearanceCharacteristics().setAlternateIcon(icon.getIconObject());
            }
        }
    }

    public void checkThisBox(Integer nWidget, Boolean shouldCheck) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int idx = 0;
        boolean hasOpt = false;
        if (this.getType().toString().equalsIgnoreCase("checkbox") || this.getType().toString().equalsIgnoreCase("radiobutton")) {
            PDFFieldButton b = PDFFieldButton.getInstance(this.currentField.getCosObject());
            List optlist = b.getOptionList();
            if (optlist != null && !optlist.isEmpty()) {
                hasOpt = true;
            }
            if (!b.isRadiosInUnison()) {
                String stateStr = "Yes";
                PDFAnnotationIterator iter = b.getAnnotationsIterator();
                while (iter.hasNext()) {
                    PDFAnnotation annot = iter.next();
                    if (idx == nWidget) {
                        if (hasOpt) {
                            stateStr = String.valueOf(idx);
                        }
                        ((PDFAnnotationWidget)annot).setAppearanceState(shouldCheck, stateStr);
                    } else {
                        ((PDFAnnotationWidget)annot).setAppearanceState(shouldCheck == false, stateStr);
                    }
                    ++idx;
                }
                if (shouldCheck.booleanValue()) {
                    this.currentField.setNameValue(ASName.create(nWidget.toString()));
                } else {
                    this.currentField.setNameValue(ASName.create("Off"));
                }
            } else {
                PDFAnnotationIterator iter = b.getAnnotationsIterator();
                String shouldCheckStr = "Yes";
                while (iter.hasNext()) {
                    PDFAnnotation annot = iter.next();
                    if (hasOpt) {
                        shouldCheckStr = (String)optlist.get(idx);
                    }
                    ((PDFAnnotationWidget)annot).setAppearanceState(shouldCheck, shouldCheckStr);
                    PDFAppearance widgetAppearance = ((PDFAnnotationWidget)annot).getAppearance();
                    CosObject cosAppearance = widgetAppearance.getDictionaryCosObjectValue(ASName.k_N);
                    List<ASName> keylist = ((CosDictionary)cosAppearance).getKeys();
                    for (ASName key : keylist) {
                        if (key.toString().equalsIgnoreCase("/off")) continue;
                        CosStream onapp = ((CosDictionary)cosAppearance).getCosStream(key);
                        ((CosDictionary)cosAppearance).put(ASName.create(shouldCheckStr), onapp);
                        ((CosDictionary)cosAppearance).remove(key);
                    }
                    ++idx;
                }
                if (shouldCheck.booleanValue()) {
                    this.currentField.setNameValue(ASName.create(shouldCheckStr));
                } else {
                    this.currentField.setNameValue(ASName.create("Off"));
                }
                if (hasOpt) {
                    b.removeValue(ASName.k_Opt);
                }
            }
        }
    }

    public void clear() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentField instanceof PDFFieldChoice) {
            ((PDFFieldChoice)this.currentField).removeAllItems();
        }
    }

    public void clearItems() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormFillinOk()) {
            throw new JavaScriptSecurityException();
        }
        if (this.currentField instanceof PDFFieldChoice) {
            ((PDFFieldChoice)this.currentField).removeAllItems();
        }
    }

    public Boolean defaultIsChecked(Integer nWidget, Boolean isDefaultISChecked) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (this.getType().toString().equalsIgnoreCase("checkbox") || this.getType().toString().equalsIgnoreCase("radiobutton")) {
            int index = 0;
            PDFFieldButton b = PDFFieldButton.getInstance(this.currentField.getCosObject());
            PDFAnnotationIterator iter = b.getAnnotationsIterator();
            while (iter.hasNext()) {
                PDFAnnotation annot = iter.next();
                if (!(annot instanceof PDFAnnotationWidget) || ++index != nWidget) continue;
                annot.setAppearanceState(isDefaultISChecked);
                return true;
            }
        }
        return false;
    }

    public void deleteItemAt(Integer pos) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.currentField instanceof PDFFieldChoice) {
            ((PDFFieldChoice)this.currentField).deleteItemAt(pos);
        }
    }

    public Object getArray() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptException {
        boolean isTerminalFieldAcrobatCompatible = true;
        Iterator<PDFField> kidsIter = this.currentField.iterator(isTerminalFieldAcrobatCompatible);
        ArrayList<Field> aList = new ArrayList<Field>();
        ArrayList<PDFFieldNode> addedFieldNodes = new ArrayList<PDFFieldNode>();
        while (kidsIter.hasNext()) {
            PDFFieldNode curField = kidsIter.next();
            if (!curField.isTerminalField() || PDFUtil.containsPDFCosObjectRef(addedFieldNodes, curField)) continue;
            Field field = (Field)((Object)ESObject.create(this.getParentScope(), true, className, false, null));
            field.setCurrentField(curField);
            field.setCurrentAnnot(PDFAnnotationWidget.getInstance(curField.getCosObject()));
            aList.add(field);
            addedFieldNodes.add(curField);
        }
        if (aList.isEmpty()) {
            aList.add(this);
        }
        return aList.toArray();
    }

    public String getItemAt(Integer pos, Object export) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean exportValue = true;
        if (export instanceof Boolean) {
            exportValue = (Boolean)export;
        }
        if (this.currentField instanceof PDFFieldChoice) {
            return (String)((PDFFieldChoice)this.currentField).getItemAt(pos, exportValue);
        }
        return "undefined";
    }

    public Lock getLock() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptException {
        PDFFieldLock fLock;
        if (this.currentField instanceof PDFFieldSignature && (fLock = ((PDFFieldSignature)this.currentField).getPDFFieldLock()) != null) {
            Lock lock = (Lock)((Object)ESObject.create(this.getParentScope(), true, "Lock", false, null));
            lock.setCurrentLock(fLock);
            return lock;
        }
        return null;
    }

    public void insertItemAt(String cName, String cExport, Integer pos) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        if (this.currentField instanceof PDFFieldChoice) {
            ((PDFFieldChoice)this.currentField).insertItemAt(pos, cName, cExport);
        }
    }

    public Boolean isBoxChecked(Integer value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (this.getType().toString().equalsIgnoreCase("checkbox") || this.getType().toString().equalsIgnoreCase("radiobutton")) {
            int index = 0;
            PDFFieldButton b = PDFFieldButton.getInstance(this.currentField.getCosObject());
            PDFAnnotationIterator iter = b.getAnnotationsIterator();
            while (iter.hasNext()) {
                PDFAnnotation annot = iter.next();
                if (annot instanceof PDFAnnotationWidget && index == value) {
                    ASName name = annot.getAppearanceState();
                    return !"off".equalsIgnoreCase(name.asString());
                }
                ++index;
            }
        }
        return false;
    }

    public Boolean isDefaultChecked(Integer value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (this.getType().toString().equalsIgnoreCase("checkbox") || this.getType().toString().equalsIgnoreCase("radiobutton")) {
            int index = 0;
            PDFFieldButton b = PDFFieldButton.getInstance(this.currentField.getCosObject());
            PDFAnnotationIterator iter = b.getAnnotationsIterator();
            while (iter.hasNext()) {
                PDFAnnotation annot = iter.next();
                if (!(annot instanceof PDFAnnotationWidget) || index != value) continue;
                ASName name = annot.getAppearanceState();
                ++index;
                return "Yes".equalsIgnoreCase(name.asString());
            }
        }
        return false;
    }

    public void setAction(String trigger, String script) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (trigger.equalsIgnoreCase("validate")) {
            ((PDFAdditionalActionsField)this.currentField.procureAdditionalActions()).setActionOnChange(PDFActionJavaScript.newInstance(this.currentField.getPDFDocument(), PDFText.newInstance(this.currentField.getPDFDocument(), script)));
        } else if (trigger.equalsIgnoreCase("calculate")) {
            ((PDFAdditionalActionsField)this.currentField.procureAdditionalActions()).setActionOnCalculate(PDFActionJavaScript.newInstance(this.currentField.getPDFDocument(), PDFText.newInstance(this.currentField.getPDFDocument(), script)));
        } else if (trigger.equalsIgnoreCase("format")) {
            ((PDFAdditionalActionsField)this.currentField.procureAdditionalActions()).setActionOnFormat(PDFActionJavaScript.newInstance(this.currentField.getPDFDocument(), PDFText.newInstance(this.currentField.getPDFDocument(), script)));
        } else if (trigger.equalsIgnoreCase("keystroke")) {
            ((PDFAdditionalActionsField)this.currentField.procureAdditionalActions()).setActionOnKeystroke(PDFActionJavaScript.newInstance(this.currentField.getPDFDocument(), PDFText.newInstance(this.currentField.getPDFDocument(), script)));
        } else {
            throw new UnsupportedJavaScriptFeatureException(" Action not supported " + trigger);
        }
    }

    public void setFocus() {
        throw new UnsupportedJavaScriptFeatureException(" Unsupported JavaScript feature # setFocus()");
    }

    public void setItems(Object result) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormFillinOk()) {
            throw new JavaScriptSecurityException();
        }
        if (result instanceof NativeArray) {
            NativeArray arr = (NativeArray)result;
            Object[] arr1 = new Object[Integer.valueOf((int)arr.getLength()).intValue()];
            try {
                arr1 = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, Context.getCurrentContext());
            }
            catch (IllegalAccessException e) {
                throw new JavaScriptSecurityException(e);
            }
            catch (NoSuchFieldException e) {
                throw new JavaScriptException(e);
            }
            for (int i = 0; i < arr1.length; ++i) {
                if (arr1[i] instanceof Object[]) {
                    Object[] arr2 = (Object[])arr1[i];
                    this.insertItemAt(arr2[0].toString(), arr2[1].toString(), i);
                    continue;
                }
                this.insertItemAt(arr1[i].toString(), arr1[i].toString(), i);
            }
        }
    }

    public void setLock(Lock lock) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        PDFFieldLock fLock = lock.getCurrentLock();
        if (this.currentField instanceof PDFFieldSignature) {
            ((PDFFieldSignature)this.currentField).setPDFFieldLock(fLock);
        }
    }

    public void signatureGetModifications() {
        throw new UnsupportedJavaScriptFeatureException(" Unsupported JavaScript feature # signatureGetModifications()");
    }

    public Object signatureGetSeedValue() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptException {
        PDFFieldSignature signatureField;
        PDFSignatureFieldSeedValue seedval;
        if (this.currentField instanceof PDFFieldSignature && (seedval = (signatureField = PDFFieldSignature.getInstance(this.currentField.getCosObject())).getFieldSeedValue()) != null) {
            SeedValue seed = (SeedValue)((Object)ESObject.create(this.getParentScope(), true, "SeedValue", false, null));
            seed.setCurrentSigSeedValue(seedval);
            return seed;
        }
        return Undefined.instance;
    }

    public Object signatureInfo(Object oSig) {
        PDFFieldSignature sigField;
        try {
            sigField = PDFFieldSignature.getInstance(this.currentField.getCosObject());
            JSExtensionOptions extensionOptions = JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).getExtensionOptions();
            if (extensionOptions == null) {
                throw new RuntimeException("Extension options are null");
            }
            JSSigValidateProvider provider = extensionOptions.getJSSigValidateProvider();
            if (provider == null) {
                throw new RuntimeException("JSSigValidateProvider is null");
            }
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        if (sigField != null) {
            try {
                SignatureInfo sigInfo = (SignatureInfo)((Object)ESObject.create(this.getParentScope(), true, "SignatureInfo", false, null));
                sigInfo.setInitialParams(this.jsSigInfo, new SignatureFieldPDF(sigField));
                return sigInfo;
            }
            catch (PDFInvalidParameterException e) {
                throw new RuntimeException(e);
            }
        }
        return Undefined.instance;
    }

    public void signatureSetSeedValue(SeedValue seed) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, JavaScriptSecurityException, PDFUnableToCompleteOperationException {
        if (!JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).isFormModifyOk()) {
            throw new JavaScriptSecurityException();
        }
        throw new UnsupportedJavaScriptFeatureException(" Unsupported JavaScript feature # signatureSetSeedValue()");
    }

    public void signatureSign(Object oSig, Object oInfo, Object cDIPath, Object bUI, Object cLegalAttest) {
        throw new UnsupportedJavaScriptFeatureException(" Unsupported JavaScript feature # signatureSign()");
    }

    public Integer signatureValidate(Object oSig, Object bUI) {
        Number num;
        if (!(this.currentField instanceof PDFFieldSignature)) {
            return -1;
        }
        try {
            PDFFieldSignature sigField = PDFFieldSignature.getInstance(this.currentField.getCosObject());
            if (sigField.getSignature() == null) {
                return 0;
            }
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
        JSExtensionOptions extensionOptions = JavaScriptHandler.getRegisteredInstance(((Doc)this.getParentScope()).getActiveDocument()).getExtensionOptions();
        if (extensionOptions == null) {
            throw new RuntimeException("Extension Options are null");
        }
        try {
            JSSigValidateProvider provider = extensionOptions.getJSSigValidateProvider();
            if (provider == null) {
                throw new RuntimeException("JSSigValidateProvider is null");
            }
            this.jsSigInfo = provider.validateSignature(this.currentField.getQualifiedName());
        }
        catch (PDFInvalidDocumentException e) {
            throw new IllegalArgumentException("PDF document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new RuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new RuntimeException(e);
        }
        catch (PDFInvalidParameterException e) {
            throw new RuntimeException(e);
        }
        if (this.jsSigInfo != null && (num = this.jsSigInfo.getStatus()) != null) {
            return num.intValue();
        }
        return 1;
    }

    private PDFDefaultAppearanceWrapper getDefaultAppearance(PDFFieldNode fieldNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDefaultAppearance defAp = null;
        PDFDefaultAppearance defApFromParent = fieldNode.getVariableText().getDefaultAppearance();
        if (defApFromParent == null) {
            throw new PDFInvalidDocumentException("Document doesn't contain default appearance /DA.");
        }
        boolean needClone = false;
        CosObject cosValue = fieldNode.getDictionaryValue(ASName.k_DA);
        if (cosValue == null) {
            needClone = true;
        } else if (cosValue.isIndirect()) {
            needClone = true;
        } else {
            defAp = defApFromParent;
        }
        if (needClone) {
            defAp = PDFDefaultAppearance.newInstance(fieldNode.getPDFDocument(), defApFromParent.asString());
            fieldNode.getVariableText().setDefaultAppearance(defAp);
        }
        try {
            return new PDFDefaultAppearanceWrapper(defAp);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidDocumentException("Cannot instantiate default appearance.", e);
        }
    }

    static {
        valid.put(JSUtils.ESTriggerType.ESTRIGGERTYPE_DOC_STR, null);
        valid.put(JSUtils.ESTriggerType.ESTRIGGERTYPE_PAGE_STR, null);
        valid.put(JSUtils.ESTriggerType.ESTRIGGERTYPE_BOOKMARK_STR, null);
        valid.put(JSUtils.ESTriggerType.ESTRIGGERTYPE_LINK_STR, null);
        valid.put(JSUtils.ESTriggerType.ESTRIGGERTYPE_FIELD_STR, null);
        valid.put(JSUtils.ESTriggerType.ESTRIGGERTYPE_SCREENANNOT_STR, null);
        valid.put(JSUtils.ESTriggerType.ESTRIGGERTYPE_MEDIAPLAYER_STR, null);
        valid.put(JSUtils.ESTriggerType.AVTRIGGERTYPE_Annot_STR, null);
        valid.put(JSUtils.ESTriggerType.ESTRIGGERTYPE_OCG_STR, null);
        valid.put(null, null);
        bodyStyleSet = new HashMap();
        bodyStyle = new HashMap();
    }
}

