/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.javascript;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationCaret;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationCircle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationDefaults;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFileAttachment;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFreeText;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationInk;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLine;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMovie;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPolygon;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPolyline;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationScreen;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationSound;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationSquare;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationStamp;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationText;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithBorderEffects;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithIcon;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithQuadPoints;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorder;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderStyle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFInkList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFVertices;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.impl.PDFDefaultAppearanceWrapper;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import com.adobe.internal.pdftoolkit.services.javascript.Color;
import com.adobe.internal.pdftoolkit.services.javascript.Doc;
import com.adobe.internal.pdftoolkit.services.javascript.UnsupportedJavaScriptFeatureException;
import com.adobe.internal.pdftoolkit.services.javascript.model.ESObject;
import com.adobe.internal.pdftoolkit.services.javascript.model.Function;
import com.adobe.internal.pdftoolkit.services.javascript.model.JSUtils;
import com.adobe.internal.pdftoolkit.services.javascript.model.Param;
import com.adobe.internal.pdftoolkit.services.javascript.model.Property;
import com.adobe.internal.pdftoolkit.services.javascript.model.ScriptTable;
import com.adobe.internal.pdftoolkit.services.javascript.model.manual.AnnotationParams;
import com.adobe.internal.pdftoolkit.services.xfdf.XFDFService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Annotation
extends ESObject {
    protected static final ScriptTable scriptTable = new ScriptTable("Annotation.class", new HashMap<String, Function>(3){
        private static final long serialVersionUID = 1L;
        {
            this.put("destroy", new Function(Annotation.class, "destroy", Param.Type.Object, AnnotationParams.destroy, 0, false, false));
            this.put("getProps", new Function(Annotation.class, "getProps", Param.Type.Object, AnnotationParams.getProps, 0, true, false));
            this.put("setProps", new Function(Annotation.class, "setProps", Param.Type.Object, AnnotationParams.setProps, 1, false, false));
        }
    }, new HashMap<String, Property>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("soundIcon", new Property(Annotation.class, "soundIcon", "getSoundIcon", "setSoundIcon", AnnotationParams.soundIcon, false, false));
            this.put("arrowBegin", new Property(Annotation.class, "arrowBegin", "getArrowBegin", "setArrowBegin", AnnotationParams.arrowBegin, false, false));
            this.put("quads", new Property(Annotation.class, "quads", "getQuads", "setQuads", AnnotationParams.quads, false, false));
            this.put("author", new Property(Annotation.class, "author", "getAuthor", "setAuthor", AnnotationParams.author, false, false));
            this.put("rect", new Property(Annotation.class, "rect", "getRect", "setRect", AnnotationParams.rect, false, false));
            this.put("rotate", new Property(Annotation.class, "rotate", "getRotate", "setRotate", AnnotationParams.rotate, false, false));
            this.put("toggleNoView", new Property(Annotation.class, "toggleNoView", null, "setToggleNoView", AnnotationParams.toggleNoView, false, false));
            this.put("refType", new Property(Annotation.class, "refType", "getRefType", "setRefType", AnnotationParams.refType, false, false));
            this.put("inReplyTo", new Property(Annotation.class, "inReplyTo", "getInReplyTo", "setInReplyTo", AnnotationParams.inReplyTo, false, false));
            this.put("leaderLength", new Property(Annotation.class, "leaderLength", "getLeaderLength", "setLeaderLength", AnnotationParams.leaderLength, false, false));
            this.put("readOnly", new Property(Annotation.class, "readOnly", "getReadOnly", "setReadOnly", AnnotationParams.readOnly, false, false));
            this.put("subject", new Property(Annotation.class, "subject", "getSubject", "setSubject", AnnotationParams.subject, false, false));
            this.put("gestures", new Property(Annotation.class, "gestures", "getGestures", "setGestures", AnnotationParams.gestures, false, false));
            this.put("textColor", new Property(Annotation.class, "textColor", null, "setTextColor", AnnotationParams.textColor, false, false));
            this.put("textSize", new Property(Annotation.class, "textSize", "getTextSize", "setTextSize", AnnotationParams.textSize, false, false));
            this.put("doc", new Property(Annotation.class, "doc", "getDoc", null, null, false, false));
            this.put("lock", new Property(Annotation.class, "lock", "getLock", "setLock", AnnotationParams.lock, false, false));
            this.put("richContents", new Property(Annotation.class, "richContents", "getRichContents", "setRichContents", AnnotationParams.richContents, false, false));
            this.put("arrowEnd", new Property(Annotation.class, "arrowEnd", "getArrowEnd", "setArrowEnd", AnnotationParams.arrowEnd, false, false));
            this.put("type", new Property(Annotation.class, "type", "getType", null, null, false, false));
            this.put("modDate", new Property(Annotation.class, "modDate", "getModDate", "setModDate", AnnotationParams.modDate, false, false));
            this.put("delay", new Property(Annotation.class, "delay", "getDelay", "setDelay", AnnotationParams.delay, false, false));
            this.put("borderEffectStyle", new Property(Annotation.class, "borderEffectStyle", "getBorderEffectStyle", "setBorderEffectStyle", AnnotationParams.borderEffectStyle, false, false));
            this.put("points", new Property(Annotation.class, "points", "getPoints", "setPoints", AnnotationParams.points, false, false));
            this.put("opacity", new Property(Annotation.class, "opacity", "getOpacity", "setOpacity", AnnotationParams.opacity, false, false));
            this.put("seqNum", new Property(Annotation.class, "seqNum", "getSeqNum", null, null, false, false));
            this.put("leaderExtend", new Property(Annotation.class, "leaderExtend", "getLeaderExtend", "setLeaderExtend", AnnotationParams.leaderExtend, false, false));
            this.put("noteIcon", new Property(Annotation.class, "noteIcon", "getNoteIcon", "setNoteIcon", AnnotationParams.noteIcon, false, false));
            this.put("caretSymbol", new Property(Annotation.class, "caretSymbol", "getCaretSymbol", "setCaretSymbol", AnnotationParams.caretSymbol, false, false));
            this.put("vertices", new Property(Annotation.class, "vertices", "getVertices", "setVertices", AnnotationParams.vertices, false, false));
            this.put("state", new Property(Annotation.class, "state", "getState", "setState", AnnotationParams.state, false, false));
            this.put("lineEnding", new Property(Annotation.class, "lineEnding", "getLineEnding", "setLineEnding", AnnotationParams.lineEnding, false, false));
            this.put("name", new Property(Annotation.class, "name", "getName", "setName", AnnotationParams.name, false, false));
            this.put("callout", new Property(Annotation.class, "callout", "getCallout", "setCallout", AnnotationParams.callout, false, false));
            this.put("width", new Property(Annotation.class, "width", "getWidth", "setWidth", AnnotationParams.width, false, false));
            this.put("alignment", new Property(Annotation.class, "alignment", "getAlignment", "setAlignment", AnnotationParams.alignment, false, false));
            this.put("strokeColor", new Property(Annotation.class, "strokeColor", "getStrokeColor", "setStrokeColor", AnnotationParams.strokeColor, false, false));
            this.put("point", new Property(Annotation.class, "point", "getPoint", "setPoint", AnnotationParams.point, false, false));
            this.put("popupOpen", new Property(Annotation.class, "popupOpen", "getPopupOpen", "setPopupOpen", AnnotationParams.popupOpen, false, false));
            this.put("doCaption", new Property(Annotation.class, "doCaption", "getDoCaption", "setDoCaption", AnnotationParams.doCaption, false, false));
            this.put("intent", new Property(Annotation.class, "intent", "getIntent", "setIntent", AnnotationParams.intent, false, false));
            this.put("aP", new Property(Annotation.class, "aP", "getAP", "setAP", AnnotationParams.aP, false, false));
            this.put("page", new Property(Annotation.class, "page", "getPage", "setPage", AnnotationParams.page, false, false));
            this.put("creationDate", new Property(Annotation.class, "creationDate", "getCreationDate", null, null, false, false));
            this.put("textFont", new Property(Annotation.class, "textFont", "getTextFont", "setTextFont", AnnotationParams.textFont, false, false));
            this.put("print", new Property(Annotation.class, "print", "getPrint", "setPrint", AnnotationParams.print, false, false));
            this.put("attachIcon", new Property(Annotation.class, "attachIcon", "getAttachIcon", "setAttachIcon", AnnotationParams.attachIcon, false, false));
            this.put("dash", new Property(Annotation.class, "dash", "getDash", "setDash", AnnotationParams.dash, false, false));
            this.put("contents", new Property(Annotation.class, "contents", "getContents", "setContents", AnnotationParams.contents, false, false));
            this.put("borderEffectIntensity", new Property(Annotation.class, "borderEffectIntensity", "getBorderEffectIntensity", "setBorderEffectIntensity", AnnotationParams.borderEffectIntensity, false, false));
            this.put("stateModel", new Property(Annotation.class, "stateModel", "getStateModel", "setStateModel", AnnotationParams.stateModel, false, false));
            this.put("hidden", new Property(Annotation.class, "hidden", "getHidden", "setHidden", AnnotationParams.hidden, false, false));
            this.put("noView", new Property(Annotation.class, "noView", "getNoView", "setNoView", AnnotationParams.noView, false, false));
            this.put("richDefaults", new Property(Annotation.class, "richDefaults", "getRichDefaults", "setRichDefaults", AnnotationParams.richDefaults, true, true));
            this.put("style", new Property(Annotation.class, "style", "getStyle", "setStyle", AnnotationParams.style, false, false));
            this.put("popupRect", new Property(Annotation.class, "popupRect", "getPopupRect", "setPopupRect", AnnotationParams.popupRect, false, false));
            this.put("fillColor", new Property(Annotation.class, "fillColor", "getFillColor", "setFillColor", AnnotationParams.fillColor, false, false));
        }
    });
    private static final long serialVersionUID = 7469761384812984530L;
    int alignment;
    String AP;
    String arrowBegin;
    String arrowEnd;
    String attachIcon;
    String author;
    int borderEffectIntensity;
    String borderEffectStyle;
    double[] callout;
    String caretSymbol;
    String contents;
    Date creationDate;
    double[] dash;
    boolean delay;
    Doc doc;
    Color fillColor;
    boolean docCaption;
    double[] gestures;
    boolean hidden;
    String inReplyTo;
    String intent;
    double leaderExtend;
    double leaderLength;
    String lineEnding;
    boolean lock;
    Date modDate;
    String name;
    String noteIcon;
    boolean noView;
    double opacity;
    int page;
    double[] point;
    double[] points;
    boolean popupOpen;
    double[] popupRect;
    boolean print;
    double[] quads;
    double[] rect;
    boolean readOnly;
    String refType;
    Object richContents;
    Object richDefaults;
    int seqNum;
    String soundIcon;
    String state;
    String stateModel;
    Color strokeColor;
    String style;
    String subject;
    String textFont;
    double textSize;
    boolean toggleNoView;
    String type;
    Object[][] vertices;
    double width;
    PDFAnnotation pdfAnnot;
    static final String className = "Annotation";

    @Override
    public Object get(String name, Scriptable start) {
        return super.get(name, start);
    }

    @Override
    protected ScriptTable getScriptTable() {
        return scriptTable;
    }

    public Annotation() {
    }

    public Annotation(Object annot) {
        if (annot instanceof PDFAnnotation) {
            this.pdfAnnot = (PDFAnnotation)annot;
        }
    }

    @Override
    public String getClassName() {
        return className;
    }

    public void initAnnot(Object props) {
    }

    public int getAlignment() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationFreeText && ((PDFAnnotationFreeText)this.pdfAnnot).hasJustification()) {
            this.alignment = ((PDFAnnotationFreeText)this.pdfAnnot).getJustification();
        }
        return this.alignment;
    }

    public void setAlignment(Integer alignment) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationFreeText) {
            ((PDFAnnotationFreeText)this.pdfAnnot).setJustification(alignment);
        }
    }

    public String getAP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationStamp && ((PDFAnnotationStamp)this.pdfAnnot).hasIconName()) {
            this.AP = ((PDFAnnotationStamp)this.pdfAnnot).getIconName();
        }
        return this.AP;
    }

    public void setAP(String ap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationStamp) {
            ((PDFAnnotationStamp)this.pdfAnnot).setIconName(ap);
        }
    }

    public String getArrowBegin() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationLine) {
            if (((PDFAnnotationLine)this.pdfAnnot).hasLineEnds()) {
                this.arrowBegin = ((PDFAnnotationLine)this.pdfAnnot).getLineEnds()[0].toString();
            }
        } else if (this.pdfAnnot instanceof PDFAnnotationPolyline && ((PDFAnnotationPolyline)this.pdfAnnot).hasLineEnds()) {
            this.arrowBegin = ((PDFAnnotationPolyline)this.pdfAnnot).getLineEnds()[0].toString();
        }
        return this.arrowBegin;
    }

    public void setArrowBegin(String arrowBegin) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        String arrowEnd;
        PDFAnnotationLine.LineEnding[] lineEnds = new PDFAnnotationLine.LineEnding[]{PDFAnnotationLine.LineEnding.getInstance(arrowBegin), (arrowEnd = this.getArrowEnd()) != null ? PDFAnnotationLine.LineEnding.getInstance(arrowEnd) : PDFAnnotationLine.LineEnding.getInstance("None")};
        if (this.pdfAnnot instanceof PDFAnnotationLine) {
            ((PDFAnnotationLine)this.pdfAnnot).setLineEnds(lineEnds);
        } else if (this.pdfAnnot instanceof PDFAnnotationPolyline) {
            ((PDFAnnotationPolyline)this.pdfAnnot).setLineEnds(lineEnds);
        }
    }

    public String getArrowEnd() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationLine) {
            if (((PDFAnnotationLine)this.pdfAnnot).hasLineEnds()) {
                this.arrowEnd = ((PDFAnnotationLine)this.pdfAnnot).getLineEnds()[1].toString();
            }
        } else if (this.pdfAnnot instanceof PDFAnnotationPolyline && ((PDFAnnotationPolyline)this.pdfAnnot).hasLineEnds()) {
            this.arrowEnd = ((PDFAnnotationPolyline)this.pdfAnnot).getLineEnds()[1].toString();
        }
        return this.arrowEnd;
    }

    public void setArrowEnd(String arrowEnd) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFAnnotationLine.LineEnding[] lineEnds = new PDFAnnotationLine.LineEnding[2];
        lineEnds[1] = PDFAnnotationLine.LineEnding.getInstance(arrowEnd);
        String arrowBegin = this.getArrowBegin();
        lineEnds[0] = arrowBegin != null ? PDFAnnotationLine.LineEnding.getInstance(arrowBegin) : PDFAnnotationLine.LineEnding.getInstance("None");
        if (this.pdfAnnot instanceof PDFAnnotationLine) {
            ((PDFAnnotationLine)this.pdfAnnot).setLineEnds(lineEnds);
        } else if (this.pdfAnnot instanceof PDFAnnotationPolyline) {
            ((PDFAnnotationPolyline)this.pdfAnnot).setLineEnds(lineEnds);
        }
    }

    public String getAttachIcon() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationFileAttachment) {
            this.attachIcon = ((PDFAnnotationFileAttachment)this.pdfAnnot).getIconName();
        }
        return this.attachIcon;
    }

    public void setAttachIcon(String attachIcon) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationFileAttachment) {
            ((PDFAnnotationFileAttachment)this.pdfAnnot).setIconName(attachIcon);
        }
    }

    public String getAuthor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            return ((PDFAnnotationMarkup)this.pdfAnnot).getTitle();
        }
        return null;
    }

    public void setAuthor(String author) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            ((PDFAnnotationMarkup)this.pdfAnnot).setTitle(author);
        }
    }

    public double getBorderEffectIntensity() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationWithBorderEffects && ((PDFAnnotationWithBorderEffects)((Object)this.pdfAnnot)).getBorderEffects() != null && ((PDFAnnotationWithBorderEffects)((Object)this.pdfAnnot)).getBorderEffects().hasIntensity()) {
            return ((PDFAnnotationWithBorderEffects)((Object)this.pdfAnnot)).getBorderEffects().getIntensity();
        }
        return 0.0;
    }

    public void setBorderEffectIntensity(Double borderEffectIntensity) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.pdfAnnot instanceof PDFAnnotationWithBorderEffects) {
            ((PDFAnnotationWithBorderEffects)((Object)this.pdfAnnot)).procureBorderEffects().setIntensity(String.valueOf(borderEffectIntensity));
        }
    }

    public String getBorderEffectStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (this.pdfAnnot instanceof PDFAnnotationWithBorderEffects && ((PDFAnnotationWithBorderEffects)((Object)this.pdfAnnot)).getBorderEffects() != null && ((PDFAnnotationWithBorderEffects)((Object)this.pdfAnnot)).getBorderEffects().hasStyle()) {
            return ((PDFAnnotationWithBorderEffects)((Object)this.pdfAnnot)).getBorderEffects().getStyle().asString();
        }
        return "S";
    }

    public void setBorderEffectStyle(String borderEffectStyle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.pdfAnnot instanceof PDFAnnotationWithBorderEffects) {
            ((PDFAnnotationWithBorderEffects)((Object)this.pdfAnnot)).procureBorderEffects().setStyle(ASName.create(borderEffectStyle));
        }
    }

    public double[] getCallout() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationFreeText) {
            return ((PDFAnnotationFreeText)this.pdfAnnot).getCalloutLine();
        }
        return null;
    }

    public void setCallout(Object value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IllegalAccessException, NoSuchFieldException {
        double[] arr1 = null;
        if (value instanceof NativeArray) {
            NativeArray arr = (NativeArray)value;
            arr1 = new double[Integer.valueOf((int)arr.getLength()).intValue()];
            Object[] fromJS = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, Context.getCurrentContext());
            for (int i = 0; i < fromJS.length; ++i) {
                arr1[i] = Double.parseDouble(fromJS[i].toString());
            }
        }
        if (this.pdfAnnot instanceof PDFAnnotationFreeText) {
            ((PDFAnnotationFreeText)this.pdfAnnot).setCalloutLine(arr1);
        }
    }

    public String getCaretSymbol() throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationCaret && ((PDFAnnotationCaret)this.pdfAnnot).hasSymbol()) {
            return ((PDFAnnotationCaret)this.pdfAnnot).getSymbol().asString();
        }
        return null;
    }

    public void setCaretSymbol(String caretSymbol) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationCaret) {
            ((PDFAnnotationCaret)this.pdfAnnot).setSymbol(ASName.create(caretSymbol));
        }
    }

    public String getContents() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfAnnot.getContents();
    }

    public void setContents(String contents) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.pdfAnnot.setContents(contents);
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            ((PDFAnnotationMarkup)this.pdfAnnot).setRichContents(PDFUtil.makeRichTextFromString(contents));
        }
    }

    public Date getCreationDate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            return ((PDFAnnotationMarkup)this.pdfAnnot).getCreationDate().toDate();
        }
        return null;
    }

    public Object getDash() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfAnnot.getBorderStyle().getDash();
    }

    public void setDash(Object value) throws IllegalAccessException, NoSuchFieldException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        ArrayList<Double> arr1 = new ArrayList<Double>();
        if (value instanceof NativeArray) {
            NativeArray arr = (NativeArray)value;
            Object[] fromJS = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, Context.getCurrentContext());
            for (int i = 0; i < fromJS.length; ++i) {
                arr1.add(Double.parseDouble(fromJS[i].toString()));
            }
        }
        PDFBorderStyle borderStyle = this.pdfAnnot.procureBorderStyle();
        borderStyle.setDash(arr1);
        this.pdfAnnot.setBorderStyle(borderStyle);
    }

    public boolean getDelay() {
        throw new UnsupportedJavaScriptFeatureException("Unsupported JavaScript feature");
    }

    public void setDelay(Boolean delay) {
        throw new UnsupportedJavaScriptFeatureException("Unsupported JavaScript feature");
    }

    public Doc getDoc() {
        Doc doc = new Doc();
        doc.setActiveDocument(this.pdfAnnot.getPDFDocument());
        return doc;
    }

    public boolean getDoCaption() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationLine) {
            return ((PDFAnnotationLine)this.pdfAnnot).getCaption();
        }
        return false;
    }

    public void setDoCaption(Boolean docCaption) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationLine) {
            ((PDFAnnotationLine)this.pdfAnnot).setCaption(docCaption);
        }
    }

    public Color getFillColor() throws PDFInvalidDocumentException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFIOException, PDFSecurityException, IllegalAccessException, NoSuchFieldException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            Color fillColor = new Color();
            fillColor.setValue("RG", ((PDFAnnotationMarkup)this.pdfAnnot).getColor());
        }
        return this.fillColor;
    }

    public void setFillColor(Object fillColor) throws IllegalAccessException, NoSuchFieldException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean isStrokeOp = false;
        Color bgColor = new Color();
        if (fillColor instanceof NativeArray) {
            NativeArray arr = (NativeArray)fillColor;
            Object[] fromJS = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, Context.getCurrentContext());
            bgColor.setValue(fromJS, isStrokeOp);
        } else {
            bgColor.setValue((Object[])fillColor, isStrokeOp);
        }
        if (this.pdfAnnot instanceof PDFAnnotationCircle) {
            ((PDFAnnotationCircle)this.pdfAnnot).setInteriorColor(bgColor.getColorValue()[0], bgColor.getColorValue()[1], bgColor.getColorValue()[2]);
        }
        if (this.pdfAnnot instanceof PDFAnnotationSquare) {
            ((PDFAnnotationSquare)this.pdfAnnot).setInteriorColor(bgColor.getColorValue()[0], bgColor.getColorValue()[1], bgColor.getColorValue()[2]);
        }
    }

    public Object getGestures() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationInk) {
            return ((PDFAnnotationInk)this.pdfAnnot).getInkList().toArray();
        }
        return null;
    }

    public void setGestures(Object gestures) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IllegalAccessException, NoSuchFieldException {
        int i;
        Object[] arr;
        ArrayList<Object> arr1 = new ArrayList<Object>();
        if (gestures instanceof NativeArray) {
            arr = (Object[])gestures;
            Object[] fromJS = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, Context.getCurrentContext());
            for (i = 0; i < fromJS.length; ++i) {
                arr1.add(Double.parseDouble(fromJS[i].toString()));
            }
        } else if (gestures instanceof Object[]) {
            arr = (Object[])((Object[])gestures)[0];
            for (int i2 = 0; i2 < arr.length; ++i2) {
                if (arr[i2] instanceof Object[]) {
                    Object[] arr2 = (Object[])arr[i2];
                    arr1.addAll(Arrays.asList(arr2));
                    continue;
                }
                arr1.add(arr[i2]);
            }
        }
        if (this.pdfAnnot instanceof PDFAnnotationInk) {
            PDFInkList inkList = PDFInkList.newInstance(this.pdfAnnot.getPDFDocument());
            ArrayList<Number> arr3 = new ArrayList<Number>();
            for (i = 0; i < arr1.size(); ++i) {
                arr3.add((Number)arr1.get(i));
            }
            inkList.addPath(arr3);
            ((PDFAnnotationInk)this.pdfAnnot).setInkList(inkList);
        }
    }

    public boolean getHidden() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfAnnot.isHidden();
    }

    public void setHidden(Boolean hidden) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfAnnot.setHidden(hidden);
    }

    public String getInReplyTo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            return ((PDFAnnotationMarkup)this.pdfAnnot).getInReplyTo().getName();
        }
        return null;
    }

    public void setInReplyTo(String inReplyTo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            PDFAnnotation refAnnot = XFDFService.findAnnotationByName(inReplyTo, this.pdfAnnot);
            if (refAnnot != null) {
                ((PDFAnnotationMarkup)this.pdfAnnot).setInReplyTo(refAnnot);
            } else {
                throw new PDFInvalidParameterException("Annotation with name " + inReplyTo + " does not exist in the PDf document");
            }
        }
    }

    public String getIntent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            return ((PDFAnnotationMarkup)this.pdfAnnot).getIntent();
        }
        return null;
    }

    public void setIntent(String intent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            ((PDFAnnotationMarkup)this.pdfAnnot).setIntent(intent);
        }
    }

    public double getLeaderExtend() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationLine) {
            return ((PDFAnnotationLine)this.pdfAnnot).getLeaderLineExtend();
        }
        return 0.0;
    }

    public void setLeaderExtend(Double leaderExtend) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationLine) {
            ((PDFAnnotationLine)this.pdfAnnot).setLeaderLineExtend(leaderExtend);
        }
    }

    public double getLeaderLength() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationLine) {
            return ((PDFAnnotationLine)this.pdfAnnot).getLeaderLength();
        }
        return 0.0;
    }

    public void setLeaderLength(Double leaderLength) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationLine) {
            ((PDFAnnotationLine)this.pdfAnnot).setLeaderLength(leaderLength);
        }
    }

    public String getLineEnding() throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationFreeText) {
            return ((PDFAnnotationFreeText)this.pdfAnnot).getLineEnds().asString();
        }
        return null;
    }

    public void setLineEnding(String lineEnding) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationLine.LineEnding[] lineEnds = new PDFAnnotationLine.LineEnding[]{PDFAnnotationLine.LineEnding.getInstance(lineEnding)};
        if (this.pdfAnnot instanceof PDFAnnotationFreeText) {
            ((PDFAnnotationFreeText)this.pdfAnnot).setLineEnds(lineEnds);
        }
    }

    public boolean getLock() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfAnnot.isReadOnly();
    }

    public void setLock(Boolean lock) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfAnnot.setReadOnly(lock);
    }

    public Date getModDate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            return ((PDFAnnotationMarkup)this.pdfAnnot).getModificationDate().toDate();
        }
        return null;
    }

    public void setModDate(Object modDate) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            ((PDFAnnotationMarkup)this.pdfAnnot).setModificationDate(modDate.toString());
        }
    }

    public String getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfAnnot.getName();
    }

    public void setName(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfAnnot.setName(name);
    }

    public String getNoteIcon() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationText) {
            return ((PDFAnnotationText)this.pdfAnnot).getIconName();
        }
        return null;
    }

    public void setNoteIcon(String noteIcon) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationText) {
            ((PDFAnnotationText)this.pdfAnnot).setIconName(noteIcon);
        }
    }

    public boolean getNoView() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfAnnot.isViewable();
    }

    public void setNoView(Boolean noView) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfAnnot.setViewable(noView);
    }

    public double getOpacity() throws NumberFormatException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup && ((PDFAnnotationMarkup)this.pdfAnnot).hasOpacity()) {
            return ((PDFAnnotationMarkup)this.pdfAnnot).getOpacity().doubleValue();
        }
        return 0.0;
    }

    public void setOpacity(Double opacity) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup && ((PDFAnnotationMarkup)this.pdfAnnot).hasOpacity()) {
            ((PDFAnnotationMarkup)this.pdfAnnot).setOpacity(opacity);
        }
    }

    public int getPage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot.getPage() != null) {
            return this.pdfAnnot.getPage().getIndex();
        }
        return -1;
    }

    public void setPage(Integer page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPage curPage = (PDFPage)this.pdfAnnot.getPDFDocument().requirePages().get(page);
        this.pdfAnnot.setPage(curPage);
    }

    public PDFAnnotation getPdfAnnot() {
        return this.pdfAnnot;
    }

    public void setPdfAnnot(PDFAnnotation pdfAnnot) {
        this.pdfAnnot = pdfAnnot;
    }

    public double[] getPoint() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] point = new double[]{0.0, 0.0};
        if (this.pdfAnnot instanceof PDFAnnotationWithIcon) {
            point[0] = ((PDFAnnotationMarkup)this.pdfAnnot).getRect().top();
            point[1] = ((PDFAnnotationMarkup)this.pdfAnnot).getRect().left();
        }
        return point;
    }

    public void setPoint(Object coords) throws IllegalAccessException, NoSuchFieldException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] arr1 = new double[2];
        if (coords instanceof NativeArray) {
            NativeArray arr = (NativeArray)coords;
            arr1 = new double[Integer.valueOf((int)arr.getLength()).intValue()];
            Object[] fromJS = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, Context.getCurrentContext());
            for (int i = 0; i < fromJS.length; ++i) {
                arr1[i] = Double.parseDouble(fromJS[i].toString());
            }
        } else if (coords instanceof NativeJavaArray) {
            coords = Context.jsToJava((Object)coords, NativeJavaArray.class);
            arr1 = new double[((NativeJavaArray)coords).getIds().length];
            for (int i = 0; i < ((NativeJavaArray)coords).getIds().length; ++i) {
                if (((NativeJavaArray)coords).get(i, (Scriptable)this) instanceof NativeJavaObject) {
                    arr1[i] = (Double)((NativeJavaObject)((NativeJavaArray)coords).get(i, (Scriptable)this)).unwrap();
                    continue;
                }
                if (!(((NativeJavaArray)coords).get(i, (Scriptable)this) instanceof Double)) continue;
                arr1[i] = (Double)((NativeJavaArray)coords).get(i, (Scriptable)this);
            }
        } else if (coords instanceof Double[]) {
            for (int i = 0; i < ((Double[])coords).length; ++i) {
                arr1[i] = Double.parseDouble(((Double[])coords)[i].toString());
            }
        } else if (coords instanceof Integer[]) {
            for (int i = 0; i < ((Integer[])coords).length; ++i) {
                arr1[i] = Double.parseDouble(((Integer[])coords)[i].toString());
            }
        } else if (coords instanceof Object[]) {
            int i;
            ArrayList<Double> objs = new ArrayList<Double>();
            for (i = 0; i < ((Object[])coords).length; ++i) {
                if (((Object[])coords)[i] instanceof Object[]) {
                    int j = 0;
                    for (j = 0; j < ((Object[])((Object[])coords)[i]).length; ++j) {
                        objs.add(Double.parseDouble(((Object[])((Object[])coords)[i])[j].toString()));
                    }
                    continue;
                }
                arr1[i] = Double.parseDouble(((Object[])coords)[i].toString());
            }
            if (!objs.isEmpty()) {
                arr1 = new double[4];
                for (i = 0; i < objs.size(); ++i) {
                    arr1[i] = (Double)objs.get(i);
                }
            }
        } else if (coords instanceof double[]) {
            for (int i = 0; i < ((double[])coords).length; ++i) {
                arr1[i] = ((double[])coords)[i];
            }
        }
        if (this.pdfAnnot instanceof PDFAnnotationSound || this.pdfAnnot instanceof PDFAnnotationText || this.pdfAnnot instanceof PDFAnnotationFileAttachment) {
            if (this.pdfAnnot.hasRect()) {
                this.pdfAnnot.setRect(arr1[0], arr1[0] + this.pdfAnnot.getRect().getRectangle().bottom(), arr1[0] + this.pdfAnnot.getRect().getRectangle().right() - this.pdfAnnot.getRect().getRectangle().left(), arr1[1]);
            } else {
                this.pdfAnnot.setRect(arr1[0], 0.0, 0.0, arr1[1]);
            }
        }
    }

    public double[] getPoints() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationLine) {
            return ((PDFAnnotationLine)this.pdfAnnot).getLineCoords();
        }
        return null;
    }

    public void setPoints(Object coords) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IllegalAccessException, NoSuchFieldException {
        double[] arr1 = new double[4];
        if (coords instanceof NativeArray) {
            NativeArray arr = (NativeArray)coords;
            arr1 = new double[Integer.valueOf((int)arr.getLength()).intValue()];
            Object[] fromJS = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, Context.getCurrentContext());
            for (int i = 0; i < fromJS.length; ++i) {
                arr1[i] = Double.parseDouble(fromJS[i].toString());
            }
        } else if (coords instanceof NativeJavaArray) {
            coords = Context.jsToJava((Object)coords, NativeJavaArray.class);
            arr1 = new double[((NativeJavaArray)coords).getIds().length];
            for (int i = 0; i < ((NativeJavaArray)coords).getIds().length; ++i) {
                if (((NativeJavaArray)coords).get(i, (Scriptable)this) instanceof NativeJavaObject) {
                    arr1[i] = (Double)((NativeJavaObject)((NativeJavaArray)coords).get(i, (Scriptable)this)).unwrap();
                    continue;
                }
                if (!(((NativeJavaArray)coords).get(i, (Scriptable)this) instanceof Double)) continue;
                arr1[i] = (Double)((NativeJavaArray)coords).get(i, (Scriptable)this);
            }
        } else if (coords instanceof Double[]) {
            for (int i = 0; i < ((Double[])coords).length; ++i) {
                arr1[i] = Double.parseDouble(((Double[])coords)[i].toString());
            }
        } else if (coords instanceof Integer[]) {
            for (int i = 0; i < ((Integer[])coords).length; ++i) {
                arr1[i] = Double.parseDouble(((Integer[])coords)[i].toString());
            }
        } else if (coords instanceof Object[]) {
            int i;
            ArrayList<Double> objs = new ArrayList<Double>();
            for (i = 0; i < ((Object[])coords).length; ++i) {
                if (((Object[])coords)[i] instanceof Object[]) {
                    int j = 0;
                    for (j = 0; j < ((Object[])((Object[])coords)[i]).length; ++j) {
                        objs.add(Double.parseDouble(((Object[])((Object[])coords)[i])[j].toString()));
                    }
                    continue;
                }
                arr1[i] = Double.parseDouble(((Object[])coords)[i].toString());
            }
            if (!objs.isEmpty()) {
                arr1 = new double[4];
                for (i = 0; i < objs.size(); ++i) {
                    arr1[i] = (Double)objs.get(i);
                }
            }
        } else if (coords instanceof double[]) {
            for (int i = 0; i < ((double[])coords).length; ++i) {
                arr1[i] = ((double[])coords)[i];
            }
        }
        if (this.pdfAnnot instanceof PDFAnnotationLine) {
            ((PDFAnnotationLine)this.pdfAnnot).setLineCoords(arr1[0], arr1[1], arr1[2], arr1[3]);
        }
    }

    public boolean getPopupOpen() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            return ((PDFAnnotationMarkup)this.pdfAnnot).getPopup().getOpenState();
        }
        return false;
    }

    public void setPopupOpen(Boolean popupOpen) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            ((PDFAnnotationMarkup)this.pdfAnnot).getPopup().setOpenState(popupOpen);
            ((PDFAnnotationMarkup)this.pdfAnnot).getPopup().setPrintable(true);
            ((PDFAnnotationMarkup)this.pdfAnnot).getPopup().setViewable(true);
        }
    }

    public double[] getPopupRect() throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        double[] arr = new double[4];
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            arr = ((PDFAnnotationMarkup)this.pdfAnnot).getPopup().getRect().getValues();
        }
        return arr;
    }

    public void setPopupRect(Object coords) throws IllegalAccessException, NoSuchFieldException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] arr1 = new double[4];
        if (coords instanceof NativeArray) {
            NativeArray arr = (NativeArray)coords;
            arr1 = new double[Integer.valueOf((int)arr.getLength()).intValue()];
            Object[] fromJS = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, Context.getCurrentContext());
            for (int i = 0; i < fromJS.length; ++i) {
                arr1[i] = Double.parseDouble(fromJS[i].toString());
            }
            arr1 = new double[]{arr1[0], arr1[3], arr1[2], arr1[1]};
        } else if (coords instanceof NativeJavaArray) {
            coords = Context.jsToJava((Object)coords, NativeJavaArray.class);
            arr1 = new double[((NativeJavaArray)coords).getIds().length];
            for (int i = 0; i < ((NativeJavaArray)coords).getIds().length; ++i) {
                if (((NativeJavaArray)coords).get(i, (Scriptable)this) instanceof NativeJavaObject) {
                    arr1[i] = (Double)((NativeJavaObject)((NativeJavaArray)coords).get(i, (Scriptable)this)).unwrap();
                    continue;
                }
                if (!(((NativeJavaArray)coords).get(i, (Scriptable)this) instanceof Double)) continue;
                arr1[i] = (Double)((NativeJavaArray)coords).get(i, (Scriptable)this);
            }
        } else if (coords instanceof Double[]) {
            for (int i = 0; i < ((Double[])coords).length; ++i) {
                arr1[i] = Double.parseDouble(((Double[])coords)[i].toString());
            }
            arr1 = new double[]{arr1[0], arr1[3], arr1[2], arr1[1]};
        } else if (coords instanceof Integer[]) {
            for (int i = 0; i < ((Integer[])coords).length; ++i) {
                arr1[i] = Double.parseDouble(((Integer[])coords)[i].toString());
            }
            arr1 = new double[]{arr1[0], arr1[3], arr1[2], arr1[1]};
        } else if (coords instanceof Object[]) {
            for (int i = 0; i < ((Object[])coords).length; ++i) {
                arr1[i] = Double.parseDouble(((Object[])coords)[i].toString());
            }
            arr1 = new double[]{arr1[0], arr1[3], arr1[2], arr1[1]};
        } else if (coords instanceof double[]) {
            for (int i = 0; i < ((double[])coords).length; ++i) {
                arr1[i] = ((double[])coords)[i];
            }
            arr1 = new double[]{arr1[0], arr1[3], arr1[2], arr1[1]};
        }
        PDFRectangle annotRect2 = PDFRectangle.newInstance(this.pdfAnnot.getPDFDocument(), arr1[0], arr1[3], arr1[2], arr1[1]);
        PDFAnnotationPopup popup = PDFAnnotationPopup.newInstance(this.pdfAnnot.getPDFDocument());
        popup.setParent(this.pdfAnnot);
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            ((PDFAnnotationMarkup)this.pdfAnnot).setPopup(popup);
        }
        popup.setRect(annotRect2);
        popup.setOpenState(false);
        popup.setPrintable(true);
        popup.setViewable(true);
        PDFPage page = (PDFPage)this.pdfAnnot.getPDFDocument().requirePages().get(this.getPage());
        page.getAnnotationList().add(popup);
    }

    public boolean getPrint() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfAnnot.isPrintable();
    }

    public void setPrint(Boolean print) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfAnnot.setPrintable(print);
    }

    public double[] getQuads() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationWithQuadPoints) {
            return ((PDFAnnotationWithQuadPoints)((Object)this.pdfAnnot)).getQuadPoints();
        }
        return new double[8];
    }

    public void setQuads(Object coords) throws IllegalAccessException, NoSuchFieldException, PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        double[] arr1 = new double[8];
        if (coords instanceof NativeArray) {
            NativeArray arr = (NativeArray)coords;
            arr1 = new double[Integer.valueOf((int)arr.getLength()).intValue()];
            Object[] fromJS = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, Context.getCurrentContext());
            for (int i = 0; i < fromJS.length; ++i) {
                arr1[i] = Double.parseDouble(fromJS[i].toString());
            }
        } else if (coords instanceof NativeJavaArray) {
            coords = Context.jsToJava((Object)coords, NativeJavaArray.class);
            arr1 = new double[((NativeJavaArray)coords).getIds().length];
            for (int i = 0; i < ((NativeJavaArray)coords).getIds().length; ++i) {
                if (((NativeJavaArray)coords).get(i, (Scriptable)this) instanceof NativeJavaObject) {
                    arr1[i] = (Double)((NativeJavaObject)((NativeJavaArray)coords).get(i, (Scriptable)this)).unwrap();
                    continue;
                }
                if (!(((NativeJavaArray)coords).get(i, (Scriptable)this) instanceof Double)) continue;
                arr1[i] = (Double)((NativeJavaArray)coords).get(i, (Scriptable)this);
            }
        } else if (coords instanceof Double[]) {
            for (int i = 0; i < ((Double[])coords).length; ++i) {
                arr1[i] = Double.parseDouble(((Double[])coords)[i].toString());
            }
        } else if (coords instanceof Integer[]) {
            for (int i = 0; i < ((Integer[])coords).length; ++i) {
                arr1[i] = Double.parseDouble(((Integer[])coords)[i].toString());
            }
        } else if (coords instanceof Object[]) {
            int i;
            ArrayList<Double> objs = new ArrayList<Double>();
            for (i = 0; i < ((Object[])coords).length; ++i) {
                if (((Object[])coords)[i] instanceof Object[]) {
                    int j = 0;
                    for (j = 0; j < ((Object[])((Object[])coords)[i]).length; ++j) {
                        objs.add(Double.parseDouble(((Object[])((Object[])coords)[i])[j].toString()));
                    }
                    for (int k = j; k < 8; ++k) {
                        objs.add(0.0);
                    }
                    continue;
                }
                arr1[i] = Double.parseDouble(((Object[])coords)[i].toString());
            }
            if (!objs.isEmpty()) {
                arr1 = new double[32];
                for (i = 0; i < objs.size(); ++i) {
                    arr1[i] = (Double)objs.get(i);
                }
            }
        } else if (coords instanceof double[]) {
            for (int i = 0; i < ((double[])coords).length; ++i) {
                arr1[i] = ((double[])coords)[i];
            }
        }
        if (this.pdfAnnot instanceof PDFAnnotationWithQuadPoints) {
            ((PDFAnnotationWithQuadPoints)((Object)this.pdfAnnot)).setQuadPoints(arr1);
        }
    }

    public boolean getReadOnly() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfAnnot.isReadOnly();
    }

    public void setReadOnly(Boolean readOnly) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfAnnot.setReadOnly(readOnly);
    }

    public double[] getRect() throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        this.getPdfAnnot().getRect().getValues();
        return this.rect;
    }

    public void setRect(Object coords) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IllegalAccessException, NoSuchFieldException {
        double[] arr1 = new double[4];
        if (coords instanceof NativeArray) {
            NativeArray arr = (NativeArray)coords;
            arr1 = new double[Integer.valueOf((int)arr.getLength()).intValue()];
            Object[] fromJS = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, Context.getCurrentContext());
            for (int i = 0; i < fromJS.length; ++i) {
                arr1[i] = Double.parseDouble(fromJS[i].toString());
            }
            arr1 = new double[]{arr1[0], arr1[3], arr1[2], arr1[1]};
        } else if (coords instanceof NativeJavaArray) {
            coords = Context.jsToJava((Object)coords, NativeJavaArray.class);
            arr1 = new double[((NativeJavaArray)coords).getIds().length];
            for (int i = 0; i < ((NativeJavaArray)coords).getIds().length; ++i) {
                if (((NativeJavaArray)coords).get(i, (Scriptable)this) instanceof NativeJavaObject) {
                    arr1[i] = (Double)((NativeJavaObject)((NativeJavaArray)coords).get(i, (Scriptable)this)).unwrap();
                    continue;
                }
                if (!(((NativeJavaArray)coords).get(i, (Scriptable)this) instanceof Double)) continue;
                arr1[i] = (Double)((NativeJavaArray)coords).get(i, (Scriptable)this);
            }
        } else if (coords instanceof Double[]) {
            for (int i = 0; i < ((Double[])coords).length; ++i) {
                arr1[i] = Double.parseDouble(((Double[])coords)[i].toString());
            }
            arr1 = new double[]{arr1[0], arr1[3], arr1[2], arr1[1]};
        } else if (coords instanceof Integer[]) {
            for (int i = 0; i < ((Integer[])coords).length; ++i) {
                arr1[i] = Double.parseDouble(((Integer[])coords)[i].toString());
            }
            arr1 = new double[]{arr1[0], arr1[3], arr1[2], arr1[1]};
        } else if (coords instanceof Object[]) {
            for (int i = 0; i < ((Object[])coords).length; ++i) {
                arr1[i] = Double.parseDouble(((Object[])coords)[i].toString());
            }
            arr1 = new double[]{arr1[0], arr1[3], arr1[2], arr1[1]};
        } else if (coords instanceof double[]) {
            for (int i = 0; i < ((double[])coords).length; ++i) {
                arr1[i] = ((double[])coords)[i];
            }
            arr1 = new double[]{arr1[0], arr1[3], arr1[2], arr1[1]};
        }
        PDFRectangle annotRect2 = PDFRectangle.newInstance(this.pdfAnnot.getPDFDocument(), arr1[0], arr1[3], arr1[2], arr1[1]);
        this.pdfAnnot.setRect(annotRect2);
    }

    public String getRefType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            return ((PDFAnnotationMarkup)this.pdfAnnot).getReplyType();
        }
        return null;
    }

    public void setRefType(String refType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            ((PDFAnnotationMarkup)this.pdfAnnot).setReplyType(refType);
        }
    }

    public Object getRichContents() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            return ((PDFAnnotationMarkup)this.pdfAnnot).getRichContents();
        }
        return null;
    }

    public void setRichContents(Object richContents) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            ((PDFAnnotationMarkup)this.pdfAnnot).setRichContents(richContents.toString());
        }
    }

    public Object getRichDefaults() {
        throw new UnsupportedJavaScriptFeatureException(" Unsupported JavaScript feature # getrichDefaults()");
    }

    public void setRichDefaults(Object richDefaults) {
        throw new UnsupportedJavaScriptFeatureException(" Unsupported JavaScript feature # setRichDefaults()");
    }

    public int getRotate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationFreeText) {
            return ((PDFAnnotationFreeText)this.pdfAnnot).getRotation();
        }
        if (this.pdfAnnot instanceof PDFAnnotationCaret) {
            return ((PDFAnnotationCaret)this.pdfAnnot).getRotation();
        }
        if (this.pdfAnnot instanceof PDFAnnotationMovie) {
            return ((PDFAnnotationMovie)this.pdfAnnot).getRotation();
        }
        if (this.pdfAnnot instanceof PDFAnnotationScreen) {
            return ((PDFAnnotationScreen)this.pdfAnnot).getRotation();
        }
        return 0;
    }

    public void setRotate(Integer rotation) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationFreeText) {
            ((PDFAnnotationFreeText)this.pdfAnnot).setRotation(rotation);
        }
        if (this.pdfAnnot instanceof PDFAnnotationCaret) {
            ((PDFAnnotationCaret)this.pdfAnnot).setRotation(rotation);
        }
        if (this.pdfAnnot instanceof PDFAnnotationMovie) {
            ((PDFAnnotationMovie)this.pdfAnnot).setRotation(rotation);
        }
        if (this.pdfAnnot instanceof PDFAnnotationScreen) {
            ((PDFAnnotationScreen)this.pdfAnnot).setRotation(rotation);
        }
    }

    public int getSeqNum() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfAnnot.getSeqNum();
    }

    public String getSoundIcon() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationSound) {
            return ((PDFAnnotationSound)this.pdfAnnot).getIconName();
        }
        return null;
    }

    public void setSoundIcon(String soundIcon) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationSound) {
            ((PDFAnnotationSound)this.pdfAnnot).setIconName(soundIcon);
        }
    }

    public String getState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationText) {
            return ((PDFAnnotationText)this.pdfAnnot).getState();
        }
        return null;
    }

    public void setState(String state) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationText) {
            ((PDFAnnotationText)this.pdfAnnot).setState(state);
        }
    }

    public String getStateModel() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationText) {
            return ((PDFAnnotationText)this.pdfAnnot).getStateModel();
        }
        return null;
    }

    public void setStateModel(String stateModel) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationText) {
            ((PDFAnnotationText)this.pdfAnnot).setStateModel(stateModel);
        }
    }

    public Color getStrokeColor() throws PDFInvalidDocumentException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFIOException, PDFSecurityException, IllegalAccessException, NoSuchFieldException {
        if (this.pdfAnnot instanceof PDFAnnotationMarkup) {
            Color fillColor = new Color();
            fillColor.setValue("RG", ((PDFAnnotationMarkup)this.pdfAnnot).getColor());
        }
        return this.fillColor;
    }

    public void setStrokeColor(Object strokeColor) throws IllegalAccessException, NoSuchFieldException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean isStrokeOp = false;
        Color bgColor = new Color();
        if (strokeColor instanceof NativeArray) {
            NativeArray arr = (NativeArray)strokeColor;
            Object[] fromJS = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, Context.getCurrentContext());
            bgColor.setValue(fromJS, isStrokeOp);
        } else {
            bgColor.setValue((Object[])strokeColor, isStrokeOp);
        }
        if (this.pdfAnnot instanceof PDFAnnotationWidget) {
            ((PDFAnnotationWidget)this.pdfAnnot).procureAppearanceCharacteristics().setBorderColor(bgColor.getColorValue());
        } else if (this.pdfAnnot instanceof PDFAnnotationFreeText) {
            PDFDefaultAppearance dap = ((PDFAnnotationFreeText)this.pdfAnnot).getDefaultFreeTextAppearance();
            if (dap != null) {
                try {
                    PDFDefaultAppearanceWrapper defAp = new PDFDefaultAppearanceWrapper(dap);
                    PDFDefaultAppearance newDefAp = defAp.setFontColor(bgColor.getColorSpace(), bgColor.getColorValue());
                    ((PDFAnnotationFreeText)this.pdfAnnot).setDefaultAppearance(newDefAp);
                }
                catch (PDFUnableToCompleteOperationException e) {
                    throw new PDFInvalidDocumentException("Cannot instantiate default appearance.", e);
                }
            }
        } else {
            this.pdfAnnot.setColor(bgColor.getColorValue());
        }
    }

    public String getStyle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBorderStyle.Style style;
        PDFBorderStyle bStyle = this.pdfAnnot.getBorderStyle();
        if (bStyle != null && (style = bStyle.getStyle()) != null) {
            return style.toString();
        }
        return "";
    }

    public void setStyle(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFBorderStyle style;
        if (value.equalsIgnoreCase("beveled") || value.equalsIgnoreCase("b")) {
            style = this.pdfAnnot.procureBorderStyle();
            this.pdfAnnot.setBorderStyle(style);
            style.setStyle(PDFBorderStyle.Style.Beveled);
        }
        if (value.equalsIgnoreCase("solid") || value.equalsIgnoreCase("s")) {
            style = this.pdfAnnot.procureBorderStyle();
            this.pdfAnnot.setBorderStyle(style);
            style.setStyle(PDFBorderStyle.Style.Solid);
        }
        if (value.equalsIgnoreCase("inset") || value.equalsIgnoreCase("i")) {
            style = this.pdfAnnot.procureBorderStyle();
            this.pdfAnnot.setBorderStyle(style);
            style.setStyle(PDFBorderStyle.Style.Inset);
        }
        if (value.equalsIgnoreCase("underline") || value.equalsIgnoreCase("u")) {
            style = this.pdfAnnot.procureBorderStyle();
            this.pdfAnnot.setBorderStyle(style);
            style.setStyle(PDFBorderStyle.Style.Underline);
        }
        if (value.equalsIgnoreCase("dashed") || value.equalsIgnoreCase("d")) {
            style = this.pdfAnnot.procureBorderStyle();
            this.pdfAnnot.setBorderStyle(style);
            style.setStyle(PDFBorderStyle.Style.Dashed);
        }
    }

    public String getSubject() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfAnnot.getContents();
    }

    public void setSubject(String subject) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.pdfAnnot.setContents(subject);
    }

    public String getTextFont() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDefaultAppearance dap;
        if (this.pdfAnnot instanceof PDFAnnotationFreeText && (dap = ((PDFAnnotationFreeText)this.pdfAnnot).getDefaultFreeTextAppearance()) != null) {
            try {
                PDFDefaultAppearanceWrapper dapImpl = new PDFDefaultAppearanceWrapper(dap);
                return dapImpl.getBaseFontName();
            }
            catch (PDFUnableToCompleteOperationException e) {
                throw new PDFInvalidDocumentException("Cannot instantiate default appearance.", e);
            }
        }
        return this.textFont;
    }

    public void setTextFont(String textFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDefaultAppearance dap;
        if (this.pdfAnnot instanceof PDFAnnotationFreeText && (dap = ((PDFAnnotationFreeText)this.pdfAnnot).getDefaultFreeTextAppearance()) != null) {
            try {
                PDFDefaultAppearanceWrapper defAp = new PDFDefaultAppearanceWrapper(dap);
                PDFDefaultAppearance newDefAp = defAp.setBaseFontName(textFont);
                ((PDFAnnotationFreeText)this.pdfAnnot).setDefaultAppearance(newDefAp);
            }
            catch (PDFUnableToCompleteOperationException e) {
                throw new PDFInvalidDocumentException("Cannot instantiate default appearance.", e);
            }
        }
    }

    public void setTextColor(Object value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IllegalAccessException, NoSuchFieldException {
        boolean isStrokeOp = false;
        Color textColor = new Color();
        if (value instanceof NativeArray) {
            PDFDefaultAppearance dap;
            NativeArray arr = (NativeArray)value;
            Object[] fromJS = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, Context.getCurrentContext());
            textColor.setValue(fromJS, isStrokeOp);
            if (this.pdfAnnot instanceof PDFAnnotationFreeText && (dap = ((PDFAnnotationFreeText)this.pdfAnnot).getDefaultFreeTextAppearance()) != null) {
                try {
                    PDFDefaultAppearanceWrapper defAp = new PDFDefaultAppearanceWrapper(dap);
                    PDFDefaultAppearance newDefAp = defAp.setFontColor(textColor.getColorSpace(), textColor.getColorValue());
                    ((PDFAnnotationFreeText)this.pdfAnnot).setDefaultAppearance(newDefAp);
                }
                catch (PDFUnableToCompleteOperationException e) {
                    throw new PDFInvalidDocumentException("Cannot instantiate default appearance.", e);
                }
            }
        }
    }

    public double getTextSize() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDefaultAppearance dap;
        if (this.pdfAnnot instanceof PDFAnnotationFreeText && (dap = ((PDFAnnotationFreeText)this.pdfAnnot).getDefaultFreeTextAppearance()) != null) {
            try {
                PDFDefaultAppearanceWrapper dapImpl = new PDFDefaultAppearanceWrapper(dap);
                return dapImpl.getFontSize();
            }
            catch (PDFUnableToCompleteOperationException e) {
                throw new PDFInvalidDocumentException("Cannot instantiate default appearance.", e);
            }
        }
        return this.textSize;
    }

    public void setTextSize(Double textSize) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDefaultAppearance dap;
        if (this.pdfAnnot instanceof PDFAnnotationFreeText && (dap = ((PDFAnnotationFreeText)this.pdfAnnot).getDefaultFreeTextAppearance()) != null) {
            try {
                PDFDefaultAppearanceWrapper defAp = new PDFDefaultAppearanceWrapper(dap);
                PDFDefaultAppearance newDefAp = defAp.setFontSize(textSize);
                ((PDFAnnotationFreeText)this.pdfAnnot).setDefaultAppearance(newDefAp);
            }
            catch (PDFUnableToCompleteOperationException e) {
                throw new PDFInvalidDocumentException("Cannot instantiate default appearance.", e);
            }
        }
    }

    public boolean istoggleNoView() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfAnnot.isInvisible();
    }

    public void setToggleNoView(Boolean toggleNoView) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfAnnot.setInvisible(toggleNoView);
    }

    public String getType() throws PDFUnableToCompleteOperationException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfAnnot.getSubtype().asString();
    }

    public Object getVertices() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot instanceof PDFAnnotationPolyline) {
            return ((PDFAnnotationPolyline)this.pdfAnnot).getVertices();
        }
        if (this.pdfAnnot instanceof PDFAnnotationPolygon) {
            return ((PDFAnnotationPolygon)this.pdfAnnot).getVertices();
        }
        return this.vertices;
    }

    public void setVertices(Object coords) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<Double> objs = new ArrayList<Double>();
        if (coords instanceof Object[]) {
            for (int i = 0; i < ((Object[])coords).length; ++i) {
                if (!(((Object[])coords)[i] instanceof Object[])) continue;
                int j = 0;
                for (j = 0; j < ((Object[])((Object[])coords)[i]).length; ++j) {
                    objs.add(Double.parseDouble(((Object[])((Object[])coords)[i])[j].toString()));
                }
            }
        }
        if (this.pdfAnnot instanceof PDFAnnotationPolyline) {
            ((PDFAnnotationPolyline)this.pdfAnnot).setVertices(PDFVertices.newInstance(this.pdfAnnot.getPDFDocument(), objs));
        } else if (this.pdfAnnot instanceof PDFAnnotationPolygon) {
            ((PDFAnnotationPolygon)this.pdfAnnot).setVertices(PDFVertices.newInstance(this.pdfAnnot.getPDFDocument(), objs));
        }
    }

    public double getWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot.hasBorder()) {
            return this.pdfAnnot.getBorder().getWidth();
        }
        return 0.0;
    }

    public void setWidth(Double width) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfAnnot.hasBorder()) {
            this.pdfAnnot.getBorder().setWidth(width);
        } else {
            PDFBorder border = this.pdfAnnot.procureBorder();
            this.pdfAnnot.setBorder(border);
            border.setWidth(width);
        }
    }

    public void destroy() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationList annots = this.pdfAnnot.getPage().getAnnotationList();
        if (annots != null) {
            annots.remove(this.pdfAnnot);
        }
    }

    public void getProps() {
        throw new UnsupportedJavaScriptFeatureException(" Annotation.getProps() is not supported");
    }

    public void setProps(Object arg2) throws IllegalAccessException, NoSuchFieldException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        Double page;
        HashMap annotDetails = new HashMap();
        ScriptableObject fromJS = (ScriptableObject)Context.jsToJava((Object)arg2, Object.class);
        if (arg2 instanceof NativeArray) {
            NativeArray arr = (NativeArray)arg2;
            Object[] fromJS1 = (Object[])JSUtils.scriptableToJava((ScriptableObject)arr, Context.getCurrentContext());
            for (int j = 0; j < fromJS1.length; ++j) {
                Object[] valArr = (Object[])fromJS1[j];
                annotDetails.put(valArr[0], valArr[1]);
            }
        } else {
            annotDetails = (HashMap)JSUtils.scriptableToJava(fromJS, Context.getCurrentContext());
        }
        HashMap annotDef = new PDFAnnotationDefaults().constructAnnotationDefaults();
        if (this.pdfAnnot instanceof PDFAnnotationWithQuadPoints) {
            annotDef = new PDFAnnotationDefaults().addQuadPointsToDefaults(annotDef);
        }
        annotDef.putAll(annotDetails);
        annotDetails = annotDef;
        if (annotDetails.containsKey("page")) {
            Object[] c1;
            int page2 = new Double(annotDetails.get("page").toString()).intValue();
            this.setPage(page2);
            for (Map.Entry entry : annotDetails.entrySet()) {
                String methodName = (String)entry.getKey();
                Object args = entry.getValue();
                if (args.toString().startsWith("\"") && args.toString().endsWith("\"")) {
                    args = args.toString().substring(1, this.type.length() - 1);
                }
                Annotation.putProperty((Scriptable)this, (String)methodName, args);
            }
            if (!annotDetails.containsKey("popupRect") && !(this.pdfAnnot instanceof PDFAnnotationFreeText) && this.pdfAnnot instanceof PDFAnnotationMarkup) {
                if (annotDetails.containsKey("rect")) {
                    Object rect = annotDetails.get("rect");
                    Annotation.putProperty((Scriptable)this, (String)"popupRect", rect);
                } else {
                    c1 = new Object[]{new Double(0.0), new Double(0.0), new Double(100.0), new Double(100.0)};
                    Annotation.putProperty((Scriptable)this, (String)"popupRect", (Object)c1);
                }
            }
            if (!annotDetails.containsKey("strokeColor")) {
                c1 = new Object[]{"RGB", new Double(1.0), new Double(1.0), new Double(1.0)};
                this.setStrokeColor(c1);
            }
        }
        if ((page = (Double)annotDetails.get("page")) != null) {
            PDFPage curPage = (PDFPage)this.pdfAnnot.getPDFDocument().requirePages().get(page.intValue());
            if (!curPage.getAnnotationList().contains(this.getPdfAnnot())) {
                curPage.getAnnotationList().add(this.getPdfAnnot());
            }
        } else {
            PDFPage curPage = (PDFPage)this.pdfAnnot.getPDFDocument().requirePages().get(this.getPage());
            if (curPage != null && !curPage.getAnnotationList().contains(this.getPdfAnnot())) {
                curPage.getAnnotationList().add(this.getPdfAnnot());
            }
        }
    }
}

