/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.interchange.structure;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCProperty;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureIDTree;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.interchange.structure.StructureListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class StructureUtil {
    private static final char PERIOD = '.';

    public static int getMaximumMCID(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        int maxMCID = 0;
        HashSet<Integer> seenObjects = new HashSet<Integer>();
        Iterator<PDFPage> pageIter = pdfDoc.requirePages().iterator();
        while (pageIter.hasNext()) {
            PDFPage curPage = pageIter.next();
            maxMCID = Math.max(StructureUtil.getMaximumMCID(curPage, seenObjects), maxMCID);
        }
        return maxMCID;
    }

    public static int getMaximumMCID(PDFPage page, HashSet<Integer> seenObjects) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        int pageObjectNumber = page.getCosObject().getObjNum();
        StructureListener maxMCIDCache = StructureListener.getInstance(page.getPDFDocument());
        int maxMCID = maxMCIDCache.getCachedMaxMCID(pageObjectNumber);
        if (maxMCID != 0) {
            return maxMCID;
        }
        if (seenObjects.contains(pageObjectNumber)) {
            return 0;
        }
        seenObjects.add(pageObjectNumber);
        maxMCID = 0;
        Content pageContent = Content.newInstance(page);
        maxMCID = Math.max(StructureUtil.getMaximumMCID(pageContent, seenObjects), maxMCID);
        maxMCIDCache.cacheMaxMCID(pageObjectNumber, maxMCID);
        return maxMCID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getMaximumMCID(Content content, HashSet<Integer> seenObjects) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        int maxMCID = 0;
        if (content == null) {
            return 0;
        }
        if (content.getContents() == null) {
            return 0;
        }
        if (seenObjects.contains(content.getContents().getCosObject().getObjNum())) {
            return 0;
        }
        seenObjects.add(content.getContents().getCosObject().getObjNum());
        HashSet<ASName> ops = new HashSet<ASName>();
        ops.add(ASName.k_BDC);
        ContentReader readContent = null;
        try {
            readContent = ContentReader.newInstance(content, ops);
            while (readContent.hasNext()) {
                Instruction command = readContent.next();
                ASName operator = command.getOperator();
                if (operator != ASName.k_BDC) continue;
                OperandStack operands = command.getOperands();
                Map<ASName, ASObject> properties = null;
                if (operands.peekTypeIsName()) {
                    PDFMCProperty prop = content.getResources().getMCProperty(operands.peekName());
                    if (prop != null) {
                        properties = (Map)prop.getCosDictionary().getValue();
                    }
                } else {
                    properties = operands.peekDictionary();
                }
                if (properties == null || !properties.containsKey(ASName.k_MCID)) continue;
                Object dictMCID = properties.get(ASName.k_MCID);
                if (operands.peekTypeIsName()) {
                    maxMCID = Math.max(((Number)dictMCID).intValue(), maxMCID);
                    continue;
                }
                maxMCID = Math.max(((ASNumber)dictMCID).intValue(), maxMCID);
            }
        }
        finally {
            if (readContent != null) {
                try {
                    readContent.close();
                }
                catch (IOException e) {}
            }
        }
        PDFResources contentResources = content.getResources();
        return Math.max(StructureUtil.getMaximumMCID(contentResources, seenObjects), maxMCID);
    }

    private static int getMaximumMCID(PDFResources resources, HashSet<Integer> seenObjects) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        int maxMCID = 0;
        if (resources == null) {
            return 0;
        }
        if (seenObjects.contains(resources.getCosObject().getObjNum())) {
            return 0;
        }
        seenObjects.add(resources.getCosObject().getObjNum());
        PDFXObjectMap xObjects = resources.getXObjectMap();
        if (xObjects != null) {
            for (ASName key : xObjects.keySet()) {
                PDFXObject curXObject = xObjects.get(key);
                if (!(curXObject instanceof PDFXObjectForm)) continue;
                Content xObjectContent = Content.newInstance((PDFXObjectForm)curXObject);
                maxMCID = Math.max(maxMCID, StructureUtil.getMaximumMCID(xObjectContent, seenObjects));
            }
        }
        return maxMCID;
    }

    private static ASString calculateSuffixFromStructureTree(Iterator<PDFTree.Entry> treeIter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int suffix = -1;
        if (treeIter == null) {
            return null;
        }
        while (treeIter.hasNext()) {
            PDFTree.Entry entry = treeIter.next();
            ASString srcName = (ASString)entry.getKey();
            int periodPos = srcName.lastIndexOf(46);
            if (periodPos < 0) continue;
            try {
                byte[] bytes;
                String suffixStr;
                int suffixNum;
                ASString suffixBytes = srcName.substring(periodPos + 1);
                if (suffixBytes == null || (suffixNum = Integer.parseInt(suffixStr = new String(bytes = suffixBytes.getBytes(), 0, bytes.length, "UTF-8"))) < 0) continue;
                suffix = Math.max(suffix, suffixNum);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-8 encoding not supported.", e);
            }
            catch (Exception exp) {
            }
        }
        StringBuilder suffixBuf = new StringBuilder();
        suffixBuf.append('.');
        suffixBuf.append(Integer.toString(++suffix));
        return new ASString(suffixBuf.toString());
    }

    public static ASString checkID(ASString key, ASString suffix, PDFStructureIDTree idTree) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!idTree.isEmpty() && idTree.getEntry(key) != null) {
            if (suffix == null) {
                Iterator<PDFTree.Entry> suffixIter = idTree.iterator();
                suffix = StructureUtil.calculateSuffixFromStructureTree(suffixIter);
            }
            key = key.concat(suffix);
        }
        return key;
    }

    public static void updateMCID(Content content, ModifiableContent newContent, int addMCID) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ContentReader readContent = ContentReader.newInstance(content);
        ContentWriter writeContent = ContentWriter.newInstance(newContent);
        while (readContent.hasNext()) {
            Instruction command = readContent.next();
            ASName operator = command.getOperator();
            if (operator == ASName.k_BDC) {
                Object properties;
                OperandStack operands = command.getOperands();
                ASName propertyName = null;
                if (operands.peekTypeIsName()) {
                    propertyName = operands.peekName();
                    properties = content.getResources().getMCProperty(propertyName).getCosDictionary();
                    CosNumeric cosMCID = (CosNumeric)((CosDictionary)properties).get(ASName.k_MCID);
                    if (cosMCID != null) {
                        ((CosDictionary)properties).put(ASName.k_MCID, cosMCID.intValue() + addMCID);
                    }
                } else {
                    properties = operands.peekDictionary();
                    ASNumber mcid = (ASNumber)((ASDictionary)properties).get(ASName.k_MCID);
                    if (mcid != null) {
                        ((ASDictionary)properties).put(ASName.k_MCID, new ASNumber(mcid.intValue() + addMCID));
                    }
                }
            }
            writeContent.write(command);
        }
        writeContent.close();
    }
}

