/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.interchange.structure;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListener;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerProperties;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentMessage;
import java.util.HashMap;

public class StructureListener
implements DocumentListener {
    private static HashMap<Integer, Integer> maxMCIDMap = new HashMap();

    private StructureListener() {
    }

    public static StructureListener getInstance(PDFDocument document) {
        DocumentListener existingListener = document.getListenerRegistry().getListener(StructureListener.class);
        if (existingListener == null) {
            StructureListener mcidCacheDocumentListner = new StructureListener();
            document.getListenerRegistry().registerListener(StructureListener.class, mcidCacheDocumentListner);
            return mcidCacheDocumentListner;
        }
        return (StructureListener)existingListener;
    }

    public int getCachedMaxMCID(int pageObjectNumber) {
        Integer maxMCID = maxMCIDMap.get(pageObjectNumber);
        return maxMCID != null ? maxMCID : 0;
    }

    public void cacheMaxMCID(int pageObjectNumber, int maxMCID) {
        maxMCIDMap.put(pageObjectNumber, maxMCID);
    }

    public void removeCacheMaxMCID(int objectNumber) {
        maxMCIDMap.remove(objectNumber);
    }

    @Override
    public DocumentListenerProperties getProperties() {
        return null;
    }

    @Override
    public void message(DocumentMessage message) throws PDFUnableToCompleteOperationException {
        if (message.getMessageType() == DocumentMessage.SAVE || message.getMessageType() == DocumentMessage.CLOSE || message.getMessageType() == DocumentMessage.FINISH || message.getMessageType() == DocumentMessage.FLUSH_FONTS) {
            maxMCIDMap.clear();
        }
    }
}

