/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fontresources.subsetting;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.internal.io.ByteBufferByteReader;
import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.StreamManager;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDFontWidths;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFCIDVerticalMetrics;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFType0FontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.services.fontresources.FontResources;
import com.adobe.internal.pdftoolkit.services.fontresources.subsetting.CharCodeToCidMapper;
import com.adobe.internal.pdftoolkit.services.fontresources.subsetting.FontSubsetter;
import com.adobe.internal.pdftoolkit.services.fontresources.subsetting.SubsetUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class Type0FontSubsetter
extends FontSubsetter {
    private Map<PDFCIDFont, CIDFontInfo> cidFontInfoMap = new LinkedHashMap<PDFCIDFont, CIDFontInfo>();

    public Type0FontSubsetter(PDFDocument pdfDoc, Map<PDFFont, TreeMap<Integer, Integer>> fontToCharCodesMap) {
        super(pdfDoc, fontToCharCodesMap);
    }

    @Override
    protected void populateFontInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        PDFCIDFont currentCIDFont;
        for (Map.Entry currEntry : this.fontToCharCodesMap.entrySet()) {
            PDFFontType0 currentType0Font = (PDFFontType0)currEntry.getKey();
            currentCIDFont = currentType0Font.getDescendantFont();
            CIDFontInfo cidFontInfo = this.cidFontInfoMap.get(currentCIDFont);
            if (cidFontInfo == null) {
                cidFontInfo = new CIDFontInfo();
                this.cidFontInfoMap.put(currentCIDFont, cidFontInfo);
            }
            cidFontInfo.getPdfType0FontSet().add(currentType0Font);
            Iterator charCodesIter = ((TreeMap)currEntry.getValue()).keySet().iterator();
            while (charCodesIter.hasNext()) {
                int charCode = (Integer)charCodesIter.next();
                cidFontInfo.getCidToGidMap().put(currentType0Font.getEncoding().getCID(charCode), currentType0Font.charCode2gid(charCode));
            }
        }
        for (Map.Entry<PDFCIDFont, CIDFontInfo> cidFontInfoEntry : this.cidFontInfoMap.entrySet()) {
            Type0FontInfo currentFontFileInfo;
            currentCIDFont = cidFontInfoEntry.getKey();
            CIDFontInfo currentCIDFontInfo = cidFontInfoEntry.getValue();
            PDFFontDescriptor fontDescriptor = currentCIDFont.getFontDescriptor();
            PDFFontFile currentFontFile = PDFFontUtils.getFontFileFromFontDescriptor(fontDescriptor);
            if (currentCIDFont.getSubType() == ASName.k_CIDFontType2 && fontDescriptor.getFontFile2() != null) {
                fontDescriptor.setFontFile3(currentFontFile);
                fontDescriptor.setFontFile2(null);
            }
            if ((currentFontFileInfo = (Type0FontInfo)this.fontFileToFontInfoMap.get(currentFontFile)) == null) {
                currentFontFileInfo = new Type0FontInfo();
                try {
                    currentFontFileInfo.setFont(currentCIDFontInfo.getPdfType0FontSet().iterator().next().getAFEFont());
                }
                catch (FontLoadingException e) {
                    throw new PDFFontException(e);
                }
                currentFontFileInfo.type2 = currentCIDFont.getSubType() == ASName.k_CIDFontType2;
                this.fontFileToFontInfoMap.put(currentFontFile, currentFontFileInfo);
            }
            currentFontFileInfo.getCidFontSet().add(currentCIDFont);
            currentFontFileInfo.getGIDsSet().addAll(currentCIDFontInfo.getCidToGidMap().values());
        }
    }

    @Override
    protected void doSubsetting() throws PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException, PDFInvalidDocumentException {
        for (Map.Entry fontFileToFontInfoEntry : this.fontFileToFontInfoMap.entrySet()) {
            PDFFontFile fontFile = (PDFFontFile)fontFileToFontInfoEntry.getKey();
            Type0FontInfo fontInfo = (Type0FontInfo)fontFileToFontInfoEntry.getValue();
            Map<Integer, Integer> oldGidsToNewGidsMap = this.subsetCIDFontStream(fontFile, fontInfo.getFont(), fontInfo.getGIDsSet(), fontInfo.type2);
            for (PDFCIDFont currentCIDFont : fontInfo.getCidFontSet()) {
                CIDFontInfo cidFontInfo = this.cidFontInfoMap.get(currentCIDFont);
                Set<Integer> cidSet = cidFontInfo.getCidToGidMap().keySet();
                this.subsetCidFont(currentCIDFont, cidSet, oldGidsToNewGidsMap, cidFontInfo.getCidToGidMap().lastKey());
                for (PDFFontType0 currentPdfType0Font : cidFontInfo.getPdfType0FontSet()) {
                    TreeMap charCodesMap = (TreeMap)this.fontToCharCodesMap.get(currentPdfType0Font);
                    this.subsetType0Font(currentPdfType0Font, charCodesMap);
                }
            }
        }
    }

    private void subsetType0Font(PDFFontType0 fontType0, TreeMap<Integer, Integer> charCodesMap) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFFontException {
        SubsetUtils.createUpdatedToUnicodeCMap(fontType0, charCodesMap);
        CharCodeToCidMapper newCharCodeToCidMap = null;
        final PDFType0FontEncoding type0Encoding = fontType0.getEncoding();
        newCharCodeToCidMap = new CharCodeToCidMapper(){

            @Override
            public int getCid(int charCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
                return type0Encoding.getCID(charCode);
            }
        };
        SubsetUtils.createUpdatedCMap(fontType0, newCharCodeToCidMap, charCodesMap);
    }

    private void subsetCidFont(PDFCIDFont cidFont, Set<Integer> cidSet, Map<Integer, Integer> oldGidsToNewGidsMap, int maxCID) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCIDVerticalMetrics verticalMatrices;
        cidFont.getFontDescriptor().setCIDSet(null);
        cidFont.getFontDescriptor().setCharSet(null);
        PDFCIDFontWidths originalFontWidths = cidFont.getW();
        if (originalFontWidths != null) {
            PDFCIDFontWidths updatedWidths = PDFCIDFontWidths.newInstance(cidFont.getPDFDocument());
            for (int currCID : cidSet) {
                if (!originalFontWidths.containsWidth(currCID)) continue;
                double width = originalFontWidths.getWidth(currCID);
                updatedWidths.addWidths(new double[]{width}, currCID, currCID);
            }
            cidFont.setW(updatedWidths);
        }
        if ((verticalMatrices = cidFont.getW2()) != null) {
            CosArray w2Array = PDFCosUtils.newCosArray(cidFont.getPDFDocument());
            for (int cid : cidSet) {
                w2Array.addInt(cid);
                CosArray matriceArray = PDFCosUtils.newCosArray(cidFont.getPDFDocument());
                double[] matrices = verticalMatrices.getMetrics(cid);
                matriceArray.addDouble(matrices[0]);
                matriceArray.addDouble(matrices[1]);
                matriceArray.addDouble(matrices[2]);
                w2Array.add(matriceArray);
            }
            PDFCIDVerticalMetrics newVerticalMatrices = PDFCIDVerticalMetrics.getInstance(w2Array);
            cidFont.setW2(newVerticalMatrices);
        }
        if (cidFont.getSubType() == ASName.k_CIDFontType2) {
            TreeMap<Integer, Integer> updatedCidsToGidsMap = this.createUpdatedCIDToGIDMap(cidFont, oldGidsToNewGidsMap, cidSet, maxCID);
            CosStream cid2gidStream = this.createCIDToGIDStream(updatedCidsToGidsMap);
            cidFont.removeValue(ASName.k_CIDToGIDMap);
            cidFont.setDictionaryStreamValue(ASName.k_CIDToGIDMap, cid2gidStream);
        }
    }

    private TreeMap<Integer, Integer> createUpdatedCIDToGIDMap(PDFCIDFont cidFont, Map<Integer, Integer> oldGidToNewGidMap, Set<Integer> cids, int maxCID) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        TreeMap<Integer, Integer> updatedCidToGidMap = new TreeMap<Integer, Integer>();
        for (int i = 0; i <= maxCID; ++i) {
            int gidValue = cids.contains(i) ? oldGidToNewGidMap.get(cidFont.cid2gid(i)) : 0;
            updatedCidToGidMap.put(i, gidValue);
        }
        return updatedCidToGidMap;
    }

    private CosStream createCIDToGIDStream(TreeMap<Integer, Integer> updatedCIDToGIDMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            CosStream cidToGidStream = PDFCosUtils.newCosStream(this.pdfDoc);
            int maxCID = updatedCIDToGIDMap.lastKey();
            byte[] gidsArray = new byte[(maxCID + 1) * 2];
            for (int i = 0; i <= maxCID; ++i) {
                int currentGID = updatedCIDToGIDMap.get(i);
                gidsArray[i * 2] = (byte)(currentGID >> 8);
                gidsArray[i * 2 + 1] = (byte)(currentGID & 0xFF);
            }
            StreamManager streamManager = this.pdfDoc.getStreamManager();
            ByteBufferByteReader gidsArrayReader = new ByteBufferByteReader(gidsArray);
            cidToGidStream.newDataDecoded(streamManager.getInputByteStream(gidsArrayReader));
            cidToGidStream.put(ASName.create("Filter"), ASName.create("FlateDecode"));
            return cidToGidStream;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private Map<Integer, Integer> subsetCIDFontStream(PDFFontFile fontFile, Font afeFont, Set<Integer> gids, boolean type2) throws PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException, PDFInvalidDocumentException {
        try {
            OutputByteStream subsetStream = this.pdfDoc.getStreamManager().getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, 1024L);
            Map<Integer, Integer> oldGidsToNewGidsMap = FontResources.getSubsettedCIDFontStream(gids, afeFont, subsetStream.toOutputStream(), true);
            InputByteStream subsetInputStream = subsetStream.closeAndConvert();
            fontFile.getCosStream().clear();
            fontFile.getCosStream().newDataDecoded(subsetInputStream);
            fontFile.setFilter(PDFFilterFlate.newInstance(this.pdfDoc, null));
            if (type2) {
                fontFile.setEmbeddedFontType(PDFFontFile.EmbeddedFontType.OpenType);
            } else {
                fontFile.setEmbeddedFontType(PDFFontFile.EmbeddedFontType.CIDFontType0C);
            }
            return oldGidsToNewGidsMap;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private static class CIDFontInfo {
        private Set<PDFFontType0> pdfType0FontSet = new LinkedHashSet<PDFFontType0>();
        private TreeMap<Integer, Integer> cidToGidMap = new TreeMap();

        private CIDFontInfo() {
        }

        TreeMap<Integer, Integer> getCidToGidMap() {
            return this.cidToGidMap;
        }

        Set<PDFFontType0> getPdfType0FontSet() {
            return this.pdfType0FontSet;
        }
    }

    private static class Type0FontInfo
    extends FontSubsetter.FontInfo {
        Set<Integer> gidsSet = new LinkedHashSet<Integer>();
        Set<PDFCIDFont> cidFontSet = new LinkedHashSet<PDFCIDFont>();
        boolean type2;

        private Type0FontInfo() {
        }

        Set<Integer> getGIDsSet() {
            return this.gidsSet;
        }

        Set<PDFCIDFont> getCidFontSet() {
            return this.cidFontSet;
        }
    }
}

