/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fontresources;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.Subset;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListener;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerProperties;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentMessage;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.services.fontresources.FontManager;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFFontGroupListener;
import java.util.TreeMap;

public class PDFFontListener
implements DocumentListener {
    private static final Object KEY = PDFFontListener.class;
    private FontManager fontManager;
    private boolean ignoreErrors;
    private boolean enableFontOperations = true;

    private PDFFontListener(PDFDocument pdfDoc) {
        this.fontManager = new FontManager(pdfDoc);
    }

    public static PDFFontListener getFontListener(PDFDocument pdfDoc) {
        PDFFontListener fontListener = PDFFontListener.procureFontListener(pdfDoc);
        if (fontListener.enableFontOperations) {
            return fontListener;
        }
        return null;
    }

    public void addToFontCache(PDFFont subsetFont, int charCode, int charCodeLength) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        if (this.enableFontOperations && PDFFontUtils.getFontFileFromFontDescriptor(subsetFont.getFontDescriptor()) != null) {
            this.fontManager.addMapping(subsetFont, charCode, charCodeLength);
        }
    }

    public void addToFontCache(Font afeFont, Subset subset, PDFFontType0 pdfFont) {
        if (this.enableFontOperations) {
            this.fontManager.addMapping(afeFont, subset, pdfFont);
        }
    }

    public void addToFontCache(Font afeFont, TreeMap<Integer, byte[]> toUnicodeMappings) {
        if (this.enableFontOperations) {
            this.fontManager.addMapping(afeFont, toUnicodeMappings);
        }
    }

    public boolean hasMappingInFontCache(Font afeFont) {
        if (this.enableFontOperations) {
            return this.fontManager.hasMapping(afeFont);
        }
        return false;
    }

    public Subset getSubsetObjFromFontCache(Font afeFont) {
        if (this.enableFontOperations) {
            return this.fontManager.getSubsetFromCache(afeFont);
        }
        return null;
    }

    public PDFFontType0 getPDFFontFromFontCache(Font afeFont) {
        if (this.enableFontOperations) {
            return this.fontManager.getPDFFontFromCache(afeFont);
        }
        return null;
    }

    private static PDFFontListener procureFontListener(PDFDocument pdfDoc) {
        PDFFontGroupListener gListener = PDFFontGroupListener.getFontGroupListener(pdfDoc);
        PDFFontListener fontListener = (PDFFontListener)gListener.getListener(KEY);
        if (fontListener == null) {
            fontListener = new PDFFontListener(pdfDoc);
            gListener.registerListener(Integer.MIN_VALUE, KEY, fontListener);
            gListener.holdStrongly(KEY, true);
        }
        return fontListener;
    }

    public static void enableFontOperations(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFInvalidParameterException {
        PDFFontListener fontListener = PDFFontListener.procureFontListener(pdfDoc);
        fontListener.enableFontOperations = true;
    }

    public static void disableFontOperations(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFInvalidParameterException {
        PDFFontListener fontListener = PDFFontListener.procureFontListener(pdfDoc);
        fontListener.flush();
        fontListener.enableFontOperations = false;
    }

    @Override
    public DocumentListenerProperties getProperties() {
        return null;
    }

    @Override
    public void message(DocumentMessage message) throws PDFUnableToCompleteOperationException {
        DocumentMessage.MessageType type = message.getMessageType();
        if (type == DocumentMessage.FINISH || type == DocumentMessage.SAVE || type == DocumentMessage.FLUSH_FONTS) {
            try {
                this.flush();
            }
            catch (PDFException e) {
                throw new PDFUnableToCompleteOperationException(e);
            }
        }
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    private void flush() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFFontException {
        block2: {
            try {
                this.fontManager.finishFonts();
            }
            catch (PDFFontException e) {
                if (this.ignoreErrors) break block2;
                throw e;
            }
        }
    }

    Font getAFEFontForFontDescriptorFromCache(int objNum) {
        return this.fontManager.getAFEFontForFontDescriptor(objNum);
    }

    void putAFEFontForFontDescriptorInCache(int objNum, Font afeFont) {
        this.fontManager.putAFEFontForFontDescriptor(objNum, afeFont);
    }
}

