/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fdf;

import com.adobe.fontengine.font.Font;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionJavaScript;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation3D;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationCaret;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationCircle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFileAttachment;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFreeText;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationHighlight;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationInk;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationLine;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPolygon;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPolyline;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationProjection;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationSound;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationSquare;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationSquiggly;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationStamp;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationStrikeOut;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationText;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationUnderline;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFExData;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldChoice;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldText;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedJavaScripts;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DDDict;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DDStream;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DExData3DM;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DExDataMarkup3D;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurement;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DMeasurementList;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DVDict;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDF3DViewArray;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.ap.AppearanceService;
import com.adobe.internal.pdftoolkit.services.ap.impl.AppearanceUtils;
import com.adobe.internal.pdftoolkit.services.ap.spi.APContext;
import com.adobe.internal.pdftoolkit.services.ap.spi.APResources;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureManager;
import com.adobe.internal.pdftoolkit.services.fdf.FDFDocument;
import com.adobe.internal.pdftoolkit.services.fdf.impl.FDFAnnotation;
import com.adobe.internal.pdftoolkit.services.fdf.impl.FDFContent;
import com.adobe.internal.pdftoolkit.services.fdf.impl.FDFDocumentImpl;
import com.adobe.internal.pdftoolkit.services.fdf.impl.FDFField;
import com.adobe.internal.pdftoolkit.services.fdf.impl.FDFFieldList;
import com.adobe.internal.pdftoolkit.services.fdf.impl.FDFJavaScript;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFFontSetUtil;
import com.adobe.internal.pdftoolkit.services.manipulations.impl.PMMNamedDestinations;
import com.adobe.internal.pdftoolkit.services.manipulations.impl.PMMPages;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class FDFService {
    private PDFDocument inDoc;
    private CosCloneMgr pdfCloneHandler = null;
    private CosCloneMgr fdfCloneHandler = null;
    private boolean generateApparances = false;
    private HashSet<Object> visitedSet = null;

    public FDFService(PDFDocument doc) {
        this.inDoc = doc;
    }

    public void importForm(FDFDocument fdfDoc, PDFFontSet fontSet, Locale locale, boolean importIntoLockedFields) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFConfigurationException, PDFInvalidParameterException, PDFFontException {
        this.importForm(fdfDoc, fontSet, locale, importIntoLockedFields, true);
    }

    public void importForm(FDFDocument fdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            this.importForm(fdfDoc, null, null, true, false);
        }
        catch (PDFConfigurationException e) {
        }
        catch (PDFInvalidParameterException e) {
        }
        catch (PDFFontException pDFFontException) {
            // empty catch block
        }
    }

    private void importForm(FDFDocument fdfDoc, PDFFontSet fontSet, Locale locale, boolean importIntoLockedFields, boolean appearances) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFConfigurationException, PDFInvalidParameterException, PDFFontException {
        this.pdfCloneHandler = new CosCloneMgr(this.inDoc.getCosDocument());
        FDFContent fdfContent = fdfDoc.getFDFDocument().requireContent();
        PDFInteractiveForm acroForm = this.inDoc.getInteractiveForm();
        this.generateApparances = appearances;
        if (acroForm != null) {
            HashMap<Font, PDFFont> afePDFFontMap = new HashMap<Font, PDFFont>();
            if (this.generateApparances) {
                if (locale == null) {
                    locale = AppearanceUtils.convertStringToLocale(this.inDoc.requireCatalog().getLang());
                }
                fontSet = PDFFontSetUtil.buildWorkingFontSet(this.inDoc, fontSet, locale, afePDFFontMap);
            }
            boolean buildFontSet = false;
            boolean isImported = this.importFormFields(acroForm.getChildren(), FDFFieldList.getInstance(fdfContent.getFields()), fontSet, importIntoLockedFields, locale, buildFontSet, afePDFFontMap);
            FDFJavaScript fdfJS = fdfContent.getFDFJavaScript();
            if (fdfJS != null) {
                ArrayList<Object> js = fdfJS.getDoc();
                for (int i = 0; i < js.size(); ++i) {
                    ArrayList jsValue = new ArrayList((ArrayList)js.get(i));
                    this.propagateJavaScript(jsValue.get(0).toString(), jsValue.get(1).toString(), this.inDoc);
                }
            }
            if (!this.generateApparances && isImported) {
                acroForm.setNeedAppearances(true);
            }
        }
    }

    public FDFDocument exportForm(PDFFileSpecification fileSpec) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.exportForm(fileSpec, PDFOpenOptions.newInstance());
    }

    public FDFDocument exportForm(PDFFileSpecification fileSpec, PDFOpenOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFInteractiveForm acroForm = this.inDoc.getInteractiveForm();
        FDFDocumentImpl fdfDoc = FDFDocumentImpl.newFDFInstance(options);
        if (acroForm != null) {
            this.fdfCloneHandler = new CosCloneMgr(fdfDoc.getCosDocument());
            FDFFieldList fdfFields = this.exportFormFields(fdfDoc, null, acroForm.getChildren());
            if (fdfFields != null) {
                CosArray id;
                FDFContent content = fdfDoc.requireFDFCatalog().procureContent();
                content.setFields(fdfFields);
                if (fileSpec != null) {
                    content.setFileSpecification(fileSpec);
                }
                if ((id = (CosArray)this.inDoc.getCosDocument().getTrailer().get(ASName.k_ID)) != null) {
                    content.setID((CosArray)this.fdfCloneHandler.clone(id));
                }
            }
        }
        return new FDFDocument(fdfDoc);
    }

    public void importAnnotations(FDFDocument fdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFAnnotationList fdfAnnots = fdfDoc.getFDFDocument().requireContent().getAnnotationList();
        if (fdfAnnots == null) {
            return;
        }
        this.pdfCloneHandler = new CosCloneMgr(this.inDoc.getCosDocument());
        PMMNamedDestinations destsHandler = new PMMNamedDestinations(this.inDoc, this.pdfCloneHandler, false);
        PMMPages pagesHandler = new PMMPages(this.inDoc, this.pdfCloneHandler);
        PDFAnnotationIterator annotsIter = fdfAnnots.iterator();
        HashMap<PDFAnnotation, PDFAnnotation> allAnnots = new HashMap<PDFAnnotation, PDFAnnotation>(fdfAnnots.size());
        HashMap<PDFAction, PDFAction> allActions = new HashMap<PDFAction, PDFAction>();
        HashMap<PDFAdditionalActions, PDFAdditionalActions> allAdditionalActions = new HashMap<PDFAdditionalActions, PDFAdditionalActions>();
        HashMap<String, PDFAnnotation> irtAnnots = new HashMap<String, PDFAnnotation>();
        HashMap<String, PDFAnnotation> annotsByName = new HashMap<String, PDFAnnotation>(allAnnots.size());
        HashMap<ASString, PDF3DVDict> new3DViews = new HashMap<ASString, PDF3DVDict>();
        while (annotsIter.hasNext()) {
            PDFPage pdfPage;
            PDFAnnotation pdfAnnotIncarnation = annotsIter.next();
            FDFAnnotation fdfAnnot = FDFAnnotation.newInstance(pdfAnnotIncarnation);
            if (!fdfAnnot.hasPageNumber()) continue;
            int pageNum = fdfAnnot.getPageNumber();
            PDFAnnotation pdfAnnot = pagesHandler.cloneAnnotation(fdfAnnot.getPDFAnnotation(), null, destsHandler, allAnnots, null, allActions, allAdditionalActions);
            String annotName = pdfAnnot.getName();
            if (annotName != null) {
                annotsByName.put(annotName, pdfAnnot);
            }
            pdfAnnot.removeValue(ASName.k_Page);
            String irtName = fdfAnnot.getInReplyTo();
            if (irtName != null) {
                irtAnnots.put(irtName, pdfAnnot);
            }
            PDFAnnotationPopup popup = null;
            PDFAnnotationPopup clonedPopup = null;
            if (pdfAnnot instanceof PDFAnnotationMarkup) {
                popup = ((PDFAnnotationMarkup)fdfAnnot.getPDFAnnotation()).getPopup();
            }
            if (popup != null) {
                clonedPopup = (PDFAnnotationPopup)pagesHandler.cloneAnnotation(popup, null, destsHandler, allAnnots, null, allActions, allAdditionalActions);
            }
            if ((pdfPage = this.inDoc.requirePages().getPage(pageNum)) == null) continue;
            PDFAnnotationList pdfAnnots = pdfPage.procureAnnotationList();
            if (pdfAnnot instanceof PDFAnnotationMarkup && ((PDFAnnotationMarkup)pdfAnnot).hasExData()) {
                this.import3DMarkup((PDFAnnotationMarkup)pdfAnnot, pdfAnnots, new3DViews);
            }
            if (!pdfAnnots.contains(pdfAnnot)) {
                pdfAnnots.add(pdfAnnot);
            }
            if (clonedPopup != null && !pdfAnnots.contains(clonedPopup)) {
                clonedPopup.setParent(pdfAnnot);
                clonedPopup.removeValue(ASName.k_Page);
                pdfAnnots.add(clonedPopup);
            }
            if (pdfAnnot instanceof PDFAnnotationPopup) continue;
            pdfAnnot.setPage(pdfPage);
        }
        for (Map.Entry entry : irtAnnots.entrySet()) {
            PDFAnnotation mainAnnot = (PDFAnnotation)entry.getValue();
            String refName = (String)entry.getKey();
            PDFAnnotation refAnnot = (PDFAnnotation)annotsByName.get(refName);
            if (refAnnot == null) continue;
            ((PDFAnnotationMarkup)mainAnnot).setInReplyTo(refAnnot);
        }
    }

    public FDFDocument exportAnnotations(PDFFileSpecification fileSpec) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.exportAnnotations(fileSpec, null);
    }

    public FDFDocument exportAnnotations(PDFFileSpecification fileSpec, PDFAnnotationList exportedAnnots) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.exportAnnotations(fileSpec, exportedAnnots, PDFOpenOptions.newInstance());
    }

    public FDFDocument exportAnnotations(PDFFileSpecification fileSpec, PDFAnnotationList exportedAnnots, PDFOpenOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        FDFDocumentImpl fdfDoc = FDFDocumentImpl.newFDFInstance(options);
        ArrayList<PDFAnnotation> annotsList = exportedAnnots != null ? new ArrayList<PDFAnnotation>(exportedAnnots.getArrayList()) : null;
        this.fdfCloneHandler = new CosCloneMgr(fdfDoc.getCosDocument());
        PMMNamedDestinations destsHandler = new PMMNamedDestinations(fdfDoc, this.fdfCloneHandler, false);
        HashMap<PDFAnnotation, PDFAnnotation> allAnnots = new HashMap<PDFAnnotation, PDFAnnotation>();
        HashMap<PDFAction, PDFAction> allActions = new HashMap<PDFAction, PDFAction>();
        HashMap<PDFAdditionalActions, PDFAdditionalActions> allAdditionalActions = new HashMap<PDFAdditionalActions, PDFAdditionalActions>();
        PMMPages pagesHandler = new PMMPages(fdfDoc, this.fdfCloneHandler);
        Iterator<PDFPage> pagesIter = this.inDoc.requirePages().iterator();
        int pageNum = 0;
        PDFAnnotationList fdfAnnots = PDFAnnotationList.newInstance(fdfDoc);
        block4: while (pagesIter.hasNext()) {
            PDFPage curPage = pagesIter.next();
            PDFAnnotationList annots = curPage.getAnnotationList();
            if (annots != null) {
                ArrayList<PDFAnnotation> annots3D = new ArrayList<PDFAnnotation>();
                PDFAnnotationIterator annotsIter = annots.iterator();
                while (annotsIter.hasNext()) {
                    PDFAnnotation pdfAnnot = annotsIter.next();
                    if (annotsList == null || annotsList.contains(pdfAnnot)) {
                        if (pdfAnnot instanceof PDFAnnotation3D) {
                            annots3D.add(pdfAnnot);
                        }
                        if (FDFService.supportsFDF(pdfAnnot)) {
                            PDFAnnotation reply;
                            if (!(pdfAnnot instanceof PDFAnnotationStamp)) {
                                pdfAnnot.removeAppearance();
                            }
                            if (pdfAnnot instanceof PDFAnnotationMarkup && ((PDFAnnotationMarkup)pdfAnnot).hasExData()) {
                                try {
                                    this.export3DMarkup((PDFAnnotationMarkup)pdfAnnot);
                                }
                                catch (PDFInvalidParameterException e) {
                                    throw new PDFInvalidDocumentException(e);
                                }
                                try {
                                    this.fixAnnot3DCommentExport((PDFAnnotationMarkup)pdfAnnot, annots3D);
                                }
                                catch (PDFInvalidParameterException e) {
                                    throw new PDFInvalidDocumentException(e);
                                }
                            }
                            FDFAnnotation fdfAnnot = FDFAnnotation.newInstance(pagesHandler.cloneAnnotation(pdfAnnot, null, destsHandler, allAnnots, null, allActions, allAdditionalActions));
                            pdfAnnot.getDictionaryValue(ASName.k_ExData);
                            if (pdfAnnot instanceof PDFAnnotationMarkup && (reply = ((PDFAnnotationMarkup)pdfAnnot).getInReplyTo()) != null) {
                                fdfAnnot.setInReplyTo(reply.getName());
                            }
                            fdfAnnot.setPageNumber(pageNum);
                            fdfAnnots.add(fdfAnnot);
                        }
                    }
                    if (annotsList == null) continue;
                    annotsList.remove(pdfAnnot);
                    if (!annotsList.isEmpty()) continue;
                    break block4;
                }
            }
            ++pageNum;
        }
        if (fdfAnnots.size() > 0) {
            CosArray id;
            FDFContent content = fdfDoc.requireFDFCatalog().procureContent();
            content.setAnnotationList(fdfAnnots);
            if (fileSpec != null) {
                PDFFileSpecification clonedFileSpec = PDFFileSpecification.getInstance(this.fdfCloneHandler.clone(fileSpec.getCosObject()));
                content.setFileSpecification(clonedFileSpec);
            }
            if ((id = (CosArray)this.inDoc.getCosDocument().getTrailer().get(ASName.k_ID)) != null) {
                content.setID((CosArray)this.fdfCloneHandler.clone(id));
            }
        }
        return new FDFDocument(fdfDoc);
    }

    private boolean importFormFields(PDFFieldList pdfFields, FDFFieldList fdfFields, PDFFontSet fontSet, boolean importToLockedFields, Locale locale, boolean buildFontSet, HashMap<Font, PDFFont> afeFontMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFInvalidParameterException, PDFFontException {
        if (pdfFields == null || fdfFields == null) {
            return false;
        }
        for (FDFField fdfField : fdfFields) {
            PDFFieldNode pdfField = pdfFields.getFieldNamed(fdfField.getPartialName());
            if (pdfField == null) {
                return false;
            }
            this.propagateField(pdfField, fdfField, fontSet, importToLockedFields, locale, buildFontSet, afeFontMap, false);
        }
        return true;
    }

    private FDFFieldList exportFormFields(FDFDocumentImpl fdfDoc, FDFFieldList fdfFields, PDFFieldList pdfFields) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfFields == null) {
            return null;
        }
        if (fdfFields == null) {
            fdfFields = FDFFieldList.newInstance(fdfDoc);
        }
        for (PDFFieldNode curField : pdfFields) {
            if (null == this.visitedSet) {
                this.visitedSet = new HashSet();
            }
            if (this.visitedSet.contains(curField)) continue;
            this.visitedSet.add(curField);
            this.exportField(fdfDoc, fdfFields, curField);
        }
        return fdfFields;
    }

    private void propagateField(PDFFieldNode pdfField, FDFField fdfField, PDFFontSet fonts, boolean importToLockedFields, Locale locale, boolean buildFontSet, HashMap<Font, PDFFont> afeFontMap, boolean changed) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFInvalidParameterException, PDFFontException {
        if (importToLockedFields || (pdfField.getFlags() & 1) == 0) {
            List values = fdfField.getValueList();
            PDFField valueField = PDFField.getInstance(pdfField.getCosObject());
            if (values != null && valueField != null) {
                List formOptList;
                if (valueField instanceof PDFFieldButton && (formOptList = ((PDFFieldButton)valueField).getOptionList()) != null) {
                    int optIndex = formOptList.indexOf(values.get(0));
                    if (optIndex >= 0) {
                        Integer valueIndex = optIndex;
                        valueField.setNameValue(ASName.create(valueIndex.toString()));
                        ((PDFFieldButton)valueField).setStateFromValue();
                    }
                } else if (valueField instanceof PDFFieldButton) {
                    ((PDFFieldButton)valueField).setNameValue(ASName.create((String)values.get(0)));
                    ((PDFFieldButton)valueField).setStateFromValue();
                } else if (pdfField instanceof PDFFieldSignature && !SignatureManager.newInstance(pdfField.getPDFDocument()).isDocCertified()) {
                    CosDictionary value = (CosDictionary)this.pdfCloneHandler.clone((CosObject)values.get(0));
                    ((PDFFieldSignature)pdfField).setSignature(PDFSignature.getInstance(value));
                } else if (values.size() == 1 && !(pdfField instanceof PDFFieldSignature)) {
                    valueField.setStringValue((String)values.get(0));
                    changed = true;
                } else if (!(pdfField instanceof PDFFieldSignature)) {
                    try {
                        valueField.setListValue(values);
                        changed = true;
                    }
                    catch (PDFInvalidParameterException e) {
                        throw new PDFInvalidDocumentException("Invalid form field value", e);
                    }
                }
                if (valueField instanceof PDFFieldChoice) {
                    ((PDFFieldChoice)valueField).setOptIndex();
                }
            }
            PDFDocument curDoc = pdfField.getPDFDocument();
            String richText = null;
            if (pdfField instanceof PDFFieldText) {
                richText = fdfField.getValueRichText();
            }
            if (richText != null) {
                PDFText pdfText = PDFText.newInstance(curDoc, richText);
                PDFFilterFlate filter = PDFFilterFlate.newInstance(curDoc, null);
                pdfText.setFilter(filter);
                pdfField.setRichText(pdfText);
                RichTextHandler richTextHandler = new RichTextHandler();
                String rawRichText = richTextHandler.getRawContent(richText);
                if (rawRichText != null) {
                    pdfField.setStringValue(rawRichText);
                }
                changed = true;
            }
            boolean hasFlag = false;
            if (!(pdfField instanceof PDFFieldSignature) && !SignatureManager.newInstance(pdfField.getPDFDocument()).isDocCertified()) {
                if (pdfField.hasFlags()) {
                    hasFlag = true;
                }
                int flags = pdfField.getFlags();
                if (fdfField.hasFlags()) {
                    hasFlag = true;
                    flags = fdfField.getFlags();
                } else if (fdfField.hasSetFlags()) {
                    hasFlag = true;
                    flags |= fdfField.getSetFlags();
                } else if (fdfField.hasClearFlags()) {
                    hasFlag = true;
                    flags &= fdfField.getClearFlags();
                }
                if (hasFlag) {
                    pdfField.setFlags(flags);
                }
                hasFlag = false;
                PDFAnnotationIterator annotsIter = null;
                if (pdfField.isTerminalField()) {
                    annotsIter = ((PDFField)pdfField).getAnnotationsIterator();
                }
                if (annotsIter != null) {
                    while (annotsIter.hasNext()) {
                        PDFAnnotation widget = PDFAnnotationFactory.getInstance(annotsIter.next().getCosObject());
                        flags = widget.getFlags();
                        if (fdfField.hasWidgetFlags()) {
                            flags = fdfField.getWidgetFlags();
                        } else {
                            flags |= fdfField.getSetWidgetFlags();
                            flags &= fdfField.getClearWidgetFlags();
                        }
                        widget.setFlags(flags);
                    }
                }
            }
            if (pdfField instanceof PDFFieldChoice && fdfField.hasOptionList()) {
                ArrayList<Object> fdfOption = fdfField.getOptionList();
                try {
                    ((PDFFieldChoice)pdfField).setOptionList(fdfOption);
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException("Invalid form field option list", e);
                }
            }
            this.propagateFieldJavaScript(fdfField, pdfField);
            if (changed && this.generateApparances && pdfField instanceof PDFField) {
                APResources apResources = new APResources(fonts, locale, afeFontMap);
                APContext apContext = new APContext(apResources, buildFontSet, null);
                AppearanceService.generateFieldAppearances(valueField.getPDFDocument(), valueField, apContext, null);
            }
            this.importFormFields(pdfField.getChildren(), FDFFieldList.getInstance(fdfField.getChildren()), fonts, importToLockedFields, locale, buildFontSet, afeFontMap);
        }
    }

    private void propagateFieldJavaScript(FDFField fdfField, PDFFieldNode pdfField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFAdditionalActions aas;
        PDFAction action = fdfField.getAction();
        if (action instanceof PDFActionJavaScript) {
            String script = ((PDFActionJavaScript)action).getJavaScriptString();
            if (!(pdfField instanceof PDFField)) {
                PDFField field = PDFField.getInstance(pdfField.getCosObject());
                field.setJavaScriptAction(script);
            } else {
                ((PDFField)pdfField).setJavaScriptAction(script);
            }
        }
        if ((aas = fdfField.getAdditionalActions()) != null) {
            pdfField.setAdditionalActions(aas);
        }
    }

    private void exportField(FDFDocumentImpl fdfDoc, FDFFieldList fdfFields, PDFFieldNode pdfField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        FDFFieldList fdfKids;
        CosObject clonedValue;
        FDFField fdfField = FDFField.newInstance(fdfDoc);
        String name = pdfField.getPartialName();
        if (name == null || this.fdfCloneHandler == null) {
            return;
        }
        fdfField.setPartialName(name);
        CosObject value = pdfField.getDictionaryCosObjectValue(ASName.k_V);
        if (value != null) {
            clonedValue = this.fdfCloneHandler.clone(value);
            fdfField.setDictionaryValue(ASName.k_V, clonedValue);
        }
        if ((value = pdfField.getDictionaryCosObjectValue(ASName.k_RV)) != null) {
            clonedValue = this.fdfCloneHandler.clone(value);
            fdfField.setDictionaryValue(ASName.k_RV, clonedValue);
        }
        if ((value = pdfField.getDictionaryCosObjectValue(ASName.k_Ff)) != null) {
            clonedValue = this.fdfCloneHandler.clone(value);
            fdfField.setDictionaryValue(ASName.k_Ff, clonedValue);
        }
        PDFAnnotationList widgets = null;
        if (pdfField instanceof PDFField) {
            widgets = ((PDFField)pdfField).getAnnotations();
        }
        if (widgets != null && (value = widgets.get(0).getDictionaryCosObjectValue(ASName.k_F)) != null) {
            clonedValue = this.fdfCloneHandler.clone(value);
            fdfField.setDictionaryValue(ASName.k_F, clonedValue);
        }
        if (pdfField instanceof PDFFieldChoice && (value = pdfField.getDictionaryCosObjectValue(ASName.k_Opt)) != null) {
            clonedValue = this.fdfCloneHandler.clone(value);
            fdfField.setDictionaryValue(ASName.k_Opt, clonedValue);
        }
        if ((fdfKids = this.exportFormFields(fdfDoc, null, pdfField.getChildren())) != null) {
            fdfField.setDictionaryArrayValue(ASName.k_Kids, fdfKids.getCosArray());
        }
        fdfFields.add(fdfField);
    }

    private void import3DMarkup(PDFAnnotationMarkup pdfAnnot, PDFAnnotationList pdfAnnots, HashMap<ASString, PDF3DVDict> new3DViews) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDF3DVDict _3DVFromFDFAnnot = null;
        PDFExData exData = pdfAnnot.getExData();
        if (exData.getSubtype() != null) {
            ASString viewExternalName;
            PDF3DVDict view2;
            PDF3DViewArray views;
            boolean isExistingView;
            PDFAnnotation3D annot3D;
            if (exData.getSubtype().equals(ASName.k_Markup3D)) {
                boolean update3DA;
                ASString newViewName = null;
                _3DVFromFDFAnnot = ((PDF3DExDataMarkup3D)exData).get3DV();
                if (_3DVFromFDFAnnot != null && _3DVFromFDFAnnot.getExternalName() != null) {
                    newViewName = _3DVFromFDFAnnot.getExternalName();
                }
                String annot3DName = null;
                if (((PDF3DExDataMarkup3D)exData).get3DAAsDict() != null) {
                    annot3DName = ((PDF3DExDataMarkup3D)exData).get3DAAsDict().getName();
                } else if (((PDF3DExDataMarkup3D)exData).get3DAAsTextString() != null) {
                    annot3DName = ((PDF3DExDataMarkup3D)exData).get3DAAsTextString().stringValue();
                }
                annot3D = null;
                annot3D = this.get3DAnnot(annot3DName, pdfAnnots);
                boolean bl = update3DA = annot3D != null;
                if (annot3D == null) {
                    return;
                }
                if (newViewName != null) {
                    if (!new3DViews.containsKey(newViewName)) {
                        isExistingView = false;
                        views = this.getViewArray(pdfAnnot, annot3D);
                        view2 = null;
                        viewExternalName = null;
                        for (PDF3DVDict view2 : views) {
                            if (view2 == null || (viewExternalName = view2.getExternalName()) == null || !viewExternalName.equals(newViewName)) continue;
                            _3DVFromFDFAnnot = view2;
                            ((PDF3DExDataMarkup3D)exData).set3DV(_3DVFromFDFAnnot);
                            isExistingView = true;
                            break;
                        }
                        if (!isExistingView) {
                            new3DViews.put(newViewName, _3DVFromFDFAnnot);
                            views.add(_3DVFromFDFAnnot);
                        }
                    } else {
                        ((PDF3DExDataMarkup3D)exData).set3DV(new3DViews.get(newViewName));
                    }
                }
                if (update3DA) {
                    ((PDF3DExDataMarkup3D)exData).set3DAAsDict(annot3D);
                }
            }
            if (exData.getSubtype().equals(PDFExData.k_3DM)) {
                String annot3DName = exData.getDictionaryStringValue(ASName.k_3DA).asString();
                _3DVFromFDFAnnot = PDF3DVDict.getInstance(exData.getDictionaryDictionaryValue(ASName.k_3DV));
                String measureName = exData.getDictionaryStringValue(ASName.k_M3N).asString();
                annot3D = this.get3DAnnot(annot3DName, pdfAnnots);
                if (annot3D == null) {
                    return;
                }
                ASString newViewName = _3DVFromFDFAnnot.getExternalName();
                if (newViewName != null) {
                    if (!new3DViews.containsKey(newViewName)) {
                        isExistingView = false;
                        views = this.getViewArray(pdfAnnot, annot3D);
                        view2 = null;
                        viewExternalName = null;
                        for (PDF3DVDict view2 : views) {
                            if (view2 == null || (viewExternalName = view2.getExternalName()) == null || !viewExternalName.equals(newViewName)) continue;
                            _3DVFromFDFAnnot = view2;
                            isExistingView = true;
                            break;
                        }
                        if (!isExistingView) {
                            new3DViews.put(newViewName, _3DVFromFDFAnnot);
                            views.add(_3DVFromFDFAnnot);
                            this.fixAnnot3DCommentImport((PDF3DExData3DM)exData, _3DVFromFDFAnnot, measureName);
                        }
                    } else {
                        this.fixAnnot3DCommentImport((PDF3DExData3DM)exData, _3DVFromFDFAnnot, measureName);
                    }
                }
            }
        }
    }

    private void export3DMarkup(PDFAnnotationMarkup pdfAnnot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDF3DExDataMarkup3D exData;
        if (pdfAnnot.getExData() instanceof PDF3DExDataMarkup3D && (exData = (PDF3DExDataMarkup3D)pdfAnnot.getExData()).getSubtype() != null && exData.getSubtype().equals(ASName.k_Markup3D)) {
            String annot3DName = null;
            if (exData.get3DAAsDict() != null) {
                annot3DName = exData.get3DAAsDict().getName();
                if (annot3DName != null) {
                    exData.set3DAAsTextString(PDFText.newInstance(pdfAnnot.getPDFDocument(), new ASString(annot3DName)));
                } else {
                    exData.removeValue(ASName.k_3DA);
                }
            }
        }
    }

    private void fixAnnot3DCommentExport(PDFAnnotationMarkup pdfAnnot, List<PDFAnnotation> annots3D) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (pdfAnnot.getExData() instanceof PDF3DExData3DM) {
            PDF3DExData3DM exData = (PDF3DExData3DM)pdfAnnot.getExData();
            PDF3DMeasurement measure3D = exData.getM3DREF();
            if (measure3D == null) {
                return;
            }
            for (int i3D = 0; i3D < annots3D.size(); ++i3D) {
                PDFAnnotation3D annot3D = (PDFAnnotation3D)annots3D.get(i3D);
                PDF3DDStream _3ddStream = null;
                if (annot3D.get3DDictOrStreamAsStream() != null) {
                    _3ddStream = (PDF3DDStream)annot3D.get3DDictOrStreamAsStream();
                } else if (annot3D.get3DDictOrStreamAsDict() != null) {
                    PDF3DDDict _3dd = (PDF3DDDict)annot3D.get3DDictOrStreamAsDict();
                    _3ddStream = _3dd.get3DD();
                }
                if (_3ddStream == null || !_3ddStream.hasPresetViewArtwork()) continue;
                PDF3DViewArray va = _3ddStream.getPresetViewArtwork();
                PDF3DVDict _3dv2 = null;
                if (va == null) continue;
                for (PDF3DVDict _3dv2 : va) {
                    PDF3DMeasurementList maList;
                    if (!_3dv2.hasMA() || !(maList = _3dv2.getMA()).contains(measure3D)) continue;
                    PDF3DExData3DM newExData = PDF3DExData3DM.newInstance(pdfAnnot.getPDFDocument(), measure3D);
                    newExData.removeValue(PDF3DExData3DM.k_M3DREF);
                    if (annot3D.getName() != null) {
                        newExData.setDictionaryStringValue(ASName.k_3DA, annot3D.getName());
                    }
                    newExData.setDictionaryValue(ASName.k_3DV, _3dv2);
                    if (measure3D.getTRL() != null) {
                        newExData.setDictionaryStringValue(ASName.k_M3N, measure3D.getTRL().stringValue());
                    }
                    pdfAnnot.setExData(newExData);
                    return;
                }
            }
        }
    }

    private void propagateJavaScript(String name, String script, PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFNameDictionary pdfNameDict = pdfDoc.requireCatalog().getNameDictionary();
        if (pdfNameDict != null) {
            PDFNamedJavaScripts namedScripts = pdfNameDict.getNamedJavaScripts();
            namedScripts.removeEntry(new ASString(script));
        }
        PDFActionJavaScript action = PDFActionJavaScript.newInstance(pdfDoc, PDFText.newInstance(pdfDoc, script));
        PDFNameDictionary names = pdfDoc.requireCatalog().procureNameDictionary();
        PDFNamedJavaScripts scripts = names.procureNamedJavaScripts();
        scripts.addEntry(new ASString(name), action);
    }

    private PDFAnnotation3D get3DAnnot(String annot3DName, PDFAnnotationList pdfAnnots) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotation annot;
        PDFAnnotation3D annot3D = null;
        if (annot3DName != null && (annot = pdfAnnots.findAnnotation(annot3DName)) instanceof PDFAnnotation3D) {
            annot3D = (PDFAnnotation3D)annot;
        }
        if (annot3D == null) {
            PDFAnnotationIterator iter = pdfAnnots.iterator();
            while (iter.hasNext()) {
                PDFAnnotation annot2 = iter.next();
                if (!(annot2 instanceof PDFAnnotation3D)) continue;
                annot3D = (PDFAnnotation3D)annot2;
            }
        }
        return annot3D;
    }

    private PDF3DViewArray getViewArray(PDFAnnotationMarkup pdfAnnot, PDFAnnotation3D annot3D) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDF3DDStream _3ddStream = null;
        if (annot3D.get3DDictOrStreamAsStream() != null) {
            _3ddStream = (PDF3DDStream)annot3D.get3DDictOrStreamAsStream();
        } else if (annot3D.get3DDictOrStreamAsDict() != null) {
            PDF3DDDict _3dd = (PDF3DDDict)annot3D.get3DDictOrStreamAsDict();
            _3ddStream = _3dd.get3DD();
        }
        PDF3DViewArray views = null;
        if (_3ddStream == null) {
            throw new PDFInvalidDocumentException("3DD key is missing in the 3D annotation dictionary. It is required.");
        }
        views = _3ddStream.getPresetViewArtwork();
        if (views == null) {
            views = PDF3DViewArray.newInstance(pdfAnnot.getPDFDocument());
            _3ddStream.setPresetViewArtwork(views);
        }
        return views;
    }

    private void fixAnnot3DCommentImport(PDF3DExData3DM exData, PDF3DVDict view, String measureName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (view.hasMA()) {
            PDF3DMeasurementList maList = view.getMA();
            PDF3DMeasurement measure2 = null;
            boolean isMeasureExist = false;
            for (PDF3DMeasurement measure2 : maList) {
                if (!measure2.hasTRL() || measure2.getTRL() == null || !measure2.getTRL().stringValue().equals(measureName)) continue;
                isMeasureExist = true;
                break;
            }
            if (!isMeasureExist) {
                throw new PDFInvalidDocumentException("3D measurement is not found in MA array.");
            }
            exData.removeValue(ASName.k_3DA);
            exData.removeValue(ASName.k_3DV);
            exData.removeValue(ASName.k_M3N);
            exData.setDictionaryValue(PDF3DExData3DM.k_M3DREF, measure2);
        }
    }

    private static boolean supportsFDF(PDFAnnotation annot) {
        return FDFService.supportsXFDFandFDF(annot) || annot instanceof PDFAnnotationStamp;
    }

    private static boolean supportsXFDFandFDF(PDFAnnotation annot) {
        return annot instanceof PDFAnnotationText || annot instanceof PDFAnnotationCircle || annot instanceof PDFAnnotationFileAttachment || annot instanceof PDFAnnotationFreeText || annot instanceof PDFAnnotationHighlight || annot instanceof PDFAnnotationSquiggly || annot instanceof PDFAnnotationCaret || annot instanceof PDFAnnotationPolygon || annot instanceof PDFAnnotationPolyline || annot instanceof PDFAnnotationInk || annot instanceof PDFAnnotationLine || annot instanceof PDFAnnotationSound || annot instanceof PDFAnnotationSquare || annot instanceof PDFAnnotationStamp || annot instanceof PDFAnnotationStrikeOut || annot instanceof PDFAnnotationUnderline || annot instanceof PDFAnnotationProjection;
    }
}

