/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNamedEmbeddedFiles;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTree;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelector;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.StringID;
import com.adobe.internal.pdftoolkit.services.digsig.impl.MessageDigestFactory;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public final class NamedEmbeddedFilesDigester
extends ObjectDigester {
    PDFNamedEmbeddedFiles nameTree;

    public NamedEmbeddedFilesDigester(PDFDocument pdfDoc, PDFNamedEmbeddedFiles nameTree, MessageDigestFactory digesterFactory, HashMap digestCache, ObjectSelector selector, PDFFieldSignature sigField) throws PDFInvalidParameterException {
        super(pdfDoc, digesterFactory, digestCache, selector, sigField);
        this.nameTree = nameTree;
    }

    @Override
    public byte[] digest() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (this.nameTree != null) {
            TreeSet<PDFTree.Entry> sortedSet = new TreeSet<PDFTree.Entry>(new NamedEmbeddedFilesComparator());
            Iterator<PDFTree.Entry> iter = this.nameTree.iterator();
            while (iter.hasNext()) {
                sortedSet.add(iter.next());
            }
            for (PDFTree.Entry efEntry : sortedSet) {
                byte[] digest;
                ASString name = (ASString)efEntry.getKey();
                PDFFileSpecification fileSpec = (PDFFileSpecification)efEntry.getValue();
                CosObject cosObj = fileSpec.getCosObject();
                if (!this.isDigestCached(cosObj)) {
                    ObjectDigester digester = new ObjectDigester(this.pdfDoc, this.digesterFactory, this.digestCache, this.selector, this.sigField);
                    digester.update(name);
                    digester.update(cosObj);
                    digest = digester.digest();
                    this.cacheDigest(cosObj, digest);
                } else {
                    digest = this.getCachedDigest(cosObj);
                }
                this.update(digest);
            }
        }
        byte[] digest = super.digest();
        return digest;
    }

    static class NamedEmbeddedFilesComparator
    implements Comparator {
        NamedEmbeddedFilesComparator() {
        }

        public int compare(Object o1, Object o2) {
            StringID id1 = null;
            StringID id2 = null;
            try {
                PDFTree.Entry efNode1 = (PDFTree.Entry)o1;
                PDFTree.Entry efNode2 = (PDFTree.Entry)o2;
                id1 = StringID.getID(((ASString)efNode1.getKey()).getBytes(), null);
                id2 = StringID.getID(((ASString)efNode2.getKey()).getBytes(), null);
            }
            catch (PDFSecurityException e) {
                throw new RuntimeException("Problem enountered trying to sort named entities.", e);
            }
            catch (PDFInvalidDocumentException e) {
                throw new RuntimeException("Problem enountered trying to sort named entities.", e);
            }
            catch (PDFIOException e) {
                throw new RuntimeException("Problem enountered trying to sort named entities.", e);
            }
            return id1.compareTo(id2);
        }
    }
}

