/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFFieldLock;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureFieldSeedValue;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldText;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ActionsDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.AdditionalActionsDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelector;
import com.adobe.internal.pdftoolkit.services.digsig.impl.MessageDigestFactory;
import java.util.HashMap;

public final class FieldAnnotDigester
extends ObjectDigester {
    private PDFField field;
    private PDFAnnotationWidget annot;

    public FieldAnnotDigester(PDFDocument pdfDoc, PDFAnnotationWidget annot, MessageDigestFactory digesterFactory, HashMap digestCache, ObjectSelector selector, PDFFieldSignature sigField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        super(pdfDoc, digesterFactory, digestCache, selector, sigField);
        PDFFieldNode node;
        this.annot = annot;
        this.sigField = sigField;
        this.field = annot.getField();
        if (!this.field.getCosDictionary().containsKey(ASName.k_T) && (node = this.field.getInheritableValueFieldNode(ASName.k_T)) != null) {
            this.field = PDFField.getInstance(node.getCosObject());
        }
    }

    @Override
    public byte[] digest() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        byte[] digest;
        CosDictionary annotDict = this.annot.getCosDictionary();
        CosDictionary fieldDict = this.field.getCosDictionary();
        if (!this.isDigestCached(annotDict)) {
            try {
                PDFAdditionalActions additionalActions;
                PDFAction action;
                boolean fieldIsSigField = (this.sigField != null ? this.sigField.getCosDictionary() : null) == fieldDict;
                boolean includeValue = this.selector.shouldDigestFieldAnnotValue(this.field, fieldIsSigField);
                CosDictionary tempFieldDict = fieldDict;
                CosString partialName = null;
                while (partialName == null && (partialName = tempFieldDict.getCosString(ASName.k_T)) == null && (tempFieldDict = tempFieldDict.getCosDictionary(ASName.k_Parent)) != null) {
                }
                if (partialName != null) {
                    byte[] pnBytes = partialName.byteArrayValue();
                    if (pnBytes[0] == -2 && pnBytes[1] == -1) {
                        this.updateUnicodeString(this.field.getQualifiedName());
                    } else {
                        this.updateString(partialName.byteArrayValue());
                    }
                } else {
                    this.updateString(new byte[0]);
                }
                this.update(PDFCosUtils.getInheritableValue(ASName.k_FT, ASName.k_Parent, this.field));
                this.update(PDFCosUtils.getInheritableValue(ASName.k_DV, ASName.k_Parent, this.field));
                if (includeValue) {
                    if (fieldDict.containsKey(ASName.k_I)) {
                        this.update(fieldDict.get(ASName.k_I));
                    }
                    this.updateFieldValue();
                }
                if ((action = this.annot.getAction()) != null) {
                    ActionsDigester actionDigester = new ActionsDigester(this.pdfDoc, action, this.digesterFactory, this.digestCache, this.selector, this.sigField);
                    byte[] actionDigest = actionDigester.digest();
                    this.digester.update(actionDigest);
                }
                if ((additionalActions = this.field.getAdditionalActions()) != null && FieldAnnotDigester.fieldAdditionalActionIsValid(additionalActions)) {
                    AdditionalActionsDigester aaDigester = new AdditionalActionsDigester(this.pdfDoc, additionalActions, this.digesterFactory, this.digestCache, this.selector, this.sigField);
                    byte[] aaDigest = aaDigester.digest();
                    this.digester.update(aaDigest);
                }
                int fieldFlags = 0;
                CosObject cosFlags = PDFCosUtils.getInheritableValue(ASName.k_Ff, ASName.k_Parent, this.field);
                if (cosFlags != null) {
                    fieldFlags = cosFlags.intValue();
                }
                this.update(fieldFlags &= 0xFFFFFFFE);
                int annotFlags = this.annot.getFlags();
                annotFlags &= 0xFFFFFFBF;
                this.update(annotFlags &= 0xFFFFFF7F);
                if (this.field instanceof PDFFieldSignature) {
                    PDFSignatureFieldSeedValue seedValues;
                    PDFFieldSignature sigField = (PDFFieldSignature)this.field;
                    PDFFieldLock fieldLock = sigField.getPDFFieldLock();
                    if (fieldLock != null) {
                        this.update(fieldLock.getCosObject());
                    }
                    if ((seedValues = sigField.getFieldSeedValue()) != null) {
                        this.update(seedValues.getCosObject());
                    }
                }
                digest = super.digest();
                this.cacheDigest(annotDict, digest);
            }
            catch (PDFCosParseException e) {
                throw new PDFInvalidDocumentException("Invalid document used to compute field annot digest", e);
            }
            catch (PDFIOException e) {
                throw new PDFIOException("IO exception encountered when computing field annot digest", e);
            }
            catch (PDFSecurityException e) {
                throw new PDFSecurityException("Security exception encountered when computing field annot digest", e);
            }
        } else {
            digest = this.getCachedDigest(annotDict);
        }
        return digest;
    }

    private void updateFieldValue() throws PDFInvalidDocumentException, PDFInvalidParameterException, PDFIOException, PDFSecurityException {
        PDFFieldButton buttonField;
        CosObject value = PDFCosUtils.getInheritableValue(ASName.k_V, ASName.k_Parent, this.field);
        if (this.field instanceof PDFFieldText) {
            String richText;
            PDFFieldText textField = (PDFFieldText)this.field;
            if (textField.isRichText() && (richText = textField.getRichTextForValue()) != null) {
                this.updateString(richText.getBytes());
                return;
            }
        } else if (this.field instanceof PDFFieldButton && ((buttonField = (PDFFieldButton)this.field).isCheckBox() || buttonField.isRadioButton())) {
            if (value == null) {
                this.update(ASName.create("Off"));
                return;
            }
            CosObject options = PDFCosUtils.getInheritableValue(ASName.k_Opt, ASName.k_Parent, this.field);
            if (options != null && options.getType() == 5) {
                CosArray optArray = (CosArray)options;
                try {
                    CosObject option;
                    Integer index;
                    String valueString = null;
                    if (value instanceof CosName) {
                        valueString = value.nameValue().asString();
                    }
                    if (value instanceof CosString) {
                        valueString = value.stringValue().asString();
                    }
                    if ((index = Integer.valueOf(valueString)) < optArray.size() && (option = optArray.get(index)).getType() == 4) {
                        this.update(option);
                        return;
                    }
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        this.update(value);
    }

    private static boolean fieldAdditionalActionIsValid(PDFAdditionalActions aa) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean isValid;
        block14: {
            isValid = false;
            CosObject cosObj = aa.getCosObject();
            isValid = cosObj.getType() == 6;
            try {
                PDFAction action;
                CosDictionary cosDict;
                if (isValid) {
                    cosDict = (CosDictionary)cosObj;
                    if (cosDict.containsKey(ASName.k_K)) {
                        action = PDFActionFactory.getInstance(cosDict.get(ASName.k_K));
                        isValid = action.isValid();
                    } else {
                        return false;
                    }
                }
                if (isValid) {
                    cosDict = (CosDictionary)cosObj;
                    if (cosDict.containsKey(ASName.k_F)) {
                        action = PDFActionFactory.getInstance(cosDict.get(ASName.k_F));
                        isValid = action.isValid();
                    } else {
                        return false;
                    }
                }
                if (isValid) {
                    cosDict = (CosDictionary)cosObj;
                    if (cosDict.containsKey(ASName.k_V)) {
                        action = PDFActionFactory.getInstance(cosDict.get(ASName.k_V));
                        isValid = action.isValid();
                    } else {
                        return false;
                    }
                }
                if (!isValid) break block14;
                cosDict = (CosDictionary)cosObj;
                if (cosDict.containsKey(ASName.k_C)) {
                    action = PDFActionFactory.getInstance(cosDict.get(ASName.k_C));
                    isValid = action.isValid();
                    break block14;
                }
                return false;
            }
            catch (PDFCosParseException e) {
                isValid = false;
            }
            catch (PDFIOException e) {
                isValid = false;
            }
            catch (PDFSecurityException e) {
                isValid = false;
            }
        }
        return isValid;
    }
}

