/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.RangeInputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.HSMCredentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.JCECredentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.RSACredentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.utils.CertUtils;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.securityframework.CryptoMode;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFDocMDPPermissions;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFFieldAction;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFFilterBuildData;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureReference;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureReferenceList;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureSubFilter;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParameters;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParametersDocMDP;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParametersFieldMDP;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFPermissions;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearanceCharacteristics;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.digsig.DocModAnalysisStatus;
import com.adobe.internal.pdftoolkit.services.digsig.ObjectDigestMode;
import com.adobe.internal.pdftoolkit.services.digsig.SigFieldLock;
import com.adobe.internal.pdftoolkit.services.digsig.SigSeedValue;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureAppearanceOptions;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureManager;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptions;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptionsDocMDP;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureUtils;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureValidationStatus;
import com.adobe.internal.pdftoolkit.services.digsig.UserInfo;
import com.adobe.internal.pdftoolkit.services.digsig.XFAChangeLogger;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.CryptoContext;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.SignatureServiceProvider;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.Signer;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.Verifier;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.CertJNonFIPSProvider;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSACredentialUtils;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSASigningUtils;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.SignatureHandler;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.XFAValidationContext;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.FormModelWorkFlow;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.JarManifestLoader;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.SignerFactory;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.VerifierFactory;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.XFADigSigWorkFlow;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.XFAVersionComparator;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.DocumentDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelector;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelectorDocMDPAnnotationFormChanges;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelectorDocMDPFormChanges;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelectorDocMDPNoChanges;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelectorFieldMDPAll;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelectorFieldMDPExclude;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelectorFieldMDPInclude;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.DocModAnalyzer;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.DocModAnalyzerParams;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.DocModAnalyzerResult;
import com.adobe.internal.pdftoolkit.services.digsig.impl.DNUtils;
import com.adobe.internal.pdftoolkit.services.digsig.impl.MessageDigestFactory;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SignatureAppearance;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SignatureFlags;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SigningUtils;
import com.adobe.internal.pdftoolkit.services.digsig.spi.RevocationInfoProvider;
import com.adobe.internal.pdftoolkit.services.digsig.spi.TimeStampProvider;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAUtils;
import com.adobe.internal.pdftoolkit.services.xfa.form.FieldMDP;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFAInternalUtils;
import com.adobe.internal.pdftoolkit.services.xfa.template.XFACaption;
import com.adobe.xfa.XFA;
import com.adobe.xfa.layout.BoxModelLayout;
import com.adobe.xfa.template.containers.Field;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class SignatureHandlerPPKLite
implements SignatureHandler {
    protected static final String filter = PDFSignature.k_Adobe_PPKLite.asString(true);
    protected PDFDocument pdfDoc;
    protected SignatureFieldInterface sigField;
    protected PDFSignature signature;
    protected int packageSize;
    protected long contentsOffset;
    protected long byteRangeOffset;
    protected long[] ranges = new long[4];
    protected TimeStampProvider tsProvider;
    protected RevocationInfoProvider revInfoProvider;
    protected Signer signer;
    private static final int MAX_BYTERANGE_STR_LENGTH = 45;
    private static final int MAX_DIGESTLOCATION_LENGTH = 23;
    static int DEFAULT_BLOCKSIZE = 32768;

    public static boolean isSubFilterSupported(ASName subFilter) {
        return subFilter == PDFSignature.k_adbe_x509_rsa_sha1 || subFilter == PDFSignature.k_adbe_pkcs7_detached || subFilter == PDFSignature.k_adbe_pkcs7_sha1 || subFilter == PDFSignature.k_ETSI_RFC3161 || subFilter == PDFSignature.k_ETSI_CADES_detached;
    }

    @Override
    public void prepareToSign(PDFDocument pdfDoc, SignatureFieldInterface sigField, PDFSignature signature, SignatureOptions sigOptions, Credentials credentials) throws PDFSignatureException {
        this.prepareToSignWrapperAPI(pdfDoc, new FormModelWorkFlow(sigField), signature, sigOptions, credentials);
    }

    private void prepareToSignWrapperAPI(PDFDocument pdfDoc, XFADigSigWorkFlow workFlow, PDFSignature signature, SignatureOptions sigOptions, Credentials credentials) throws PDFSignatureException {
        SignatureFieldInterface sigField = workFlow.getSignatureField();
        this.pdfDoc = pdfDoc;
        this.sigField = sigField;
        this.signature = signature;
        try {
            String digestMethod = sigOptions.getDigestMethod();
            SignerFactory signerFactory = SignerFactory.newInstance(PDFSignatureSubFilter.getInstance(signature.getSubFilterName()));
            if (sigOptions.getSignatureServiceProvider() != null) {
                this.signer = signerFactory.newSigner(credentials, sigOptions.getSignatureServiceProvider());
            } else {
                CryptoContext cryptoContext = new CryptoContext(CryptoMode.NON_FIPS_MODE, digestMethod, sigOptions.getSignatureAlgorithm());
                cryptoContext.registerTimeStampProvider(sigOptions.getTimeStampProvider());
                cryptoContext.registerRevocationInfoProvider(sigOptions.getRevocationInfoProvider());
                CertJNonFIPSProvider defaultCryptoProvider = new CertJNonFIPSProvider(cryptoContext, sigOptions);
                this.signer = signerFactory.newSigner(credentials, defaultCryptoProvider);
            }
            if (this.usesCertField()) {
                if (this.certChainPresent(credentials)) {
                    byte[][] derCertChain = this.createDERCertArray(credentials);
                    signature.setCertificates(derCertChain);
                } else {
                    byte[] derCert = this.createDERCert(credentials);
                    signature.setCertificate(derCert);
                }
            }
            PDFFieldSignature pdfSigField = null;
            if (sigField != null) {
                pdfSigField = sigField.getPDFField().getPDFFieldSignature();
                pdfSigField.setSignature(signature);
            }
            List<String> fieldMDPLockList = null;
            if (!SignatureUtils.isDocumentTimeStampSignature(signature)) {
                this.setUserInfo(signature, sigOptions.getUserInfo(), credentials);
                signature.setDate(new ASDate(Calendar.getInstance().getTime()));
                if (pdfSigField != null) {
                    if (!pdfSigField.hasAnnotations()) {
                        throw new PDFInvalidParameterException("The signature field must contain an annotation");
                    }
                    PDFAnnotationWidget annot = pdfSigField.getAnnotation();
                    SignatureAppearanceOptions appearanceOptions = sigOptions.getSignatureAppearanceOptions();
                    ASRectangle dynXFAFieldBBox = this.getDynBBoxRect(sigOptions, appearanceOptions, workFlow);
                    if (dynXFAFieldBBox != null || this.shouldGenerateAppearance(annot, appearanceOptions)) {
                        SignatureAppearance.createSignatureAppearance(sigField, RSACredentialUtils.getRSACertificate(credentials), appearanceOptions, dynXFAFieldBBox);
                    }
                    this.postProcessDynamicXFA(sigField);
                    annot.setFlags(annot.getFlags() | 0x80);
                    this.setLockSettings(workFlow, sigOptions);
                    SigFieldLock fieldLock = workFlow.getFieldLock();
                    if (fieldLock != null) {
                        boolean lockCertifyingField = false;
                        if (SigningUtils.isCertification(sigOptions)) {
                            lockCertifyingField = ((SignatureOptionsDocMDP)sigOptions).lockDynXFACertifyingField();
                        }
                        fieldMDPLockList = this.doFieldMDPLock(pdfDoc, sigField, lockCertifyingField, workFlow);
                        PDFSignatureReference sigReference = PDFSignatureReference.newInstance(pdfDoc, PDFSignature.k_FieldMDP);
                        PDFSignatureReferenceList sigRefList = signature.getSignatureReferences();
                        if (sigRefList == null) {
                            sigRefList = PDFSignatureReferenceList.newInstance(pdfDoc);
                            signature.setReferences(sigRefList);
                        }
                        Iterator sigRefIter = sigRefList.iterator();
                        while (sigRefIter.hasNext()) {
                            PDFSignatureReference targetReference = (PDFSignatureReference)sigRefIter.next();
                            if (targetReference.getTransformMethodName() != PDFSignature.k_FieldMDP) continue;
                            sigRefIter.remove();
                        }
                        sigRefList.add(sigReference);
                    }
                }
            } else {
                pdfSigField.getAnnotation().setAppearanceCharacteristics(PDFAppearanceCharacteristics.newInstance(sigField.getPDFDocument()));
            }
            if (SignatureUtils.hasReferences(signature)) {
                Iterator iter = SignatureUtils.getReferencesIterator(signature);
                while (iter.hasNext()) {
                    PDFSignatureReference sigReference = (PDFSignatureReference)iter.next();
                    this.setupReference(workFlow, signature, sigReference, sigOptions, fieldMDPLockList);
                }
            }
            SignatureFlags.byteRangeSignatureAdded(pdfDoc);
            this.packageSize = this.signer.getSignatureSize();
            byte[] dummyContents = new byte[this.packageSize];
            signature.setContents(dummyContents);
            this.ranges[0] = 1234567890L;
            this.ranges[1] = 1234567890L;
            this.ranges[2] = 1234567890L;
            this.ranges[3] = 1234567890L;
            signature.setByteRanges(this.ranges);
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFSignatureException("The PDF document to be signed is invalid", e);
        }
        catch (PDFIOException e) {
            throw new PDFSignatureException("IO exception with the PDF document to be signed", e);
        }
        catch (PDFSecurityException e) {
            throw new PDFSignatureException("Security exception with the PDF document to be signed", e);
        }
        catch (PDFConfigurationException e) {
            throw new PDFSignatureException("Problem with the configuration of the third party rsa libs", e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFSignatureException("The parameters sent in to the method are incorrect ", e);
        }
        catch (PDFFontException e) {
            throw new PDFSignatureException("Exception encountered during generate signature appearance", e);
        }
        catch (PDFInvalidXMLException e) {
            throw new PDFSignatureException("Exception encountered when determining if the document was an XFA doc", e);
        }
    }

    private boolean hasHiddenFields() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFInteractiveForm iform = this.pdfDoc.getInteractiveForm();
        Iterator<PDFField> itr = iform.iterator();
        while (itr.hasNext()) {
            PDFField field = itr.next();
            if (!field.isAnnotation() || field.isAcrobatAnnotation()) continue;
            PDFAnnotationIterator annotItr = field.getAnnotationsIterator();
            while (annotItr.hasNext()) {
                if (!annotItr.next().isHidden()) continue;
                return true;
            }
        }
        return false;
    }

    private int numUnsignedSignatureFields() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int numUnsignedSigFields = 0;
        SignatureManager sigMgr = SignatureManager.newInstance(this.pdfDoc);
        Iterator<SignatureFieldInterface> iter = sigMgr.getDocSignatureFieldIterator();
        while (iter.hasNext()) {
            SignatureFieldInterface sigField = iter.next();
            if (sigField.isSigned()) continue;
            ++numUnsignedSigFields;
        }
        return numUnsignedSigFields;
    }

    private void setLockSettings(XFADigSigWorkFlow workFlow, SignatureOptions sigOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFSignature sig = this.sigField.getPDFField().getPDFFieldSignature().getSignature();
        if (sig != null && (SignatureUtils.isAuthorSignature(sig) || SignatureUtils.isUsageRightsSignature(sig))) {
            return;
        }
        SigSeedValue seedValue = workFlow.getSeedValue();
        SigFieldLock fieldLock = workFlow.getFieldLock();
        boolean lockDocument = false;
        boolean requiredFlagSet = false;
        boolean isValid = false;
        boolean lockDocumentInSigOptions = sigOptions.isLockDocument();
        if (seedValue != null) {
            boolean bl = requiredFlagSet = (seedValue.getFlags() & 0x80) > 0;
            if (seedValue.getLockDocument() == ASName.k_true) {
                lockDocument = !requiredFlagSet ? lockDocumentInSigOptions : true;
                isValid = true;
            } else if (seedValue.getLockDocument() == ASName.k_false) {
                if (!requiredFlagSet) {
                    lockDocument = lockDocumentInSigOptions;
                }
                isValid = true;
            }
        }
        if (!(!lockDocumentInSigOptions || isValid || fieldLock != null && fieldLock.getFieldAction() != null || this.hasHiddenFields() || this.numUnsignedSignatureFields() > 1 || (seedValue == null || seedValue.getLockDocument() != ASName.k_auto) && this.pdfDoc.getInteractiveForm().hasXFA())) {
            lockDocument = lockDocumentInSigOptions;
        }
        if (lockDocument) {
            if (fieldLock == null) {
                fieldLock = new SigFieldLock(PDFFieldAction.All, null, PDFDocMDPPermissions.NoChanges);
            } else {
                fieldLock.setFieldAction(PDFFieldAction.All);
                fieldLock.setFieldList(null);
                fieldLock.setFieldPermission(PDFDocMDPPermissions.NoChanges);
            }
            workFlow.setFieldLock(fieldLock);
        }
    }

    private void postProcessDynamicXFA(SignatureFieldInterface sigField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFConfigurationException {
        if (XFAService.getDocumentType(this.pdfDoc).isDynamic()) {
            sigField.getPDFField().getPDFFieldSignature().getAnnotation().removeValue(ASName.k_BS);
            sigField.getPDFField().getPDFFieldSignature().getAnnotation().removeValue(ASName.k_MK);
            sigField.getPDFField().getPDFFieldSignature().getAnnotation().removeValue(ASName.k_SV);
        }
    }

    private ASRectangle getDynBBoxRect(SignatureOptions sigOptions, SignatureAppearanceOptions appearanceOptions, XFADigSigWorkFlow workFlow) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFInvalidParameterException {
        PDFDocument pdfDoc;
        ASRectangle appearanceRect = null;
        if ((!workFlow.isFormModelWorkFlow() && sigOptions instanceof SignatureOptionsDocMDP || workFlow.isFormModelWorkFlow()) && (XFAService.getDocumentType(pdfDoc = this.sigField.getPDFDocument()).isDynamic() || XFAService.getDocumentType(pdfDoc) == PDFDocument.PDFDocumentType.StaticShellXFA)) {
            if (!workFlow.isFormModelWorkFlow() && XFAService.getDocumentType(pdfDoc) == PDFDocument.PDFDocumentType.DynamicNonShellXFA && !((SignatureOptionsDocMDP)sigOptions).leanDocumentGenerationEnabled()) {
                return appearanceRect;
            }
            Field xfaSigField = workFlow.getXFAField();
            if (xfaSigField == null) {
                throw new PDFInvalidParameterException("XFA Signature field is null");
            }
            String presenceAttribute = xfaSigField.getAttribute(XFA.PRESENCETAG).getAttrValue();
            if ("invisible".equals(presenceAttribute)) {
                return null;
            }
            XFACaption xfaCaption = XFAInternalUtils.getCaptionForField(xfaSigField);
            if (!xfaCaption.hasReserveAttribute()) {
                throw new PDFUnsupportedFeatureException("The xfa signature field caption has no reserve attribute and is not of fixed size.Not supported.");
            }
            BoxModelLayout boxModel = XFAInternalUtils.getBoxModelLayout(xfaSigField);
            if (boxModel == null) {
                throw new PDFUnsupportedFeatureException("The box model generated for this signature field is null.");
            }
            XFAInternalUtils.populateSigWidgetAPCharacteristics(this.sigField, boxModel);
            appearanceRect = XFAUtils.getWidgetBoundingBox(boxModel, xfaCaption);
            Locale ambientLocale = appearanceOptions.getAmbientLocale();
            Locale computedLocale = this.sigField.getPDFDocument().getDocumentLocale();
            String locale = null;
            locale = ambientLocale != null ? XFAUtils.getLocale(xfaSigField, ambientLocale.toString()) : XFAUtils.getLocale(xfaSigField, null);
            if (locale != null) {
                computedLocale = new Locale(locale);
            }
            appearanceOptions.setLocale(computedLocale);
        }
        return appearanceRect;
    }

    @Override
    public void calculateOffsetsAfterSave(InputByteStream inputByteStream) throws PDFSignatureException {
        try {
            Map<ASName, Integer> resultMap = SigningUtils.computeAllOffsetsOnce(this.signature);
            this.contentsOffset = SigningUtils.getContentsOffset(resultMap);
            if (this.contentsOffset == 0L) {
                throw new PDFSignatureException("Cannot write out the signature at offset 0. Wrong contents offset computed.");
            }
            this.byteRangeOffset = SigningUtils.getByteRangesOffset(resultMap);
            if (this.byteRangeOffset == 0L) {
                throw new PDFSignatureException("Cannot write out the byteranges at offset 0. Wrong byterange offset computed.");
            }
            int contentsSize = this.packageSize * 2;
            this.ranges[0] = 0L;
            this.ranges[1] = this.contentsOffset;
            this.ranges[2] = this.contentsOffset + (long)contentsSize + 2L;
            this.ranges[3] = inputByteStream.length() - this.ranges[2];
        }
        catch (PDFIOException e) {
            throw new PDFSignatureException("The InputByteStream representing the pdf document is erroneous", e);
        }
        catch (IOException e) {
            throw new PDFSignatureException("The InputByteStream representing the pdf document is erroneous", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSignatureAfterSave(SignatureOptions sigOptions, OutputByteStream outputByteStream) throws PDFSignatureException {
        try {
            StringBuilder byteRange = new StringBuilder(45);
            byteRange.append('[');
            for (int i = 0; i < this.ranges.length; ++i) {
                byteRange.append(this.ranges[i]);
                if (i >= this.ranges.length - 1) continue;
                byteRange.append(' ');
            }
            byteRange.append(']');
            while (byteRange.length() < 45) {
                byteRange.append(' ');
            }
            outputByteStream.seek(this.byteRangeOffset);
            outputByteStream.write(byteRange.toString().getBytes());
            InputByteStream ibs = this.pdfDoc.getCosDocument().getStream();
            this.signature.setByteRanges(this.ranges);
            CosArray cosByteRange = this.signature.getDictionaryArrayValue(ASName.k_ByteRange);
            cosByteRange.markNotDirty();
            PDFSignatureReferenceList sigRefs = this.signature.getSignatureReferences();
            if (sigRefs != null) {
                Map resultMap = null;
                CosDictionary sigDict = this.signature.getCosDictionary();
                long baseLoc = sigDict.getObjPos();
                Iterator iter = sigRefs.iterator();
                while (iter.hasNext()) {
                    PDFSignatureReference sigRef = PDFSignatureReference.getInstance(((PDFSignatureReference)iter.next()).getCosObject());
                    PDFTransformParameters transformParams = sigRef.getPDFTransformParameters();
                    ASName transformMethodName = sigRef.getTransformMethodName();
                    byte[] sigRefDigestValue = sigRef.getDigest();
                    if (sigRefDigestValue == null || transformMethodName != PDFSignature.k_DocMDP && transformMethodName != PDFSignature.k_FieldMDP) continue;
                    ObjectDigestMode odMode = ObjectDigestMode.Dummy;
                    if (sigOptions instanceof SignatureOptionsDocMDP && ((SignatureOptionsDocMDP)sigOptions).hasObjectDigestMode()) {
                        odMode = ((SignatureOptionsDocMDP)sigOptions).getObjectDigestMode();
                    }
                    if (odMode != ObjectDigestMode.Real && odMode != ObjectDigestMode.Dummy) continue;
                    if (resultMap == null) {
                        resultMap = SigningUtils.computeAllDigestOffsetsOnce(sigDict);
                    }
                    long digestLocationOffset = SigningUtils.getDigestLocationArrayOffset(sigRef, baseLoc, resultMap, transformMethodName);
                    long digestOffset = SigningUtils.getDigestStringOffset(sigRef, baseLoc, resultMap, transformMethodName);
                    long digestLength = sigRefDigestValue.length * 2 + 2;
                    StringBuilder digestLocation = new StringBuilder(23);
                    digestLocation.append('[');
                    digestLocation.append(digestOffset);
                    digestLocation.append(' ');
                    digestLocation.append(digestLength);
                    digestLocation.append(']');
                    while (digestLocation.length() < 23) {
                        digestLocation.append(' ');
                    }
                    outputByteStream.seek(digestLocationOffset);
                    outputByteStream.write(digestLocation.toString().getBytes());
                    sigRef.setDigestLocation(digestOffset, digestLength);
                    CosArray cosDigestLocation = sigRef.getDictionaryArrayValue(PDFSignatureReference.k_DigestLocation);
                    cosDigestLocation.markNotDirty();
                    ASName digestMethodName = sigRef.getDigestMethodName();
                    if (digestMethodName == null) {
                        digestMethodName = ASName.create(this.getDefaultTransformDigestMethod());
                    }
                    DocumentDigester digester = null;
                    MessageDigestFactory digestFactory = new MessageDigestFactory(digestMethodName.asString(true));
                    byte[] digestValue = null;
                    if (odMode == ObjectDigestMode.Real) {
                        ObjectSelector selector;
                        if (transformMethodName == PDFSignature.k_DocMDP) {
                            selector = null;
                            PDFDocMDPPermissions perms = ((PDFTransformParametersDocMDP)transformParams).getPermissions();
                            if (perms == PDFDocMDPPermissions.NoChanges) {
                                selector = new ObjectSelectorDocMDPNoChanges();
                            } else if (perms == PDFDocMDPPermissions.FormChanges) {
                                selector = new ObjectSelectorDocMDPFormChanges();
                            } else if (perms == PDFDocMDPPermissions.AnnotationFormChanges) {
                                selector = new ObjectSelectorDocMDPAnnotationFormChanges();
                            }
                            HashMap digestCache = new HashMap();
                            digester = new DocumentDigester(this.pdfDoc, digestFactory, digestCache, selector, this.sigField.getPDFField().getPDFFieldSignature());
                        } else if (transformMethodName == PDFSignature.k_FieldMDP) {
                            selector = null;
                            PDFTransformParametersFieldMDP fieldMDPParams = (PDFTransformParametersFieldMDP)transformParams;
                            PDFFieldAction action = fieldMDPParams.getAction();
                            if (action == PDFFieldAction.All) {
                                selector = new ObjectSelectorFieldMDPAll();
                            } else if (action == PDFFieldAction.Include) {
                                selector = new ObjectSelectorFieldMDPInclude(fieldMDPParams.getFieldNames());
                            } else if (action == PDFFieldAction.Exclude) {
                                selector = new ObjectSelectorFieldMDPExclude(fieldMDPParams.getFieldNames());
                            }
                            HashMap digestCache = new HashMap();
                            digester = new DocumentDigester(this.pdfDoc, digestFactory, digestCache, selector, this.sigField.getPDFField().getPDFFieldSignature());
                        } else {
                            throw new PDFInvalidParameterException("Invalid Transform method name " + transformMethodName);
                        }
                        digestValue = ((ObjectDigester)digester).digest();
                    } else if (odMode == ObjectDigestMode.Dummy) {
                        MessageDigest md = digestFactory.newMessageDigest();
                        digestValue = md.digest();
                    }
                    byte[] hexDigestValue = ByteOps.getHex(digestValue);
                    outputByteStream.seek(digestOffset + 1L);
                    outputByteStream.write(hexDigestValue);
                    if (sigRefDigestValue == null) continue;
                    CosString cosDigestValue = sigRef.getCosDictionary().getCosString(PDFSignatureReference.k_DigestValue);
                    cosDigestValue.setDataInternal(digestValue, false);
                }
            }
            RangeInputByteStream inputByteStream = null;
            InputStream inputStream = null;
            byte[] contents = null;
            try {
                inputByteStream = new RangeInputByteStream(ibs, this.ranges);
                inputStream = inputByteStream.toInputStream();
                contents = this.signer.sign(inputStream);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                finally {
                    if (inputByteStream != null) {
                        inputByteStream.close();
                    }
                }
            }
            if (contents.length > this.packageSize) {
                throw new PDFSignatureException("The estimate for the signature's content size (pre hex encoding) was too small");
            }
            byte[] contentsHex = ByteOps.getHex(contents);
            outputByteStream.seek(this.contentsOffset + 1L);
            outputByteStream.write(contentsHex);
            outputByteStream.flush();
            byte[] paddedContents = new byte[this.packageSize];
            System.arraycopy(contents, 0, paddedContents, 0, contents.length);
            CosString cosContents = this.signature.getCosDictionary().getCosString(ASName.k_Contents);
            cosContents.setDataInternal(paddedContents, false);
        }
        catch (IOException e) {
            throw new PDFSignatureException("IO exception with the PDF document to be signed", e);
        }
        catch (PDFIOException e) {
            throw new PDFSignatureException("IO exception with the PDF document to be signed", e);
        }
        catch (PDFCosParseException e) {
            throw new PDFSignatureException("The PDF document to be signed is invalid", e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFSignatureException("The PDF document to be signed is invalid", e);
        }
        catch (PDFSecurityException e) {
            throw new PDFSignatureException("Security exception with the PDF document to be signed", e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFSignatureException("Exception encountered when getting the hex value of the PKCS packet", e);
        }
    }

    private void setUserInfo(PDFSignature signature, UserInfo userInfo, Credentials credentials) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFSignatureException {
        if (userInfo != null) {
            String contactInfo;
            String reason;
            String location;
            String name = userInfo.getName();
            if (name != null) {
                signature.setName(name);
            }
            if ((location = userInfo.getLocation()) != null) {
                signature.setLocation(location);
            }
            if ((reason = userInfo.getReason()) != null) {
                signature.setReason(reason);
            }
            if ((contactInfo = userInfo.getContactInfo()) != null) {
                signature.setContactInfo(contactInfo);
            }
        }
        if (signature.getName() == null) {
            String subjectCN = null;
            if (credentials instanceof RSACredentials) {
                DNUtils dnUtil = new DNUtils(((RSACredentials)credentials).getRSAX509Cert().getSubjectName());
                subjectCN = dnUtil.getCommonNameRDN();
            } else if (credentials instanceof JCECredentials) {
                subjectCN = CertUtils.getCommonSubjectName(((JCECredentials)credentials).getCertificate());
            }
            signature.setName(subjectCN);
        }
    }

    private void setupReference(XFADigSigWorkFlow workFlow, PDFSignature signature, PDFSignatureReference sigReference, SignatureOptions sigOptions, List<String> fieldMDPLockList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        ASName transformName = sigReference.getTransformMethodName();
        if (transformName == PDFSignature.k_DocMDP) {
            this.setupTransformDocMDP(signature, sigReference, (SignatureOptionsDocMDP)sigOptions);
        } else if (transformName == PDFSignature.k_FieldMDP && this.sigField != null) {
            this.setupTransformFieldMDP(workFlow, sigReference, sigOptions, fieldMDPLockList);
        } else if (transformName == PDFSignature.k_UR || transformName == PDFSignature.k_UR3) {
            this.setupTransformUR(signature, sigReference, transformName);
        }
    }

    private void setupTransformDocMDP(PDFSignature signature, PDFSignatureReference sigReference, SignatureOptionsDocMDP sigOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFCatalog catalog = this.pdfDoc.requireCatalog();
        PDFPermissions pdfPerms = catalog.getPermissions();
        if (pdfPerms == null) {
            pdfPerms = PDFPermissions.newInstance(this.pdfDoc);
            catalog.setPermissions(pdfPerms);
        }
        pdfPerms.setDocMDP(signature);
        ObjectDigestMode odMode = ObjectDigestMode.Dummy;
        if (sigOptions.hasObjectDigestMode()) {
            odMode = sigOptions.getObjectDigestMode();
        }
        if (odMode == ObjectDigestMode.Real || odMode == ObjectDigestMode.Dummy) {
            ASName digestMethodName = sigReference.getDigestMethodName();
            if (digestMethodName == null) {
                digestMethodName = PDFSignature.k_MD5;
                sigReference.setDigestMethod(digestMethodName.asString(true));
            }
            MessageDigestFactory digestFactory = new MessageDigestFactory(digestMethodName.asString(true));
            MessageDigest dummyDigest = digestFactory.newMessageDigest();
            byte[] dummyDigestBytes = new byte[dummyDigest.digest().length];
            sigReference.setDigest(dummyDigestBytes);
            sigReference.setData(catalog.getCosObject());
        }
    }

    private void setupTransformFieldMDP(XFADigSigWorkFlow workFlow, PDFSignatureReference sigReference, SignatureOptions sigOptions, List<String> fieldMDPLockList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFTransformParametersFieldMDP transformParams = (PDFTransformParametersFieldMDP)sigReference.getPDFTransformParameters();
        SigFieldLock fieldLock = workFlow.getFieldLock();
        if (fieldLock != null) {
            PDFFieldAction action = fieldLock.getFieldAction();
            if (transformParams == null) {
                transformParams = PDFTransformParametersFieldMDP.newInstance(this.pdfDoc);
                sigReference.setPDFTransformParameters(transformParams);
            }
            transformParams.setAction(action);
            if (action != PDFFieldAction.All) {
                transformParams.setFieldNames(fieldMDPLockList.toArray(new String[fieldMDPLockList.size()]));
            }
        }
        ObjectDigestMode odMode = ObjectDigestMode.Dummy;
        if (sigOptions.hasObjectDigestMode()) {
            odMode = sigOptions.getObjectDigestMode();
        }
        if (odMode == ObjectDigestMode.Real || odMode == ObjectDigestMode.Dummy) {
            ASName digestMethodName = sigReference.getDigestMethodName();
            if (digestMethodName == null) {
                digestMethodName = PDFSignature.k_MD5;
                sigReference.setDigestMethod(digestMethodName.asString(true));
            }
            MessageDigestFactory digestFactory = new MessageDigestFactory(digestMethodName.asString(true));
            MessageDigest dummyDigest = digestFactory.newMessageDigest();
            byte[] dummyDigestBytes = new byte[dummyDigest.digest().length];
            sigReference.setDigest(dummyDigestBytes);
            sigReference.setData(this.pdfDoc.requireCatalog().getCosObject());
        }
    }

    private void setupTransformUR(PDFSignature signature, PDFSignatureReference sigReference, ASName transformName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFCatalog catalog = this.pdfDoc.requireCatalog();
        PDFPermissions pdfPerms = catalog.getPermissions();
        if (pdfPerms == null) {
            pdfPerms = PDFPermissions.newInstance(this.pdfDoc);
            catalog.setPermissions(pdfPerms);
        }
        if (transformName == PDFSignature.k_UR) {
            pdfPerms.setUR(signature);
            ASName digestMethodName = sigReference.getDigestMethodName();
            if (digestMethodName == null) {
                digestMethodName = PDFSignature.k_MD5;
                sigReference.setDigestMethod(digestMethodName.asString(true));
            }
            MessageDigestFactory digestFactory = new MessageDigestFactory(digestMethodName.asString(true));
            MessageDigest dummyDigest = digestFactory.newMessageDigest();
            byte[] dummyDigestBytes = new byte[dummyDigest.digest().length];
            sigReference.setDigest(dummyDigestBytes);
        } else if (transformName == PDFSignature.k_UR3) {
            pdfPerms.setUR3(signature);
        }
        sigReference.setData(catalog.getCosObject());
    }

    private void lockFields(PDFFieldAction action, PDFFieldNode[] fieldNodes, PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (action == PDFFieldAction.All) {
            PDFInteractiveForm iform = pdfDoc.requireCatalog().procureInteractiveForm();
            Iterator<PDFField> iter = iform.iterator();
            while (iter.hasNext()) {
                PDFField field = iter.next();
                this.lockFieldNode(field);
            }
        } else if (fieldNodes != null && fieldNodes.length != 0) {
            if (action == PDFFieldAction.Include) {
                for (int i = 0; i < fieldNodes.length; ++i) {
                    this.lockFieldNode(fieldNodes[i]);
                }
            } else if (action == PDFFieldAction.Exclude) {
                PDFInteractiveForm iform = pdfDoc.requireCatalog().procureInteractiveForm();
                Iterator<PDFField> iter = iform.iterator();
                while (iter.hasNext()) {
                    PDFFieldNode field = iter.next();
                    if (!field.dictionaryContains(ASName.k_T)) {
                        field = field.getInheritableValueFieldNode(ASName.k_T);
                    }
                    boolean exclude = false;
                    for (int i = 0; i < fieldNodes.length; ++i) {
                        if (field.getCosObject() != fieldNodes[i].getCosObject()) continue;
                        exclude = true;
                        break;
                    }
                    if (exclude) continue;
                    this.lockFieldNode(field);
                }
            }
        } else if (XFAService.getDocumentType(pdfDoc) == PDFDocument.PDFDocumentType.Acroform) {
            throw new PDFInvalidDocumentException("Field lock action is " + (Object)((Object)action) + " but the fields list to be locked is " + (fieldNodes == null ? "null." : "empty."));
        }
    }

    private void lockFieldNode(PDFFieldNode fieldNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldNode flaggedNode = fieldNode.getInheritableValueFieldNode(ASName.k_Ff);
        if (flaggedNode != null) {
            flaggedNode.setFlags(fieldNode.getFlags() | 1);
        } else {
            fieldNode.setFlags(fieldNode.getFlags() | 1);
        }
    }

    private String[] getLockedFieldNames(PDFTransformParametersFieldMDP fieldMDP) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldAction action = fieldMDP.getAction();
        if (action == PDFFieldAction.All) {
            ArrayList<String> lockedFieldNames = new ArrayList<String>();
            PDFInteractiveForm iform = this.pdfDoc.requireCatalog().procureInteractiveForm();
            Iterator<PDFField> iter = iform.iterator();
            while (iter.hasNext()) {
                PDFField field = iter.next();
                lockedFieldNames.add(field.getQualifiedName());
            }
            return lockedFieldNames.toArray(new String[lockedFieldNames.size()]);
        }
        if (action == PDFFieldAction.Include) {
            return fieldMDP.getFieldNames();
        }
        if (action == PDFFieldAction.Exclude) {
            String[] excludeFieldNames = fieldMDP.getFieldNames();
            ArrayList<String> lockedFieldNames = new ArrayList<String>();
            PDFInteractiveForm iform = this.pdfDoc.requireCatalog().procureInteractiveForm();
            Iterator<PDFField> iter = iform.iterator();
            while (iter.hasNext()) {
                PDFField field = iter.next();
                String fieldName = field.getQualifiedName();
                boolean excluded = false;
                for (int i = 0; i < excludeFieldNames.length; ++i) {
                    if (excludeFieldNames[i] == null || !excludeFieldNames[i].equals(fieldName)) continue;
                    excluded = true;
                    break;
                }
                if (excluded) continue;
                lockedFieldNames.add(fieldName);
            }
            return lockedFieldNames.toArray(new String[lockedFieldNames.size()]);
        }
        return null;
    }

    @Override
    public void setTimeStampProvider(TimeStampProvider tsProvider) {
        this.tsProvider = tsProvider;
    }

    @Override
    public TimeStampProvider getTimeStampProvider() {
        return this.tsProvider;
    }

    @Override
    public void setRevocationInfoProvider(RevocationInfoProvider revInfoProvider) {
        this.revInfoProvider = revInfoProvider;
    }

    @Override
    public RevocationInfoProvider getRevocationInfoProvider() {
        return this.revInfoProvider;
    }

    protected boolean ArrayContainsStringIgnoreCase(String[] strArray, String str) {
        for (int i = 0; i < strArray.length; ++i) {
            if (!str.equalsIgnoreCase(strArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean shouldGenerateAppearance(PDFAnnotationWidget annot, SignatureAppearanceOptions appearanceOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRectangle annotRect = annot.getRect();
        if (annotRect.hasNonZeroDimensions()) {
            return true;
        }
        if (appearanceOptions.hasInvisibleAppearanceSize()) {
            ASRectangle invRect = appearanceOptions.getInvisibleAppearanceSize();
            return invRect.hasNonZeroDimensions();
        }
        return false;
    }

    private int getFieldLockMDPSetting(XFADigSigWorkFlow workFlow) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        int defaultPermsValue = 4;
        if (workFlow != null) {
            PDFDocMDPPermissions perms;
            SigFieldLock fieldLock = workFlow.getFieldLock();
            PDFDocMDPPermissions pDFDocMDPPermissions = perms = fieldLock != null ? fieldLock.getFieldPermission() : null;
            if (perms != null) {
                defaultPermsValue = perms.getValue();
            }
        }
        return defaultPermsValue;
    }

    private void validateTransforms(XFADigSigWorkFlow workFlow, SignatureOptions sigOptions, SignatureValidationStatus sigValidationStatus) throws PDFSignatureException {
        try {
            DocModAnalyzerResult result;
            DocModAnalyzer analyzer;
            DocModAnalyzerParams dmaParams;
            PDFTransformParameters params;
            PDFSignatureReferenceList sigRefList = this.signature.getSignatureReferences();
            if (sigOptions == null) {
                sigOptions = SignatureOptions.newInstance();
            }
            boolean useYellowTriangleValidation = this.validateWithYellowTriangle(sigOptions);
            DocModAnalysisStatus docModAnalysisStatus = sigValidationStatus.getDocModAnalysisStatus();
            boolean enableA9Logic = false;
            if (useYellowTriangleValidation) {
                enableA9Logic = true;
            }
            int fieldMDPMode = this.getFieldMDPMode(workFlow);
            boolean isXFADocument = this.isXFADoc();
            XFAValidationContext xfaValidationContext = null;
            if (isXFADocument) {
                xfaValidationContext = this.createXFAValidationContext(sigOptions, fieldMDPMode);
                if (!this.runDocModAnalysis()) {
                    this.runXFAComparator(workFlow, useYellowTriangleValidation, sigOptions, xfaValidationContext, docModAnalysisStatus, sigValidationStatus, fieldMDPMode);
                    return;
                }
            }
            if (SignatureUtils.isRecipientSignature(this.signature)) {
                if (useYellowTriangleValidation) {
                    DocModAnalyzerParams dmaParams2 = new DocModAnalyzerParams(this.pdfDoc, this.signature.getCosObject(), DocModAnalyzerParams.DocModAnalysisMode.values()[this.getFieldLockMDPSetting(workFlow)], enableA9Logic, xfaValidationContext, null);
                    DocModAnalyzer analyzer2 = sigOptions.getDocModAnalyzer();
                    DocModAnalyzerResult result2 = analyzer2.doModAnalysis(dmaParams2);
                    if (!result2.docModsValid()) {
                        docModAnalysisStatus.appendStatus(1L);
                    }
                    if (result2.isFormModified()) {
                        docModAnalysisStatus.appendStatus(8L);
                    }
                    if (result2.isXFAFormModified()) {
                        sigValidationStatus.setXFAFormModified(true);
                    }
                } else if (isXFADocument) {
                    this.runXFAComparator(workFlow, useYellowTriangleValidation, sigOptions, xfaValidationContext, docModAnalysisStatus, sigValidationStatus, fieldMDPMode);
                }
            }
            if (SignatureUtils.isAuthorSignature(this.signature)) {
                params = null;
                for (PDFSignatureReference sigRef : sigRefList) {
                    if (sigRef.getTransformMethodName() != PDFSignature.k_DocMDP) continue;
                    params = (PDFTransformParametersDocMDP)sigRef.getPDFTransformParameters();
                }
                PDFDocMDPPermissions perms = params.getPermissions();
                dmaParams = new DocModAnalyzerParams(this.pdfDoc, this.signature.getCosObject(), DocModAnalyzerParams.DocModAnalysisMode.values()[perms.getValue()], enableA9Logic, xfaValidationContext, null);
                analyzer = sigOptions.getDocModAnalyzer();
                result = analyzer.doModAnalysis(dmaParams);
                if (!result.docModsValid()) {
                    docModAnalysisStatus.appendStatus(2L);
                }
                if (result.isFormModified() && useYellowTriangleValidation) {
                    docModAnalysisStatus.appendStatus(8L);
                }
                if (result.isXFAFormModified()) {
                    sigValidationStatus.setXFAFormModified(true);
                }
            }
            if (SignatureUtils.hasFieldMDPRestrictions(this.signature)) {
                if (XFAService.getDocumentType(this.pdfDoc).isDynamic()) {
                    if (workFlow != null) {
                        workFlow.verifyFieldMDP(xfaValidationContext, docModAnalysisStatus);
                    }
                } else {
                    params = null;
                    for (PDFSignatureReference sigRef : sigRefList) {
                        if (sigRef.getTransformMethodName() != PDFSignature.k_FieldMDP) continue;
                        params = (PDFTransformParametersFieldMDP)sigRef.getPDFTransformParameters();
                    }
                    String[] lockedFieldNames = this.getLockedFieldNames((PDFTransformParametersFieldMDP)params);
                    dmaParams = new DocModAnalyzerParams(this.pdfDoc, this.signature.getCosObject(), DocModAnalyzerParams.DocModAnalysisMode.MDPFieldMode, enableA9Logic, xfaValidationContext, lockedFieldNames);
                    analyzer = sigOptions.getDocModAnalyzer();
                    result = analyzer.doModAnalysis(dmaParams);
                    if (!result.docModsValid()) {
                        docModAnalysisStatus.appendStatus(4L);
                    }
                    if (result.isFormModified() && useYellowTriangleValidation) {
                        docModAnalysisStatus.appendStatus(8L);
                    }
                    if (result.isXFAFormModified()) {
                        sigValidationStatus.setXFAFormModified(true);
                    }
                }
            }
            if (sigOptions != null) {
                sigValidationStatus.setXFAChangeLogger(sigOptions.getXFAChangeLogger());
            }
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFSignatureException(e);
        }
        catch (PDFIOException e) {
            throw new PDFSignatureException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFSignatureException(e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFSignatureException(e);
        }
        catch (PDFInvalidXMLException e) {
            throw new PDFSignatureException(e);
        }
        catch (PDFConfigurationException e) {
            throw new PDFSignatureException(e);
        }
    }

    private void runXFAComparator(XFADigSigWorkFlow workFlow, boolean useYellowTriangleValidation, SignatureOptions sigOptions, XFAValidationContext xfaValidationContext, DocModAnalysisStatus docModAnalysisStatus, SignatureValidationStatus sigValidationStatus, int fieldMDPMode) throws PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFInvalidXMLException, PDFConfigurationException {
        try {
            XFAVersionComparator versionComparator = new XFAVersionComparator(this.signature.getPDFDocument(), null, XFAVersionComparator.DSMDPType.MDPCommentsAndDefault, null, DocModAnalyzerParams.DocModAnalysisMode.values()[fieldMDPMode], xfaValidationContext);
            XFAChangeLogger changeLogger = sigOptions.getXFAChangeLogger();
            if (sigOptions.XFAChangeRecordingEnabled()) {
                changeLogger.enableChangeLogging();
            }
            versionComparator.initComparator(XFAVersionComparator.DSMDPType.MDPAllowNone, changeLogger, DocModAnalyzerParams.DocModAnalysisMode.MDPAllowNone);
            versionComparator.compareXFAVersions();
            if (changeLogger.isFormModified()) {
                if (useYellowTriangleValidation) {
                    docModAnalysisStatus.appendStatus(8L);
                }
                sigValidationStatus.setXFAFormModified(true);
            }
            sigValidationStatus.setXFAChangeLogger(sigOptions.getXFAChangeLogger());
            if (XFAService.getDocumentType(this.pdfDoc).isDynamic() && SignatureUtils.hasFieldMDPRestrictions(this.signature) && workFlow != null) {
                workFlow.verifyFieldMDP(xfaValidationContext, docModAnalysisStatus);
            }
            return;
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFInvalidParameterException(e);
        }
    }

    XFAValidationContext createXFAValidationContext(SignatureOptions sigOptions, int fieldMDPMode) throws PDFSignatureException, PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        try {
            boolean forceRecreate = false;
            return new XFAValidationContext(this.signature, sigOptions, DocModAnalyzerParams.DocModAnalysisMode.values()[fieldMDPMode], forceRecreate);
        }
        catch (PDFUnsupportedFeatureException e) {
            throw new PDFSignatureException("Could not create xfa validation context - Unsupported Feature Exception", e);
        }
    }

    private boolean isXFADoc() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return XFAService.getDocumentType(this.pdfDoc).isXFA();
    }

    private boolean runDocModAnalysis() throws PDFIOException {
        CosDocument curCosDoc;
        long rbEOF = this.signature.getCosObject().getObjEOF();
        return rbEOF != (curCosDoc = this.signature.getPDFDocument().getCosDocument()).getEOF() || curCosDoc.isDirty();
    }

    private int getFieldMDPMode(XFADigSigWorkFlow workFlow) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (SignatureUtils.isRecipientSignature(this.signature)) {
            return this.getFieldLockMDPSetting(workFlow);
        }
        PDFTransformParametersDocMDP params = null;
        PDFSignatureReferenceList sigRefList = this.signature.getSignatureReferences();
        for (PDFSignatureReference sigRef : sigRefList) {
            if (sigRef.getTransformMethodName() != PDFSignature.k_DocMDP) continue;
            params = (PDFTransformParametersDocMDP)sigRef.getPDFTransformParameters();
        }
        PDFDocMDPPermissions perms = params.getPermissions();
        if (perms != null) {
            return perms.getValue();
        }
        return 4;
    }

    private byte[] createDERCert(Credentials credentials) throws PDFInvalidParameterException {
        byte[] derCert = null;
        try {
            derCert = credentials instanceof RSACredentials || credentials instanceof HSMCredentials ? RSASigningUtils.createDERCertFromRSA((RSACredentials)credentials) : ((JCECredentials)credentials).getCertificate().getEncoded();
        }
        catch (CertificateEncodingException e1) {
            throw new PDFInvalidParameterException("Cannot get encoded certificate", e1);
        }
        return derCert;
    }

    private byte[][] createDERCertArray(Credentials credentials) throws PDFInvalidParameterException {
        byte[][] derCerts = null;
        try {
            derCerts = credentials instanceof RSACredentials ? RSASigningUtils.buildDERCertChainFromRSA((RSACredentials)credentials) : SignatureHandlerPPKLite.buildDERCertChain(((JCECredentials)credentials).getCertificateChain());
        }
        catch (CertificateEncodingException e1) {
            throw new PDFInvalidParameterException("Cannot get encoded certificate chain", e1);
        }
        catch (CertificateException e) {
            throw new PDFInvalidParameterException("Cannot get encoded certificate chain", e);
        }
        return derCerts;
    }

    private static byte[][] buildDERCertChain(Certificate[] certChain) throws CertificateEncodingException, CertificateException {
        if (certChain != null) {
            byte[][] derCertChain = new byte[certChain.length][];
            for (int i = 0; i < certChain.length; ++i) {
                X509Certificate javaCert = (X509Certificate)certChain[i];
                derCertChain[i] = javaCert.getEncoded();
            }
            return derCertChain;
        }
        return null;
    }

    private boolean certChainPresent(Credentials credentials) {
        return credentials instanceof RSACredentials || credentials instanceof HSMCredentials ? ((RSACredentials)credentials).getRSAX509CertChain() != null : ((JCECredentials)credentials).getCertificateChain() != null;
    }

    @Override
    public PDFFilterBuildData setUpPDFFilterBuildPropValues() throws PDFSignatureException {
        try {
            String debugTag;
            int debugJarUsed;
            PDFFilterBuildData filterDict = PDFFilterBuildData.newInstance(this.signature.getPDFDocument());
            filterDict.setName("AdobePDFJavaToolkit.PPKLite");
            filterDict.setPreRelease(false);
            String date = JarManifestLoader.getInstance().getDate();
            String revNumber = JarManifestLoader.getInstance().getRevNumber();
            if (revNumber == null) {
                revNumber = "0.0";
            }
            if ((debugJarUsed = revNumber.indexOf(debugTag = "DEBUG-")) != -1) {
                filterDict.setRevNumber(revNumber.substring(debugTag.length()));
            } else {
                filterDict.setRevNumber(revNumber);
            }
            if (date != null) {
                filterDict.setDate(date);
            }
            return filterDict;
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFSignatureException("The pdf document is invalid", e);
        }
        catch (PDFIOException e) {
            throw new PDFSignatureException("IOException encountered when setting filter build dict entries", e);
        }
        catch (PDFSecurityException e) {
            throw new PDFSignatureException("Security exception encountered when obtaining the PDF document", e);
        }
    }

    public boolean contentsDataValid(InputByteStream ibs, int contentsStartPosition, int contentsEndPosition) throws IOException {
        ibs.seek(contentsStartPosition);
        char charAtStartOffset = (char)ibs.read();
        if (charAtStartOffset != '<') {
            ibs.seek(0L);
            return false;
        }
        ibs.seek(contentsEndPosition);
        char charAtLastOffset = (char)ibs.read();
        if (charAtLastOffset != '>') {
            ibs.seek(0L);
            return false;
        }
        ibs.seek(contentsStartPosition + 1);
        for (int pos = contentsStartPosition + 1; pos < contentsEndPosition; ++pos) {
            char charRead = (char)ibs.read();
            if (charRead != '<' && charRead != '>') continue;
            ibs.seek(0L);
            return false;
        }
        ibs.seek(0L);
        return true;
    }

    boolean validateWithYellowTriangle(SignatureOptions sigOptions) {
        if (sigOptions == null) {
            return false;
        }
        return sigOptions.useA9Validation();
    }

    private List<String> doFieldMDPLock(PDFDocument pdfDoc, SignatureFieldInterface sigField, boolean isCertifyingSignatureField, XFADigSigWorkFlow workFlow) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        SigFieldLock fieldLock = sigField.getFieldLock();
        if (!workFlow.isFormModelWorkFlow() || sigField.getXFAField() == null) {
            if (isCertifyingSignatureField) {
                this.mergeCertifyingSigFieldToLockFields(sigField);
            }
            List<String> fieldNames = fieldLock.getFieldList();
            this.lockFields(fieldLock.getFieldAction(), fieldNames != null ? PDFFieldUtils.searchFields(fieldNames.toArray(new String[fieldNames.size()]), pdfDoc) : null, pdfDoc);
            return fieldNames;
        }
        if (XFAService.getDocumentType(pdfDoc).isXFA()) {
            FieldMDP fieldMDP = new FieldMDP(pdfDoc, sigField);
            List<String> lockableNodes = fieldMDP.applyFieldMDP(isCertifyingSignatureField);
            if (XFAService.getDocumentType(pdfDoc) == PDFDocument.PDFDocumentType.StaticNonShellXFA) {
                this.lockFields(PDFFieldAction.Include, lockableNodes != null ? PDFFieldUtils.searchFields(lockableNodes.toArray(new String[lockableNodes.size()]), pdfDoc) : null, pdfDoc);
            }
            if (fieldLock.getFieldAction() == PDFFieldAction.Exclude) {
                ArrayList<String> excludedFields = new ArrayList<String>();
                fieldMDP.resolveTemplateReferencesInclude(fieldMDP.populateFieldNames, excludedFields, fieldMDP.getManifestNode());
                return excludedFields;
            }
            return lockableNodes;
        }
        return null;
    }

    private void mergeCertifyingSigFieldToLockFields(SignatureFieldInterface sigField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        SigFieldLock sigFieldLock = sigField.getFieldLock();
        List<String> fieldList = sigFieldLock.getFieldList();
        ArrayList<String> newFieldList = null;
        boolean isModified = false;
        PDFFieldAction action = sigFieldLock.getFieldAction();
        if (action == PDFFieldAction.Include) {
            newFieldList = new ArrayList<String>();
            if (fieldList != null) {
                if (!newFieldList.contains(sigField.getQualifiedName())) {
                    for (int i = 0; i < fieldList.size(); ++i) {
                        newFieldList.add(fieldList.get(i));
                    }
                    newFieldList.add(sigField.getQualifiedName());
                    isModified = true;
                }
            } else {
                newFieldList.add(sigField.getQualifiedName());
                isModified = true;
            }
        }
        if (isModified) {
            sigFieldLock.setFieldList(newFieldList);
            sigField.setFieldLock(sigFieldLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SignatureValidationStatus validateAPIWrapper(PDFDocument pdfDoc, XFADigSigWorkFlow workFlow, PDFSignature signature, SignatureOptions sigOptions, SignatureServiceProvider sigServiceProvider) throws PDFSignatureException {
        try {
            SignatureFieldInterface sigField = workFlow.getSignatureField();
            if (sigField != null) {
                if (!sigField.isSigned()) throw new PDFSignatureException("Signature Field passed for validation is not signed.");
                this.signature = sigField.getPDFField().getPDFFieldSignature().getSignature();
            } else {
                this.signature = signature;
            }
            this.sigField = sigField;
            signature = this.signature;
            this.pdfDoc = pdfDoc;
            SignatureValidationStatus sigValidationStatus = new SignatureValidationStatus(this.signature);
            byte[][] derCertChain = this.signature.getCertificates();
            VerifierFactory verifierFactory = VerifierFactory.newInstance(PDFSignatureSubFilter.getInstance(this.signature.getSubFilterName()));
            Verifier verifier = verifierFactory.newVerifier(sigServiceProvider, derCertChain);
            long[] ranges = this.signature.getByteRanges();
            if (ranges == null) {
                throw new PDFInvalidParameterException("Missing byterange entry for signature");
            }
            InputByteStream ibs = null;
            InputStream inputStream = null;
            InputByteStream rangeIBS = null;
            boolean byteRangeValid = false;
            try {
                ibs = pdfDoc.getCosDocument().getStream();
                byteRangeValid = this.contentsDataValid(ibs, (int)ranges[1], (int)(ranges[2] - 1L));
                if (!byteRangeValid) {
                    sigValidationStatus.setByteRangeValid(byteRangeValid);
                    SignatureValidationStatus signatureValidationStatus = sigValidationStatus;
                    return signatureValidationStatus;
                }
                rangeIBS = new RangeInputByteStream(ibs, ranges);
                byte[] sigBytes = SignatureUtils.getContents(this.signature);
                inputStream = rangeIBS.toInputStream();
                byteRangeValid = verifier.verify(inputStream, sigBytes);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                finally {
                    try {
                        if (rangeIBS != null) {
                            rangeIBS.close();
                        }
                    }
                    finally {
                        if (ibs != null) {
                            ibs.close();
                        }
                    }
                }
            }
            sigValidationStatus.setByteRangeValid(byteRangeValid);
            boolean useYellowTriangleValidation = this.validateWithYellowTriangle(sigOptions);
            if (!byteRangeValid) return sigValidationStatus;
            if (!(useYellowTriangleValidation || SignatureUtils.isAuthorSignature(signature) || SignatureUtils.hasFieldMDPRestrictions(signature))) {
                if (!this.isXFADoc()) return sigValidationStatus;
            }
            this.validateTransforms(workFlow, sigOptions, sigValidationStatus);
            return sigValidationStatus;
        }
        catch (PDFIOException e) {
            throw new PDFSignatureException("IO exception with the signature being verified", e);
        }
        catch (IOException e) {
            throw new PDFSignatureException("IO exception with the signature being verified", e);
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFSignatureException("The PDF document to be verified is invalid", e);
        }
        catch (PDFConfigurationException e) {
            throw new PDFSignatureException("Problem with the configuration of the third party rsa libs", e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFSignatureException("Invalid parameter found while validating signature", e);
        }
        catch (PDFSecurityException e) {
            throw new PDFSignatureException("Security exception with the PDF document to be verified", e);
        }
    }

    @Override
    public SignatureValidationStatus validate(PDFDocument pdfDoc, SignatureFieldInterface sigField, SignatureOptions sigOptions, SignatureServiceProvider sigServiceProvider) throws PDFSignatureException {
        return this.validateAPIWrapper(pdfDoc, new FormModelWorkFlow(sigField), null, sigOptions, sigServiceProvider);
    }
}

