/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFPermissions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.WinAnsiEncoding;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFXFAArray;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFXFAPacket;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFXFAStream;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFMarkInfo;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentArray;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureMCID;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRole;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoleMap;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoot;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureUtils;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldPDF;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureManager;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;

public class LeanDocGenerator {
    static final ASName DefaultFontName = ASName.create("T1_0");
    private static final String BoilerPlatePgMsg1Acro81 = "To view the full contents of this document, you need a later version of  the PDF viewer. You can upgrade";
    private static final String BoilerPlateMsg2Acro81 = "to the latest version of Adobe Reader from www.adobe.com/products/acrobat/readstep2.html";
    private static final String BoilerPlateMsg3Acro81 = "For further support, go to www.adobe.com/support/products/acrreader.html";

    private static void mergeIncrementalSections(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfDoc.getNumRevisions() > 1) {
            PDFSignature ur;
            long lastSignedEOF = -1L;
            PDFSignature lastSignatureApplied = null;
            PDFPermissions perms = pdfDoc.requireCatalog().getPermissions();
            if (perms != null && (ur = perms.getUR()) != null) {
                lastSignatureApplied = ur;
                lastSignedEOF = pdfDoc.getCosDocument().getObjEOF(ur.getCosObject());
            }
            SignatureManager sigMgr = SignatureManager.newInstance(pdfDoc);
            Iterator<SignatureFieldInterface> itr = sigMgr.getPDFSignatureFieldIterator();
            SignatureFieldInterface sigField = null;
            PDFSignature signature = null;
            long eof = -1L;
            while (itr.hasNext()) {
                sigField = itr.next();
                if (!sigField.isSigned()) continue;
                signature = sigField.getPDFField().getPDFFieldSignature().getSignature();
                eof = pdfDoc.getCosDocument().getObjEOF(signature.getCosObject());
                if (eof <= lastSignedEOF) continue;
                lastSignedEOF = eof;
                lastSignatureApplied = signature;
            }
            if (lastSignatureApplied == null || lastSignedEOF <= 0L) {
                return;
            }
            LeanDocGenerator.markRequiredObjectsDirty(pdfDoc);
            pdfDoc.getCosDocument().setNextIncrementalSectionOffset(lastSignedEOF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void markRequiredObjectsDirty(PDFDocument pdfDoc) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        block10: {
            try {
                PDFXFAStream xfaStream;
                PDFInteractiveForm iForm;
                CosDocument currentDoc = pdfDoc.getCosDocument();
                CosDictionary currentCatalog = currentDoc.getRoot();
                CosObject metadata = currentCatalog.get(ASName.k_Metadata);
                if (metadata instanceof CosStream && !metadata.isDirty()) {
                    ((CosStream)metadata).newDataDecoded(((CosStream)metadata).getStreamDecoded());
                }
                if ((iForm = pdfDoc.requireCatalog().getInteractiveForm()) == null) {
                    return;
                }
                if (iForm.xfaIsArray()) {
                    PDFXFAArray xfaArray = iForm.getXFAAsArray();
                    Iterator<PDFXFAPacket> itr = xfaArray.iterator();
                    PDFXFAPacket xfaPacket = null;
                    while (itr.hasNext()) {
                        xfaPacket = itr.next();
                        InputByteStream ibs = xfaPacket.getDataStream().getCosStream().getStreamDecoded();
                        try {
                            xfaArray.update(xfaPacket.getPacketName(), ibs.toInputStream());
                        }
                        finally {
                            if (ibs == null) continue;
                            ibs.close();
                        }
                    }
                    break block10;
                }
                if (iForm.xfaIsStream() && (xfaStream = iForm.getXFAAsStream()) != null) {
                    xfaStream.getCosStream().newDataDecoded(xfaStream.getCosStream().getStreamDecoded());
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }

    public static void generateLeanDocument(PDFDocument pdfDoc, boolean mergeIncrementalSections) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFSignatureException, PDFInvalidParameterException {
        if (XFAService.getDocumentType(pdfDoc).isDynamic()) {
            if (mergeIncrementalSections) {
                LeanDocGenerator.mergeIncrementalSections(pdfDoc);
            }
            try {
                LeanDocGenerator.generateNewPageAndStructure(pdfDoc);
            }
            catch (UnsupportedEncodingException e) {
                throw new PDFSignatureException("Unsupported Encoding exception caught while creating boiler plate page for lean document generation.", e);
            }
            PDFPage page = pdfDoc.requirePages().getPage(0);
            PDFInteractiveForm iForm = pdfDoc.getInteractiveForm();
            Iterator<PDFField> itr = iForm.iterator();
            PDFField field = null;
            while (itr.hasNext()) {
                field = itr.next();
                if (!(field instanceof PDFFieldSignature) || !new SignatureFieldPDF((PDFFieldSignature)field).isSigned()) {
                    itr.remove();
                    continue;
                }
                page.addAnnotation(((PDFFieldSignature)field).getAnnotation());
            }
            pdfDoc.requireCatalog().setNeedsRendering(true);
            LeanDocGenerator.ensureAcroformDAEntry(pdfDoc);
        }
    }

    private static void generateNewPageAndStructure(PDFDocument bloatedDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFSignatureException, UnsupportedEncodingException, PDFInvalidParameterException {
        PDFRectangle mediaBox = PDFRectangle.newInstance(bloatedDoc, 0.0, 0.0, 612.0, 792.0);
        PDFPage emptyPage = PDFPage.newInstance(bloatedDoc, mediaBox);
        PDFPageTree.newInstance(bloatedDoc, emptyPage);
        LeanDocGenerator.generatePageContent(emptyPage);
    }

    private static void ensureAcroformDAEntry(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFInteractiveForm iform = pdfDoc.getInteractiveForm();
        String defaultAP = iform.getDefaultAppearance();
        if (defaultAP == null || defaultAP.trim().length() == 0) {
            iform.setDictionaryStringValue(ASName.k_DA, "/Helv 0 Tf 0 g");
        }
    }

    private static void generatePageContent(PDFPage oPage) throws PDFSignatureException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException, UnsupportedEncodingException, PDFInvalidParameterException {
        if (oPage == null) {
            throw new PDFSignatureException("Null page. Cannot generate page content");
        }
        PDFContents oPDEPageContent = PDFContents.newInstance(oPage.getPDFDocument());
        PDFResources resources = PDFResources.newInstance(oPage.getPDFDocument());
        PDFSimpleFontEncoding fontEncoding = PDFSimpleFontEncoding.newInstance(oPage.getPDFDocument(), WinAnsiEncoding.getEncoding());
        PDFFontSimple defaultFont = PDFFontSimple.newInstance(oPage.getPDFDocument(), ASName.k_Helvetica, ASName.k_Type1);
        defaultFont.setEncoding(fontEncoding);
        PDFFontMap drFontMap = PDFFontMap.newInstance(oPage.getPDFDocument());
        drFontMap.set(DefaultFontName, defaultFont);
        resources.setFontMap(drFontMap);
        resources.setProcSetList(new ASName[]{ASName.k_PDF, ASName.k_Text});
        oPage.setResources(resources);
        ContentWriter contentWriter = ContentWriter.newInstance(ModifiableContent.newInstance(oPDEPageContent, resources));
        contentWriter.write(InstructionFactory.newBeginText());
        ASDictionary mParams = new ASDictionary();
        mParams.put(ASName.k_MCID, new ASNumber(0));
        contentWriter.write(InstructionFactory.newBeginMarkedContent(ASName.create("Content"), mParams));
        contentWriter.write(InstructionFactory.newDeviceRGBFill(0.0, 0.0, 0.0));
        contentWriter.write(InstructionFactory.newRelativeColorimetric());
        contentWriter.write(InstructionFactory.newTextFont(DefaultFontName, 1.0));
        contentWriter.write(InstructionFactory.newTextMatrix(10.0, 0.0, 0.0, 10.0, 72.0, 712.104));
        contentWriter.write(InstructionFactory.newShowText(BoilerPlatePgMsg1Acro81.getBytes("UTF-8")));
        contentWriter.write(InstructionFactory.newTextPositionAndLeading(0.0, -1.2));
        contentWriter.write(InstructionFactory.newShowText(BoilerPlateMsg2Acro81.getBytes("UTF-8")));
        contentWriter.write(InstructionFactory.newTextNextLine());
        contentWriter.write(InstructionFactory.newShowText("".getBytes("UTF-8")));
        contentWriter.write(InstructionFactory.newTextNextLine());
        contentWriter.write(InstructionFactory.newShowText(BoilerPlateMsg3Acro81.getBytes("UTF-8")));
        contentWriter.write(InstructionFactory.newEndMarkedContent());
        contentWriter.write(InstructionFactory.newEndText());
        Content newContent = contentWriter.close();
        oPage.setContents(newContent.getContents());
        LeanDocGenerator.generateStructure(oPage);
    }

    private static void generateStructure(PDFPage oPage) throws PDFSignatureException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFCatalog catalog = oPage.getPDFDocument().requireCatalog();
        PDFMarkInfo markInfo = PDFMarkInfo.newInstance(oPage.getPDFDocument());
        markInfo.setMarked(true);
        catalog.setMarkInfo(markInfo);
        catalog.removeValue(ASName.k_StructTreeRoot);
        PDFStructureRoot structRoot = PDFStructureRoot.newInstance(oPage.getPDFDocument());
        PDFStructureElement docElem = PDFStructureElement.newInstance(oPage.getPDFDocument(), PDFStructureRole.k_Document, structRoot);
        structRoot.setDictionaryValue(ASName.k_K, docElem);
        PDFStructureElement pageElem = PDFStructureElement.newInstance(oPage.getPDFDocument(), PDFStructureRole.k_P, docElem);
        PDFStructureElement divElem = PDFStructureElement.newInstance(oPage.getPDFDocument(), PDFStructureRole.k_Div, docElem);
        divElem.setDictionaryValue(ASName.k_K, PDFStructureElement.newInstance(oPage.getPDFDocument(), PDFStructureRole.k_P, divElem));
        pageElem.setDictionaryValue(ASName.k_Pg, oPage);
        divElem.setDictionaryValue(ASName.k_K, pageElem);
        docElem.setDictionaryValue(ASName.k_K, divElem);
        PDFStructureRoleMap roleMap = PDFStructureRoleMap.newInstance(oPage.getPDFDocument());
        roleMap.addRole(ASName.create("Draw"), PDFStructureRole.k_Div);
        roleMap.addRole(ASName.create("Field"), PDFStructureRole.k_Div);
        roleMap.addRole(ASName.create("Subform"), PDFStructureRole.k_Sect);
        roleMap.addRole(ASName.k_Page, PDFStructureRole.k_Part);
        structRoot.setRoleMap(roleMap);
        PDFStructureContentArray pdfStructArray = PDFStructureContentArray.newInstance(oPage.getPDFDocument(), pageElem);
        pageElem.addContent(PDFStructureMCID.newInstance(oPage.getPDFDocument(), 0));
        PDFStructureUtils.setStructParentsInTree(pdfStructArray, oPage);
    }
}

