/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStoreBuilder;
import org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import org.bouncycastle.cert.selector.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.bc.BcRSASignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TSPValidationException;
import org.bouncycastle.tsp.TimeStampToken;

class BCUtilities {
    static final Provider provider = new BouncyCastleProvider();

    BCUtilities() {
    }

    static boolean verifyTimestampToken(TimeStampToken timeStampToken) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, CertStoreException, GeneralSecurityException, IOException {
        Security.addProvider(provider);
        SignerId signer_id = timeStampToken.getSID();
        JcaX509CertSelectorConverter conv = new JcaX509CertSelectorConverter();
        X509CertificateHolderSelector sel = new X509CertificateHolderSelector(signer_id.getIssuer(), signer_id.getSerialNumber());
        X509CertSelector signerConstraints = conv.getCertSelector(sel);
        JcaCertStoreBuilder storeBuilder = new JcaCertStoreBuilder();
        storeBuilder.addCertificates(timeStampToken.getCertificates());
        storeBuilder.addCRLs(timeStampToken.getCRLs());
        CertStore cs = storeBuilder.build();
        Collection<? extends Certificate> certs = cs.getCertificates(signerConstraints);
        if (certs == null) {
            certs = cs.getCertificates(null);
        }
        Iterator<? extends Certificate> iter = certs.iterator();
        BcRSASignerInfoVerifierBuilder infoBuilder = new BcRSASignerInfoVerifierBuilder((CMSSignatureAlgorithmNameGenerator)new DefaultCMSSignatureAlgorithmNameGenerator(), (SignatureAlgorithmIdentifierFinder)new DefaultSignatureAlgorithmIdentifierFinder(), (DigestAlgorithmIdentifierFinder)new DefaultDigestAlgorithmIdentifierFinder(), (DigestCalculatorProvider)new BcDigestCalculatorProvider());
        while (iter.hasNext()) {
            X509Certificate certificate = (X509Certificate)iter.next();
            try {
                SignerInformationVerifier sigVerifier = infoBuilder.build(new X509CertificateHolder(certificate.getEncoded()));
                timeStampToken.validate(sigVerifier);
                return true;
            }
            catch (OperatorCreationException e) {
            }
            catch (TSPValidationException e) {
            }
            catch (TSPException e) {
            }
        }
        return false;
    }

    static ASN1Encodable getASN1EncodableAttributeValue(Attribute attribute) {
        ASN1Set valuesSet = attribute.getAttrValues();
        if (valuesSet != null) {
            return valuesSet.getObjectAt(0);
        }
        return null;
    }

    static byte[] getASN1EncodedAttributeValue(Attribute attribute) {
        ASN1Object valueAsDerObject;
        ASN1Encodable derEncodedValueAt0 = BCUtilities.getASN1EncodableAttributeValue(attribute);
        if (derEncodedValueAt0 != null && (valueAsDerObject = (ASN1Object)derEncodedValueAt0) != null) {
            try {
                return valueAsDerObject.getEncoded();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

