/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.impl;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.inlineformatting.css20.CSS20FontDescription;
import com.adobe.internal.afml.AFMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.fontset.impl.PDFFontSetImpl;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentModifier;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearanceCharacteristics;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderStyle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFIconFit;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.ap.AppearanceAttributes;
import com.adobe.internal.pdftoolkit.services.ap.extension.APExtensionException;
import com.adobe.internal.pdftoolkit.services.ap.extension.ButtonApProvider;
import com.adobe.internal.pdftoolkit.services.ap.impl.AppearanceUtils;
import com.adobe.internal.pdftoolkit.services.ap.impl.PushButtonXFACaptionFormatter;
import com.adobe.internal.pdftoolkit.services.ap.impl.SimpleTextFormatterImpl;
import com.adobe.internal.pdftoolkit.services.ap.impl.TextAppearance;
import com.adobe.internal.pdftoolkit.services.ap.impl.TextRegion;
import com.adobe.internal.pdftoolkit.services.ap.spi.APResources;
import com.adobe.internal.pdftoolkit.services.fontresources.FontResources;
import com.adobe.internal.pdftoolkit.services.pdfport.PDFPort;
import com.adobe.internal.pdftoolkit.services.rcg.RCGAlignment;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextHandler;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;

public class PushButtonApProviderImpl
implements ButtonApProvider {
    private static final String ICON_XOBJECT_KEY = "FRM";
    private HashMap<Font, PDFFont> afePDFFontMap;
    private PDFFontSet pdfFontSet;
    private PDFDocument pdfDoc;
    private PDFResources defResources;
    private Locale locale;
    private static double AUTO_SIZE_FACTOR = 0.3333333333333333;

    private PushButtonApProviderImpl(APResources apResources, PDFDocument pdfDoc, PDFResources defResources) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        this.afePDFFontMap = apResources.getAfePDFFontMap();
        this.pdfFontSet = apResources.getSystemFonts();
        this.pdfDoc = pdfDoc;
        this.locale = apResources.getLocale();
        this.defResources = defResources;
    }

    public static PushButtonApProviderImpl getInstance(APResources apResources, PDFDocument pdfDoc) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        if (pdfDoc == null) {
            throw new PDFInvalidParameterException("PDFDocument cant be passed as null");
        }
        PDFInteractiveForm form = pdfDoc.getInteractiveForm();
        if (form == null) {
            return null;
        }
        return new PushButtonApProviderImpl(apResources, pdfDoc, form.getResources());
    }

    @Override
    public void generateAppearance(PDFFieldButton buttonField) throws APExtensionException {
        try {
            if (buttonField == null || !buttonField.isPushButton()) {
                return;
            }
            PDFAnnotationIterator buttonAnnotationIterator = buttonField.getAnnotationsIterator();
            while (buttonAnnotationIterator.hasNext()) {
                PDFAnnotation annotation = buttonAnnotationIterator.next();
                if (!(annotation instanceof PDFAnnotationWidget)) continue;
                this.generateButtonWidgetAnnotAppearance((PDFAnnotationWidget)annotation);
            }
        }
        catch (Exception e) {
            throw new APExtensionException("Error generating appearance for button field (Object number: " + buttonField.getCosObject().getObjNum(), e);
        }
    }

    private void generateButtonWidgetAnnotAppearance(PDFAnnotationWidget buttonWidgetAnnotation) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFConfigurationException, PDFFontException, AFMLException, PDFInvalidXMLException {
        PDFRectangle fieldBBox = AppearanceUtils.getBBoxRectangle(buttonWidgetAnnotation);
        PDFAppearanceCharacteristics fieldAppearanceCharacteristics = buttonWidgetAnnotation.getAppearanceCharacteristics();
        if (fieldAppearanceCharacteristics == null) {
            return;
        }
        PDFXObjectForm buttonNormalAppearanceXObject = PDFXObjectForm.newInstance(this.pdfDoc);
        buttonNormalAppearanceXObject.setResources(PDFResources.newInstance(this.pdfDoc));
        PDFAppearance buttonAppearance = buttonWidgetAnnotation.getAppearance();
        if (buttonAppearance == null) {
            buttonAppearance = PDFAppearance.newInstance(this.pdfDoc);
            buttonWidgetAnnotation.setAppearance(buttonAppearance);
        }
        buttonAppearance.setNormalAppearance(buttonNormalAppearanceXObject);
        ASMatrix appearanceXObjectMatrix = AppearanceUtils.getRotationMatrix(ASMatrix.createIdentityMatrix(), fieldAppearanceCharacteristics, fieldBBox);
        buttonNormalAppearanceXObject.setMatrix(appearanceXObjectMatrix.getValues());
        buttonNormalAppearanceXObject.setBBox(fieldBBox);
        ContentWriter buttonAppearanceXObjectWriter = ContentWriter.newInstance(this.pdfDoc);
        PDFBorderStyle bs = buttonWidgetAnnotation.getBorderStyle();
        TextAppearance.buildAppearanceCharacteristics(fieldAppearanceCharacteristics, fieldBBox, bs, null, null, buttonAppearanceXObjectWriter);
        this.addIconAndCaption(buttonNormalAppearanceXObject, buttonAppearanceXObjectWriter, buttonWidgetAnnotation, fieldAppearanceCharacteristics, fieldBBox);
        buttonNormalAppearanceXObject.setContents(buttonAppearanceXObjectWriter.close().getContents());
    }

    private void addIconAndCaption(PDFXObjectForm buttonAppearanceXObject, ContentWriter buttonAppearanceXObjectWriter, PDFAnnotationWidget buttonWidgetAnnotation, PDFAppearanceCharacteristics fieldAppearanceCharacteristics, PDFRectangle fieldBBox) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFInvalidParameterException, PDFFontException, AFMLException, PDFInvalidXMLException {
        PushButtonXFACaptionFormatter xfaCaptionFormatter;
        AppearanceAttributes appearanceAttributes;
        double fxAdjust;
        double fxMargin = AppearanceUtils.getBorderWidth(buttonWidgetAnnotation);
        double[] clipPadding = new double[]{fxMargin, fxMargin, fxMargin, fxMargin};
        ContentModifier.addClippingPath(buttonAppearanceXObjectWriter, buttonAppearanceXObject.getBBox(), clipPadding[0], clipPadding[1], clipPadding[2], clipPadding[3]);
        ASRectangle frFullBbox = new ASRectangle(0.0, 0.0, fieldBBox.width(), fieldBBox.height());
        PDFIconFit iconFitDict = fieldAppearanceCharacteristics.getIconFit();
        if ((iconFitDict == null || !iconFitDict.getScaleFit()) && (fxAdjust = fxMargin * 2.0) < Math.min(frFullBbox.width() / 2.0, frFullBbox.height() / 2.0)) {
            frFullBbox = new ASRectangle(frFullBbox.left() + fxAdjust, frFullBbox.bottom() + fxAdjust, frFullBbox.right() - fxAdjust, frFullBbox.top() - fxAdjust);
        }
        double fxFullWidth = frFullBbox.width();
        double fxFullHeight = frFullBbox.height();
        String buttonCaption = fieldAppearanceCharacteristics.getNormalCaption();
        buttonCaption = buttonCaption != null && buttonCaption.trim().length() > 0 ? RichTextHandler.convertString2RichText(Arrays.asList(buttonCaption)) : null;
        boolean hasNormalIcon = fieldAppearanceCharacteristics.hasNormalIcon();
        PDFAppearanceCharacteristics.CaptionPosition captionPosition = !hasNormalIcon && buttonCaption == null ? null : (buttonCaption == null ? PDFAppearanceCharacteristics.CaptionPosition.kNoCaption_IconOnly : (!hasNormalIcon ? PDFAppearanceCharacteristics.CaptionPosition.kNoIcon_CaptionOnly : fieldAppearanceCharacteristics.getCaptionPosition()));
        if (captionPosition == PDFAppearanceCharacteristics.CaptionPosition.kNoIcon_CaptionOnly && XFAService.getDocumentType(this.pdfDoc) == PDFDocument.PDFDocumentType.StaticNonShellXFA && (appearanceAttributes = (xfaCaptionFormatter = new PushButtonXFACaptionFormatter(this.pdfDoc)).fetchAppearanceAttributes(buttonWidgetAnnotation, this.defResources, this.locale)) != null) {
            PDFPort pdfPort = new PDFPort(buttonAppearanceXObjectWriter, buttonAppearanceXObject.getResources(), new HashMap());
            try {
                CSS20FontDescription cssfontdescriptor;
                Font psFont = FontResources.findFont(appearanceAttributes.getStyleAttributes().getFontName(), this.pdfDoc, (PDFFontSetImpl)this.pdfFontSet, this.afePDFFontMap);
                if (appearanceAttributes.isRichText() && psFont != null && appearanceAttributes.getStyleAttributes().getFontName().equalsIgnoreCase(psFont.getPDFFontDescription().getPostscriptName()) && (cssfontdescriptor = psFont.getPreferredCSS20FontDescription()) != null) {
                    appearanceAttributes.getStyleAttributes().setFontFamily(cssfontdescriptor.getFamilyName());
                    appearanceAttributes.getStyleAttributes().setFontStyle(cssfontdescriptor.getStyle().toString());
                    appearanceAttributes.getStyleAttributes().setFontWeight(cssfontdescriptor.getWeight());
                    appearanceAttributes.getStyleAttributes().setFontStretchFactor(cssfontdescriptor.getStretch().toString());
                    appearanceAttributes.getStyleAttributes().setFontVariant(cssfontdescriptor.getVariant().toString());
                }
                xfaCaptionFormatter.formatAndRenderText(appearanceAttributes, this.pdfFontSet, psFont, pdfPort);
            }
            catch (InvalidFontException e) {
                throw new PDFFontException("Invalid Font in the Font Set.", e);
            }
            catch (UnsupportedFontException e) {
                throw new PDFUnsupportedFeatureException("Attempt to use unsupported font type.", e);
            }
            catch (FontLoadingException e) {
                throw new PDFFontException("Error loading a font.", e);
            }
            finally {
                pdfPort.closePDFPort();
            }
            return;
        }
        if (captionPosition != null) {
            BBoxHolder bboxHolder = this.calculateIconAndTextBBoxes(fxMargin, frFullBbox, fxFullWidth, fxFullHeight, buttonCaption, captionPosition, buttonWidgetAnnotation);
            if (bboxHolder.iconBBox != null) {
                this.emitIcon(buttonAppearanceXObject, bboxHolder.iconBBox, iconFitDict, buttonAppearanceXObjectWriter, fieldAppearanceCharacteristics);
            }
            if (bboxHolder.textBBox != null) {
                this.emitText(buttonAppearanceXObject, buttonAppearanceXObjectWriter, bboxHolder.textBBox, buttonCaption, buttonWidgetAnnotation);
            }
        }
    }

    private BBoxHolder calculateIconAndTextBBoxes(double fxMargin, ASRectangle frFullBbox, double fxFullWidth, double fxFullHeight, String buttonCaption, PDFAppearanceCharacteristics.CaptionPosition captionPosition, PDFAnnotationWidget buttonWidgetAnnotation) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFCosParseException, PDFInvalidParameterException, PDFFontException, AFMLException {
        double fxIconWidth = 0.0;
        double fxIconHeight = 0.0;
        double nIconX = 0.0;
        double nIconY = 0.0;
        boolean bEmitIcon = false;
        double fxTextWidth = 0.0;
        double fxTextHeight = 0.0;
        ASRectangle textBBox = null;
        switch (captionPosition) {
            case kNoCaption_IconOnly: {
                fxIconWidth = fxFullWidth;
                fxIconHeight = fxFullHeight;
                nIconX = frFullBbox.left();
                nIconY = frFullBbox.bottom();
                bEmitIcon = true;
                break;
            }
            case kCaptionAboveIcon: {
                TextRegion textRegion = this.getTextRegion(fxFullWidth, fxFullHeight, buttonCaption, 1.0, AUTO_SIZE_FACTOR, buttonWidgetAnnotation);
                fxTextWidth = textRegion.getWidth();
                fxTextHeight = textRegion.getHeight();
                fxIconWidth = fxFullWidth;
                fxIconHeight = fxFullHeight - fxMargin - fxTextHeight;
                if (fxIconHeight <= 0.0) {
                    fxIconHeight = 0.0;
                    fxIconWidth = 0.0;
                }
                nIconX = frFullBbox.left();
                nIconY = frFullBbox.bottom();
                double deltaX = (fxFullWidth - fxTextWidth) / 2.0;
                double deltaY = (fxFullHeight - fxTextHeight - fxIconHeight) / 2.0;
                textBBox = new ASRectangle(frFullBbox.left() + deltaX, frFullBbox.bottom() + deltaY, frFullBbox.right() - deltaX, frFullBbox.top() - deltaY);
                textBBox = new ASRectangle(textBBox.left(), textBBox.top() - fxTextHeight, textBBox.right(), textBBox.top());
                bEmitIcon = fxIconWidth != 0.0;
                break;
            }
            case kCaptionBelowIcon: {
                TextRegion textRegion = this.getTextRegion(fxFullWidth, fxFullHeight, buttonCaption, 1.0, AUTO_SIZE_FACTOR, buttonWidgetAnnotation);
                fxTextWidth = textRegion.getWidth();
                fxTextHeight = textRegion.getHeight();
                fxIconWidth = fxFullWidth;
                fxIconHeight = fxFullHeight - fxMargin - fxTextHeight;
                if (fxIconHeight <= 0.0) {
                    fxIconHeight = 0.0;
                    fxIconWidth = 0.0;
                }
                nIconX = frFullBbox.left();
                nIconY = frFullBbox.bottom() + fxTextHeight + fxMargin;
                double deltaX = (fxFullWidth - fxTextWidth) / 2.0;
                double deltaY = (fxFullHeight - fxTextHeight - fxIconHeight - fxMargin) / 2.0;
                textBBox = new ASRectangle(frFullBbox.left() + deltaX, frFullBbox.bottom() + deltaY, frFullBbox.right() - deltaX, frFullBbox.top() - deltaY);
                textBBox = new ASRectangle(textBBox.left(), textBBox.bottom(), textBBox.right(), textBBox.bottom() + fxTextHeight);
                bEmitIcon = true;
                break;
            }
            case kNoIcon_CaptionOnly: {
                TextRegion textRegion = this.getTextRegion(fxFullWidth, fxFullHeight, buttonCaption, 1.0, 1.0, buttonWidgetAnnotation);
                fxTextWidth = textRegion.getWidth();
                fxTextHeight = textRegion.getHeight();
                double deltaX = (fxFullWidth - fxTextWidth) / 2.0;
                double deltaY = (fxFullHeight - fxTextHeight - fxMargin) / 2.0;
                textBBox = new ASRectangle(frFullBbox.left() + deltaX, frFullBbox.bottom() + deltaY, frFullBbox.right() - deltaX, frFullBbox.top() - deltaY);
                bEmitIcon = false;
                break;
            }
            case kCaptionRightOfIcon: {
                TextRegion textRegion = this.getTextRegion(fxFullWidth, fxFullHeight, buttonCaption, AUTO_SIZE_FACTOR, 1.0, buttonWidgetAnnotation);
                fxTextWidth = textRegion.getWidth();
                fxTextHeight = textRegion.getHeight();
                fxIconWidth = fxFullWidth - fxMargin - fxTextWidth;
                fxIconHeight = fxFullHeight;
                if (fxIconWidth <= 0.0) {
                    fxIconHeight = 0.0;
                    fxIconWidth = 0.0;
                }
                nIconX = frFullBbox.left();
                nIconY = frFullBbox.bottom();
                double deltaX = (fxFullWidth - fxIconWidth - fxTextWidth - fxMargin) / 2.0;
                double deltaY = (fxFullHeight - fxTextHeight) / 2.0;
                textBBox = new ASRectangle(frFullBbox.left() + deltaX, frFullBbox.bottom() + deltaY, frFullBbox.right() - deltaX, frFullBbox.top() - deltaY);
                textBBox = new ASRectangle(textBBox.right() - fxTextWidth + fxMargin, textBBox.bottom(), textBBox.right(), textBBox.top());
                bEmitIcon = fxIconWidth != 0.0;
                break;
            }
            case kCaptionLeftOfIcon: {
                TextRegion textRegion = this.getTextRegion(fxFullWidth, fxFullHeight, buttonCaption, AUTO_SIZE_FACTOR, 1.0, buttonWidgetAnnotation);
                fxTextWidth = textRegion.getWidth();
                fxTextHeight = textRegion.getHeight();
                fxIconWidth = fxFullWidth - fxMargin - fxTextWidth;
                fxIconHeight = fxFullHeight;
                if (fxIconWidth <= 0.0) {
                    fxIconHeight = 0.0;
                    fxIconWidth = 0.0;
                }
                nIconX = frFullBbox.left() + fxTextWidth + fxMargin;
                nIconY = frFullBbox.bottom();
                double deltaX = (fxFullWidth - fxIconWidth - fxTextWidth) / 2.0;
                double deltaY = (fxFullHeight - fxTextHeight) / 2.0;
                textBBox = new ASRectangle(frFullBbox.left() + deltaX, frFullBbox.bottom() + deltaY, frFullBbox.right() - deltaX, frFullBbox.top() - deltaY);
                textBBox = new ASRectangle(textBBox.left() + fxMargin, textBBox.bottom(), textBBox.left() + fxTextWidth - fxMargin, textBBox.top());
                bEmitIcon = fxIconWidth != 0.0;
                break;
            }
            case kCaptionOverlaidOnIcon: {
                TextRegion textRegion = this.getTextRegion(fxFullWidth, fxFullHeight, buttonCaption, 1.0, 1.0, buttonWidgetAnnotation);
                fxTextWidth = textRegion.getWidth();
                fxTextHeight = textRegion.getHeight();
                fxIconWidth = fxFullWidth;
                fxIconHeight = fxFullHeight;
                nIconX = frFullBbox.left();
                nIconY = frFullBbox.bottom();
                double deltaX = (fxFullWidth - fxTextWidth) / 2.0;
                double deltaY = (fxFullHeight - fxTextHeight - fxIconHeight - fxMargin) / 2.0;
                textBBox = new ASRectangle(frFullBbox.left() + deltaX, frFullBbox.bottom() + deltaY, frFullBbox.right() - deltaX, frFullBbox.top() - deltaY);
                bEmitIcon = true;
                break;
            }
        }
        ASRectangle iconBBox = null;
        if (bEmitIcon) {
            iconBBox = new ASRectangle(nIconX, nIconY, nIconX + fxIconWidth, nIconY + fxIconHeight);
        }
        BBoxHolder bboxHolder = new BBoxHolder(textBBox, iconBBox);
        return bboxHolder;
    }

    private TextRegion getTextRegion(double fxFullWidth, double fxFullHeight, String buttonCaption, double widthFactorForAutosize, double heightFactorForAutosize, PDFAnnotationWidget buttonWidgetAnnotation) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException, PDFCosParseException, PDFInvalidParameterException, PDFFontException, AFMLException {
        SimpleTextFormatterImpl textFormatter = new SimpleTextFormatterImpl(fxFullWidth, fxFullHeight, widthFactorForAutosize, heightFactorForAutosize);
        AppearanceAttributes appearanceAttributes = textFormatter.fetchAppearanceAttributes(buttonWidgetAnnotation, this.defResources, this.locale);
        Font psFont = FontResources.findFont(appearanceAttributes.getStyleAttributes().getFontName(), this.pdfDoc, (PDFFontSetImpl)this.pdfFontSet, this.afePDFFontMap);
        return textFormatter.getFormattedTextRegionInfo(psFont, this.pdfFontSet, buttonCaption, appearanceAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitText(PDFXObjectForm buttonAppearanceXObject, ContentWriter buttonAppearanceXObjectWriter, ASRectangle textBBox, String buttonCaption, PDFAnnotationWidget buttonWidgetAnnotation) throws PDFInvalidParameterException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFConfigurationException, PDFCosParseException, PDFFontException {
        double[] ctm = new ASMatrix(new double[]{1.0, 0.0, 0.0, 1.0, -textBBox.left(), -textBBox.bottom()}).getInverse().getValues();
        buttonAppearanceXObjectWriter.write(InstructionFactory.newConcatMatrix(ctm[0], ctm[1], ctm[2], ctm[3], ctm[4], ctm[5]));
        SimpleTextFormatterImpl textFormatter = new SimpleTextFormatterImpl(textBBox.width(), textBBox.height());
        AppearanceAttributes appearanceAttributes = textFormatter.fetchAppearanceAttributes(buttonWidgetAnnotation, this.defResources, this.locale);
        appearanceAttributes.setTextValue(buttonCaption);
        appearanceAttributes.getStyleAttributes().setTextAlignment(1);
        appearanceAttributes.getRcgOptions().setVerticalAlignment(RCGAlignment.Middle);
        PDFPort pdfPort = new PDFPort(buttonAppearanceXObjectWriter, buttonAppearanceXObject.getResources(), new HashMap());
        try {
            Font psFont = FontResources.findFont(appearanceAttributes.getStyleAttributes().getFontName(), this.pdfDoc, (PDFFontSetImpl)this.pdfFontSet, this.afePDFFontMap);
            textFormatter.formatAndRenderText(appearanceAttributes, this.pdfFontSet, psFont, pdfPort);
        }
        finally {
            pdfPort.closePDFPort();
        }
    }

    private void emitIcon(PDFXObjectForm buttonAppearanceXObject, ASRectangle iconLocationOnButton, PDFIconFit iconFit, ContentWriter buttonAppearanceXObjectWriter, PDFAppearanceCharacteristics fieldAppearanceCharacteristics) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        PDFXObjectForm iconXObj = fieldAppearanceCharacteristics.getNormalIcon();
        ASMatrix iconMatrix = null;
        iconMatrix = iconXObj.getMatrix() != null ? new ASMatrix(iconXObj.getMatrix()) : ASMatrix.createIdentityMatrix();
        ASRectangle iconXObjBBox = iconXObj.getBBox().getRectangle().transform(iconMatrix).normalized();
        ASMatrix fitMatrix = PushButtonApProviderImpl.getFitMatrix(iconFit, iconLocationOnButton, iconXObjBBox);
        buttonAppearanceXObjectWriter.write(InstructionFactory.newGSave());
        if (iconFit != null && !iconFit.getScaleFit()) {
            buttonAppearanceXObjectWriter.write(InstructionFactory.newRectangle(iconLocationOnButton.left(), iconLocationOnButton.bottom(), iconLocationOnButton.width(), iconLocationOnButton.height()));
            buttonAppearanceXObjectWriter.write(InstructionFactory.newClipPath());
            buttonAppearanceXObjectWriter.write(InstructionFactory.newEndPathNoOp());
        }
        buttonAppearanceXObjectWriter.write(InstructionFactory.newConcatMatrix(fitMatrix.geta(), fitMatrix.getb(), fitMatrix.getc(), fitMatrix.getd(), fitMatrix.getx(), fitMatrix.gety()));
        buttonAppearanceXObjectWriter.write(InstructionFactory.newDeviceGrayFill(0.0));
        buttonAppearanceXObjectWriter.write(InstructionFactory.newDeviceGrayStroke(0.0));
        buttonAppearanceXObjectWriter.write(InstructionFactory.newLineCapStyle(0));
        buttonAppearanceXObjectWriter.write(InstructionFactory.newLineWidth(1.0));
        buttonAppearanceXObjectWriter.write(InstructionFactory.newLineCapStyle(0));
        buttonAppearanceXObjectWriter.write(InstructionFactory.newInvokeNamedXObject(ASName.create(ICON_XOBJECT_KEY)));
        buttonAppearanceXObjectWriter.write(InstructionFactory.newGRestore());
        buttonAppearanceXObject.getResources().procureXObjectMap().put(ASName.create(ICON_XOBJECT_KEY), iconXObj);
    }

    private static ASMatrix getFitMatrix(PDFIconFit iconFit, ASRectangle iconBBox, ASRectangle formBBox) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double offW;
        double offH;
        double fscH;
        double fscW;
        double[] align;
        double[] dArray;
        ASName scaling;
        ASName scaleWhen;
        double frX = iconBBox.left();
        double frY = iconBBox.bottom();
        double frW = iconBBox.right() - iconBBox.left();
        double frH = iconBBox.top() - iconBBox.bottom();
        double anX = formBBox.left();
        double anY = formBBox.bottom();
        double anW = formBBox.right() - formBBox.left();
        double anH = formBBox.top() - formBBox.bottom();
        ASName aSName = scaleWhen = iconFit == null ? ASName.k_A : iconFit.getIconScaleCondition().getValue();
        if (scaleWhen == null) {
            scaleWhen = ASName.k_A;
        }
        ASName aSName2 = scaling = iconFit == null ? ASName.k_P : iconFit.getIconScaleType().getValue();
        if (iconFit == null) {
            double[] dArray2 = new double[2];
            dArray2[0] = 0.5;
            dArray = dArray2;
            dArray2[1] = 0.5;
        } else {
            dArray = align = iconFit.getIconScalePosition();
        }
        if (frW == anW && frH == anH) {
            return new ASMatrix(1.0, 0.0, 0.0, 1.0, frX - anX, frY - anY);
        }
        boolean performScaleW = anW < frW ? scaleWhen == ASName.k_A || scaleWhen == ASName.k_S : (anW > frW ? scaleWhen == ASName.k_A || scaleWhen == ASName.k_B : false);
        boolean performScaleH = anH < frH ? scaleWhen == ASName.k_A || scaleWhen == ASName.k_S : (anH > frH ? scaleWhen == ASName.k_A || scaleWhen == ASName.k_B : false);
        if (scaling == ASName.k_P) {
            if (anW > frW && anH <= frH || anH > frH && anW <= frW) {
                performScaleH = scaleWhen == ASName.k_B || scaleWhen == ASName.k_A;
                performScaleW = performScaleH;
            }
            if (anW == frW && anH < frH || anH == frH && anW < frW) {
                performScaleH = false;
                performScaleW = false;
            }
        }
        if (performScaleW) {
            fscW = frW / anW;
            if (scaling == ASName.k_P) {
                fscH = frH / anH;
                if (fscW < fscH) {
                    fscH = fscW;
                    offH = frH - fscH * anH;
                    offW = 0.0;
                } else if (fscH < fscW) {
                    fscW = fscH;
                    offW = frW - fscW * anW;
                    offH = 0.0;
                } else {
                    offH = 0.0;
                    offW = 0.0;
                }
            } else if (!performScaleH) {
                fscH = 1.0;
                offH = frH - anH;
                offW = 0.0;
            } else {
                fscH = frH / anH;
                offH = 0.0;
                offW = 0.0;
            }
        } else if (performScaleH) {
            fscH = frH / anH;
            fscW = 1.0;
            offW = frW - anW;
            offH = 0.0;
        } else {
            fscW = 1.0;
            fscH = 1.0;
            offW = frW - anW;
            offH = frH - anH;
        }
        offW = frX - fscW * anX + align[0] * offW;
        offH = frY - fscH * anY + align[1] * offH;
        return new ASMatrix(fscW, 0.0, 0.0, fscH, offW, offH);
    }

    private class BBoxHolder {
        ASRectangle textBBox;
        ASRectangle iconBBox;

        BBoxHolder(ASRectangle textBBox, ASRectangle iconBBox) {
            this.textBBox = textBBox;
            this.iconBBox = iconBBox;
        }
    }
}

