/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.ap.annot;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationHighlight;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRotationEnum;
import com.adobe.internal.pdftoolkit.services.ap.annot.AnnotationAppearanceGenerator;

class HighlightAnnotApGenerator
extends AnnotationAppearanceGenerator<PDFAnnotationHighlight> {
    HighlightAnnotApGenerator() {
    }

    @Override
    public void generateAppearanceInternal(PDFAnnotationHighlight annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        super.generateAppearanceInternal(annot);
        double[] strokeColor = annot.getColor();
        PDFAnnotationRotationEnum rotationEnum = this.writer.getRotationType();
        boolean isRotate = false;
        PDFRectangle rectangle = annot.getRect();
        ASMatrix fm = ASMatrix.createIdentityMatrix();
        if ((rotationEnum == PDFAnnotationRotationEnum.OnlyAnnotationRotation || rotationEnum == PDFAnnotationRotationEnum.WithPageRotation) && annot.getRotation() != 0) {
            isRotate = true;
        }
        if (isRotate) {
            fm = this.applyRotation(Math.toRadians(annot.getRotation()), rectangle);
            this.writer.contentWriter.write(InstructionFactory.newGSave());
            this.writer.contentWriter.write(InstructionFactory.newConcatMatrix(fm.geta(), fm.getb(), fm.getc(), fm.getd(), fm.getx(), fm.gety()));
        }
        this.writer.writeFillColor(strokeColor);
        double[] co = annot.getQuadPoints();
        int nSize = co.length;
        for (int n = 0; n < nSize; n += 8) {
            AnnotationAppearanceGenerator.Quad q = new AnnotationAppearanceGenerator.Quad(co, n);
            this.writer.lineWidth = (Math.abs(q.tr.y() - q.br.y()) + Math.abs(q.tr.x() - q.br.x())) / 16.0;
            this.writer.contentWriter.write(InstructionFactory.newLineWidth(this.writer.lineWidth));
            this.writer.moveTo(q.bl.x(), q.bl.y());
            this.writer.bulgeTo(q.tl.x(), q.tl.y(), q.bl.x(), q.bl.y());
            this.writer.lineTo(q.tr.x(), q.tr.y());
            this.writer.bulgeTo(q.br.x(), q.br.y(), q.tr.x(), q.tr.y());
            this.writer.fillStroke(this.writer.fill, false);
        }
        if (isRotate) {
            this.writer.contentWriter.write(InstructionFactory.newGRestore());
        }
        Number fxOpacity = annot.getOpacity();
        if (!isRotate) {
            this.maybeWrapForOpacity(annot, fxOpacity, ASName.k_Multiply);
        }
        if (isRotate) {
            this.createAndSetAppearance(annot, annot.getPage().getCropBox());
        } else {
            this.createAndSetAppearance(annot, this.writer.getAdjustedBBox(annot.getPDFDocument()));
        }
    }
}

