/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.Jpeg2000;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.DataEntryURLBox;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Box;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxInfo;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxType;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.UUIDListBox;
import java.io.IOException;

public class UUIDInfoBox
extends Jpeg2000Box {
    private UUIDListBox uuidListBox;
    private DataEntryURLBox dataEntryUrlBox;

    UUIDInfoBox(Jpeg2000BoxInfo boxInfo) {
        this.boxInfo = boxInfo;
    }

    public UUIDListBox getUUIDListBox() throws IOException {
        this.lazilyPopulateFields();
        return this.uuidListBox;
    }

    public DataEntryURLBox getDataEntryURLBox() throws IOException {
        this.lazilyPopulateFields();
        return this.dataEntryUrlBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void lazilyPopulateFields() throws IOException {
        InputByteStream boxContents = this.boxInfo.getBoxContents();
        if (boxContents == null) {
            return;
        }
        try {
            block8: while (boxContents.bytesAvailable() > 0L) {
                Jpeg2000BoxInfo innerBoxInfo = new Jpeg2000BoxInfo(boxContents);
                Jpeg2000BoxType innerBoxType = innerBoxInfo.getType();
                if (innerBoxType == null) {
                    return;
                }
                switch (innerBoxType) {
                    case uuidListBox: {
                        this.uuidListBox = new UUIDListBox(innerBoxInfo);
                        continue block8;
                    }
                    case dataEntryURLBox: {
                        this.dataEntryUrlBox = new DataEntryURLBox(innerBoxInfo);
                        continue block8;
                    }
                }
            }
        }
        finally {
            this.boxInfo.clearContents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void close() throws IOException {
        try {
            if (this.uuidListBox != null) {
                this.uuidListBox.close();
            }
        }
        finally {
            try {
                if (this.dataEntryUrlBox != null) {
                    this.dataEntryUrlBox.close();
                }
            }
            finally {
                this.boxInfo.clearContents();
            }
        }
    }
}

