/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.utils;

import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public class PDFUtil {
    private static final String RICH_TEXT_START = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><body xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:xfa=\"http://www.xfa.org/schema/xfa-data/1.0/\" xfa:APIVersion=\"2.2\"><p>";
    private static final String RICH_TEXT_END = "</p></body>";

    public static String toString(byte[] b) {
        StringBuilder rslt = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            rslt.append((char)b[i]);
        }
        return rslt.toString();
    }

    public static ArrayList<Double> parseNumbers(String numbersString, String separator) {
        StringTokenizer numbersTokens = new StringTokenizer(numbersString, separator);
        ArrayList<Double> numbers = new ArrayList<Double>();
        while (numbersTokens.hasMoreTokens()) {
            StringBuilder oneNumber = new StringBuilder(numbersTokens.nextToken());
            int numInd = 0;
            while (numInd < oneNumber.length()) {
                if (!ByteOps.isWhitespace(oneNumber.charAt(numInd))) {
                    ++numInd;
                    continue;
                }
                oneNumber.delete(numInd, numInd + 1);
            }
            numbers.add(new Double(oneNumber.toString()));
        }
        return numbers.isEmpty() ? null : numbers;
    }

    public static int findStringInArray(String look, String[] lookup) {
        for (int strInd = 0; strInd < lookup.length; ++strInd) {
            if (!look.equals(lookup[strInd])) continue;
            return strInd;
        }
        return -1;
    }

    public static String substituteStringFromArray(String look, String[] lookup, String[] substitute) {
        int arrayInd = PDFUtil.findStringInArray(look, lookup);
        return arrayInd == -1 ? null : substitute[arrayInd];
    }

    public static String makeRichTextFromString(String simpleString) {
        if (simpleString == null) {
            return null;
        }
        StringBuilder bufStr = new StringBuilder(RICH_TEXT_START.length() + RICH_TEXT_END.length() + simpleString.length());
        bufStr.append(RICH_TEXT_START);
        bufStr.append(simpleString);
        bufStr.append(RICH_TEXT_END);
        return bufStr.toString();
    }

    public static <T extends PDFCosObject> boolean containsPDFCosObjectRef(Collection<T> objectList, T obj) {
        for (PDFCosObject nextObject : objectList) {
            if (!PDFUtil.isPDFCosObjectRefEqual(obj, nextObject)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPDFCosObjectRefEqual(PDFCosObject pdfCosObject1, PDFCosObject pdfCosObject2) {
        if (pdfCosObject1 == null && pdfCosObject2 == null) {
            return true;
        }
        if (pdfCosObject1 == null || pdfCosObject2 == null) {
            return false;
        }
        if (pdfCosObject1.getClass() != pdfCosObject2.getClass()) {
            return false;
        }
        return pdfCosObject1.getCosObject() == pdfCosObject2.getCosObject();
    }

    public static <T extends PDFCosObject> int indexOfPDFCosObjectRef(Collection<T> objectList, T obj) {
        int index = 0;
        for (PDFCosObject nextObject : objectList) {
            if (PDFUtil.isPDFCosObjectRefEqual(obj, nextObject)) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

