/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.rendering;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalfToneType;
import com.adobe.internal.pdftoolkit.pdf.rendering.PDFHalftoneWithFunction;

public class PDFHalftoneType10
extends PDFHalftoneWithFunction {
    private PDFHalftoneType10(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFHalftoneType10 newInstance(PDFDocument pdfDocument, int key_XSquare, int key_YSquare) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFHalftoneType10 pdfObject = new PDFHalftoneType10(cosObject);
        pdfObject.setHalftoneType(PDFHalfToneType.HALFTONE_TYPE10);
        pdfObject.setXSquare(key_XSquare);
        pdfObject.setYSquare(key_YSquare);
        return pdfObject;
    }

    public static PDFHalftoneType10 getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFHalftoneType10 pdfObject = (PDFHalftoneType10)PDFCosObject.getCachedInstance(cosObject, PDFHalftoneType10.class);
        if (pdfObject == null) {
            pdfObject = new PDFHalftoneType10(cosObject);
        }
        return pdfObject;
    }

    public int getXSquare() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_XSquare);
    }

    public void setXSquare(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_XSquare, value);
    }

    public int requireXSquare() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_XSquare);
        if (!(cosObject instanceof CosNumeric)) {
            throw new PDFInvalidDocumentException("Unable to get XSquare.");
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public boolean hasXSquare() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_XSquare);
    }

    public int getYSquare() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryIntValue(ASName.k_YSquare);
    }

    public void setYSquare(int value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_YSquare, value);
    }

    public int requireYSquare() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getDictionaryCosObjectValue(ASName.k_YSquare);
        if (!(cosObject instanceof CosNumeric)) {
            throw new PDFInvalidDocumentException("Unable to get YSquare.");
        }
        return ((CosNumeric)cosObject).intValue();
    }

    public boolean hasYSquare() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_YSquare);
    }
}

