/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.page;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecificationList;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFGroupAttributes;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFThumbnailImage;
import com.adobe.internal.pdftoolkit.pdf.interactive.PDFViewPortList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFNavNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFThumb;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.PDFTransition;
import com.adobe.internal.pdftoolkit.pdf.interchange.documentparts.PDFDPart;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOutputIntentsList;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFSeparationInfo;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureUtils;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageBoxColorInfo;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPagePiece;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTreeNode;
import com.adobe.internal.pdftoolkit.pdf.page.PDFTabOrder;

public class PDFPage
extends PDFPageTreeNode
implements Comparable {
    private int mPageNumber = -1;

    protected PDFPage(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFPage getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFPage pdfObject = (PDFPage)PDFCosObject.getCachedInstance(cosObject, PDFPage.class);
        if (pdfObject == null) {
            pdfObject = new PDFPage(cosObject);
        }
        return pdfObject;
    }

    public static PDFPage newInstance(PDFDocument pdfDocument, PDFRectangle mediaBox) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosPage = PDFCosObject.newCosDictionary(pdfDocument);
        cosPage.put(ASName.k_Type, ASName.k_Page);
        cosPage.put(ASName.k_MediaBox, mediaBox.getCosObject());
        return new PDFPage(cosPage);
    }

    @Override
    public PDFPageTreeNode getParent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPageTreeNode.getInstance(this.getDictionaryCosObjectValue(ASName.k_Parent));
    }

    public PDFPage nextPage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageTreeNode.PDFPageTreePagesIterator treeIter = this.pagesIterator(this);
        return treeIter.hasNext() ? treeIter.next() : null;
    }

    public void prependPage(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageTreeNode parent = this.getParent();
        int i = parent.indexOfParent(this);
        parent.getKids().add(i, page);
        page.setDictionaryValue(ASName.k_Parent, parent);
        parent.incrementCount();
    }

    public void appendPage(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageTreeNode parent = this.getParent();
        int i = parent.indexOfParent(this) + 1;
        parent.getKids().add(i, page);
        page.setDictionaryValue(ASName.k_Parent, parent);
        parent.incrementCount();
    }

    public void remove() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageTreeNode parent = this.getParent();
        int i = parent.indexOfParent(this);
        parent.getKids().remove(i);
        parent.decrementCount();
    }

    public int getIndex() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getPageIndex();
    }

    public boolean hasAnnotations() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Annots);
    }

    public PDFAnnotationList getAnnotationList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAnnotationList.getInstance(this.getDictionaryCosObjectValue(ASName.k_Annots));
    }

    public void setAnnotationList(PDFAnnotationList pdfAnnotationList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Annots, pdfAnnotationList);
    }

    public PDFAnnotationList procureAnnotationList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationList annots = this.getAnnotationList();
        if (annots == null) {
            annots = PDFAnnotationList.newInstance(this.getPDFDocument());
            this.setAnnotationList(annots);
        }
        return annots;
    }

    public void removeAnnotationList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(ASName.k_Annots);
    }

    public PDFContents getContents() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFContents.getInstance(this.getDictionaryCosObjectValue(ASName.k_Contents));
    }

    public void setContents(InputByteStream contents) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFContents pdfContents = this.getContents();
        pdfContents.setContents(contents);
    }

    public void setContents(PDFContents pdfContents) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Contents, pdfContents);
    }

    public void setCropBox(double llx, double lly, double urx, double ury) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRectangle bbox = PDFRectangle.newInstance(this.getPDFDocument(), llx, lly, urx, ury);
        this.setDictionaryArrayValue(ASName.k_CropBox, bbox.getCosArray());
    }

    public void setCropBox(PDFRectangle cropBox) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_CropBox, cropBox);
    }

    public void setMediaBox(double llx, double lly, double urx, double ury) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRectangle bbox = PDFRectangle.newInstance(this.getPDFDocument(), llx, lly, urx, ury);
        this.setDictionaryArrayValue(ASName.k_MediaBox, bbox.getCosArray());
    }

    public void setMediaBox(PDFRectangle mediaBox) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_MediaBox, mediaBox);
    }

    public void setArtBox(double llx, double lly, double urx, double ury) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRectangle bbox = PDFRectangle.newInstance(this.getPDFDocument(), llx, lly, urx, ury);
        this.setDictionaryArrayValue(ASName.k_ArtBox, bbox.getCosArray());
    }

    public void setArtBox(PDFRectangle artBox) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_ArtBox, artBox);
    }

    public void setBleedBox(double llx, double lly, double urx, double ury) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRectangle bbox = PDFRectangle.newInstance(this.getPDFDocument(), llx, lly, urx, ury);
        this.setDictionaryArrayValue(ASName.k_BleedBox, bbox.getCosArray());
    }

    public void setBleedBox(PDFRectangle bleedBox) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_BleedBox, bleedBox);
    }

    public void setTrimBox(double llx, double lly, double urx, double ury) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRectangle bbox = PDFRectangle.newInstance(this.getPDFDocument(), llx, lly, urx, ury);
        this.setDictionaryArrayValue(ASName.k_TrimBox, bbox.getCosArray());
    }

    @Override
    public PDFRectangle getCropBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRectangle cropBox = super.getCropBox();
        if (cropBox == null) {
            cropBox = this.getMediaBox();
        }
        return cropBox;
    }

    public PDFRectangle getBleedBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(ASName.k_BleedBox)) {
            return PDFRectangle.getInstance(this.getDictionaryCosObjectValue(ASName.k_BleedBox));
        }
        return this.getCropBox();
    }

    public PDFRectangle getTrimBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(ASName.k_TrimBox)) {
            return PDFRectangle.getInstance(this.getDictionaryCosObjectValue(ASName.k_TrimBox));
        }
        return this.getCropBox();
    }

    public PDFRectangle getArtBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(ASName.k_ArtBox)) {
            return PDFRectangle.getInstance(this.getDictionaryCosObjectValue(ASName.k_ArtBox));
        }
        return this.getCropBox();
    }

    @Override
    public PDFRotation getRotation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRotation rotation = super.getRotation();
        if (rotation == null) {
            rotation = PDFRotation.ROTATE_0;
        }
        return rotation;
    }

    public ASMatrix getDefaultPageMatrix() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASMatrix alignmentMatrix;
        ASMatrix pageRotationMatrix;
        PDFRectangle pageCropBox = this.getArtBox();
        double pageCropWidth = pageCropBox.width();
        double pageCropHeight = pageCropBox.height();
        PDFRotation pageRotation = this.getRotation();
        if (pageRotation == PDFRotation.ROTATE_90) {
            pageRotationMatrix = new ASMatrix(0.0, -1.0, 1.0, 0.0, 0.0, 0.0);
            alignmentMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, -pageCropWidth, 0.0);
        } else if (pageRotation == PDFRotation.ROTATE_180) {
            pageRotationMatrix = new ASMatrix(-1.0, 0.0, 0.0, -1.0, 0.0, 0.0);
            alignmentMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, -pageCropWidth, -pageCropHeight);
        } else if (pageRotation == PDFRotation.ROTATE_270) {
            pageRotationMatrix = new ASMatrix(0.0, 1.0, -1.0, 0.0, 0.0, 0.0);
            alignmentMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, 0.0, -pageCropHeight);
        } else {
            pageRotationMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            alignmentMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        }
        pageRotationMatrix = alignmentMatrix.concat(pageRotationMatrix);
        return pageRotationMatrix;
    }

    public ASName getTabOrder() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(ASName.k_Tabs)) {
            return this.getDictionaryNameValue(ASName.k_Tabs);
        }
        return null;
    }

    public void setTabOrder(PDFTabOrder order) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Tabs, ASName.create(order.toString()));
    }

    public PDFGroupAttributes getGroup() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFGroupAttributes.getInstance(this.getDictionaryCosObjectValue(ASName.k_Group));
    }

    public void setGroup(PDFGroupAttributes group) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Group, group);
    }

    public void addAnnotation(PDFAnnotation annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotation curAnnot;
        PDFAnnotationList annotations = this.getAnnotationList();
        if (annotations == null) {
            annotations = PDFAnnotationList.newInstance(this.getPDFDocument());
            this.setAnnotationList(annotations);
        }
        if (annot.hasName() && (curAnnot = annotations.findAnnotation(annot.getName())) != null) {
            PDFAnnotationPopup popup = ((PDFAnnotationMarkup)curAnnot).getPopup();
            annotations.remove(curAnnot);
            if (popup != null) {
                annotations.remove(popup);
            }
        }
        annot.setPage(this);
        annotations.add(annot);
    }

    public PDFThumb getThumbnail() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFThumb.getInstance(this.getDictionaryCosObjectValue(ASName.k_Thumb));
    }

    public void setThumbnail(PDFThumb thumb) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Thumb, thumb);
    }

    public void removeThumbnail() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(ASName.k_Thumb);
    }

    public int getPageNumber() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int result = this.mPageNumber;
        if (result == -1) {
            this.mPageNumber = result = this.getIndex();
        }
        return result;
    }

    public boolean hasBoxColorInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_BoxColorInfo);
    }

    public PDFPageBoxColorInfo getBoxColorInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPageBoxColorInfo.getInstance(this.getDictionaryCosObjectValue(ASName.k_BoxColorInfo));
    }

    public int compareTo(Object obj) {
        try {
            return this.getPageNumber() - ((PDFPage)obj).getPageNumber();
        }
        catch (PDFException e) {
            ClassCastException newException = new ClassCastException("Error during parsing.");
            newException.initCause(e);
            throw newException;
        }
    }

    public boolean wasTemplateInstantiated() {
        return this.getCosDictionary().containsKey(ASName.create("TemplateInstantiated"));
    }

    public ASName getTemplateName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.create("TemplateInstantiated"));
    }

    public void setTemplateName(String templateName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.create("TemplateInstantiated"), templateName);
    }

    public PDFPagePiece getPieceInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPagePiece.getInstance(this.getDictionaryCosObjectValue(ASName.k_PieceInfo));
    }

    public PDFPagePiece procurePieceInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPagePiece pieceInfo = this.getPieceInfo();
        if (pieceInfo == null) {
            pieceInfo = PDFPagePiece.newInstance(this.getPDFDocument());
        }
        return pieceInfo;
    }

    public void setPieceInfo(PDFPagePiece pieceInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_PieceInfo, pieceInfo);
    }

    public boolean hasUserUnit() {
        return this.getCosDictionary().containsKey(ASName.k_UserUnit);
    }

    public double getUserUnit() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.hasUserUnit()) {
            return this.getDictionaryDoubleValue(ASName.k_UserUnit);
        }
        return 1.0;
    }

    public void setUserUnit(double userUnit) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryDoubleValue(ASName.k_UserUnit, userUnit);
    }

    public PDFNavNode getPresSteps() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFNavNode.getInstance(this.getDictionaryCosObjectValue(ASName.k_PresSteps));
    }

    public void setPresSteps(PDFNavNode value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_PresSteps, value);
    }

    public boolean hasPresSteps() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_PresSteps);
    }

    public PDFSeparationInfo getSeparationInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFSeparationInfo.getInstance(this.getDictionaryCosObjectValue(ASName.k_SeparationInfo));
    }

    public void setSeparationInfo(PDFSeparationInfo value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_SeparationInfo, value);
    }

    public boolean hasSeparationInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_SeparationInfo);
    }

    public PDFTransition getTransition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFTransition.getInstance(this.getDictionaryCosObjectValue(ASName.k_Trans));
    }

    public void setTransition(PDFTransition value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Trans, value);
    }

    public boolean hasTransition() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Trans);
    }

    public PDFViewPortList getViewPort() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_VP);
        if (cosArray == null) {
            return null;
        }
        return PDFViewPortList.getInstance(cosArray);
    }

    public void setViewPort(PDFViewPortList pdfViewPortList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (pdfViewPortList == null) {
            this.removeValue(ASName.k_VP);
        } else {
            this.setDictionaryArrayValue(ASName.k_VP, pdfViewPortList.getCosArray());
        }
    }

    public boolean hasViewPort() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_VP);
    }

    public Integer getStructParents() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFStructureUtils.getStructParents(this);
    }

    public void setStructParents(Integer structParents) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFStructureUtils.setStructParents(structParents, (PDFCosDictionary)this);
    }

    public PDFDPart getDPart() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFDPart.getInstance(this.getDictionaryCosObjectValue(ASName.k_DPart));
    }

    public void setDPart(PDFDPart documentPart) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_DPart, documentPart);
    }

    public PDFFileSpecificationList getAssociatedFiles() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_AF);
        if (cosArray == null) {
            return null;
        }
        return PDFFileSpecificationList.getInstance(cosArray);
    }

    public void setAssociatedFiles(PDFFileSpecificationList fileSpecificationList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (fileSpecificationList == null) {
            this.removeValue(ASName.k_AF);
        } else {
            this.setDictionaryArrayValue(ASName.k_AF, fileSpecificationList.getCosArray());
        }
    }

    public PDFThumbnailImage getThumbnailStream() throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFThumbnailImage.getInstance(((CosDictionary)this.getCosObject()).getCosStream(ASName.k_Thumb));
    }

    public void setThumbnailStream(PDFThumbnailImage thumbnailStream) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ((CosDictionary)this.getCosObject()).put(ASName.k_Thumb, thumbnailStream.getCosObject());
    }

    public PDFOutputIntentsList getOutputIntents() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_OutputIntents);
        if (cosArray == null) {
            return null;
        }
        return PDFOutputIntentsList.getInstance(cosArray);
    }

    public void setOutputIntents(PDFOutputIntentsList outputIntents) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (outputIntents == null) {
            this.removeValue(ASName.k_OutputIntents);
        } else {
            this.setDictionaryArrayValue(ASName.k_OutputIntents, outputIntents.getCosArray());
        }
    }
}

