/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interchange.webcapture;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFWebCaptureCommandSettings
extends PDFCosDictionary {
    private PDFWebCaptureCommandSettings(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFWebCaptureCommandSettings newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFWebCaptureCommandSettings pdfObject = new PDFWebCaptureCommandSettings(cosObject);
        return pdfObject;
    }

    public static PDFWebCaptureCommandSettings getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFWebCaptureCommandSettings pdfObject = (PDFWebCaptureCommandSettings)PDFCosObject.getCachedInstance(cosObject, PDFWebCaptureCommandSettings.class);
        if (pdfObject == null) {
            pdfObject = new PDFWebCaptureCommandSettings(cosObject);
        }
        return pdfObject;
    }

    public CosDictionary getGlobalConversion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDictionaryValue(ASName.k_G);
    }

    public void setGlobalConversion(CosDictionary value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_G, value);
    }

    public boolean hasGlobalConversion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_G);
    }

    public CosDictionary getConversionEngines() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDictionaryValue(ASName.k_C);
    }

    public void setConversionEngines(CosDictionary value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_C, value);
    }

    public boolean hasConversionEngines() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_C);
    }
}

