/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionFieldType;

public class PDFCollectionField
extends PDFCosDictionary {
    public static final ASName k_CollectionField = ASName.create("CollectionField");

    private PDFCollectionField(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFCollectionField getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFCollectionField pdfObject = (PDFCollectionField)PDFCosObject.getCachedInstance(cosObject, PDFCollectionField.class);
        if (pdfObject == null) {
            pdfObject = new PDFCollectionField(cosObject);
        }
        return pdfObject;
    }

    public static PDFCollectionField newInstance(PDFDocument pdfDocument, PDFCollectionFieldType fieldType, String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFCollectionField pdfObject = new PDFCollectionField(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, k_CollectionField);
        pdfObject.setFieldType(fieldType);
        pdfObject.setName(name);
        return pdfObject;
    }

    public PDFCollectionFieldType getFieldType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCollectionFieldType.getInstance(this.getDictionaryNameValue(ASName.k_Subtype));
    }

    public PDFCollectionFieldType requireFieldType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFCollectionFieldType type = this.getFieldType();
        if (type == null) {
            throw new PDFInvalidDocumentException("Subtype entry in PDFCollectionField is a required entry");
        }
        return type;
    }

    public void setFieldType(PDFCollectionFieldType type) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (type == null) {
            throw new PDFInvalidParameterException("SubType is required when creating newInstance of PDFCollectionField.");
        }
        this.setDictionaryNameValue(ASName.k_Subtype, type.getView());
    }

    public String getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_N);
    }

    public String requireName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String name = this.getName();
        if (name == null) {
            throw new PDFInvalidDocumentException("Required instance");
        }
        return name;
    }

    public void setName(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (name == null || name.length() == 0) {
            throw new PDFInvalidParameterException("N is required when creating newInstance of PDFCollectionField.");
        }
        this.setDictionaryStringValue(ASName.k_N, name);
    }

    public int getOrder() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.hasOrder() ? this.getDictionaryIntValue(ASName.k_O) : 0;
    }

    public boolean hasOrder() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_O);
    }

    public void setOrder(int order) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_O, order);
    }

    public boolean removeOrder() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.removeValue(ASName.k_O);
    }

    public boolean getVisibility() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.hasVisibility() ? this.getDictionaryBooleanValue(ASName.k_V) : true;
    }

    public boolean hasVisibility() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_V);
    }

    public void setVisibility(boolean visibility) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_V, visibility);
    }

    public boolean getAllowEdit() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.hasAllowEdit() ? this.getDictionaryBooleanValue(ASName.k_E) : false;
    }

    public boolean hasAllowEdit() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_E);
    }

    public void setAllowEdit(boolean allow) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_E, allow);
    }
}

