/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms.impl;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.content.NoopOperatorHandler;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ConditionalContentStreamProcessor;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentStreamProcessor;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.StandardFontUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import java.io.IOException;
import java.util.List;

public class PDFDefaultAppearanceWrapper {
    private PDFDefaultAppearance defaultAp;
    private String fontName;
    private String baseFontName;
    private double fontSize;
    private double[] fontColor;
    private double[] fillColor;
    private double[] strokeColor;
    private ASName colorSpace;
    private ASName[] allColorTypes = new ASName[]{ASName.k_g, ASName.k_G, ASName.k_rg, ASName.k_RG, ASName.k_k, ASName.k_K};
    private boolean isBaseFontNameInitialized = false;
    private Double charSpacing;
    private Double wordSpacing;
    private Double scale;
    private Double rise;
    private Double leading;

    public PDFDefaultAppearanceWrapper(PDFDefaultAppearance defAp) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException, PDFUnableToCompleteOperationException {
        this.defaultAp = defAp;
        this.init();
    }

    public String getFontName() throws PDFSecurityException, PDFIOException, PDFInvalidDocumentException, PDFUnableToCompleteOperationException {
        return this.fontName;
    }

    public String getBaseFontName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        if (!this.isBaseFontNameInitialized) {
            this.updateBaseFontName();
            this.isBaseFontNameInitialized = true;
        }
        return this.baseFontName;
    }

    public PDFDefaultAppearance setBaseFontName(String newBaseFontName) throws PDFSecurityException, PDFIOException, PDFInvalidDocumentException, PDFUnableToCompleteOperationException {
        if (newBaseFontName.equals(this.baseFontName)) {
            return this.defaultAp;
        }
        this.baseFontName = newBaseFontName;
        this.updateFontName();
        return this.updateValue(new ASName[]{ASName.k_Tf});
    }

    public double getFontSize() throws PDFSecurityException, PDFIOException, PDFInvalidDocumentException, PDFUnableToCompleteOperationException {
        return this.fontSize;
    }

    public PDFDefaultAppearance setFontSize(double newFontSize) throws PDFSecurityException, PDFIOException, PDFInvalidDocumentException, PDFUnableToCompleteOperationException {
        if (newFontSize == this.fontSize) {
            return this.defaultAp;
        }
        this.fontSize = newFontSize;
        return this.updateValue(new ASName[]{ASName.k_Tf});
    }

    public double[] getFontColor() throws PDFSecurityException, PDFIOException, PDFInvalidDocumentException, PDFUnableToCompleteOperationException {
        return this.fontColor;
    }

    public PDFDefaultAppearance setFontColor(ASName colorSpace, double[] newFontColor) throws PDFSecurityException, PDFIOException, PDFInvalidDocumentException, PDFUnableToCompleteOperationException {
        if (newFontColor == this.fontColor) {
            return this.defaultAp;
        }
        this.fontColor = newFontColor;
        this.colorSpace = this.getPDFColorSpace(colorSpace, this.fontColor);
        return this.updateValue(this.allColorTypes);
    }

    public String getColorSpace() throws PDFUnableToCompleteOperationException, PDFSecurityException, PDFIOException, PDFInvalidDocumentException {
        return this.colorSpace.asString();
    }

    private void init() throws PDFSecurityException, PDFIOException, PDFInvalidDocumentException, PDFUnableToCompleteOperationException {
        NoopOperatorHandler operatorHandler = new NoopOperatorHandler(){

            @Override
            public void Tf(ASName fName, double fSize, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
                PDFDefaultAppearanceWrapper.this.fontSize = fSize;
                PDFDefaultAppearanceWrapper.this.fontName = fName.asString();
            }

            @Override
            public void G(float gray, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
                if (PDFDefaultAppearanceWrapper.this.fontColor == null) {
                    PDFDefaultAppearanceWrapper.this.colorSpace = ASName.k_G;
                }
                this.handleGOperators(gray, PDFDefaultAppearanceWrapper.this.fontColor == null, false);
            }

            @Override
            public void g(float gray, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
                if (PDFDefaultAppearanceWrapper.this.fontColor == null) {
                    PDFDefaultAppearanceWrapper.this.colorSpace = ASName.k_g;
                }
                this.handleGOperators(gray, PDFDefaultAppearanceWrapper.this.fontColor == null, true);
            }

            @Override
            public void RG(float r, float g, float b, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
                if (PDFDefaultAppearanceWrapper.this.fontColor == null) {
                    PDFDefaultAppearanceWrapper.this.colorSpace = ASName.k_RG;
                }
                this.handleRGOperators(r, g, b, PDFDefaultAppearanceWrapper.this.fontColor == null, false);
            }

            @Override
            public void rg(float r, float g, float b, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
                if (PDFDefaultAppearanceWrapper.this.fontColor == null) {
                    PDFDefaultAppearanceWrapper.this.colorSpace = ASName.k_rg;
                }
                this.handleRGOperators(r, g, b, PDFDefaultAppearanceWrapper.this.fontColor == null, true);
            }

            @Override
            public void k(float c, float m, float y, float k, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
                if (PDFDefaultAppearanceWrapper.this.fontColor == null) {
                    PDFDefaultAppearanceWrapper.this.colorSpace = ASName.k_k;
                }
                this.handleKOperators(c, m, y, k, PDFDefaultAppearanceWrapper.this.fontColor == null, true);
            }

            @Override
            public void K(float c, float m, float y, float k, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
                if (PDFDefaultAppearanceWrapper.this.fontColor == null) {
                    PDFDefaultAppearanceWrapper.this.colorSpace = ASName.k_K;
                }
                this.handleKOperators(c, m, y, k, PDFDefaultAppearanceWrapper.this.fontColor == null, false);
            }

            private void handleGOperators(float gray, boolean updateFontColor, boolean fill) {
                if (updateFontColor) {
                    PDFDefaultAppearanceWrapper.access$202(PDFDefaultAppearanceWrapper.this, new double[1]);
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).fontColor[0] = gray;
                }
                if (fill) {
                    PDFDefaultAppearanceWrapper.access$402(PDFDefaultAppearanceWrapper.this, new double[1]);
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).fillColor[0] = gray;
                } else {
                    PDFDefaultAppearanceWrapper.access$502(PDFDefaultAppearanceWrapper.this, new double[1]);
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).strokeColor[0] = gray;
                }
            }

            private void handleRGOperators(float r, float g, float b, boolean updateFontColor, boolean fill) {
                if (updateFontColor) {
                    PDFDefaultAppearanceWrapper.access$202(PDFDefaultAppearanceWrapper.this, new double[3]);
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).fontColor[2] = b;
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).fontColor[1] = g;
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).fontColor[0] = r;
                }
                if (fill) {
                    PDFDefaultAppearanceWrapper.access$402(PDFDefaultAppearanceWrapper.this, new double[3]);
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).fillColor[2] = b;
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).fillColor[1] = g;
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).fillColor[0] = r;
                } else {
                    PDFDefaultAppearanceWrapper.access$502(PDFDefaultAppearanceWrapper.this, new double[3]);
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).strokeColor[2] = b;
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).strokeColor[1] = g;
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).strokeColor[0] = r;
                }
            }

            private void handleKOperators(float c, float m, float y, float k, boolean updateFontColor, boolean fill) {
                if (updateFontColor) {
                    PDFDefaultAppearanceWrapper.access$202(PDFDefaultAppearanceWrapper.this, new double[4]);
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).fontColor[3] = k;
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).fontColor[2] = y;
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).fontColor[1] = m;
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).fontColor[0] = c;
                }
                if (fill) {
                    PDFDefaultAppearanceWrapper.access$402(PDFDefaultAppearanceWrapper.this, new double[4]);
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).fillColor[3] = k;
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).fillColor[2] = y;
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).fillColor[1] = m;
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).fillColor[0] = c;
                } else {
                    PDFDefaultAppearanceWrapper.access$502(PDFDefaultAppearanceWrapper.this, new double[4]);
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).strokeColor[3] = k;
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).strokeColor[2] = y;
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).strokeColor[1] = m;
                    ((PDFDefaultAppearanceWrapper)PDFDefaultAppearanceWrapper.this).strokeColor[0] = c;
                }
            }

            @Override
            public void Tc(double cSpacing, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
                PDFDefaultAppearanceWrapper.this.charSpacing = cSpacing;
            }

            @Override
            public void Tw(double wSpacing, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
                PDFDefaultAppearanceWrapper.this.wordSpacing = wSpacing;
            }

            @Override
            public void Tz(double scaling, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
                PDFDefaultAppearanceWrapper.this.scale = scaling;
            }

            @Override
            public void Ts(double textRise, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
                PDFDefaultAppearanceWrapper.this.rise = textRise;
            }

            @Override
            public void TL(double l, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
                PDFDefaultAppearanceWrapper.this.leading = l;
            }
        };
        ModifiableContent content = ModifiableContent.newInstance(this.defaultAp);
        ConditionalContentStreamProcessor processor = new ConditionalContentStreamProcessor(operatorHandler);
        ((ContentStreamProcessor)processor).process(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PDFDefaultAppearance updateValue(ASName[] matchOperators) throws PDFSecurityException, PDFIOException, PDFInvalidDocumentException, PDFUnableToCompleteOperationException {
        PDFDefaultAppearance newDefAp;
        byte[] bytes;
        ModifiableContent content = ModifiableContent.newInstance(this.defaultAp);
        ContentReader reader = null;
        ContentWriter writer = ContentWriter.newInstance(this.defaultAp.getPDFDocument());
        Content newContent = null;
        try {
            reader = ContentReader.newInstance(content);
            writer.setInstructionDelimiter(32);
            ASName matchOperator = null;
            ASName newColorSpace = null;
            Instruction instruction = null;
            while (reader.hasNext()) {
                instruction = reader.next();
                ASName operator = instruction.getOperator();
                OperandStack operands = instruction.getOperands();
                for (int i = 0; i < matchOperators.length; ++i) {
                    matchOperator = matchOperators[i];
                    if (!operator.equals(matchOperator)) continue;
                    if (operator.equals(ASName.k_Tf)) {
                        operands.pop();
                        operands.pop();
                        operands.pushName(ASName.create(this.fontName));
                        operands.pushASNumber(new ASNumber(this.fontSize));
                        break;
                    }
                    if (operator.equals(ASName.k_G) || operator.equals(ASName.k_g)) {
                        newColorSpace = this.getPDFColorSpace(this.colorSpace, this.fontColor);
                        if (!newColorSpace.equals(operator)) {
                            instruction = this.createColorInstruction();
                            this.colorSpace = newColorSpace;
                        } else {
                            operands.pop();
                            operands.pushASNumber(new ASNumber(this.fontColor[0]));
                        }
                    }
                    if (operator.equals(ASName.k_RG) || operator.equals(ASName.k_rg)) {
                        newColorSpace = this.getPDFColorSpace(this.colorSpace, this.fontColor);
                        if (!newColorSpace.equals(operator)) {
                            instruction = this.createColorInstruction();
                            this.colorSpace = newColorSpace;
                        } else {
                            operands.pop();
                            operands.pop();
                            operands.pop();
                            operands.pushASNumber(new ASNumber(this.fontColor[0]));
                            operands.pushASNumber(new ASNumber(this.fontColor[1]));
                            operands.pushASNumber(new ASNumber(this.fontColor[2]));
                        }
                    }
                    if (operator.equals(ASName.k_K) || operator.equals(ASName.k_k)) {
                        newColorSpace = this.getPDFColorSpace(this.colorSpace, this.fontColor);
                        if (!newColorSpace.equals(operator)) {
                            instruction = this.createColorInstruction();
                            this.colorSpace = newColorSpace;
                        } else {
                            operands.pop();
                            operands.pop();
                            operands.pop();
                            operands.pop();
                            operands.pushASNumber(new ASNumber(this.fontColor[0]));
                            operands.pushASNumber(new ASNumber(this.fontColor[1]));
                            operands.pushASNumber(new ASNumber(this.fontColor[2]));
                            operands.pushASNumber(new ASNumber(this.fontColor[3]));
                        }
                    }
                    if (operator.equals(ASName.k_Tc)) {
                        operands.pop();
                        operands.pushASNumber(new ASNumber((double)this.charSpacing));
                    }
                    if (operator.equals(ASName.k_Tw)) {
                        operands.pop();
                        operands.pushASNumber(new ASNumber((double)this.wordSpacing));
                    }
                    if (operator.equals(ASName.k_Tz)) {
                        operands.pop();
                        operands.pushASNumber(new ASNumber((double)this.scale));
                    }
                    if (operator.equals(ASName.k_Ts)) {
                        operands.pop();
                        operands.pushASNumber(new ASNumber((double)this.rise));
                    }
                    if (!operator.equals(ASName.k_TL)) continue;
                    operands.pop();
                    operands.pushASNumber(new ASNumber((double)this.leading));
                }
                writer.write(instruction);
            }
        }
        finally {
            try {
                if (writer != null) {
                    newContent = writer.close();
                }
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new PDFIOException(e);
                }
            }
        }
        try {
            bytes = this.getBytes(newContent.getContentStream(), 0, newContent.getContentStream().length());
        }
        catch (IOException e) {
            throw new PDFInvalidDocumentException("Cannot get bytes.", e);
        }
        this.defaultAp = newDefAp = PDFDefaultAppearance.newInstance(this.defaultAp.getPDFDocument(), bytes);
        return this.defaultAp;
    }

    private ASName getPDFColorSpace(ASName colorSpace, double[] value) throws PDFInvalidDocumentException, PDFUnableToCompleteOperationException {
        if (value.length == 1) {
            if (colorSpace.equals(ASName.k_G)) {
                return ASName.k_G;
            }
            if (colorSpace.equals(ASName.k_g)) {
                return ASName.k_g;
            }
            return ASName.k_g;
        }
        if (value.length == 3) {
            if (colorSpace.equals(ASName.k_RG)) {
                return ASName.k_RG;
            }
            if (colorSpace.equals(ASName.k_rg)) {
                return ASName.k_rg;
            }
            return ASName.k_rg;
        }
        if (value.length == 4) {
            if (colorSpace.equals(ASName.k_K)) {
                return ASName.k_K;
            }
            if (colorSpace.equals(ASName.k_k)) {
                return ASName.k_k;
            }
            return ASName.k_k;
        }
        throw new PDFInvalidDocumentException("Color array size is incorrect.");
    }

    private Instruction createColorInstruction() throws PDFInvalidDocumentException {
        if (this.colorSpace.equals(ASName.k_g)) {
            return InstructionFactory.newDeviceGrayFill(this.fontColor[0]);
        }
        if (this.colorSpace.equals(ASName.k_G)) {
            return InstructionFactory.newDeviceGrayStroke(this.fontColor[0]);
        }
        if (this.colorSpace.equals(ASName.k_rg)) {
            return InstructionFactory.newDeviceRGBFill(this.fontColor[0], this.fontColor[1], this.fontColor[2]);
        }
        if (this.colorSpace.equals(ASName.k_RG)) {
            return InstructionFactory.newDeviceRGBStroke(this.fontColor[0], this.fontColor[1], this.fontColor[2]);
        }
        if (this.colorSpace.equals(ASName.k_k)) {
            return InstructionFactory.newDeviceCMYKFill(this.fontColor[0], this.fontColor[1], this.fontColor[2], this.fontColor[3]);
        }
        if (this.colorSpace.equals(ASName.k_K)) {
            return InstructionFactory.newDeviceCMYKStroke(this.fontColor[0], this.fontColor[1], this.fontColor[2], this.fontColor[3]);
        }
        throw new PDFInvalidDocumentException("Color space is not recognizable.");
    }

    private void updateFontName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        ASName base14Name;
        PDFFontMap fontMap = this.defaultAp.getPDFDocument().getInteractiveForm().getResources().getFontMap();
        if (fontMap != null) {
            List<ASName> fontKeyList = fontMap.getCosDictionary().getKeys();
            for (int i = 0; i < fontKeyList.size(); ++i) {
                if (!this.baseFontName.equals(fontMap.get(fontKeyList.get(i)).getBaseFont().asString())) continue;
                this.fontName = fontKeyList.get(i).asString();
                return;
            }
        }
        if ((base14Name = StandardFontUtils.getStandardFontProperName(ASName.create(this.baseFontName))) == null) {
            throw new PDFInvalidDocumentException("Cannot find font.");
        }
        this.fontName = base14Name.asString();
    }

    private void updateBaseFontName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFUnableToCompleteOperationException {
        PDFFontMap fontMap = this.defaultAp.getPDFDocument().getInteractiveForm().getResources().getFontMap();
        PDFFont pdfFont = null;
        if (fontMap != null) {
            pdfFont = fontMap.get(ASName.create(this.fontName));
        }
        if (pdfFont != null) {
            this.baseFontName = pdfFont.getBaseFont().asString();
            return;
        }
        ASName base14Name = StandardFontUtils.getStandardFontProperName(ASName.create(this.fontName));
        if (base14Name == null) {
            throw new PDFInvalidDocumentException("Cannot find font.");
        }
        this.baseFontName = base14Name.asString();
    }

    private byte[] getBytes(InputByteStream stream, int offset, long length) throws IOException {
        byte[] bytes = new byte[(int)length];
        int counter = 0;
        stream.seek(offset);
        while (!stream.eof()) {
            bytes[++counter - 1] = (byte)stream.read();
            if ((long)counter != length) continue;
            break;
        }
        return bytes;
    }

    public Double getCharSpacing() {
        return this.charSpacing;
    }

    public void setCharSpacing(Double charSpacing) {
        this.charSpacing = charSpacing;
    }

    public Double getWordSpacing() {
        return this.wordSpacing;
    }

    public void setWordSpacing(Double wordSpacing) {
        this.wordSpacing = wordSpacing;
    }

    public Double getScale() {
        return this.scale;
    }

    public void setScale(Double scale) {
        this.scale = scale;
    }

    public Double getRise() {
        return this.rise;
    }

    public void setRise(Double rise) {
        this.rise = rise;
    }

    public Double getLeading() {
        return this.leading;
    }

    public void setLeading(Double leading) {
        this.leading = leading;
    }

    public double[] getFillColor() throws PDFSecurityException, PDFIOException, PDFInvalidDocumentException, PDFUnableToCompleteOperationException {
        return this.fillColor;
    }

    public double[] getStrokeColor() throws PDFSecurityException, PDFIOException, PDFInvalidDocumentException, PDFUnableToCompleteOperationException {
        return this.strokeColor;
    }

    static /* synthetic */ double[] access$202(PDFDefaultAppearanceWrapper x0, double[] x1) {
        x0.fontColor = x1;
        return x1;
    }

    static /* synthetic */ double[] access$402(PDFDefaultAppearanceWrapper x0, double[] x1) {
        x0.fillColor = x1;
        return x1;
    }

    static /* synthetic */ double[] access$502(PDFDefaultAppearanceWrapper x0, double[] x1) {
        x0.strokeColor = x1;
        return x1;
    }
}

