/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.util.Utility;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldType;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFVariableText;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;

public class PDFFieldNode
extends PDFCosDictionary {
    public static final int kReadOnly = 1;
    public static final int kRequire = 2;
    public static final int kNoExport = 4;
    static final ASName[] pureFieldKeys = new ASName[]{ASName.k_FT, ASName.k_Parent, ASName.k_Kids, ASName.k_T, ASName.k_TU, ASName.k_TM, ASName.k_Ff, ASName.k_V, ASName.k_DV, ASName.k_AA, ASName.k_DA, ASName.k_Q, ASName.k_DS, ASName.k_RV, ASName.k_Opt, ASName.k_MaxLen, ASName.k_TI, ASName.k_I, ASName.k_Lock, ASName.k_SV};
    static final ASName[] pureFieldAndStructureKeys = new ASName[]{ASName.k_FT, ASName.k_Parent, ASName.k_Kids, ASName.k_T, ASName.k_TU, ASName.k_TM, ASName.k_Ff, ASName.k_V, ASName.k_DV, ASName.k_AA, ASName.k_DA, ASName.k_Q, ASName.k_DS, ASName.k_RV, ASName.k_Opt, ASName.k_MaxLen, ASName.k_TI, ASName.k_I, ASName.k_Lock, ASName.k_SV, ASName.k_StructParent, ASName.k_StructParents};

    protected PDFFieldNode(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFieldNode getInstance(CosObject cosObject) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFieldNode.getInstance(cosObject, false);
    }

    public static PDFFieldNode getInstance(CosObject cosObject, boolean useAcrobatIsTerminalCheck) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        CosDictionary cosDict = (CosDictionary)cosObject;
        if (cosDict.containsKey(ASName.k_Fields)) {
            return PDFInteractiveForm.getInstance(cosObject);
        }
        if (PDFFieldUtils.isTerminalField(cosDict, useAcrobatIsTerminalCheck)) {
            return PDFField.getInstance(cosObject);
        }
        PDFFieldNode pdfObject = (PDFFieldNode)PDFCosObject.getCachedInstance(cosObject, PDFFieldNode.class);
        if (pdfObject == null) {
            pdfObject = new PDFFieldNode(cosObject);
        }
        return pdfObject;
    }

    public static PDFFieldNode newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        return new PDFFieldNode(cosObject);
    }

    public static PDFFieldNode newInstance(PDFFieldNode field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldNode newField = PDFFieldNode.newInstance(field.getPDFDocument());
        newField.resetFieldEntries(field);
        return PDFFieldNode.getInstance(newField.getCosObject());
    }

    public PDFFieldType getFieldType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosName fieldType = (CosName)PDFCosUtils.getInheritableValue(ASName.k_FT, ASName.k_Parent, this);
        return fieldType == null ? null : PDFFieldType.getInstance(fieldType.nameValue());
    }

    public String getPartialName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_T);
    }

    public boolean hasPartialName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_T);
    }

    public String getInheritedPartialName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldNode parent;
        String partialName = this.getPartialName();
        if (partialName == null && (parent = this.getParent()) != null && !(parent instanceof PDFInteractiveForm)) {
            partialName = parent.getInheritedPartialName();
        }
        return partialName;
    }

    public void setPartialName(String partialName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (partialName == null) {
            this.removeValue(ASName.k_T);
        } else {
            this.setDictionaryStringValue(ASName.k_T, partialName);
        }
    }

    public void setPartialName(String partialName, boolean useUnicodeEncoding) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (partialName == null) {
            this.removeValue(ASName.k_T);
        } else {
            this.setDictionaryTextValue(ASName.k_T, PDFText.newInstance(this.getPDFDocument(), partialName, false, useUnicodeEncoding));
        }
    }

    public String getQualifiedName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldNode parent = this.getParent();
        if (parent == null || parent instanceof PDFInteractiveForm) {
            return this.getPartialName();
        }
        String fullName = parent.getQualifiedName();
        String partialName = this.getPartialName();
        if (partialName != null) {
            fullName = fullName + "." + partialName;
        }
        return fullName;
    }

    public String getQualifiedNameNoPartialName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldNode parent = this.getParent();
        if (parent == null || parent instanceof PDFInteractiveForm) {
            return this.getPartialName();
        }
        return parent.getQualifiedName();
    }

    public String getValueRichText() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldNode parent;
        String richText = this.getDictionaryTextStringOrStreamValue(ASName.k_RV);
        if (richText == null && this.isAcrobatAnnotation() && (parent = this.getParent()) != null) {
            richText = parent.getDictionaryTextStringOrStreamValue(ASName.k_RV);
        }
        return richText;
    }

    public String getAlternateName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_TU);
    }

    public void setAlternateName(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_TU, name);
    }

    public String getMappingName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_TM);
    }

    public void setMappingName(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_TM, name);
    }

    public boolean hasFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCosUtils.containsInheritableKey(ASName.k_Ff, ASName.k_Parent, this);
    }

    public int getFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosNumeric value = (CosNumeric)PDFCosUtils.getInheritableValue(ASName.k_Ff, ASName.k_Parent, this);
        return value == null ? 0 : value.numberValue().intValue();
    }

    public void setFlags(int flags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_Ff, flags);
    }

    public boolean isReadOnly() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.getFlags() & 1) != 0;
    }

    public void setReadOnly(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value) {
            this.setFlags(this.getFlags() | 1);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFFFE);
        }
    }

    public boolean isRequired() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.getFlags() & 2) == 2;
    }

    public void setRequired(boolean reqd) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (reqd) {
            this.setFlags(this.getFlags() | 2);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFFFD);
        }
    }

    private List getValueListImpl(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosValue = PDFCosUtils.getInheritableValue(key, ASName.k_Parent, this);
        if (cosValue == null) {
            return null;
        }
        LinkedList<Object> stringList = new LinkedList<Object>();
        if (cosValue.getType() == 3) {
            stringList.add(((CosName)cosValue).nameValue().asString(true));
        } else if (cosValue.getType() == 5) {
            CosArray cosArray = (CosArray)cosValue;
            for (int i = 0; i < cosArray.size(); ++i) {
                PDFText text = PDFText.getInstance(cosArray.get(i));
                stringList.add(text.stringValue());
            }
        } else if (cosValue.getType() == 6) {
            stringList.add(cosValue);
        } else {
            PDFText text = PDFText.getInstance(cosValue);
            stringList.add(text.stringValue());
        }
        return stringList;
    }

    public List getValueList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getValueListImpl(ASName.k_V);
    }

    public List getDefaultValueList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getValueListImpl(ASName.k_DV);
    }

    public void setDefaultStringValue(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldNode field = this;
        if (this.isAcrobatAnnotation()) {
            field = this.getParent();
        }
        if (field != null) {
            field.setDictionaryTextValue(ASName.k_DV, PDFText.newInstance(this.getPDFDocument(), value));
        }
    }

    public void setRichText(PDFText richText) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldNode field = this;
        if (this.isAcrobatAnnotation()) {
            field = this.getParent();
        }
        if (field != null) {
            field.setDictionaryTextValue(ASName.k_RV, richText);
        }
    }

    public void setStringValue(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldNode field = this;
        if (this.isAcrobatAnnotation()) {
            field = this.getParent();
        }
        if (field != null) {
            field.setDictionaryTextValue(ASName.k_V, value == null ? null : PDFText.newInstance(this.getPDFDocument(), value));
        }
    }

    public void setTextValue(PDFText value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldNode field = this;
        if (this.isAcrobatAnnotation()) {
            field = this.getParent();
        }
        if (field != null) {
            field.setDictionaryTextValue(ASName.k_V, value);
        }
    }

    public void removeValue() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.getCosDictionary().remove(ASName.k_V);
    }

    public void setNameValue(ASName name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldNode field = this;
        if (this.isAcrobatAnnotation()) {
            field = this.getParent();
        }
        if (field != null) {
            field.setDictionaryNameValue(ASName.k_V, name);
        }
    }

    public void setStringValue(String value, boolean isUTF16) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        PDFFieldNode field = this;
        if (this.isAcrobatAnnotation()) {
            field = this.getParent();
        }
        if (field != null) {
            field.setDictionaryStringOrStreamValue(ASName.k_V, value, isUTF16);
        }
    }

    public void setListValue(List values) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        if (values == null || values.isEmpty()) {
            return;
        }
        Iterator iterateValues = values.iterator();
        CosArray stringArray = PDFCosObject.newCosArray(this.getPDFDocument());
        while (iterateValues.hasNext()) {
            Object nextValue = iterateValues.next();
            if (nextValue instanceof String) {
                stringArray.addText((String)nextValue);
                continue;
            }
            if (nextValue instanceof PDFText) {
                stringArray.add(((PDFText)nextValue).getCosObject());
                continue;
            }
            throw new PDFInvalidParameterException("Bad value type in list");
        }
        if (!stringArray.isEmpty()) {
            PDFFieldNode field = this;
            if (this.isAcrobatAnnotation()) {
                field = this.getParent();
            }
            if (field != null) {
                field.getCosDictionary().put(ASName.k_V, stringArray);
            }
        }
    }

    public PDFVariableText getVariableText() throws PDFInvalidDocumentException {
        return PDFVariableText.getInstance(this.getCosObject());
    }

    public PDFAdditionalActions getAdditionalActions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAdditionalActionsField.getInstance(PDFCosUtils.getInheritableValue(ASName.k_AA, ASName.k_Parent, this));
    }

    public PDFAdditionalActions procureAdditionalActions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFAdditionalActionsField.getInstance(PDFCosUtils.getInheritableValue(ASName.k_AA, ASName.k_Parent, this)) != null) {
            return PDFAdditionalActionsField.getInstance(PDFCosUtils.getInheritableValue(ASName.k_AA, ASName.k_Parent, this));
        }
        PDFAdditionalActionsField field = PDFAdditionalActionsField.newInstance(this.getPDFDocument());
        this.setAdditionalActions(field);
        return field;
    }

    public void setAdditionalActions(PDFAdditionalActions additionalActions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_AA, additionalActions);
    }

    public void setActions(PDFAction actions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_A, actions);
    }

    public boolean noExport() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.getFlags() & 4) != 0;
    }

    public PDFFieldNode getParent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(ASName.k_Parent)) {
            return PDFFieldNode.getInstance(this.getCosDictionary().get(ASName.k_Parent));
        }
        return null;
    }

    public void setParent(PDFFieldNode parent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!(parent instanceof PDFInteractiveForm) && !(this instanceof PDFInteractiveForm)) {
            this.setDictionaryValue(ASName.k_Parent, parent);
        }
    }

    public PDFFieldList getChildren() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getChildren(false);
    }

    public PDFFieldList getChildren(boolean useAcrobatIsTerminalFieldCheck) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFieldList.getInstance(this.getDictionaryCosObjectValue(ASName.k_Kids), useAcrobatIsTerminalFieldCheck);
    }

    public void removeChildren() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.removeValue(ASName.k_Kids);
    }

    public void addChild(PDFFieldNode childNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldList kids = this.getChildren();
        if (kids == null) {
            kids = PDFFieldList.newInstance(this.getPDFDocument());
            kids.add(childNode);
            this.setDictionaryArrayValue(ASName.k_Kids, kids.getCosArray());
        } else {
            kids.add(childNode);
        }
        childNode.setParent(this);
    }

    public void removeChild(PDFFieldNode childNode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldList kids = this.getChildren();
        if (kids != null) {
            kids.remove(childNode);
            if (kids.isEmpty()) {
                this.removeChildren();
            }
        }
    }

    public boolean isTerminalField() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return false;
    }

    public boolean isAnnotation() {
        return false;
    }

    public boolean isAcrobatAnnotation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return false;
    }

    private void resetFieldEntries(PDFFieldNode field) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Iterator<ASName> fieldIterator = field.getCosDictionary().keyIterator();
        while (fieldIterator.hasNext()) {
            ASName key = fieldIterator.next();
            if (!Utility.nameInArray(key, pureFieldKeys)) continue;
            this.setDictionaryValue(key, field.getDictionaryCosObjectValue(key));
        }
    }

    public void removeFieldEntries() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        for (int nameInd = 0; nameInd < pureFieldKeys.length; ++nameInd) {
            ASName curName = pureFieldKeys[nameInd];
            if (!this.dictionaryContains(curName)) continue;
            this.getCosDictionary().remove(curName);
        }
    }

    @Override
    public String toString() {
        String dictStr;
        String str = dictStr = super.toString();
        try {
            str = this.getQualifiedName() + " " + dictStr;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return str;
    }

    public PDFFieldNode getInheritableValueFieldNode(ASName key) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFieldNode.getInstance(PDFCosUtils.getInheritableValueDictionary(key, ASName.k_Parent, this));
    }

    public Iterator<PDFField> iterator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.iterator(false);
    }

    public Iterator<PDFField> iterator(boolean useAcrobatIsTerminalFieldCheck) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isTerminalField()) {
            return new PDFFieldNodeIterator(null, useAcrobatIsTerminalFieldCheck);
        }
        return new PDFFieldNodeIterator(this.getChildren(useAcrobatIsTerminalFieldCheck), useAcrobatIsTerminalFieldCheck);
    }

    public Iterator<PDFField> iterator(PDFFieldType filter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.iterator(new PDFFieldNodeFilter(filter, false), false);
    }

    public Iterator<PDFField> iterator(PDFFieldType filter, boolean useAcrobatIsTerminalFieldCheck) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.iterator(new PDFFieldNodeFilter(filter, useAcrobatIsTerminalFieldCheck), useAcrobatIsTerminalFieldCheck);
    }

    private Iterator<PDFField> iterator(PDFCosArrayList.PDFObjectFilter filter, boolean useAcrobatIsTerminalFieldCheck) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isTerminalField()) {
            return new PDFFieldNodeIterator(null, filter, useAcrobatIsTerminalFieldCheck);
        }
        return new PDFFieldNodeIterator(this.getChildren(useAcrobatIsTerminalFieldCheck), filter, useAcrobatIsTerminalFieldCheck);
    }

    private class PDFFieldNodeIterator
    implements Iterator<PDFField> {
        private PDFFieldNode mKid;
        private PDFField curField = null;
        private PDFFieldNodeIterator mKidIterator;
        private Iterator<PDFFieldNode> mKidsIterator;
        private HashSet<PDFFieldNode> visitedSet = null;
        private final PDFCosArrayList.PDFObjectFilter mFilter;
        private final PDFFieldList kids;
        private final boolean useAcrobatIsTerminalFieldCheck;

        private PDFFieldNodeIterator(PDFFieldList kids, boolean useAcrobatIsTerminalFieldCheck) {
            this.mFilter = null;
            this.kids = kids;
            this.useAcrobatIsTerminalFieldCheck = useAcrobatIsTerminalFieldCheck;
            if (kids == null) {
                return;
            }
            this.mKidsIterator = kids.iterator(useAcrobatIsTerminalFieldCheck);
        }

        private PDFFieldNodeIterator(PDFFieldList kids, PDFCosArrayList.PDFObjectFilter filter, boolean useAcrobatIsTerminalFieldCheck) {
            this.mFilter = filter;
            this.kids = kids;
            this.useAcrobatIsTerminalFieldCheck = useAcrobatIsTerminalFieldCheck;
            if (kids == null) {
                return;
            }
            this.mKidsIterator = kids.iterator(filter, useAcrobatIsTerminalFieldCheck);
        }

        @Override
        public boolean hasNext() {
            if (this.curField == null) {
                this.curField = this.fetchNextField();
            }
            return this.curField != null;
        }

        @Override
        public PDFField next() {
            if (this.curField == null) {
                throw new NoSuchElementException("Error in PDFFieldNodeIterator next().");
            }
            PDFField nextField = this.curField;
            this.curField = null;
            return nextField;
        }

        @Override
        public void remove() {
            try {
                if (this.mKidIterator == null) {
                    this.mKidsIterator.remove();
                    if (PDFFieldNode.this.getChildren().size() == 0) {
                        PDFFieldNode.this.removeChildren();
                    }
                    return;
                }
                this.mKidIterator.remove();
                if (this.mKid.getChildren() == null) {
                    this.mKidsIterator.remove();
                    if (PDFFieldNode.this.getChildren().size() == 0) {
                        PDFFieldNode.this.removeChildren();
                    }
                }
            }
            catch (PDFException e) {
                IllegalStateException newException = new IllegalStateException("Error in PDFFieldNodeIterator remove().");
                newException.initCause(e);
                throw newException;
            }
        }

        private PDFField fetchNextField() {
            if (this.mKidIterator == null) {
                if (this.mKidsIterator == null) {
                    return null;
                }
                try {
                    this.kids.useAcrobatIsTerminalFieldCheck = this.useAcrobatIsTerminalFieldCheck;
                    PDFFieldNode pDFFieldNode = this.mKid = this.mKidsIterator.hasNext() ? this.mKidsIterator.next() : null;
                    if (null == this.visitedSet) {
                        this.visitedSet = new HashSet();
                    }
                    while (null != this.mKid && this.visitedSet.contains(this.mKid)) {
                        this.mKid = this.mKidsIterator.hasNext() ? this.mKidsIterator.next() : null;
                    }
                    if (null == this.mKid) {
                        return null;
                    }
                    this.visitedSet.add(this.mKid);
                    if (this.mKid.isTerminalField()) {
                        return (PDFField)this.mKid;
                    }
                    this.mKidIterator = this.mFilter == null ? (PDFFieldNodeIterator)this.mKid.iterator(this.useAcrobatIsTerminalFieldCheck) : (PDFFieldNodeIterator)this.mKid.iterator(this.mFilter, this.useAcrobatIsTerminalFieldCheck);
                    this.mKidIterator.visitedSet = this.visitedSet;
                }
                catch (PDFException e) {
                    NoSuchElementException newException = new NoSuchElementException("Error in PDFFieldNodeIterator next().");
                    newException.initCause(e);
                    throw newException;
                }
            }
            this.curField = this.mKidIterator.fetchNextField();
            if (this.curField == null) {
                this.mKidIterator = null;
                this.curField = this.fetchNextField();
            }
            return this.curField;
        }
    }

    private static class PDFFieldNodeFilter
    implements PDFCosArrayList.PDFObjectFilter {
        private final PDFField.PDFFieldFilter fieldFilter;
        private final boolean useAcrobatIsTerminalFieldCheck;

        private PDFFieldNodeFilter(PDFFieldType type, boolean useAcrobatIsTerminalFieldCheck) {
            this.fieldFilter = new PDFField.PDFFieldFilter(type);
            this.useAcrobatIsTerminalFieldCheck = useAcrobatIsTerminalFieldCheck;
        }

        @Override
        public boolean accept(CosObject obj) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
            CosDictionary cosDict = (CosDictionary)obj;
            if (cosDict.containsKey(ASName.k_Fields)) {
                return false;
            }
            if (!PDFFieldUtils.isTerminalField(cosDict, this.useAcrobatIsTerminalFieldCheck)) {
                return true;
            }
            return this.fieldFilter.accept(obj);
        }
    }
}

