/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.forms;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldWithOptions;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import java.util.ArrayList;
import java.util.List;

public class PDFFieldChoice
extends PDFFieldWithOptions {
    public static final int kCombo = 131072;
    public static final int kEdit = 262144;
    public static final int kSort = 524288;
    public static final int kMultiSelect = 0x200000;
    public static final int kDoNotSpellCheck = 0x400000;
    public static final int kCommitOnSelChange = 0x4000000;
    private static final String DEFAULT_CHOICEFIELD_NAME = "Button";

    private PDFFieldChoice(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFieldChoice getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFieldChoice pdfObject = (PDFFieldChoice)PDFCosObject.getCachedInstance(cosObject, PDFFieldChoice.class);
        if (pdfObject == null) {
            pdfObject = new PDFFieldChoice(cosObject);
        }
        return pdfObject;
    }

    public static PDFFieldChoice newInstance(String qualifiedFieldName, PDFPage page, PDFRectangle annotRect, PDFDefaultAppearance da, boolean combineFieldAnnot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (page == null) {
            throw new PDFInvalidParameterException("A page must be provided for the annotation when creating fields.");
        }
        if (annotRect == null) {
            throw new PDFInvalidParameterException("An annotation rectangle must be specified when creating fields.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(page.getPDFDocument());
        PDFFieldChoice field = new PDFFieldChoice(cosObject);
        PDFInteractiveForm iform = page.getPDFDocument().requireCatalog().procureInteractiveForm();
        PDFFieldNode parent = iform.procureIntermediateFieldNodes(qualifiedFieldName);
        String fieldName = PDFFieldUtils.getTerminalFieldName(qualifiedFieldName);
        field.init(parent, fieldName, page, annotRect, combineFieldAnnot, da);
        return field;
    }

    public static PDFFieldChoice newInstance(PDFFieldNode parent, PDFPage page, PDFRectangle annotRect, PDFDefaultAppearance da, boolean combineFieldAnnot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (parent == null) {
            throw new PDFInvalidParameterException("A parent field node must be specified when creating fields.");
        }
        if (page == null) {
            throw new PDFInvalidParameterException("A page must be provided for the annotation when creating fields.");
        }
        if (annotRect == null) {
            throw new PDFInvalidParameterException("An annotation rectangle must be specified when creating fields.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(page.getPDFDocument());
        PDFFieldChoice field = new PDFFieldChoice(cosObject);
        field.init(parent, null, page, annotRect, combineFieldAnnot, da);
        return field;
    }

    private void init(PDFFieldNode parent, String fieldName, PDFPage page, PDFRectangle annotRect, boolean combineFieldAnnot, PDFDefaultAppearance da) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.init(parent, fieldName, DEFAULT_CHOICEFIELD_NAME, da, false);
        this.initWidgetAnnot(page, annotRect, combineFieldAnnot);
        this.setDictionaryNameValue(ASName.k_FT, ASName.k_Ch);
    }

    public boolean isComboBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.getFlags() & 0x20000) != 0;
    }

    public void setComboBox(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value) {
            this.setFlags(this.getFlags() | 0x20000);
        } else {
            this.setFlags(this.getFlags() & 0xFFFDFFFF);
        }
    }

    public boolean hasEditableTextBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.isComboBox() && (this.getFlags() & 0x40000) != 0;
    }

    public void setEditable(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isComboBox()) {
            if (value) {
                this.setFlags(this.getFlags() | 0x40000);
            } else {
                this.setFlags(this.getFlags() & 0xFFFBFFFF);
            }
        }
    }

    public boolean shouldSort() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.getFlags() & 0x80000) != 0;
    }

    public void setSort(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value) {
            this.setFlags(this.getFlags() | 0x80000);
        } else {
            this.setFlags(this.getFlags() & 0xFFF7FFFF);
        }
    }

    public boolean isMultipleSelectionAllowed() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.getFlags() & 0x200000) != 0;
    }

    public void setMultipleSelectionAllowed(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value) {
            this.setFlags(this.getFlags() | 0x200000);
        } else {
            this.setFlags(this.getFlags() & 0xFFDFFFFF);
        }
    }

    public void setcommitOnSelChange(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value) {
            this.setFlags(this.getFlags() | 0x4000000);
        } else {
            this.setFlags(this.getFlags() & 0xFBFFFFFF);
        }
    }

    public boolean shouldNotSpellCheck() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.isComboBox() && this.hasEditableTextBox() && (this.getFlags() & 0x400000) != 0;
    }

    @Override
    public CosObject getOptionValue() throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldNode parent;
        CosObject options = this.getDictionaryCosObjectValue(ASName.k_Opt);
        if (options == null && this.isAcrobatAnnotation() && (parent = this.getParent()) != null) {
            options = parent.getDictionaryCosObjectValue(ASName.k_Opt);
        }
        return options;
    }

    public int getOptionValueSize() throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return ((CosArray)this.getOptionValue()).size();
    }

    protected void setOptionValue(CosObject options) throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Opt, options);
    }

    public boolean commitOnSelectionChange() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (this.getFlags() & 0x4000000) != 0;
    }

    public boolean hasTopIndex() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_TI);
    }

    public int getTopIndex() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldNode parent;
        Number topIdx = this.getDictionaryNumericValue(ASName.k_TI);
        if (topIdx == null && this.isAcrobatAnnotation() && (parent = this.getParent()) != null) {
            topIdx = parent.getDictionaryNumericValue(ASName.k_TI);
        }
        return topIdx == null ? 0 : topIdx.intValue();
    }

    public void setTopIndex(int topIndex) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (topIndex < 0) {
            throw new PDFInvalidParameterException("Invalid value of TopIndex: " + topIndex);
        }
        this.setDictionaryIntValue(ASName.k_TI, topIndex);
    }

    public boolean hasIndexArray() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCosUtils.containsInheritableKey(ASName.k_I, ASName.k_Parent, this);
    }

    public void setIndexArray(int[] arr) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (arr == null || arr.length == 0) {
            this.removeValue(ASName.k_I);
            return;
        }
        CosArray inArr = PDFCosObject.newCosArray(this.getPDFDocument());
        for (int i = 0; i < arr.length; ++i) {
            inArr.addInt(i, arr[i]);
        }
        this.setDictionaryArrayValue(ASName.k_I, inArr);
        Object selected = this.getSelectedItem();
        this.setStringValue(selected.toString());
    }

    public int[] getIndexArray() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = PDFCosUtils.getInheritableValue(ASName.k_I, ASName.k_Parent, this);
        if (!(cosObject instanceof CosArray)) {
            return null;
        }
        CosArray cosArray = (CosArray)cosObject;
        if (cosArray == null || cosArray.size() == 0) {
            return null;
        }
        ArrayList<Integer> indexArray = new ArrayList<Integer>();
        for (int arrayInd = 0; arrayInd < cosArray.size(); ++arrayInd) {
            CosObject arrayItem = cosArray.get(arrayInd);
            if (!(arrayItem instanceof CosNumeric)) continue;
            indexArray.add(arrayItem.intValue());
        }
        if (indexArray.isEmpty()) {
            return null;
        }
        int[] array = new int[indexArray.size()];
        for (int idx = 0; idx < indexArray.size(); ++idx) {
            array[idx] = (Integer)indexArray.get(idx);
        }
        return array;
    }

    public void insertItemAt(int pos, String item, String exportValue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject options = this.cloneOptionValue();
        ASString astr = new ASString(item);
        CosArray valArr = this.getPDFDocument().getCosDocument().createCosArray();
        if (options instanceof CosArray) {
            this.checkDuplicate((CosArray)options, astr);
            valArr.addString(new ASString(exportValue));
            valArr.addString(astr);
            ((CosArray)options).add(pos, valArr);
        } else {
            options = PDFCosObject.newCosArray(this.getPDFDocument());
            this.setOptionValue(options);
            valArr.addString(new ASString(exportValue));
            valArr.addString(astr);
            ((CosArray)options).add(pos, valArr);
        }
        Object selected = this.getSelectedItem();
        if (selected != null) {
            this.setStringValue(selected.toString());
        }
    }

    private int checkDuplicate(CosArray options, ASString astr) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        for (int i = 0; i < options.size(); ++i) {
            CosArray arr = options.getCosArray(i);
            if (arr.findString(astr) == -1) continue;
            options.remove(i);
        }
        return -1;
    }

    public Object getSelectedItem() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject arr = this.getOptionValue();
        int[] iarr = this.getIndexArray();
        String value = null;
        if (arr != null && iarr != null) {
            int idxSelection = iarr[0];
            List options = this.getOptionList();
            if (options.size() > idxSelection) {
                value = this.getValueFromOptions(this.getOptionList().get(idxSelection), this.getQualifiedName());
                return value;
            }
            if (options.get(0) instanceof List) {
                options = (List)options.get(0);
                value = this.getValueFromOptions(options.get(idxSelection), this.getQualifiedName());
            }
            return value;
        }
        if (arr instanceof CosArray) {
            CosObject selected = ((CosArray)arr).get(0);
            if (selected instanceof CosArray) {
                return ((CosArray)selected).get(0).textValue();
            }
            return selected.textValue();
        }
        return null;
    }

    private String getValueFromOptions(Object value, String fieldName) throws PDFInvalidDocumentException {
        String optionValue = null;
        if (value instanceof String) {
            optionValue = (String)value;
        }
        if (value instanceof ArrayList && value != null && ((ArrayList)value).size() > 0) {
            if (((ArrayList)value).size() > 2) {
                throw new PDFInvalidDocumentException("More than 2 elements in Opt array for choice field " + fieldName + ".");
            }
            optionValue = ((ArrayList)value).size() == 1 ? (String)((ArrayList)value).get(0) : (String)((ArrayList)value).get(1);
        }
        return optionValue;
    }

    public Object getItemAt(int pos, boolean exportValue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject arr = this.getOptionValue();
        if (arr instanceof CosArray) {
            CosObject selected = ((CosArray)arr).get(pos);
            if (selected instanceof CosArray) {
                if (exportValue) {
                    return ((CosArray)selected).get(0).textValue();
                }
                return ((CosArray)selected).get(1).textValue();
            }
            return selected.textValue();
        }
        return null;
    }

    public void deleteItemAt(int pos) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject options = this.cloneOptionValue();
        if (options instanceof CosArray) {
            ((CosArray)options).remove(pos);
        }
    }

    public void removeAllItems() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject options = this.cloneOptionValue();
        if (options instanceof CosArray) {
            ((CosArray)options).clear();
        }
        this.removeValue(ASName.k_V);
        this.removeValue(ASName.k_DV);
        this.removeValue(ASName.k_I);
    }

    public void setdoNotSpellCheck(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.isComboBox();
        if (value) {
            this.setFlags(this.getFlags() | 0x400000);
        } else {
            this.setFlags(this.getFlags() | 0xFFBFFFFF);
        }
    }

    public Object getValue() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getSelectedItem();
    }

    private CosObject cloneOptionValue() throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean needClone = false;
        CosObject options = this.getDictionaryCosObjectValue(ASName.k_Opt);
        if (options != null) {
            if (options.isIndirect()) {
                needClone = true;
            }
        } else {
            options = this.getOptionValue();
            if (options != null && options.isIndirect()) {
                needClone = true;
            }
        }
        if (needClone) {
            options = new CosCloneMgr(this.getPDFDocument().getCosDocument()).clone(options);
            this.setOptionValue(options);
        }
        return options;
    }

    public void setOptIndex() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        List values = this.getValueList();
        List options = this.getOptionList();
        if (values == null || options == null) {
            return;
        }
        String[] optionStrings = new String[options.size()];
        for (int optInd = 0; optInd < options.size(); ++optInd) {
            Object curOption = options.get(optInd);
            if (curOption instanceof ArrayList) {
                curOption = ((ArrayList)curOption).get(0);
            }
            optionStrings[optInd] = (String)curOption;
        }
        ArrayList<Integer> optIndeces = new ArrayList<Integer>(optionStrings.length);
        for (Object curValue : values) {
            int valueIndex;
            if (!(curValue instanceof String) || (valueIndex = PDFUtil.findStringInArray((String)curValue, optionStrings)) < 0) continue;
            optIndeces.add(valueIndex);
        }
        this.setDictionaryArrayValue(ASName.k_I, optIndeces);
    }

    @Override
    public boolean hasOptionList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return super.getCosDictionary().get(ASName.k_Opt) != null;
    }

    @Override
    public List getOptionList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject options = this.getOptionValue();
        if (options == null) {
            return null;
        }
        return this.addOptionsItem(null, options);
    }

    private List addOptionsItem(ArrayList optionList, CosObject cosItem) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (cosItem.getType() == 4) {
            PDFText text = PDFText.getInstance(cosItem);
            if (optionList == null) {
                optionList = new ArrayList<String>();
            }
            optionList.add(text.stringValue());
        } else if (cosItem.getType() == 5) {
            CosArray cosArray = (CosArray)cosItem;
            ArrayList arrayVal = new ArrayList(2);
            for (int arrayInd = 0; arrayInd < cosArray.size(); ++arrayInd) {
                CosObject arrayItem = cosArray.get(arrayInd);
                this.addOptionsItem(arrayVal, arrayItem);
            }
            if (optionList == null) {
                optionList = arrayVal;
            } else {
                optionList.add((String)((Object)arrayVal));
            }
        }
        return optionList;
    }

    @Override
    public void setOptionList(List option) throws PDFIOException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_Opt, option);
    }

    @Override
    public void setOptionList(String option) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Opt, option);
    }
}

