/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive.annotation;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosStream;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationMarkup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWithIcon;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFMultimediaUtil;

public class PDFAnnotationSound
extends PDFAnnotationMarkup
implements PDFAnnotationWithIcon {
    private PDFAnnotationSound(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    public static PDFAnnotationSound getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFAnnotationSound pdfObject = (PDFAnnotationSound)PDFCosObject.getCachedInstance(cosObject, PDFAnnotationSound.class);
        if (pdfObject == null) {
            pdfObject = new PDFAnnotationSound(cosObject);
        }
        return pdfObject;
    }

    private PDFAnnotationSound(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pdfDoc);
        this.setSubtype(ASName.k_Sound);
    }

    public static PDFAnnotationSound newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFAnnotationSound(pdfDocument);
    }

    public PDFCosStream getSoundFromAnnotation() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (PDFCosStream)PDFMultimediaUtil.createPDFMultimediaObject("PDFSound", this.getDataDictionary());
    }

    boolean hasDataDictionary() {
        return this.getCosDictionary().containsKey(ASName.k_Sound);
    }

    private CosDictionary getDataDictionary() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary dataDictionary = this.getDictionaryDictionaryValue(ASName.k_Sound);
        if (dataDictionary == null) {
            throw new PDFInvalidDocumentException("Missing required entry Data Dictionary");
        }
        return this.getDictionaryDictionaryValue(ASName.k_Sound);
    }

    private CosDictionary procureDataDictionary() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.hasDataDictionary()) {
            this.setDictionaryValue(ASName.k_Sound, PDFCosObject.newCosStream(this.getPDFDocument()));
        }
        return this.getDataDictionary();
    }

    public CosStream getDataStream() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (CosStream)this.getDictionaryCosObjectValue(ASName.k_Sound);
    }

    public boolean hasBits() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.hasDataDictionary() && this.getDataDictionary().containsKey(ASName.k_B);
    }

    public int getBits() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDataDictionary().getInt(ASName.k_B);
    }

    public void setBits(int soundBits) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.procureDataDictionary().put(ASName.k_B, soundBits);
    }

    public boolean hasChannels() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.hasDataDictionary() && this.getDataDictionary().containsKey(ASName.k_C);
    }

    public int getChannels() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDataDictionary().getInt(ASName.k_C);
    }

    public void setChannels(int soundChannels) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.procureDataDictionary().put(ASName.k_C, soundChannels);
    }

    public boolean hasEncoding() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.hasDataDictionary() && this.getDataDictionary().containsKey(ASName.k_E);
    }

    public String getEncoding() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName encoding = this.getDataDictionary().getName(ASName.k_E);
        if (encoding == null) {
            return null;
        }
        return encoding.asString(true);
    }

    public void setEncoding(String soundEncoding) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.procureDataDictionary().put(ASName.k_E, ASName.create(soundEncoding));
    }

    public boolean hasRate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.hasDataDictionary() && this.getDataDictionary().containsKey(ASName.k_R);
    }

    public double getRate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDataDictionary().getDouble(ASName.k_R);
    }

    public void setRate(double soundRate) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.procureDataDictionary().put(ASName.k_R, soundRate);
    }

    @Override
    public boolean hasIconName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Name);
    }

    @Override
    public String getIconName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj = this.getDictionaryValue(ASName.k_Name);
        if (obj instanceof CosName) {
            return this.getDictionaryNameValue(ASName.k_Name).asString(true);
        }
        ASString asStr = this.getDictionaryStringValue(ASName.k_Name);
        return asStr != null ? asStr.asString() : null;
    }

    @Override
    public void setIconName(String icon) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Name, icon);
    }

    @Override
    public void transform(ASMatrix matrix, double rotationAngle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.transformRect(matrix);
        this.transformAppearances(matrix, rotationAngle);
    }
}

