/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.interactive;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFMeasure;
import com.adobe.internal.pdftoolkit.pdf.interactive.geospatial.PDFPointData;

public class PDFViewPort
extends PDFCosDictionary {
    private static ASName k_Viewport = ASName.create("Viewport");

    private PDFViewPort(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFViewPort newInstance(PDFDocument pdfDocument, PDFRectangle key_BBox) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (key_BBox == null) {
            throw new PDFInvalidParameterException("BBox is required when creating newInstance of PDFViewPort.");
        }
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFViewPort pdfObject = new PDFViewPort(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, k_Viewport);
        pdfObject.setBBox(key_BBox);
        return pdfObject;
    }

    public static PDFViewPort getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFViewPort pdfObject = (PDFViewPort)PDFCosObject.getCachedInstance(cosObject, PDFViewPort.class);
        if (pdfObject == null) {
            pdfObject = new PDFViewPort(cosObject);
        }
        return pdfObject;
    }

    public PDFMeasure getMeasure() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFMeasure.getInstance(this.getDictionaryCosObjectValue(ASName.k_Measure));
    }

    public void setMeasure(PDFMeasure value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryValue(ASName.k_Measure, value);
    }

    public boolean hasMeasure() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Measure);
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public boolean hasType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Type);
    }

    public ASString getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryStringValue(ASName.k_Name);
    }

    public void setName(ASString value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.setDictionaryASStringValue(ASName.k_Name, value);
    }

    public boolean hasName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_Name);
    }

    public PDFRectangle getBBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFRectangle.getInstance(this.getDictionaryCosObjectValue(ASName.k_BBox));
    }

    public void setBBox(PDFRectangle children) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (children == null) {
            throw new PDFInvalidParameterException("BBox is a required key therefore cannot be removed.");
        }
        this.setDictionaryArrayValue(ASName.k_BBox, children.getCosArray());
    }

    public boolean hasBBox() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_BBox);
    }

    public PDFPointData getPointData() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFPointData.getInstance(this.getDictionaryValue(ASName.k_PtData));
    }

    public void setPointData(PDFPointData pdfPointData) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_PtData, pdfPointData);
    }
}

