/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PDFOCContentUsageUserList
extends PDFCosObject {
    private PDFOCContentUsageUserList(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFOCContentUsageUserList getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFOCContentUsageUserList pdfObject = (PDFOCContentUsageUserList)PDFCosObject.getCachedInstance(cosObject, PDFOCContentUsageUserList.class);
        if (pdfObject == null) {
            pdfObject = new PDFOCContentUsageUserList(cosObject);
        }
        return pdfObject;
    }

    public static PDFOCContentUsageUserList newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        return new PDFOCContentUsageUserList(cosObject);
    }

    public static PDFOCContentUsageUserList newInstance(PDFDocument pdfDocument, ASString user) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        PDFOCContentUsageUserList pdfObject = new PDFOCContentUsageUserList(cosObject);
        cosObject.addString(user);
        return pdfObject;
    }

    public Iterator iterator() {
        return new UserIterator(this.getCosObject());
    }

    public boolean contains(ASString user) throws PDFSecurityException {
        boolean result = false;
        CosObject myObj = this.getCosObject();
        if (myObj instanceof CosString) {
            result = ((CosString)myObj).stringValue().equals(user);
        } else if (myObj instanceof CosArray) {
            Iterator iter = this.iterator();
            boolean iterResult = false;
            while (iter.hasNext()) {
                ASString objString = (ASString)iter.next();
                if (!objString.equals(user)) continue;
                iterResult = true;
                break;
            }
            result = iterResult;
        }
        return result;
    }

    static class UserIterator
    implements Iterator {
        private CosObject mNextObj = null;
        private int mType;
        private Iterator mIterator = null;
        private static final int ARRAY = 1;
        private static final int STRING = 2;

        UserIterator(CosObject cosObject) {
            if (cosObject instanceof CosArray) {
                this.mIterator = ((CosArray)cosObject).iterator();
                this.mType = 1;
            } else if (cosObject instanceof CosString) {
                this.mNextObj = cosObject;
                this.mType = 2;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public boolean hasNext() {
            boolean result = false;
            if (this.mType == 1) {
                result = this.mIterator.hasNext();
            } else if (this.mType == 2) {
                result = this.mNextObj != null;
            }
            return result;
        }

        public Object next() {
            ASString result = null;
            try {
                if (this.mType == 1) {
                    CosString resultObj = (CosString)this.mIterator.next();
                    result = resultObj.stringValue();
                } else if (this.mType == 2) {
                    CosString obj = (CosString)this.mNextObj;
                    this.mNextObj = null;
                    result = obj.stringValue();
                }
            }
            catch (PDFException e) {
                NoSuchElementException newException = new NoSuchElementException("Error during UserIterator.next().");
                newException.initCause(e);
                throw newException;
            }
            return result;
        }
    }
}

