/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCBaseState;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupArray;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCIntentList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCListMode;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCOrderList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCRGBGroupsList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCUsageApp;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCUsageAppList;

public class PDFOCConfig
extends PDFCosDictionary {
    protected PDFOCConfig(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFOCConfig getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFOCConfig pdfObject = (PDFOCConfig)PDFCosObject.getCachedInstance(cosObject, PDFOCConfig.class);
        if (pdfObject == null) {
            pdfObject = new PDFOCConfig(cosObject);
        }
        return pdfObject;
    }

    public static PDFOCConfig newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new PDFOCConfig(PDFCosObject.newCosDictionary(pdfDocument));
    }

    public static PDFOCConfig defaultInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCConfig configDict = PDFOCConfig.newInstance(pdfDocument);
        configDict.setBaseStateON();
        configDict.setIntentView();
        configDict.setOrderList(PDFOCOrderList.newInstance(pdfDocument));
        configDict.setListModeAllPages();
        configDict.setRBGroups(PDFOCRGBGroupsList.newInstance(pdfDocument));
        configDict.setLocked(PDFOCGroupArray.newInstance(pdfDocument));
        return configDict;
    }

    public void setName(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Name, name);
    }

    public String getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Name);
    }

    public void setCreator(String name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Creator, name);
    }

    public String getCreator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Creator);
    }

    public void setBaseStateON() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setBaseState(PDFOCBaseState.ON);
    }

    public void setBaseStateOFF() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setBaseState(PDFOCBaseState.OFF);
    }

    public void setBaseStateUnchanged() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setBaseState(PDFOCBaseState.Unchanged);
    }

    public void setBaseState(PDFOCBaseState state) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_BaseState, state.getState());
    }

    public boolean hasBaseState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_BaseState);
    }

    public PDFOCBaseState getBaseState() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName state = this.getDictionaryNameValue(ASName.k_BaseState);
        return PDFOCBaseState.getInstance(state);
    }

    public void setIntentView() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCIntentList intentList;
        try {
            intentList = PDFOCIntentList.newInstance(this.getPDFDocument(), ASName.k_View);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
        this.setIntent(intentList);
    }

    public void setIntentDesign() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCIntentList intentList;
        try {
            intentList = PDFOCIntentList.newInstance(this.getPDFDocument(), ASName.k_Design);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
        this.setIntent(intentList);
    }

    public void setIntentAll() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCIntentList intentList;
        try {
            intentList = PDFOCIntentList.newInstance(this.getPDFDocument(), ASName.k_All);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException(e);
        }
        this.setIntent(intentList);
    }

    public void addIntent(ASName intent) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj = this.getDictionaryCosObjectValue(ASName.k_Intent);
        if (obj instanceof CosName) {
            PDFOCIntentList newList;
            try {
                newList = PDFOCIntentList.newInstance(this.getPDFDocument(), ((CosName)obj).nameValue());
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException(e);
            }
            this.setIntent(newList);
            obj = newList.getCosObject();
        }
        if (obj instanceof CosArray) {
            CosArray arrayObj = (CosArray)obj;
            arrayObj.addName(intent);
        }
    }

    public void setIntent(PDFOCIntentList intentList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_Intent, intentList);
    }

    public PDFOCIntentList getIntent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject obj = this.getDictionaryCosObjectValue(ASName.k_Intent);
        return PDFOCIntentList.getInstance(obj);
    }

    public void setONList(PDFOCGroupArray ocgs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_ON, ocgs != null ? ocgs.getCosArray() : null);
    }

    public PDFOCGroupArray getONList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCGroupArray result = null;
        CosArray on = this.getDictionaryArrayValue(ASName.k_ON);
        if (on != null) {
            result = PDFOCGroupArray.getInstance(on);
        }
        return result;
    }

    public void setOFFList(PDFOCGroupArray ocgs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_OFF, ocgs != null ? ocgs.getCosArray() : null);
    }

    public PDFOCGroupArray getOFFList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCGroupArray result = null;
        CosArray on = this.getDictionaryArrayValue(ASName.k_OFF);
        if (on != null) {
            result = PDFOCGroupArray.getInstance(on);
        }
        return result;
    }

    public void setASList(PDFOCUsageAppList usageList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_AS, usageList.getCosArray());
    }

    public PDFOCUsageAppList getASList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCUsageAppList result = null;
        CosArray usages = this.getDictionaryArrayValue(ASName.k_AS);
        if (usages != null) {
            result = PDFOCUsageAppList.getInstance(usages);
        }
        return result;
    }

    public void setOrderList(PDFOCOrderList orderList) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (orderList == null) {
            this.removeValue(ASName.k_Order);
        } else {
            this.setDictionaryArrayValue(ASName.k_Order, orderList.getCosArray());
        }
    }

    public PDFOCOrderList getOrderList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCOrderList result = null;
        CosArray order = this.getDictionaryArrayValue(ASName.k_Order);
        if (order != null) {
            result = PDFOCOrderList.getInstance(order);
        }
        return result;
    }

    public void setListModeAllPages() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setListMode(PDFOCListMode.AllPages);
    }

    public void setListModeVisiblePages() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setListMode(PDFOCListMode.VisiblePages);
    }

    public void setListMode(PDFOCListMode mode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_ListMode, mode.getMode());
    }

    public PDFOCListMode getListMode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName mode = this.getDictionaryNameValue(ASName.k_ListMode);
        return PDFOCListMode.getInstance(mode);
    }

    public void setLocked(PDFOCGroupArray ocgs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_Locked, ocgs != null ? ocgs.getCosArray() : null);
    }

    public PDFOCGroupArray getLocked() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCGroupArray result = null;
        CosArray locked = this.getDictionaryArrayValue(ASName.k_Locked);
        if (locked != null) {
            result = PDFOCGroupArray.getInstance(locked);
        }
        return result;
    }

    public void setRBGroups(PDFOCRGBGroupsList ocgs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_RBGroups, ocgs != null ? ocgs.getCosArray() : null);
    }

    public PDFOCRGBGroupsList getRBGroups() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCRGBGroupsList result = null;
        CosArray rbgs = this.getDictionaryArrayValue(ASName.k_RBGroups);
        if (rbgs != null) {
            result = PDFOCRGBGroupsList.getInstance(rbgs);
        }
        return result;
    }

    public void remove(PDFOCGroup ocg) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCGroupArray offOCGs;
        PDFOCGroupArray onOCGs = this.getONList();
        if (onOCGs != null && onOCGs.contains(ocg)) {
            onOCGs.remove(ocg);
        }
        if ((offOCGs = this.getOFFList()) != null && offOCGs.contains(ocg)) {
            offOCGs.remove(ocg);
        }
        PDFOCOrderList orderList = this.getOrderList();
        orderList.remove(ocg);
        PDFOCUsageAppList usageAppList = this.getASList();
        for (PDFOCUsageApp usageAppDict : usageAppList) {
            usageAppDict.getOCGs().remove(ocg);
        }
    }
}

