/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings;

import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.Encoding;

public abstract class CharSetEncoding
implements Encoding {
    private ASName name;
    private char[] toUnicodeMap;
    private String[] toGlyphNameMap;
    private short[] charIdsWithGlyphNamesSortedMap;
    private short[] charIdsWithUnicodeSortedMap;
    static final String NOTDEF = ".notdef";

    protected CharSetEncoding(ASName name, char[] toUnicodeMap) {
        this.name = name;
        this.toUnicodeMap = toUnicodeMap;
    }

    protected CharSetEncoding(ASName name, char[] toUnicodeMap, String[] toGlyphNameMap) {
        this(name, toUnicodeMap);
        this.toGlyphNameMap = toGlyphNameMap;
    }

    protected CharSetEncoding(ASName name, char[] toUnicodeMap, String[] toGlyphNameMap, short[] charIdsWithGlyphNamesSortedMap, short[] charIdsWithUnicodeSortedMap) {
        this(name, toUnicodeMap, toGlyphNameMap);
        this.charIdsWithGlyphNamesSortedMap = charIdsWithGlyphNamesSortedMap;
        this.charIdsWithUnicodeSortedMap = charIdsWithUnicodeSortedMap;
    }

    public ASName getName() {
        return this.name;
    }

    @Override
    public String toUnicode(ASString string) {
        byte[] bytes = string.getBytes();
        return this.toUnicode(bytes, 0, bytes.length);
    }

    @Override
    public String toUnicode(byte[] bytes, int start, int length) {
        if (length > 0 && bytes != null) {
            StringBuilder strBuf = new StringBuilder(bytes.length);
            for (int index = start; index < length; ++index) {
                strBuf.append(this.toUnicode(bytes[index]));
            }
            return strBuf.toString();
        }
        return null;
    }

    @Override
    public char[] toUnicode(byte charCode) {
        char[] unicodeChars = new char[1];
        int index = charCode & 0xFF;
        unicodeChars[0] = this.toUnicodeMap[index];
        return unicodeChars;
    }

    @Override
    public char[] toUnicode(byte charCode, ASName fontName) {
        return this.toUnicode(charCode);
    }

    @Override
    public int fromUnicode(char unicodeChar) {
        if (this.charIdsWithUnicodeSortedMap == null) {
            for (int i = 0; i < this.toUnicodeMap.length; ++i) {
                if (this.toUnicodeMap[i] != unicodeChar) continue;
                return i;
            }
            return 0;
        }
        int lowerLimit = 0;
        int upperLimit = this.charIdsWithUnicodeSortedMap.length - 1;
        int lastFoundIndex = 0;
        while (lowerLimit <= upperLimit) {
            int mid = (lowerLimit + upperLimit) / 2;
            if (this.toUnicodeMap[this.charIdsWithUnicodeSortedMap[mid]] == unicodeChar) {
                lastFoundIndex = this.charIdsWithUnicodeSortedMap[mid];
                upperLimit = mid - 1;
                continue;
            }
            if (this.toUnicodeMap[this.charIdsWithUnicodeSortedMap[mid]] > unicodeChar) {
                upperLimit = mid - 1;
                continue;
            }
            lowerLimit = mid + 1;
        }
        return lastFoundIndex;
    }

    public int fromGlyphName(String glyphName) {
        if (this.charIdsWithGlyphNamesSortedMap == null) {
            for (int i = 0; i < this.toGlyphNameMap.length; ++i) {
                if (!glyphName.equals(this.toGlyphNameMap[i])) continue;
                return i;
            }
            return 0;
        }
        int lowerLimit = 0;
        int upperLimit = this.charIdsWithGlyphNamesSortedMap.length - 1;
        int lastFoundIndex = 0;
        while (lowerLimit <= upperLimit) {
            int mid = (lowerLimit + upperLimit) / 2;
            if (this.toGlyphNameMap[this.charIdsWithGlyphNamesSortedMap[mid]].equals(glyphName)) {
                lastFoundIndex = this.charIdsWithGlyphNamesSortedMap[mid];
                upperLimit = mid - 1;
                continue;
            }
            if (this.toGlyphNameMap[this.charIdsWithGlyphNamesSortedMap[mid]].compareTo(glyphName) > 0) {
                upperLimit = mid - 1;
                continue;
            }
            lowerLimit = mid + 1;
        }
        return lastFoundIndex;
    }

    @Override
    public String getGlyphName(int charCode) {
        if (charCode >= this.toGlyphNameMap.length || charCode < 0) {
            return null;
        }
        return this.toGlyphNameMap[charCode];
    }
}

