/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.graphics.font;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.FontLoader;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.fontset.impl.PDFFontSetImpl;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontDescriptor;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontFile;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType3;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFToUnicodeCMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFWritingMode;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFCMapUtils;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;

public abstract class PDFFont
extends PDFCosDictionary {
    private Font afeFont = null;
    private PDFFontSet mFontSet;

    protected PDFFont(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public PDFFont(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(PDFFont.newCosDictionary(pdfDoc));
        this.setDictionaryNameValue(ASName.k_Type, ASName.k_Font);
    }

    public PDFFont(PDFDocument pdfDoc, Font afeFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(PDFFont.newCosDictionary(pdfDoc));
        this.setDictionaryNameValue(ASName.k_Type, ASName.k_Font);
        this.afeFont = afeFont;
    }

    @Override
    public String toString() {
        try {
            return this.getBaseFont().asString(true);
        }
        catch (PDFException e) {
            return "";
        }
    }

    public ASName getSubtype() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        return this.getDictionaryNameValue(ASName.k_Subtype);
    }

    public FontData getAFEFontData() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        try {
            if (this.afeFont == null) {
                this.getAFEFont();
            }
            if (this.afeFont != null) {
                return ((FontImpl)this.afeFont).getFontData();
            }
        }
        catch (InvalidFontException e) {
            throw new PDFIOException(e);
        }
        catch (UnsupportedFontException e) {
            throw new PDFIOException(e);
        }
        catch (FontLoadingException e) {
            throw new PDFIOException(e);
        }
        return null;
    }

    protected static ASRectangle getRectangleCoords(Rect bbox) {
        if (bbox != null) {
            double x_left = bbox.xmin;
            double y_bottom = bbox.ymin;
            double x_right = bbox.xmax;
            double y_top = bbox.ymax;
            return new ASRectangle(x_left, y_bottom, x_right, y_top);
        }
        return new ASRectangle(0.0, 0.0, 0.0, 0.0);
    }

    public ASName getBaseFont() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getName(ASName.k_BaseFont);
    }

    private boolean hasBaseFont() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().containsKey(ASName.k_BaseFont);
    }

    public void setBaseFont(ASName baseFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_BaseFont, baseFont);
    }

    public ASName getName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getCosDictionary().getName(ASName.k_Name);
    }

    public abstract PDFWritingMode getWritingMode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

    public abstract double getGlyphWidth(byte[] var1) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException;

    public abstract double getGlyphHeight(byte[] var1) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

    public abstract double getGlyphDisplacement(int var1) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException;

    public abstract double getAscent() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException;

    public abstract double getDescent() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException;

    public abstract ASRectangle getBBox() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException;

    public abstract char[] getUnicode(long var1) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException;

    public abstract byte[] getSpaceCharCode() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

    public abstract List getCharCodes(byte[] var1, boolean var2) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

    public PDFToUnicodeCMap getToUnicodeCMap() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObj = this.getCosDictionary().get(ASName.k_ToUnicode);
        if (cosObj != null) {
            return PDFToUnicodeCMap.getInstance(cosObj);
        }
        return null;
    }

    public void setToUnicodeCMap(PDFToUnicodeCMap unicodeCMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (unicodeCMap == null) {
            this.removeValue(ASName.k_ToUnicode);
        } else {
            this.setDictionaryStreamValue(ASName.k_ToUnicode, unicodeCMap.getCosStream());
        }
    }

    public void resetAFEFont() {
        this.afeFont = null;
    }

    public Font getAFEFont() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, FontLoadingException {
        return this.getAFEFont(false);
    }

    public Font getAFEFont(boolean substitute) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, FontLoadingException {
        Font font = this.afeFont;
        if (font == null) {
            PDFFontFile pdfFontFile = PDFFontUtils.getFontFileFromFontDescriptor(PDFFontUtils.getPDFFontDescriptor(this));
            if (pdfFontFile != null) {
                InputByteStream fontByteStream = null;
                InputStream fontStream = null;
                try {
                    fontByteStream = pdfFontFile.getStream();
                    fontStream = fontByteStream.toInputStream();
                    long fontStreamLength = fontByteStream.length();
                    font = new FontLoader().load(fontStream, (int)fontStreamLength, true);
                }
                catch (IOException e) {
                    throw new PDFIOException(e);
                }
                finally {
                    if (fontByteStream != null) {
                        try {
                            fontByteStream.close();
                        }
                        catch (IOException e) {
                            throw new PDFIOException(e);
                        }
                    }
                    if (fontStream != null) {
                        try {
                            fontStream.close();
                        }
                        catch (IOException e) {
                            throw new PDFIOException(e);
                        }
                    }
                }
            }
            if (!(this instanceof PDFFontType3)) {
                try {
                    PDFFontSetImpl fontSet;
                    String psName = null;
                    if (this instanceof PDFFontType0) {
                        psName = ((PDFFontType0)this).getDescendantFont().getBaseFont().asString(true);
                    } else if (this.hasBaseFont()) {
                        psName = this.getBaseFont().asString(true);
                    }
                    if (psName != null && (fontSet = this.mFontSet != null ? (PDFFontSetImpl)this.mFontSet : (PDFFontSetImpl)this.getPDFDocument().getCosDocument().getOptions().getFontSet()) != null) {
                        Locale docLocale = this.getPDFDocument().getCosDocument().getOptions().getDocLocale();
                        font = fontSet.getPSFont(new PostscriptFontDescription(psName), docLocale, substitute);
                    }
                }
                catch (PDFFontException e) {
                    throw new PDFIOException(e);
                }
            }
            this.afeFont = font;
        }
        return font;
    }

    public abstract int charCode2gid(int var1) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException;

    public abstract PDFFontDescriptor getFontDescriptor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException;

    public void setFontSet(PDFFontSet fontSet) {
        this.mFontSet = fontSet;
    }

    public boolean applyHeuristicsToGetSpaceCharWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!PDFFontUtils.isSubsetFont(this)) {
            return false;
        }
        try {
            byte[] bytes = this.getSpaceCharCode();
            int charCode = (int)PDFCMapUtils.getCharCode(bytes);
            long gid = this.charCode2gid(charCode);
            if (gid < 1L) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

