/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.filters;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterCrypt;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterParams;
import java.util.Map;

public class PDFFilter
extends PDFCosObject {
    protected PDFFilter(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFilter getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFilter pdfObject = (PDFFilter)PDFCosObject.getCachedInstance(cosObject, PDFFilter.class);
        if (pdfObject == null) {
            pdfObject = new PDFFilter(cosObject);
        }
        return pdfObject;
    }

    public static PDFFilter newInstance(PDFDocument pdfDocument, String nameString, Map paramsMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName nameAtom = ASName.create(nameString);
        return PDFFilter.newInstance(pdfDocument, nameAtom, paramsMap);
    }

    public static PDFFilter newInstance(PDFDocument pdfDocument, ASName nameAtom, Map paramsMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFilterParams params = null;
        if (paramsMap != null) {
            params = PDFFilterParams.newInstance(pdfDocument, paramsMap);
        }
        return PDFFilter.newInstance(pdfDocument, nameAtom, params);
    }

    public static PDFFilter newInstance(PDFDocument pdfDocument, ASName nameAtom, PDFFilterParams filterParams) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (nameAtom == ASName.k_Crypt) {
            return PDFFilterCrypt.newInstance(pdfDocument, filterParams);
        }
        if (nameAtom == ASName.k_FlateDecode) {
            return PDFFilterFlate.newInstance(pdfDocument, filterParams);
        }
        CosArray cosArray = pdfDocument.getCosDocument().createCosArray();
        cosArray.addName(nameAtom);
        cosArray.add(filterParams != null ? filterParams.getCosObject() : pdfDocument.getCosDocument().createCosNull());
        return new PDFFilter(cosArray);
    }

    public ASName getFilterName() {
        try {
            return this.getCosArray().getName(0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PDFFilterParams getParams() {
        try {
            return PDFFilterParams.getInstance(this.getCosArray().get(1));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

