/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document.listener;

import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class DocumentMessage {
    public static final MessageType SAVE = new MessageType("Save");
    public static final MessageType CLOSE = new MessageType("Close");
    public static final MessageType FINISH = new MessageType("Finish");
    public static final MessageType FLUSH_FONTS = new MessageType("Flush Fonts");
    private final MessageType messageType;
    private final PDFDocument document;
    private boolean listenersDirty;
    private boolean documentDirty;

    public DocumentMessage(MessageType messageType, PDFDocument document) {
        this.messageType = messageType;
        this.document = document;
        this.documentDirty = this.document.isInternalStateDirty();
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public PDFDocument getDocument() {
        return this.document;
    }

    public void setListenersDirty(boolean dirty) {
        this.listenersDirty = dirty;
    }

    public boolean listenersDirty() {
        return this.listenersDirty;
    }

    public void setDocumentDirty(boolean dirty) {
        this.documentDirty = dirty;
    }

    public boolean documentDirty() {
        return this.documentDirty;
    }

    public static final class MessageType {
        String messageName;

        private MessageType(String messageName) {
            this.messageName = messageName;
        }

        public String toString() {
            return this.messageName;
        }
    }
}

