/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.core.util.PDFDocEncoding;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import java.io.IOException;

public class PDFText
extends PDFCosObject {
    private static final char UTF16BE_BOM = '\ufeff';
    private static final int BADSEQUENCE = -1;

    public static PDFText getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFText pdfObject = (PDFText)PDFCosObject.getCachedInstance(cosObject, PDFText.class);
        if (pdfObject == null) {
            pdfObject = new PDFText(cosObject);
        }
        return pdfObject;
    }

    private PDFText(CosObject cosObj) throws PDFInvalidDocumentException {
        super(cosObj);
        int cosType = cosObj.getType();
        if (cosType != 7 && cosType != 4) {
            throw new PDFInvalidDocumentException("attempt to construct PDF text from non-text object");
        }
    }

    public static PDFText newInstance(PDFDocument pdfDocument, ASString text) throws PDFInvalidDocumentException {
        CosString string = PDFCosObject.newCosString(pdfDocument, text);
        return new PDFText(string);
    }

    public static PDFText newInstance(PDFDocument doc, String textString, boolean asStream, boolean forceUTF16) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            forceUTF16 |= !PDFDocEncoding.isPDFDocEncoding(textString);
            if (asStream) {
                InputByteStream byteStream = doc.getStreamManager().getInputByteStream(PDFDocEncoding.fromUnicodeString(textString, forceUTF16));
                return new PDFText(PDFCosObject.newCosStream(doc, byteStream));
            }
            return new PDFText(PDFCosObject.newCosString(doc, PDFDocEncoding.fromUnicodeString(textString, forceUTF16)));
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public static PDFText newInstance(String textString, boolean isUTF16, PDFDocument doc) throws PDFIOException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        if (textString.length() > 32000) {
            return PDFText.newInstance(doc, textString, true, isUTF16);
        }
        return PDFText.newInstance(doc, textString, false, isUTF16);
    }

    public static PDFText newInstance(PDFDocument doc, String textString) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.newInstance(textString, false, doc);
    }

    public static PDFText createString(PDFDocument doc, String textString) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.newInstance(doc, textString, false, false);
    }

    public static PDFText createStream(PDFDocument doc, String textString) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFText.newInstance(doc, textString, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stringValue() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            int cosType = this.getCosObject().getType();
            byte[] bytes = null;
            if (cosType == 4) {
                bytes = ((CosString)this.getCosObject()).byteArrayValue();
            } else if (cosType == 7) {
                CosStream stream = (CosStream)this.getCosObject();
                try (InputByteStream byteStream = null;){
                    byteStream = stream.getStreamDecoded();
                    bytes = IO.inputByteStreamToArray(byteStream);
                }
            }
            try {
                if (bytes == null) {
                    return null;
                }
                return PDFDocEncoding.toUnicodeString(bytes, 0, bytes.length);
            }
            catch (PDFParseException e) {
                throw new PDFInvalidDocumentException(e);
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public byte[] byteArrayValue() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            int cosType = this.getCosObject().getType();
            byte[] bytes = null;
            if (cosType == 4) {
                bytes = ((CosString)this.getCosObject()).byteArrayValue();
            } else if (cosType == 7) {
                bytes = IO.inputByteStreamToArray(((CosStream)this.getCosObject()).getStreamDecoded());
            }
            return bytes;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public boolean isUTF16() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return PDFText.isUTF16(this.stringValue());
    }

    public static boolean isUTF16(String stringValue) {
        return stringValue.length() > 0 && stringValue.charAt(0) == '\ufeff';
    }

    public static boolean isValidUTF8(byte[] data) {
        long thisChar = 0L;
        int curPos = 0;
        int bytesAvail = data.length;
        do {
            int nextNextByte;
            int nextByte;
            short firstByte;
            if ((firstByte = (short)(0xFF & data[curPos++])) == 0) {
                thisChar = 0L;
            } else if (firstByte <= 127) {
                thisChar = firstByte;
            } else if ((firstByte & 0xE0) == 192) {
                nextByte = bytesAvail > 1 ? (int)(0xFF & data[curPos]) : 0;
                thisChar = -1L;
                if ((nextByte & 0xC0) == 128) {
                    ++curPos;
                    thisChar = (firstByte & 0x1F) << 6 | nextByte & 0x3F;
                    if (thisChar < 128L) {
                        thisChar = -1L;
                    }
                }
            } else if ((firstByte & 0xF0) == 224) {
                nextByte = bytesAvail > 1 ? (int)(0xFF & data[curPos]) : 0;
                thisChar = -1L;
                if ((nextByte & 0xC0) == 128) {
                    int n = nextNextByte = bytesAvail > 2 ? (int)(0xFF & data[++curPos]) : 0;
                    if ((nextNextByte & 0xC0) == 128) {
                        ++curPos;
                        thisChar = (firstByte & 0xF) << 12 | (nextByte & 0x3F) << 6 | nextNextByte & 0x3F;
                        if (thisChar < 2048L) {
                            thisChar = -1L;
                        }
                    }
                }
            } else if ((firstByte & 0xF8) == 240) {
                nextByte = bytesAvail > 1 ? (int)(0xFF & data[curPos]) : 0;
                thisChar = -1L;
                if ((nextByte & 0xC0) == 128) {
                    int n = nextNextByte = bytesAvail > 2 ? (int)(0xFF & data[++curPos]) : 0;
                    if ((nextNextByte & 0xC0) == 128) {
                        int nextNextNextByte;
                        int n2 = nextNextNextByte = bytesAvail > 3 ? (int)(0xFF & data[++curPos]) : 0;
                        if ((nextNextNextByte & 0xC0) == 128) {
                            ++curPos;
                            long high = (firstByte & 7) << 8 | (nextByte & 0x3F) << 2 | (nextNextByte & 0x30) >> 4;
                            long low = (nextNextByte & 0xF) << 6 | nextNextNextByte & 0x3F;
                            thisChar = (high -= 64L) * 1024L + low + 65536L;
                            if (thisChar < 65536L) {
                                thisChar = -1L;
                            }
                        }
                    }
                }
            } else {
                thisChar = -1L;
            }
            if (thisChar > 0L && thisChar != -1L) {
                if (thisChar >= 55296L && thisChar <= 57343L) {
                    thisChar = -1L;
                } else if (thisChar > 0x10FFFFL) {
                    thisChar = -1L;
                }
            }
            bytesAvail = data.length - curPos;
        } while (thisChar != -1L && thisChar != 0L && bytesAvail > 0);
        return thisChar != -1L && thisChar != 0L;
    }

    public void setFilter(PDFFilterFlate filter) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        CosObject pdfTextCosObject = this.getCosObject();
        if (pdfTextCosObject instanceof CosStream) {
            PDFStream pdfTextStream = PDFStream.getInstance(pdfTextCosObject);
            PDFFilterList filterList = pdfTextStream.procureOutputFilters();
            filterList.add(filter);
            pdfTextStream.setOutputFilters(filterList);
        }
    }
}

