/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.XMLNameValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PDFMetaDataInfo
extends PDFCosDictionary {
    private static final char COLON = ':';

    protected PDFMetaDataInfo(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public String getAuthor() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Author);
    }

    public void setAuthor(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Author, value);
    }

    public String getCreator() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Creator);
    }

    public void setCreator(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Creator, value);
    }

    public ASDate getCreationDate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDateValue(ASName.k_CreationDate);
    }

    public void setCreationDate(ASDate dateCreated) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (dateCreated == null) {
            this.removeValue(ASName.k_CreationDate);
        } else {
            this.setDictionaryStringValue(ASName.k_CreationDate, dateCreated.asString());
        }
    }

    public String getKeywords() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Keywords);
    }

    public void setKeywords(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Keywords, value);
    }

    public ASDate getModificationDate() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryDateValue(ASName.k_ModDate);
    }

    public void setModificationDate(ASDate dateModified) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (dateModified == null) {
            this.removeValue(ASName.k_ModDate);
        } else {
            this.setDictionaryStringValue(ASName.k_ModDate, dateModified.asString());
        }
    }

    public String getProducer() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Producer);
    }

    public void setProducer(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Producer, value);
    }

    public String getSubject() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Subject);
    }

    public void setSubject(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Subject, value);
    }

    public String getTitle() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(ASName.k_Title);
    }

    public void setTitle(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(ASName.k_Title, value);
    }

    public String getTrapped() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject trapped = this.getDictionaryValue(ASName.k_Trapped);
        if (trapped == null) {
            return null;
        }
        switch (trapped.getType()) {
            case 4: {
                return ((CosString)trapped).asString();
            }
            case 2: {
                return trapped.booleanValue() ? "True" : "False";
            }
        }
        return this.getDictionaryNameValueAsString(ASName.k_Trapped);
    }

    public void setTrapped(String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Trapped, value);
    }

    public List<String[]> getCustomProperties() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<String[]> custProps = new ArrayList<String[]>();
        try {
            CosDictionary dict = this.getCosDictionary();
            List<ASName> dictKeys = dict.getKeys();
            for (int idx = 0; idx < dictKeys.size(); ++idx) {
                String keyString;
                ASName key = dictKeys.get(idx);
                if (!this.isCustomProperty(key)) continue;
                String[] property = new String[2];
                CosObject value = dict.get(key);
                if (!(value instanceof CosString) || (keyString = key.asString(true)) == null || keyString.length() == 0) continue;
                property[0] = this.escapeCustomProperty(keyString);
                property[1] = ((CosString)value).asString();
                custProps.add(property);
            }
        }
        catch (PDFCosParseException e) {
            throw new PDFInvalidDocumentException("Cannot get Custom Properties.", e);
        }
        return custProps;
    }

    private String escapeCustomProperty(String propName) {
        StringBuilder ret = new StringBuilder();
        if (XMLNameValidator.isWellFormedXMLName(propName) && propName.indexOf(58) == -1) {
            return propName;
        }
        char ch = propName.charAt(0);
        if (!XMLNameValidator.isNameStartChar(ch) || ch == ':') {
            ret.append(this.escapeCharacterCode(ch));
        } else {
            ret.append(ch);
        }
        for (int i = 1; i < propName.length(); ++i) {
            ch = propName.charAt(i);
            if (!XMLNameValidator.isNameChar(ch) || ch == ':') {
                ret.append(this.escapeCharacterCode(ch));
                continue;
            }
            ret.append(ch);
        }
        return ret.toString();
    }

    private String escapeCharacterCode(char ch) {
        StringBuilder ret = new StringBuilder();
        ret.append('\u2182');
        String uniValue = Integer.toHexString(ch);
        if (uniValue.length() == 1) {
            ret.append("000");
        }
        if (uniValue.length() == 2) {
            ret.append("00");
        }
        if (uniValue.length() == 3) {
            ret.append("0");
        }
        ret.append(uniValue);
        return ret.toString();
    }

    public void setCustomProperties(List properties) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            if (properties == null) {
                CosDictionary dict = this.getCosDictionary();
                List<ASName> dictKeys = dict.getKeys();
                for (int idx = 0; idx < dictKeys.size(); ++idx) {
                    ASName key = dictKeys.get(idx);
                    if (!this.isCustomProperty(key)) continue;
                    this.removeValue(key);
                }
            } else {
                for (int idx = 0; idx < properties.size(); ++idx) {
                    String key = ((String[])properties.get(idx))[0];
                    this.setDictionaryStringOrStreamValue(ASName.create(key), ((String[])properties.get(idx))[1]);
                }
            }
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFInvalidDocumentException("Cannot set Custom Properties", e);
        }
    }

    public void setCustomProperties(List<String[]> properties, HashMap<String, String> oldDocInfoPropMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            if (properties == null) {
                CosDictionary dict = this.getCosDictionary();
                List<ASName> dictKeys = dict.getKeys();
                for (int idx = 0; idx < dictKeys.size(); ++idx) {
                    ASName key = dictKeys.get(idx);
                    if (!this.isCustomProperty(key)) continue;
                    this.removeValue(key);
                }
            } else {
                if (oldDocInfoPropMap != null) {
                    for (Map.Entry<String, String> entry : oldDocInfoPropMap.entrySet()) {
                        this.removeValue(ASName.create(entry.getKey()));
                    }
                }
                for (int idx = 0; idx < properties.size(); ++idx) {
                    String[] prop = properties.get(idx);
                    String key = prop[0];
                    String value = prop[1];
                    this.setDictionaryStringOrStreamValue(ASName.create(key), value);
                }
            }
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFInvalidDocumentException("Cannot set Custom Properties", e);
        }
    }

    private boolean isCustomProperty(ASName name) {
        return !name.equals(ASName.k_Title) && !name.equals(ASName.k_Author) && !name.equals(ASName.k_Subject) && !name.equals(ASName.k_Keywords) && !name.equals(ASName.k_Creator) && !name.equals(ASName.k_Producer) && !name.equals(ASName.k_CreationDate) && !name.equals(ASName.k_ModDate) && !name.equals(ASName.k_Trapped);
    }
}

