/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParameters;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURAnnots;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURDocument;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFUREmbeddedFiles;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURForm;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFURSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFUsageRight;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.util.HashSet;

public class PDFTransformParametersUR
extends PDFTransformParameters {
    private static final ASName k_Document = ASName.create("Document");
    private static final ASName k_Msg = ASName.create("Msg");
    private static final ASName k_EF = ASName.create("EF");

    protected PDFTransformParametersUR(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(cosObject);
    }

    static PDFTransformParametersUR getInstance(CosObject cosObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFTransformParametersUR pdfObject = (PDFTransformParametersUR)PDFCosObject.getCachedInstance(cosObject, PDFTransformParametersUR.class);
        if (pdfObject == null) {
            pdfObject = new PDFTransformParametersUR(cosObject);
        }
        return pdfObject;
    }

    public static PDFTransformParametersUR newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDirectDictionary(pdfDocument);
        PDFTransformParametersUR pdfObject = new PDFTransformParametersUR(cosObject);
        pdfObject.setVersion("2.2");
        pdfObject.setType();
        return pdfObject;
    }

    private void setRights(ASName key, PDFUsageRight[] rights) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (rights == null || rights.length == 0) {
            this.getCosDictionary().remove(key);
        } else {
            CosArray cosRights = PDFCosObject.newCosArray(this.getPDFDocument());
            HashSet<ASName> rightsAdded = new HashSet<ASName>();
            for (int i = 0; i < rights.length; ++i) {
                ASName right = rights[i].getValue();
                if (right == null || !rightsAdded.add(right)) continue;
                cosRights.addName(right);
            }
            this.setDictionaryArrayValue(key, cosRights);
        }
    }

    public PDFURDocument[] getDocumentUsageRights() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(k_Document);
        if (cosArray == null || cosArray.size() == 0) {
            return null;
        }
        PDFURDocument[] rights = new PDFURDocument[cosArray.size()];
        for (int i = 0; i < cosArray.size(); ++i) {
            ASName right = cosArray.getName(i);
            if (right == null) continue;
            rights[i] = PDFURDocument.getInstance(right);
        }
        return rights;
    }

    public void setDocumentUsageRights(PDFURDocument[] rights) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setRights(k_Document, rights);
    }

    public PDFURAnnots[] getAnnotationUsageRights() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_Annots);
        if (cosArray == null || cosArray.size() == 0) {
            return null;
        }
        PDFURAnnots[] rights = new PDFURAnnots[cosArray.size()];
        for (int i = 0; i < cosArray.size(); ++i) {
            rights[i] = PDFURAnnots.getInstance(cosArray.getName(i));
        }
        return rights;
    }

    public void setAnnotationUsageRights(PDFURAnnots[] rights) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setRights(ASName.k_Annots, rights);
    }

    public PDFURForm[] getFormUsageRights() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFURForm[] formExUsageRights;
        HashSet<PDFURForm> rights = new HashSet<PDFURForm>();
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_Form);
        if (cosArray != null && cosArray.size() != 0) {
            for (int i = 0; i < cosArray.size(); ++i) {
                rights.add(PDFURForm.getInstance(cosArray.getName(i)));
            }
        }
        if ((formExUsageRights = this.getFormExUsageRights()) != null && formExUsageRights.length != 0) {
            for (int i = 0; i < formExUsageRights.length; ++i) {
                rights.add(formExUsageRights[i]);
            }
        }
        PDFURForm[] combinedRights = rights.toArray(new PDFURForm[rights.size()]);
        return combinedRights;
    }

    public void setFormUsageRights(PDFURForm[] rights) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setRights(ASName.k_Form, rights);
    }

    PDFURForm[] getFormExUsageRights() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_FormEx);
        if (cosArray == null || cosArray.size() == 0) {
            return null;
        }
        PDFURForm[] rights = new PDFURForm[cosArray.size()];
        for (int i = 0; i < cosArray.size(); ++i) {
            ASName right = cosArray.getName(i);
            if (right == null) continue;
            rights[i] = PDFURForm.getInstance(right);
        }
        return rights;
    }

    void setFormExUsageRights(PDFURForm[] rights) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setRights(ASName.k_FormEx, rights);
    }

    public PDFURSignature[] getSignatureUsageRights() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_Signature);
        if (cosArray == null || cosArray.size() == 0) {
            return null;
        }
        PDFURSignature[] rights = new PDFURSignature[cosArray.size()];
        for (int i = 0; i < cosArray.size(); ++i) {
            rights[i] = PDFURSignature.getInstance(cosArray.getName(i));
        }
        return rights;
    }

    public void setSignatureUsageRights(PDFURSignature[] rights) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setRights(ASName.k_Signature, rights);
    }

    public PDFUREmbeddedFiles[] getEFUsageRights() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(k_EF);
        if (cosArray == null || cosArray.size() == 0) {
            return null;
        }
        PDFUREmbeddedFiles[] rights = new PDFUREmbeddedFiles[cosArray.size()];
        for (int i = 0; i < cosArray.size(); ++i) {
            rights[i] = PDFUREmbeddedFiles.getInstance(cosArray.getName(i));
        }
        return rights;
    }

    public void setEFUsageRights(PDFUsageRight[] rights) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setRights(k_EF, rights);
    }

    public String getMessage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(k_Msg)) {
            return this.getDictionaryTextStringValue(k_Msg);
        }
        return "";
    }

    public void setMessage(String msg) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_Msg, msg);
    }

    public boolean getRestrictPermissions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObject = this.getCosDictionary().get(ASName.k_P);
        if (cosObject != null) {
            return cosObject.booleanValue();
        }
        return false;
    }

    public void setRestrictPermissions(boolean value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryBooleanValue(ASName.k_P, value);
    }
}

