/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosContainerValuesIterator;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public final class PDFSubjectDN
extends PDFCosDictionary {
    private static HashSet<String> allowedAttribs = PDFSubjectDN.initializeSubjectDNAttributes();

    private PDFSubjectDN(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    static PDFSubjectDN getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFSubjectDN pdfObject = (PDFSubjectDN)PDFCosObject.getCachedInstance(cosObject, PDFSubjectDN.class);
        if (pdfObject == null) {
            pdfObject = new PDFSubjectDN(cosObject);
        }
        return pdfObject;
    }

    public static PDFSubjectDN newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFSubjectDN pdfObject = new PDFSubjectDN(cosObject);
        return pdfObject;
    }

    protected static HashSet<String> initializeSubjectDNAttributes() {
        HashSet<String> allowedAttribs = new HashSet<String>();
        allowedAttribs.add("2.5.4.3");
        allowedAttribs.add("cn");
        allowedAttribs.add("2.5.4.4");
        allowedAttribs.add("sn");
        allowedAttribs.add("2.5.4.5");
        allowedAttribs.add("serialNumber");
        allowedAttribs.add("2.5.4.6");
        allowedAttribs.add("c");
        allowedAttribs.add("2.5.4.7");
        allowedAttribs.add("l");
        allowedAttribs.add("2.5.4.8");
        allowedAttribs.add("st");
        allowedAttribs.add("2.5.4.9");
        allowedAttribs.add("street");
        allowedAttribs.add("2.5.4.10");
        allowedAttribs.add("o");
        allowedAttribs.add("2.5.4.11");
        allowedAttribs.add("ou");
        allowedAttribs.add("2.5.4.12");
        allowedAttribs.add("title");
        allowedAttribs.add("2.5.4.14");
        allowedAttribs.add("TEL");
        allowedAttribs.add("2.5.4.15");
        allowedAttribs.add("BC");
        allowedAttribs.add("2.5.4.16");
        allowedAttribs.add("postalAddress");
        allowedAttribs.add("2.5.4.17");
        allowedAttribs.add("postalCode");
        allowedAttribs.add("2.5.4.41");
        allowedAttribs.add("name");
        allowedAttribs.add("2.5.4.42");
        allowedAttribs.add("givenName");
        allowedAttribs.add("2.5.4.43");
        allowedAttribs.add("initials");
        allowedAttribs.add("2.5.4.44");
        allowedAttribs.add("generationQualifier");
        allowedAttribs.add("2.5.4.46");
        allowedAttribs.add("dnQualifier");
        allowedAttribs.add("2.5.4.65");
        allowedAttribs.add("pseudonym");
        allowedAttribs.add("0.9.2342.19200300.100.1.25");
        allowedAttribs.add("dc");
        allowedAttribs.add("1.2.840.113549.1.9.1");
        allowedAttribs.add("e");
        allowedAttribs.add("email");
        allowedAttribs.add("emailaddress");
        allowedAttribs.add("ea");
        allowedAttribs.add("1.3.36.8.3.14");
        allowedAttribs.add("nameAtBirth");
        allowedAttribs.add("1.3.6.1.5.5.7.9.3");
        allowedAttribs.add("gender");
        allowedAttribs.add("1.3.6.1.5.5.7.9.1");
        allowedAttribs.add("dateOfBirth");
        allowedAttribs.add("1.3.6.1.5.5.7.9.5");
        allowedAttribs.add("countryOfResidence");
        allowedAttribs.add("1.3.6.1.5.5.7.9.4");
        allowedAttribs.add("countryOfCitizenship");
        allowedAttribs.add("1.3.6.1.5.5.7.9.2");
        allowedAttribs.add("placeOfBirth");
        allowedAttribs.add("2.16.840.1.113730.3.2.2");
        allowedAttribs.add("businessCategory");
        return allowedAttribs;
    }

    public static HashSet<String> getAllowedAttribsSet() {
        return allowedAttribs;
    }

    public void setAttributeValue(String attribute, String value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (!this.checkValidity(attribute)) {
            throw new PDFInvalidParameterException("The attribute " + attribute + " provided as part of the SubjectDN is not present in the legal attribute list.");
        }
        this.setDictionaryStringValue(ASName.create(attribute), value);
    }

    public Map getAttributes() throws PDFSecurityException, PDFIOException, PDFInvalidParameterException {
        HashMap<String, String> subDNAttrValueMap = null;
        CosDictionary cosDict = this.getCosDictionary();
        if (cosDict == null) {
            return subDNAttrValueMap;
        }
        CosContainerValuesIterator entriesIterator = cosDict.getValuesIterator();
        subDNAttrValueMap = new HashMap<String, String>();
        while (entriesIterator.hasNext()) {
            try {
                CosContainerValuesIterator.Entry entry = entriesIterator.next();
                subDNAttrValueMap.put(entry.getKey().asString(true), entry.getValue().stringValue().asString());
            }
            catch (PDFCosParseException e) {
                throw new PDFInvalidParameterException("SubjectDN attributes cannot be retrieved from the seed value dictionary", e);
            }
        }
        return subDNAttrValueMap;
    }

    private boolean checkValidity(String attribute) {
        return allowedAttribs.contains(attribute.toLowerCase(Locale.getDefault()));
    }
}

