/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFCertificateSeedValue;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTimeStampSeed;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFSignatureFieldSeedValue
extends PDFCosDictionary {
    public static final int kFilter = 1;
    public static final int kSubFilter = 2;
    public static final int kV = 4;
    public static final int kReasons = 8;
    public static final int kLegalAttestation = 16;
    public static final int kAddRevInfo = 32;
    public static final int kDigestMethod = 64;
    public static final int kLockDocument = 128;
    public static final int kAppearanceFilter = 256;
    public static final String EMPTY_REASON_STRING = ".";
    private static final ASName k_MDP = ASName.create("MDP");
    private static final ASName k_LegalAttestation = ASName.create("LegalAttestation");
    private static final ASName k_Reasons = ASName.create("Reasons");
    private static final ASName k_TimeStamp = ASName.create("TimeStamp");
    private static final ASName k_P = ASName.create("P");
    private static final ASName k_DigestMethod = ASName.create("DigestMethod");
    private static final ASName k_AddRevInfo = ASName.create("AddRevInfo");
    private static final ASName k_LockDocument = ASName.create("LockDocument");
    private static final ASName k_AppearanceFilter = ASName.create("AppearanceFilter");

    protected PDFSignatureFieldSeedValue(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFSignatureFieldSeedValue getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFSignatureFieldSeedValue pdfObject = (PDFSignatureFieldSeedValue)PDFCosObject.getCachedInstance(cosObject, PDFSignatureFieldSeedValue.class);
        if (pdfObject == null) {
            pdfObject = new PDFSignatureFieldSeedValue(cosObject);
        }
        return pdfObject;
    }

    public static PDFSignatureFieldSeedValue newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary(pdfDocument);
        PDFSignatureFieldSeedValue pdfObject = new PDFSignatureFieldSeedValue(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, ASName.k_SV);
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public ASName getFilter() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Filter);
    }

    public void setFilter(ASName filter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Filter, filter);
    }

    public ASName[] getSubFilters() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(ASName.k_SubFilter);
        if (cosArray == null) {
            return null;
        }
        ASName[] subFilters = new ASName[cosArray.size()];
        for (int i = 0; i < subFilters.length; ++i) {
            subFilters[i] = cosArray.getName(i);
        }
        return subFilters;
    }

    public void setSubFilters(ASName[] subFilters) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (subFilters == null) {
            this.removeValue(ASName.k_SubFilter);
        } else {
            CosArray array = PDFCosObject.newCosArray(this.getPDFDocument());
            int addAtIndex = 0;
            for (int i = 0; i < subFilters.length; ++i) {
                if (subFilters[i] == null) continue;
                array.addName(addAtIndex++, subFilters[i]);
            }
            if (array.size() > 0) {
                this.setDictionaryArrayValue(ASName.k_SubFilter, array);
            } else {
                this.removeValue(ASName.k_SubFilter);
            }
        }
    }

    public Double getVersion() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(ASName.k_V)) {
            return this.getDictionaryDoubleValue(ASName.k_V);
        }
        return null;
    }

    public void setVersion(Double version) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (version == null) {
            this.removeValue(ASName.k_V);
        } else {
            this.setDictionaryDoubleValue(ASName.k_V, version);
        }
    }

    public PDFCertificateSeedValue getPDFCertificateSeedValue() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCertificateSeedValue.getInstance(this.getDictionaryCosObjectValue(ASName.k_Cert));
    }

    public void setPDFCertificateSeedValue(PDFCertificateSeedValue seedValues) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (seedValues == null || seedValues.isEmpty()) {
            this.removeValue(ASName.k_Cert);
        } else {
            this.setDictionaryValue(ASName.k_Cert, seedValues);
        }
    }

    public String[] getReasons() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(k_Reasons);
        if (cosArray == null) {
            return null;
        }
        String[] reasons = new String[cosArray.size()];
        for (int i = 0; i < reasons.length; ++i) {
            reasons[i] = cosArray.getString(i).asString();
        }
        return reasons;
    }

    public void setReasons(String[] reasons) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (reasons == null) {
            this.removeValue(k_Reasons);
        } else {
            CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            for (int i = 0; i < reasons.length; ++i) {
                if (reasons[i] == null || reasons[i].length() <= 0) continue;
                cosArray.addText(reasons[i]);
            }
            if (cosArray.size() > 0) {
                if (cosArray.size() == 1) {
                    if (cosArray.getText(0).equals(EMPTY_REASON_STRING)) {
                        this.removeValue(k_Reasons);
                    } else {
                        this.setDictionaryArrayValue(k_Reasons, cosArray);
                    }
                } else {
                    this.setDictionaryArrayValue(k_Reasons, cosArray);
                }
            } else {
                this.removeValue(k_Reasons);
            }
        }
    }

    public Integer getMDP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary dict = this.getDictionaryDictionaryValue(k_MDP);
        if (dict != null) {
            CosObject cosObj = dict.get(ASName.k_P);
            if (cosObj != null && cosObj instanceof CosNumeric) {
                return ((CosNumeric)cosObj).intValue();
            }
            return null;
        }
        return null;
    }

    public void setMDP(Integer value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (value == null) {
            this.removeValue(k_MDP);
        } else {
            CosDictionary dict = this.getDictionaryDictionaryValue(k_MDP);
            if (dict == null) {
                dict = PDFCosObject.newCosDictionary(this.getPDFDocument());
                this.setDictionaryValue(k_MDP, dict);
            }
            dict.put(k_P, value);
        }
    }

    public PDFTimeStampSeed getPDFTimeStamp() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFTimeStampSeed.getInstance(this.getDictionaryCosObjectValue(k_TimeStamp));
    }

    public void setPDFTimeStamp(PDFTimeStampSeed timeStamp) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_TimeStamp, timeStamp);
    }

    public String[] getLegalAttestations() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(k_LegalAttestation);
        if (cosArray == null) {
            return null;
        }
        String[] attests = new String[cosArray.size()];
        for (int i = 0; i < attests.length; ++i) {
            attests[i] = cosArray.getString(i).asString();
        }
        return attests;
    }

    public void setLegalAttestations(String[] attestations) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (attestations == null) {
            this.removeValue(k_LegalAttestation);
        } else {
            CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            for (int i = 0; i < attestations.length; ++i) {
                if (attestations[i] == null || attestations[i].length() <= 0) continue;
                cosArray.addText(attestations[i]);
            }
            if (cosArray.size() > 0) {
                this.setDictionaryArrayValue(k_LegalAttestation, cosArray);
            } else {
                this.removeValue(k_LegalAttestation);
            }
        }
    }

    public String getAppearanceFilter() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString filter = this.getDictionaryStringValue(k_AppearanceFilter);
        if (filter == null) {
            return null;
        }
        return filter.asString();
    }

    public void setAppearanceFilter(String filter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_AppearanceFilter, filter);
    }

    public boolean getAddRevInfo() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(k_AddRevInfo)) {
            return this.getDictionaryBooleanValue(k_AddRevInfo);
        }
        return false;
    }

    public void setRevInfoFlag(boolean addRevInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!addRevInfo) {
            this.removeValue(k_AddRevInfo);
        } else {
            this.setDictionaryBooleanValue(k_AddRevInfo, addRevInfo);
        }
    }

    public String[] getDigestMethod() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(k_DigestMethod);
        if (cosArray == null) {
            return null;
        }
        String[] digestMethods = new String[cosArray.size()];
        for (int i = 0; i < digestMethods.length; ++i) {
            digestMethods[i] = cosArray.getName(i).asString(false);
        }
        return digestMethods;
    }

    public void setDigestMethod(String[] digestMethods) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (digestMethods == null) {
            this.removeValue(k_DigestMethod);
        } else {
            CosArray cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            for (int i = 0; i < digestMethods.length; ++i) {
                if (digestMethods[i] == null || digestMethods[i].length() <= 0) {
                    throw new PDFInvalidParameterException("The digest method " + digestMethods[i] + " is not supported");
                }
                cosArray.addName(ASName.create(digestMethods[i]));
            }
            if (cosArray.size() > 0) {
                this.setDictionaryArrayValue(k_DigestMethod, cosArray);
            } else {
                this.removeValue(k_DigestMethod);
            }
        }
    }

    public int getFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(ASName.k_Ff)) {
            return this.getDictionaryIntValue(ASName.k_Ff);
        }
        return 0;
    }

    public void setFlags(Integer flags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (flags == null) {
            this.removeValue(ASName.k_Ff);
        } else {
            this.setDictionaryIntValue(ASName.k_Ff, flags.intValue());
        }
    }

    public void setLockDocument(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(k_LockDocument, value);
    }

    public ASName getLockDocument() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.getCosDictionary().containsKey(k_LockDocument)) {
            return this.getDictionaryNameValue(k_LockDocument);
        }
        return null;
    }
}

