/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.contentmodify.impl;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.IContentStreamFilter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.impl.ContentStreamReader;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.impl.ContentStreamWriter;
import java.io.IOException;

public class ContentStreamTransformer {
    private static void transform(ContentReader contentReader, ContentWriter contentWriter, IContentStreamFilter filter) throws PDFInvalidContentException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        ContentStreamReader reader = new ContentStreamReader();
        filter.setParent(reader);
        ContentStreamWriter sw = new ContentStreamWriter(contentWriter);
        sw.setParent(filter);
        sw.parse(contentReader);
    }

    public static InputByteStream transformContent(Content content, IContentStreamFilter filter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        ContentWriter contentWriter = ContentWriter.newInstance(content.getPDFDocument());
        return ContentStreamTransformer.transformContent(content, filter, contentWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputByteStream transformContent(Content content, IContentStreamFilter filter, ContentWriter contentWriter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        ContentReader contentReader = null;
        try {
            contentReader = ContentReader.newInstance(content);
            ContentStreamTransformer.transform(contentReader, contentWriter, filter);
        }
        finally {
            if (contentReader != null) {
                try {
                    contentReader.close();
                }
                catch (IOException e) {}
            }
        }
        Content finalContent = contentWriter.close();
        content.getContents().setContents(finalContent.getContentStream());
        return finalContent.getContentStream();
    }
}

