/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.contentmodify;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentReader;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.PDFStream;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFExtGState;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.patterns.PDFPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.shading.PDFShading;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.inlineimage.InlineImage;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCProperty;
import java.io.IOException;
import java.util.Iterator;

public class ContentWriter {
    private ModifiableContent content;
    protected OutputByteStream contentStream;
    private OutputByteStream prependContentStream;
    int instructionDelimiter;

    private ContentWriter(PDFDocument pdfDocument, OutputByteStream contentStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.content = ModifiableContent.newInstance(pdfDocument);
        this.contentStream = contentStream;
        this.prependContentStream = null;
        this.instructionDelimiter = 13;
    }

    protected ContentWriter(ModifiableContent content) throws PDFIOException {
        try {
            this.content = content;
            this.contentStream = this.content.getPDFDocument().getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
            this.prependContentStream = null;
            this.instructionDelimiter = 13;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public static ContentWriter newInstance(ModifiableContent content) throws PDFIOException {
        return new ContentWriter(content);
    }

    public static ContentWriter newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new ContentWriter(ModifiableContent.newInstance(pdfDocument));
    }

    public static ContentWriter newInstance(PDFDocument pdfDocument, OutputByteStream contentStream) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new ContentWriter(pdfDocument, contentStream);
    }

    public Content close() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            this.content.setContents(this.createNewContents());
            return this.content;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PDFContents createNewContents() throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, IOException {
        PDFContents contents;
        CosObject cos;
        InputByteStream prependStream = null;
        InputByteStream appendStream = null;
        if (this.prependContentStream != null) {
            try {
                prependStream = this.prependContentStream.closeAndConvert();
            }
            finally {
                appendStream = this.contentStream.closeAndConvert();
                this.contentStream = null;
            }
        }
        if (this.contentStream != null) {
            appendStream = this.contentStream.closeAndConvert();
        }
        PDFContents pdfContents = PDFContents.newInstanceArray(this.content.getPDFDocument());
        CosArray array = pdfContents.getCosArray();
        if (prependStream != null) {
            CosStream stream = this.content.getPDFDocument().getCosDocument().createCosStream(prependStream);
            array.add(stream);
            if (prependStream.length() > 15L) {
                PDFStream pdfStream = PDFStream.getInstance(stream);
                pdfStream.setOutputFilter(ASName.k_FlateDecode);
            }
        }
        if ((cos = (contents = this.content.getContents()).getCosObject()) instanceof CosArray) {
            Iterator<CosObject> iter = contents.getCosArray().iterator();
            CosObject obj = null;
            while (iter.hasNext()) {
                obj = iter.next();
                if (!(obj instanceof CosStream) || this.isStreamEmpty((CosStream)obj)) continue;
                array.add(obj);
            }
        } else if (cos instanceof CosStream && !this.isStreamEmpty((CosStream)cos)) {
            array.add(contents.getCosObject());
        }
        if (appendStream != null && appendStream.length() > 0L) {
            CosStream stream = this.content.getPDFDocument().getCosDocument().createCosStream(appendStream);
            array.add(stream);
            if (appendStream.length() > 15L) {
                PDFStream pdfStream = PDFStream.getInstance(stream);
                pdfStream.setOutputFilter(ASName.k_FlateDecode);
            }
        }
        return pdfContents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStreamEmpty(CosStream stream) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        try (InputByteStream istream = null;){
            istream = stream.getStreamDecoded();
            if (istream == null || istream.length() == 0L) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public void setInstructionDelimiter(int c) {
        this.instructionDelimiter = c;
    }

    public void write(Instruction instruction) throws PDFIOException {
        try {
            instruction.write(this.contentStream);
            this.contentStream.write(this.instructionDelimiter);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public void prepend(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        InputByteStream istream = null;
        try {
            OutputByteStream newContentStream = this.content.getPDFDocument().getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
            instruction.write(newContentStream);
            newContentStream.write(this.instructionDelimiter);
            if (this.prependContentStream != null) {
                istream = this.prependContentStream.closeAndConvert();
                this.prependContentStream = null;
                IO.copy(istream, newContentStream);
            }
            this.prependContentStream = newContentStream;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        finally {
            try {
                if (istream != null) {
                    istream.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }

    public ASName prepend(PDFExtGState pdfExtGState) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.content.addResource(pdfExtGState);
        this.prepend(InstructionFactory.newInvokeNamedExtGState(name));
        return name;
    }

    public ASName prepend(PDFXObject pdfXObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.content.addResource(pdfXObject);
        this.prepend(InstructionFactory.newInvokeNamedXObject(name));
        return name;
    }

    public void write(Content content, PDFRectangle bbox) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectForm pdfXObjectForm = PDFXObjectForm.newInstance(this.content.getContents().getPDFDocument(), bbox, content.getResources(), content.getContentStream());
        this.write(pdfXObjectForm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Content content) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Content inputContent = content;
        if (inputContent == null) {
            return;
        }
        PDFContents inputPDFContents = inputContent.getContents();
        if (inputPDFContents == null || !inputPDFContents.hasContents()) {
            return;
        }
        if (inputContent.getResources() == null) {
            this.write(content.getContentStream());
            return;
        }
        if (inputContent.getResources().getPDFDocument() != this.content.getContents().getPDFDocument()) {
            PDFResources inputResources = inputContent.getResources();
            CosCloneMgr cloneMgr = new CosCloneMgr(this.content.getContents().getPDFDocument().getCosDocument());
            CosObject cloneResources = cloneMgr.clone(inputResources.getCosObject());
            inputResources = PDFResources.getInstance(cloneResources);
            inputContent = Content.newInstance(content.getContents(), inputResources);
        }
        ContentReader inputReader = null;
        PDFResources inputResources = inputContent.getResources();
        Instruction instruction = null;
        boolean isCurrentStrokingCSPattern = false;
        boolean isCurrentNonStrokingCSPattern = false;
        try {
            inputReader = ContentReader.newInstance(inputContent);
            while (inputReader.hasNext()) {
                try {
                    OperandStack newOperands;
                    ASName csName;
                    ASName namedResource;
                    PDFColorSpace cs;
                    Object operand;
                    ASName name;
                    instruction = inputReader.next();
                    ASName operator = instruction.getOperator();
                    Iterator<Object> operandIter = instruction.getOperands().iterator();
                    if (operator == ASName.k_Tf) {
                        name = (ASName)operandIter.next();
                        ASNumber fontSize = (ASNumber)operandIter.next();
                        PDFFont pdfFont = inputResources.getFont(name);
                        if (pdfFont == null) {
                            throw new PDFInvalidContentException("Tf instruction refers to unknown font.");
                        }
                        ASName newName = this.content.addResource(pdfFont);
                        this.write(InstructionFactory.newTextFont(newName, fontSize));
                        continue;
                    }
                    if (operator == ASName.k_sh) {
                        name = (ASName)operandIter.next();
                        PDFShading shading = inputResources.getShading(name);
                        if (shading == null) {
                            throw new PDFInvalidContentException("sh instruction refers to unknown shading.");
                        }
                        this.write(shading);
                        continue;
                    }
                    if (operator == ASName.k_Do) {
                        name = (ASName)operandIter.next();
                        PDFXObject xobject = inputResources.getXObject(name);
                        if (xobject == null) {
                            throw new PDFInvalidContentException("Do instruction refers to unknown XObject.");
                        }
                        this.write(xobject);
                        continue;
                    }
                    if (operator == ASName.k_BDC || operator == ASName.k_DP) {
                        name = (ASName)operandIter.next();
                        operand = operandIter.next();
                        if (operand instanceof ASName) {
                            ASName resourceName = (ASName)operand;
                            PDFMCProperty property = inputResources.getMCProperty(resourceName);
                            ASName namedResource2 = this.content.addResource(property);
                            if (operator == ASName.k_BDC) {
                                this.write(InstructionFactory.newBeginMarkedContent(namedResource2));
                                continue;
                            }
                            this.write(InstructionFactory.newMarkedPoint(name, namedResource2));
                            continue;
                        }
                        this.write(instruction);
                        continue;
                    }
                    if (operator == ASName.k_CS) {
                        name = (ASName)operandIter.next();
                        if (name != ASName.k_DeviceGray && name != ASName.k_DeviceRGB && name != ASName.k_DeviceCMYK && name != ASName.k_Pattern) {
                            cs = inputResources.getColorSpace(name);
                            if (cs == null) {
                                throw new PDFInvalidContentException("CS instruction refers to unknown color space.");
                            }
                            namedResource = this.content.addResource(cs);
                            this.write(InstructionFactory.newStrokeColorSpace(namedResource));
                            csName = cs.getCosArray().getName(0);
                        } else {
                            this.write(instruction);
                            csName = name;
                        }
                        isCurrentStrokingCSPattern = csName == ASName.k_Pattern;
                        continue;
                    }
                    if (operator == ASName.k_cs) {
                        name = (ASName)operandIter.next();
                        if (name != ASName.k_DeviceGray && name != ASName.k_DeviceRGB && name != ASName.k_DeviceCMYK && name != ASName.k_Pattern) {
                            cs = inputResources.getColorSpace(name);
                            if (cs == null) {
                                throw new PDFInvalidContentException("cs instruction refers to unknown color space.");
                            }
                            namedResource = this.content.addResource(cs);
                            this.write(InstructionFactory.newFillColorSpace(namedResource));
                            csName = cs.getCosArray().getName(0);
                        } else {
                            this.write(instruction);
                            csName = name;
                        }
                        isCurrentNonStrokingCSPattern = csName == ASName.k_Pattern;
                        continue;
                    }
                    if (operator == ASName.k_SCN || operator == ASName.k_scn) {
                        newOperands = new OperandStack();
                        operand = null;
                        while (operandIter.hasNext()) {
                            operand = operandIter.next();
                            newOperands.push(operand);
                        }
                        if (operand instanceof ASName) {
                            ASName namedResource3;
                            if (operator == ASName.k_SCN && isCurrentStrokingCSPattern || operator == ASName.k_scn && isCurrentNonStrokingCSPattern) {
                                PDFPattern pattern = inputResources.getPattern((ASName)operand);
                                if (pattern == null) {
                                    throw new PDFInvalidContentException("SCN/scn instruction refers to unknown pattern.");
                                }
                                namedResource3 = this.content.addResource(pattern);
                            } else {
                                PDFColorSpace cs2 = inputResources.getColorSpace((ASName)operand);
                                if (cs2 == null) {
                                    throw new PDFInvalidContentException("SCN/scn instruction refers to unknown color space.");
                                }
                                namedResource3 = this.content.addResource(cs2);
                            }
                            newOperands.popName();
                            newOperands.pushName(namedResource3);
                            Instruction scn = new Instruction(newOperands, operator);
                            this.write(scn);
                            continue;
                        }
                        this.write(instruction);
                        continue;
                    }
                    if (operator == ASName.k_gs) {
                        name = (ASName)operandIter.next();
                        PDFExtGState extGState = inputResources.getExtGState(name);
                        if (extGState == null) {
                            throw new PDFInvalidContentException("gs instruction refers to unknown graphic state.");
                        }
                        this.write(extGState);
                        continue;
                    }
                    if (operator == ASName.k_ID) {
                        newOperands = new OperandStack();
                        while (operandIter.hasNext()) {
                            operand = operandIter.next();
                            if (operand instanceof InputByteStream) {
                                newOperands.push(operand);
                                continue;
                            }
                            ASName key = (ASName)operand;
                            Object value = operandIter.next();
                            if ((key == ASName.k_CS || key == ASName.k_ColorSpace) && value instanceof ASName && value != ASName.k_G && value != ASName.k_DeviceGray && value != ASName.k_RGB && value != ASName.k_DeviceRGB && value != ASName.k_CMYK && value != ASName.k_DeviceCMYK) {
                                PDFColorSpace resourceCS = inputResources.getColorSpace((ASName)value);
                                if (resourceCS == null) {
                                    throw new PDFInvalidContentException("ID instruction refers to unknown color space.");
                                }
                                value = this.content.addResource(resourceCS);
                            }
                            newOperands.push(key);
                            newOperands.push(value);
                        }
                        Instruction id = new Instruction(newOperands, operator);
                        this.write(id);
                        continue;
                    }
                    this.write(instruction);
                }
                finally {
                    try {
                        if (instruction == null) continue;
                        instruction.close();
                    }
                    catch (PDFIOException e) {}
                }
            }
        }
        finally {
            try {
                if (inputReader != null) {
                    inputReader.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }

    public ASName write(PDFXObject pdfXObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.content.addResource(pdfXObject);
        this.write(InstructionFactory.newInvokeNamedXObject(name));
        return name;
    }

    public ASName write(PDFColorSpace colorspace, boolean fill) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.content.addResource(colorspace);
        if (fill) {
            this.write(InstructionFactory.newFillColorSpace(name));
        } else {
            this.write(InstructionFactory.newStrokeColorSpace(name));
        }
        return name;
    }

    public ASName write(PDFPattern pattern, boolean fill, double[] color) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.content.addResource(pattern);
        if (fill) {
            this.write(InstructionFactory.newFillColorSpace(color, name));
        } else {
            this.write(InstructionFactory.newStrokeColorSpace(color, name));
        }
        return name;
    }

    public ASName write(PDFExtGState pdfExtGState) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.content.addResource(pdfExtGState);
        this.write(InstructionFactory.newInvokeNamedExtGState(name));
        return name;
    }

    public ASName write(PDFFont font, double fontSize) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.content.addResource(font);
        this.write(InstructionFactory.newTextFont(name, fontSize));
        return name;
    }

    public ASName write(PDFShading shading) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName name = this.content.addResource(shading);
        this.write(InstructionFactory.newShading(name));
        return name;
    }

    public void write(InlineImage image) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.write(InstructionFactory.newInlineImageBegin());
        this.write(InstructionFactory.newInlineImageDict(image.createImageDict(this.content), image.getEncodedImageData(this.content)));
        this.write(InstructionFactory.newInlineImageEnd());
    }

    public void write(InputByteStream content) throws PDFIOException {
        try {
            IO.copy(content, this.contentStream);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }
}

