/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentOperator;
import com.adobe.internal.pdftoolkit.pdf.content.processor.IOperatorHandler;

class TextStateOperator
extends ContentOperator {
    static final int Tc = 1;
    static final int Tw = 2;
    static final int Tz = 3;
    static final int TL = 4;
    static final int Tf = 5;
    static final int Tr = 6;
    static final int Ts = 7;

    TextStateOperator(int type, ASName name) {
        super(type, name);
    }

    @Override
    public void process(Instruction instruction, IOperatorHandler opHandlers) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        OperandStack opStack = instruction.getReadonlyOperands();
        switch (this.getType()) {
            case 1: {
                double charSpace = opStack.popNumber().doubleValue();
                opHandlers.Tc(charSpace, instruction);
                break;
            }
            case 2: {
                double wordSpace = opStack.popNumber().doubleValue();
                opHandlers.Tw(wordSpace, instruction);
                break;
            }
            case 3: {
                double scale = opStack.popNumber().doubleValue();
                opHandlers.Tz(scale, instruction);
                break;
            }
            case 4: {
                double leading = opStack.popNumber().doubleValue();
                opHandlers.TL(leading, instruction);
                break;
            }
            case 5: {
                double fontSize = opStack.popNumber().doubleValue();
                ASName fontName = opStack.popName();
                opHandlers.Tf(fontName, fontSize, instruction);
                break;
            }
            case 6: {
                int renderMode = opStack.popNumber().intValue();
                opHandlers.Tr(renderMode, instruction);
                break;
            }
            case 7: {
                double rise = opStack.popNumber().doubleValue();
                opHandlers.Ts(rise, instruction);
            }
        }
    }
}

